/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.AttributeInfo;
import com.xmlmind.xmledit.dialog.AttributeTableModel;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataFormatException;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.UncheckedUnparsedEntities;
import com.xmlmind.xmledit.guiutil.Alert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

class AttributeCellEditor
implements TableCellEditor,
ActionListener {
    private JTextField field;
    private JComboBox combo;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent = null;
    private AttributeInfo editedAttributeInfo = new AttributeInfo();
    private String initialAttributeValue = null;
    private AttributeTableModel attributeTableModel = null;
    private JComponent editorComponent = null;
    private String comboIgnoredSelection = null;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public AttributeCellEditor() {
        this.field = new JTextField();
        this.field.setActionCommand("ok");
        this.field.addActionListener(this);
        this.field.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 0);
        this.combo = new JComboBox();
        this.combo.setEditable(false);
        this.combo.setActionCommand("ok");
        this.combo.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.stopCellEditing();
        } else if (string.equals("cancel")) {
            this.cancelCellEditing();
        }
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.attributeTableModel = (AttributeTableModel)jTable.getModel();
        AttributeInfo attributeInfo = (AttributeInfo)object;
        this.editedAttributeInfo.name = attributeInfo.name;
        this.editedAttributeInfo.value = this.initialAttributeValue = attributeInfo.value;
        this.editedAttributeInfo.field = attributeInfo.field;
        this.editedAttributeInfo.type = attributeInfo.type;
        this.editedAttributeInfo.required = attributeInfo.required;
        this.editedAttributeInfo.label = attributeInfo.label;
        this.editorComponent = null;
        this.comboIgnoredSelection = null;
        DataType dataType = attributeInfo.type.getAttributeDataType();
        Data[] dataArray = dataType.getEnumeratedValues();
        if (dataArray != null) {
            String string;
            Element element = this.attributeTableModel.getElement();
            Data data = null;
            this.comboIgnoredSelection = string = "-";
            boolean bl2 = true;
            if (attributeInfo.value != null) {
                try {
                    data = dataType.parseData(attributeInfo.value, element, UncheckedUnparsedEntities.INSTANCE);
                }
                catch (DataFormatException dataFormatException) {
                    data = null;
                }
                if (data == null) {
                    this.comboIgnoredSelection = string = dataType.normalizeWhiteSpace(attributeInfo.value);
                } else {
                    this.comboIgnoredSelection = string = data.formatData(element);
                    int n3 = 0;
                    while (n3 < dataArray.length) {
                        if (dataArray[n3].equals(data)) {
                            this.comboIgnoredSelection = null;
                            bl2 = false;
                            break;
                        }
                        ++n3;
                    }
                }
            }
            Object[] objectArray = new String[dataArray.length + (bl2 ? 1 : 0)];
            int n4 = 0;
            while (n4 < dataArray.length) {
                objectArray[n4] = dataArray[n4].equals(data) ? string : dataArray[n4].formatData(element);
                ++n4;
            }
            if (bl2) {
                objectArray[objectArray.length - 1] = string;
            }
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
            this.combo.setModel(defaultComboBoxModel);
            this.combo.setSelectedItem(string);
            this.editorComponent = this.combo;
        }
        if (this.editorComponent == null) {
            this.field.setText(attributeInfo.value == null ? "" : attributeInfo.value);
            this.editorComponent = this.field;
        }
        this.editorComponent.setFont(jTable.getFont());
        return this.editorComponent;
    }

    public AttributeInfo getEditedAttributeInfo() {
        return this.editedAttributeInfo;
    }

    public String getInitialAttributeValue() {
        return this.initialAttributeValue;
    }

    public Object getCellEditorValue() {
        return this.editedAttributeInfo;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return eventObject instanceof MouseEvent;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean cellHasBeenEdited() {
        String string;
        if (this.editorComponent == this.field) {
            DataType dataType = this.editedAttributeInfo.type.getAttributeDataType();
            string = dataType.normalizeWhiteSpace(this.field.getText());
        } else {
            string = this.editorComponent == this.combo ? (String)this.combo.getSelectedItem() : null;
        }
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            string = null;
        }
        return (this.editedAttributeInfo.value != null || string != null) && (this.editedAttributeInfo.value == null || !this.editedAttributeInfo.value.equals(string));
    }

    public boolean stopCellEditing() {
        AttributeType attributeType = this.editedAttributeInfo.type;
        if (this.editorComponent == this.field) {
            this.editedAttributeInfo.value = attributeType.getAttributeDataType().normalizeWhiteSpace(this.field.getText());
        } else if (this.editorComponent == this.combo) {
            this.editedAttributeInfo.value = (String)this.combo.getSelectedItem();
            if (this.editedAttributeInfo.value.equals(this.comboIgnoredSelection)) {
                return false;
            }
        } else {
            return false;
        }
        String string = this.attributeTableModel.getElementEditor().checkAttributeValue(attributeType, this.editedAttributeInfo.value);
        if (string == null) {
            this.fireEditingStopped();
            return true;
        }
        this.field.getToolkit().beep();
        Alert.showError(this.field, string);
        if (this.editorComponent == this.field) {
            this.field.selectAll();
        }
        return false;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = AttributeCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = AttributeCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    private void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? AttributeCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingStopped(this.changeEvent);
            }
            n -= 2;
        }
    }

    private void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? AttributeCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingCanceled(this.changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

