/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.AttributeInfo;
import com.xmlmind.xmledit.dialog.AttributeTableModel;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.guiutil.Bitmap;
import com.xmlmind.xmledit.xsd.datatype.Base64BinaryType;
import com.xmlmind.xmledit.xsd.datatype.HexBinaryType;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class AttributeCellRenderer
extends DefaultTableCellRenderer {
    private Font requiredAttributeFont = null;
    private Font fixedAttributeFont = null;
    private Font fixedRequiredAttributeFont = null;
    private ImageIcon dropdownIcon = null;
    private ImageIcon binaryIcon = null;
    private static final Bitmap dropdownBitmap = new Bitmap(7, 7, new byte[]{0, 0, 127, 62, 28, 8, 0});
    private static final Bitmap binaryBitmap = new Bitmap(29, 9, new byte[]{-1, -1, -1, 3, 1, 0, 0, 2, 65, 68, 68, 4, 98, 106, -90, 4, 66, 74, -92, 8, 68, 74, -92, 8, -28, -28, 78, 16, 8, 0, 0, 16, -8, -1, -1, 31});

    public AttributeCellRenderer() {
        this.setHorizontalTextPosition(10);
        this.setIconTextGap(2);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        AttributeInfo attributeInfo = (AttributeInfo)object;
        this.setEnabled(attributeInfo.value != null || bl || bl2);
        if (n2 == 0) {
            if (attributeInfo.required) {
                if (attributeInfo.type.getAttributeFixedValue() != null) {
                    this.setFont(this.getFixedRequiredAttributeFont());
                } else {
                    this.setFont(this.getRequiredAttributeFont());
                }
            } else if (attributeInfo.type.getAttributeFixedValue() != null) {
                this.setFont(this.getFixedAttributeFont());
            }
            this.setText(attributeInfo.label);
            this.setHorizontalAlignment(10);
            this.setIcon(null);
        } else {
            DataType dataType = attributeInfo.type.getAttributeDataType();
            boolean bl3 = dataType instanceof Base64BinaryType || dataType instanceof HexBinaryType;
            String string = attributeInfo.value;
            if (string == null) {
                Data data = attributeInfo.type.getAttributeFixedValue();
                if (data == null) {
                    data = attributeInfo.type.getAttributeDefaultValue();
                }
                if (data != null) {
                    AttributeTableModel attributeTableModel = (AttributeTableModel)jTable.getModel();
                    string = data.formatData(attributeTableModel.getElement());
                }
            }
            if (string == null) {
                if (bl3) {
                    this.setText(null);
                } else {
                    this.setText("-");
                }
                this.setHorizontalAlignment(0);
            } else {
                if (bl3) {
                    this.setText(null);
                } else {
                    this.setText(string);
                }
                this.setHorizontalAlignment(10);
            }
            if (dataType.getEnumeratedValues() != null) {
                if (this.dropdownIcon == null) {
                    this.dropdownIcon = new ImageIcon(dropdownBitmap.getImage(this.getForeground()));
                }
                this.setIcon(this.dropdownIcon);
            } else if (bl3) {
                if (this.binaryIcon == null) {
                    this.binaryIcon = new ImageIcon(binaryBitmap.getImage(this.getForeground()));
                }
                this.setIcon(this.binaryIcon);
            } else {
                this.setIcon(null);
            }
        }
        return this;
    }

    private Font getRequiredAttributeFont() {
        if (this.requiredAttributeFont == null) {
            Font font = this.getFont();
            this.requiredAttributeFont = new Font(font.getFamily(), font.isBold() ? 0 : 1, font.getSize());
        }
        return this.requiredAttributeFont;
    }

    private Font getFixedAttributeFont() {
        if (this.fixedAttributeFont == null) {
            Font font = this.getFont();
            this.fixedAttributeFont = new Font(font.getFamily(), font.isItalic() ? 0 : 2, font.getSize());
        }
        return this.fixedAttributeFont;
    }

    private Font getFixedRequiredAttributeFont() {
        if (this.fixedRequiredAttributeFont == null) {
            Font font = this.getFont();
            this.fixedRequiredAttributeFont = new Font(font.getFamily(), font.isBold() && font.isItalic() ? 0 : 3, font.getSize());
        }
        return this.fixedRequiredAttributeFont;
    }

    protected void setValue(Object object) {
    }
}

