/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.AttributeCellEditor;
import com.xmlmind.xmledit.dialog.AttributeCellRenderer;
import com.xmlmind.xmledit.dialog.AttributeEditorEvent;
import com.xmlmind.xmledit.dialog.AttributeEditorListener;
import com.xmlmind.xmledit.dialog.AttributeInfo;
import com.xmlmind.xmledit.dialog.AttributeTableModel;
import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.dialog.SetAttributeValue;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.AutoCompletion;
import com.xmlmind.xmledit.guiutil.BrowseButton;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.EditText;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.guiutil.ThinBorder;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.Base64BinaryType;
import com.xmlmind.xmledit.xsd.datatype.HexBinaryType;
import com.xmlmind.xmledit.xsd.datatype.IDREFSType;
import com.xmlmind.xmledit.xsd.datatype.IDREFType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AttributeEditor
extends JPanel
implements TableModelListener,
CellEditorListener,
ListSelectionListener,
FocusListener,
ActionListener,
MouseListener {
    private JButton cancelButton;
    private JButton okButton;
    private JTextField nameField;
    private AutoCompletion nameAutoCompletion;
    private NameChoices nameChoices;
    private JButton removeButton;
    private JTextField valueField;
    private AutoCompletion valueAutoCompletion;
    private JButton listButton;
    private BrowseButton browseButton;
    private JTextField valueTypeField;
    private JTextField defaultValueField;
    private AttributeTableModel attributeTableModel;
    private JTable table;
    private JScrollPane scrollPane;
    private EventListenerList listenerList = new EventListenerList();
    private JPopupMenu removeMenu = null;
    private String form2FilledFor = null;
    private static final AWTKeyStroke[] keyStrokes1 = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 2)};
    private static final AWTKeyStroke[] keyStrokes2 = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 2), AWTKeyStroke.getAWTKeyStroke(' ')};
    private static final String requiredLabel = Msg.msg("AE.required");
    private static final String fixedLabel = Msg.msg("AE.fixed");
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$AttributeEditor;
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$AttributeEditorListener;

    public AttributeEditor() {
        this(true);
    }

    public AttributeEditor(boolean bl) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        this.attributeTableModel = new AttributeTableModel();
        this.attributeTableModel.addTableModelListener(this);
        this.table = new Table(this.attributeTableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(4);
        this.table.setShowGrid(true);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(this);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        int n = fontMetrics.stringWidth("123456789012");
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setHeaderValue(Msg.msg("AE.attributeHeader"));
        tableColumn.setPreferredWidth(n);
        tableColumn.setResizable(true);
        AttributeCellRenderer attributeCellRenderer = new AttributeCellRenderer();
        tableColumn.setCellRenderer(attributeCellRenderer);
        AttributeCellEditor attributeCellEditor = new AttributeCellEditor();
        tableColumn.setCellEditor(attributeCellEditor);
        attributeCellEditor.addCellEditorListener(this);
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setHeaderValue(Msg.msg("AE.valueHeader"));
        tableColumn.setPreferredWidth(2 * n);
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(attributeCellRenderer);
        tableColumn.setCellEditor(attributeCellEditor);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(3 * (n + 5), 21 * fontMetrics.getHeight()));
        gridBagConstraints.gridx = 0;
        if (bl) {
            gridBagConstraints.gridy = 0;
        } else {
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets.bottom = 2;
        }
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (bl) {
            ++gridBagConstraints.gridy;
        } else {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets.bottom = 0;
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        Color color = MultiLineJLabel.getLabelForeground();
        Font font = MultiLineJLabel.getLabelFont();
        font = new Font(font.getFamily(), font.getStyle(), Math.max(10, font.getSize() - 2));
        this.valueTypeField = new JTextField();
        this.valueTypeField.setEditable(false);
        this.valueTypeField.setFocusable(false);
        this.valueTypeField.setFont(font);
        this.valueTypeField.setForeground(color);
        this.valueTypeField.setBorder(new ThinBorder(this.getBackground(), false));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 0;
        if (bl) {
            gridBagConstraints.insets.bottom = 2;
        }
        this.add((Component)this.valueTypeField, gridBagConstraints);
        this.defaultValueField = new JTextField();
        this.defaultValueField.setEditable(false);
        this.defaultValueField.setFocusable(false);
        this.defaultValueField.setFont(font);
        this.defaultValueField.setForeground(color);
        this.defaultValueField.setBorder(new ThinBorder(this.getBackground(), false));
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets.right = 2;
        this.add((Component)this.defaultValueField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.cancelButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$AttributeEditor == null ? (class$com$xmlmind$xmledit$dialog$AttributeEditor = AttributeEditor.class$("com.xmlmind.xmledit.dialog.AttributeEditor")) : class$com$xmlmind$xmledit$dialog$AttributeEditor, "cancel.gif")));
        DialogUtil.setIconic(this.cancelButton);
        this.cancelButton.setToolTipText(Msg.msg("AE.cancelToolTip"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.okButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$AttributeEditor == null ? (class$com$xmlmind$xmledit$dialog$AttributeEditor = AttributeEditor.class$("com.xmlmind.xmledit.dialog.AttributeEditor")) : class$com$xmlmind$xmledit$dialog$AttributeEditor, "ok.gif")));
        DialogUtil.setIconic(this.okButton);
        this.okButton.setToolTipText(Msg.msg("AE.okToolTip"));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 2;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        this.nameField = new JTextField();
        this.nameField.setActionCommand("set");
        this.nameField.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.nameField, gridBagConstraints);
        this.nameAutoCompletion = new AutoCompletion(this.nameField);
        this.nameAutoCompletion.setAppendKeyStrokes(keyStrokes2);
        this.nameChoices = new NameChoices(this.attributeTableModel);
        this.removeButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$AttributeEditor == null ? (class$com$xmlmind$xmledit$dialog$AttributeEditor = AttributeEditor.class$("com.xmlmind.xmledit.dialog.AttributeEditor")) : class$com$xmlmind$xmledit$dialog$AttributeEditor, "removecombo.gif")));
        DialogUtil.setIconic(this.removeButton);
        this.removeButton.setToolTipText(Msg.msg("AE.removeToolTip"));
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            public void showPopupMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AttributeInfo attributeInfo = AttributeEditor.this.validateForm(false, false);
                    JPopupMenu jPopupMenu = AttributeEditor.this.getRemoveMenu(attributeInfo);
                    DialogUtil.showMenu(jPopupMenu, AttributeEditor.this.removeButton);
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        this.valueField = new JTextField();
        this.valueField.addFocusListener(this);
        this.valueField.setActionCommand("ok");
        this.valueField.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.valueField, gridBagConstraints);
        this.valueAutoCompletion = new AutoCompletion(this.valueField);
        this.listButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$AttributeEditor == null ? (class$com$xmlmind$xmledit$dialog$AttributeEditor = AttributeEditor.class$("com.xmlmind.xmledit.dialog.AttributeEditor")) : class$com$xmlmind$xmledit$dialog$AttributeEditor, "list.gif")));
        DialogUtil.setIconic(this.listButton);
        this.listButton.setToolTipText(Msg.msg("AE.listToolTip"));
        this.listButton.setActionCommand("list");
        this.listButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 2;
        jPanel2.add((Component)this.listButton, gridBagConstraints);
        this.browseButton = new BrowseButton();
        this.browseButton.setActionCommand("browse");
        this.browseButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.browseButton, gridBagConstraints);
        this.enableForm();
    }

    private JPopupMenu getRemoveMenu(AttributeInfo attributeInfo) {
        JMenuItem jMenuItem;
        if (this.removeMenu == null) {
            this.removeMenu = new JPopupMenu();
            jMenuItem = this.removeMenu.add(Msg.msg("AE.copy"));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("copy");
            this.removeMenu.addSeparator();
            jMenuItem = this.removeMenu.add(Msg.msg("AE.remove"));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("remove");
            jMenuItem = this.removeMenu.add(Msg.msg("AE.forceRemove"));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("forceRemove");
        }
        jMenuItem = (JMenuItem)this.removeMenu.getComponent(0);
        JMenuItem jMenuItem2 = (JMenuItem)this.removeMenu.getComponent(2);
        JMenuItem jMenuItem3 = (JMenuItem)this.removeMenu.getComponent(3);
        boolean bl = attributeInfo != null && attributeInfo.value != null;
        jMenuItem.setEnabled(bl);
        if (!this.formIsEnabled()) {
            jMenuItem2.setEnabled(false);
            jMenuItem3.setEnabled(false);
        } else {
            jMenuItem2.setEnabled(bl && !attributeInfo.required);
            jMenuItem3.setEnabled(bl);
        }
        return this.removeMenu;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.valueField.isEnabled()) {
            return;
        }
        if (this.form2FilledFor == null || !this.form2FilledFor.equals(this.nameField.getText().trim())) {
            AttributeInfo attributeInfo = this.validateForm(false, false);
            if (attributeInfo != null) {
                this.fillForm2(attributeInfo);
            } else {
                String string = this.valueField.getText();
                this.clearForm2();
                this.valueAutoCompletion.setEntry(string);
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("set")) {
            this.setAction();
        } else if (string.equals("ok")) {
            this.okAction();
        } else if (string.equals("cancel")) {
            this.cancelAction();
        } else if (string.equals("remove")) {
            this.removeAction(false);
        } else if (string.equals("forceRemove")) {
            this.removeAction(true);
        } else if (string.equals("list")) {
            this.listAction();
        } else if (string.equals("browse")) {
            this.browseAction();
        } else if (string.equals("copy")) {
            this.copyAction();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.clearForm();
        this.enableForm();
    }

    public void editingStopped(ChangeEvent changeEvent) {
        AttributeCellEditor attributeCellEditor = (AttributeCellEditor)changeEvent.getSource();
        AttributeInfo attributeInfo = attributeCellEditor.getEditedAttributeInfo();
        String string = attributeCellEditor.getInitialAttributeValue();
        Element element = this.attributeTableModel.getElementEditor().getEditedElement();
        this.fireAttributeEdited(new AttributeEditorEvent(this, 1, element, attributeInfo.name, string, attributeInfo.value, false));
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        Element element = this.attributeTableModel.getElementEditor().getEditedElement();
        this.fireAttributeEdited(new AttributeEditorEvent(this, 0, element, null, null, null, false));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        AttributeInfo attributeInfo;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n < 0 || n2 < 0 || (attributeInfo = (AttributeInfo)this.attributeTableModel.getValueAt(n, n2)) == null) {
            this.clearForm();
        } else {
            this.fillForm(attributeInfo);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = mouseEvent.getPoint();
            int n = this.table.rowAtPoint(point);
            if (n < 0) {
                return;
            }
            if (this.table.getSelectedRow() != n) {
                this.table.changeSelection(n, 0, false, false);
            }
            AttributeInfo attributeInfo = (AttributeInfo)this.attributeTableModel.getValueAt(n, 0);
            JPopupMenu jPopupMenu = this.getRemoveMenu(attributeInfo);
            jPopupMenu.show(this.table, point.x, point.y);
        }
    }

    public void addAttributeEditorListener(AttributeEditorListener attributeEditorListener) {
        this.listenerList.add(class$com$xmlmind$xmledit$dialog$AttributeEditorListener == null ? (class$com$xmlmind$xmledit$dialog$AttributeEditorListener = AttributeEditor.class$("com.xmlmind.xmledit.dialog.AttributeEditorListener")) : class$com$xmlmind$xmledit$dialog$AttributeEditorListener, attributeEditorListener);
    }

    public void removeAttributeEditorListener(AttributeEditorListener attributeEditorListener) {
        this.listenerList.remove(class$com$xmlmind$xmledit$dialog$AttributeEditorListener == null ? (class$com$xmlmind$xmledit$dialog$AttributeEditorListener = AttributeEditor.class$("com.xmlmind.xmledit.dialog.AttributeEditorListener")) : class$com$xmlmind$xmledit$dialog$AttributeEditorListener, attributeEditorListener);
    }

    private void fireAttributeEdited(AttributeEditorEvent attributeEditorEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$xmlmind$xmledit$dialog$AttributeEditorListener == null ? AttributeEditor.class$("com.xmlmind.xmledit.dialog.AttributeEditorListener") : class$com$xmlmind$xmledit$dialog$AttributeEditorListener)) {
                ((AttributeEditorListener)objectArray[n + 1]).attributeEdited(attributeEditorEvent);
            }
            n -= 2;
        }
    }

    public JButton getOKButton() {
        return this.okButton;
    }

    public JTextField getNameTextField() {
        return this.nameField;
    }

    public void setDocument(Document document) {
        this.attributeTableModel.setDocument(document);
    }

    public Document getDocument() {
        return this.attributeTableModel.getDocument();
    }

    public void setElement(Element element) {
        this.attributeTableModel.setElement(element);
    }

    public void resetElement() {
        this.attributeTableModel.resetElement();
    }

    public Element getElement() {
        return this.attributeTableModel.getElement();
    }

    public void setEditable(boolean bl) {
        this.attributeTableModel.setEditable(bl);
        this.enableForm();
    }

    public boolean isEditable() {
        return this.attributeTableModel.isEditable();
    }

    private void enableForm() {
        boolean bl = this.formIsEnabled();
        this.cancelButton.setEnabled(bl);
        this.okButton.setEnabled(bl);
        this.nameField.setEnabled(bl);
        this.nameAutoCompletion.setChoices(bl ? this.nameChoices : null);
        this.removeButton.setEnabled(bl);
        this.valueField.setEnabled(bl);
        this.listButton.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    private boolean formIsEnabled() {
        return this.attributeTableModel.isEditable() && this.attributeTableModel.getElementEditor().canEditElement();
    }

    private void clearForm() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        this.table.clearSelection();
        AttributeEditor.ensureRowIsVisible(this.table, 0);
        this.nameAutoCompletion.setEntry("");
        this.clearForm2();
    }

    private static final void ensureRowIsVisible(JTable jTable, int n) {
        Rectangle rectangle = jTable.getCellRect(n, 0, true);
        if (rectangle.width <= 0) {
            rectangle.width = 1;
        }
        if (rectangle.height <= 0) {
            rectangle.height = 1;
        }
        jTable.scrollRectToVisible(rectangle);
    }

    private void clearForm2() {
        this.form2FilledFor = null;
        this.valueAutoCompletion.setChoices(null);
        this.valueAutoCompletion.setEntry("");
        this.valueTypeField.setText("");
        this.defaultValueField.setText("");
    }

    private void fillForm(AttributeInfo attributeInfo) {
        this.nameAutoCompletion.setEntry(attributeInfo.label);
        this.fillForm2(attributeInfo);
    }

    private void fillForm2(AttributeInfo attributeInfo) {
        Data data;
        boolean bl;
        Object object;
        this.form2FilledFor = attributeInfo.label;
        AttributeType attributeType = attributeInfo.type;
        DataType dataType = attributeType.getAttributeDataType();
        Element element = this.attributeTableModel.getElement();
        Object object2 = null;
        Data[] dataArray = dataType.getEnumeratedValues();
        if (dataArray != null) {
            object2 = object = new EnumChoices(dataArray, element);
            this.valueAutoCompletion.setAppendKeyStrokes(((EnumChoices)object).containWhitespaces() ? keyStrokes1 : keyStrokes2);
        } else if ((dataType instanceof IDREFType || dataType instanceof IDType || dataType instanceof IDREFSType) && DocumentTypeUtil.isConstrainedDocumentType((DocumentType)(object = DocumentTypeUtil.getDocumentType(element)))) {
            object2 = new IDChoices(element.getDocument(), (DocumentType)object);
            this.valueAutoCompletion.setAppendKeyStrokes(dataType instanceof IDREFSType ? keyStrokes1 : keyStrokes2);
        }
        this.valueAutoCompletion.setChoices((AutoCompletion.Choices)object2);
        boolean bl2 = bl = dataType instanceof Base64BinaryType || dataType instanceof HexBinaryType;
        if (attributeInfo.value == null || bl) {
            this.valueAutoCompletion.setEntry("");
        } else {
            this.valueAutoCompletion.setEntry(attributeInfo.value);
            this.valueField.selectAll();
        }
        String string = dataType.getDataTypeLabel(element);
        if (string == null || string.length() == 0) {
            this.valueTypeField.setText("");
        } else {
            this.valueTypeField.setText(string);
            this.valueTypeField.setCaretPosition(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (attributeInfo.required) {
            stringBuffer.append(requiredLabel);
        }
        if ((data = attributeType.getAttributeFixedValue()) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(fixedLabel);
        } else {
            data = attributeType.getAttributeDefaultValue();
        }
        if (data != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('\"');
            String string2 = data.formatData(element);
            if (string2.length() > 1024) {
                stringBuffer.append(string2.substring(0, 1020));
                stringBuffer.append(" ...");
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append('\"');
        }
        this.defaultValueField.setText(stringBuffer.toString());
        if (stringBuffer.length() != 0) {
            this.defaultValueField.setCaretPosition(0);
        }
    }

    private AttributeInfo validateForm(boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        String string = this.nameField.getText().trim();
        if (string.length() == 0) {
            if (bl2) {
                DialogUtil.badField(this.nameField);
            }
            return null;
        }
        AttributeInfo attributeInfo = null;
        AttributeInfo[] attributeInfoArray = this.attributeTableModel.getAttributeInfo();
        int n = this.attributeTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            object3 = attributeInfoArray[n2];
            if (((AttributeInfo)object3).label.equals(string)) {
                attributeInfo = ((AttributeInfo)object3).copy();
                break;
            }
            ++n2;
        }
        object3 = null;
        if (attributeInfo == null) {
            object2 = null;
            int n3 = n;
            while (n3 < attributeInfoArray.length) {
                Object object4;
                object = attributeInfoArray[n3];
                if (object2 == null && (object2 = Name.parse(string, true, (PrefixToNamespace)(object4 = this.attributeTableModel.getElement()))) == null) {
                    if (!DocumentTypeUtil.isNamespaceAware((Element)object4) && XMLUtil.isName(string)) {
                        object2 = Name.get(string);
                    } else {
                        object3 = Msg.msg("AE.malformedQName", string);
                        break;
                    }
                }
                if ((object4 = ((AttributeInfo)object).field.getFieldNameClass()).containsName((Name)object2)) {
                    attributeInfo = ((AttributeInfo)object).copy();
                    attributeInfo.name = object2;
                    ElementEditor elementEditor = this.attributeTableModel.getElementEditor();
                    attributeInfo.type = elementEditor.getAttributeType(attributeInfo.field, attributeInfo.name);
                    break;
                }
                ++n3;
            }
            if (object2 != null && attributeInfo == null) {
                object3 = Msg.msg("AE.notMatchedByAWildcard", string);
            }
        }
        if (attributeInfo == null) {
            if (bl2) {
                DialogUtil.badField(this.nameField);
                if (object3 != null) {
                    Alert.showError(this, (String)object3);
                }
            }
            return null;
        }
        if (bl) {
            object2 = attributeInfo.type.getAttributeDataType();
            String string2 = object2.normalizeWhiteSpace(this.valueField.getText());
            object3 = null;
            if (object2 instanceof Base64BinaryType || object2 instanceof HexBinaryType) {
                if (string2.length() != 0) {
                    object3 = Msg.msg("AE.cannotTypeBinaryValue");
                }
            } else {
                object = this.attributeTableModel.getElementEditor();
                object3 = ((ElementEditor)object).checkAttributeValue(attributeInfo.type, string2);
            }
            if (object3 != null) {
                if (bl2) {
                    DialogUtil.badField(this.valueField);
                    Alert.showError(this, (String)object3);
                }
                return null;
            }
            attributeInfo.value = string2;
        }
        return attributeInfo;
    }

    private void setAction() {
        this.valueField.requestFocus();
    }

    private void cancelAction() {
        this.clearForm();
        this.fireAttributeEdited(new AttributeEditorEvent(this, 0, this.attributeTableModel.getElementEditor().getEditedElement(), null, null, null, true));
    }

    private void okAction() {
        AttributeInfo attributeInfo = this.validateForm(true, true);
        if (attributeInfo == null) {
            return;
        }
        this.ok(attributeInfo);
    }

    private void ok(AttributeInfo attributeInfo) {
        ElementEditor elementEditor = this.attributeTableModel.getElementEditor();
        String string = elementEditor.getAttribute(attributeInfo.name);
        if (attributeInfo.value == null && string == null || attributeInfo.value != null && attributeInfo.value.equals(string)) {
            this.cancelAction();
            return;
        }
        elementEditor.putAttribute(attributeInfo.name, attributeInfo.value);
        this.fireAttributeEdited(new AttributeEditorEvent(this, 1, elementEditor.getEditedElement(), attributeInfo.name, string, attributeInfo.value, true));
    }

    private void removeAction(boolean bl) {
        AttributeInfo attributeInfo = this.validateForm(false, true);
        if (attributeInfo == null) {
            return;
        }
        ElementEditor elementEditor = this.attributeTableModel.getElementEditor();
        if (!bl && !elementEditor.canRemoveAttribute(attributeInfo.name)) {
            String string = attributeInfo.name.format(true, this.attributeTableModel.getElement());
            this.getToolkit().beep();
            Alert.showError(this, Msg.msg("AE.mandatoryAttribute", string));
            return;
        }
        String string = elementEditor.removeAttribute(attributeInfo.name);
        if (string == null) {
            this.cancelAction();
            return;
        }
        this.fireAttributeEdited(new AttributeEditorEvent(this, bl ? 3 : 2, elementEditor.getEditedElement(), attributeInfo.name, string, null, true));
    }

    private void listAction() {
        String string;
        AttributeInfo attributeInfo = this.validateForm(false, true);
        if (attributeInfo == null) {
            return;
        }
        DataType dataType = attributeInfo.type.getAttributeDataType();
        boolean bl = dataType instanceof Base64BinaryType || dataType instanceof HexBinaryType;
        Element element = this.attributeTableModel.getElement();
        if (SetAttributeValue.canSetValue(element, dataType)) {
            string = bl ? attributeInfo.value : this.valueField.getText();
            string = SetAttributeValue.setValue(this, element, attributeInfo.name, string, dataType);
        } else {
            string = EditText.editText(this, Msg.msg("AE.valueOfAttribute", attributeInfo.name.format(true, element)), this.valueField.getText(), false, 5, 80);
        }
        if (string == null) {
            return;
        }
        if (bl) {
            string = dataType.normalizeWhiteSpace(string);
            String string2 = this.attributeTableModel.getElementEditor().checkAttributeValue(attributeInfo.type, string);
            if (string2 != null) {
                Alert.showError(this, string2);
            } else {
                attributeInfo.value = string;
                this.ok(attributeInfo);
            }
        } else {
            this.valueAutoCompletion.setEntry(string);
            this.okAction();
        }
    }

    private void browseAction() {
        boolean bl;
        AttributeInfo attributeInfo = this.validateForm(false, true);
        if (attributeInfo == null) {
            return;
        }
        DataType dataType = attributeInfo.type.getAttributeDataType();
        boolean bl2 = bl = dataType instanceof Base64BinaryType || dataType instanceof HexBinaryType;
        if (bl) {
            return;
        }
        Element element = this.attributeTableModel.getElement();
        URL uRL = element == null ? null : element.getLocation();
        String string = this.browseButton.getSelection(this, uRL);
        if (string == null) {
            return;
        }
        this.valueAutoCompletion.setEntry(string);
        this.okAction();
    }

    private void copyAction() {
        AttributeInfo attributeInfo = this.validateForm(false, true);
        if (attributeInfo == null || attributeInfo.value == null || attributeInfo.value.length() == 0) {
            return;
        }
        Clipboard.put(this, attributeInfo.value);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class IDChoices
    extends AutoCompletion.MinimalChoices {
        private Document doc;
        private DocumentType docType;

        public IDChoices(Document document, DocumentType documentType) {
            super(null);
            this.doc = document;
            this.docType = documentType;
        }

        public Object[] getAll() {
            if (this.list == null) {
                Object[] objectArray = DocumentTypeUtil.getIds(this.doc, this.docType);
                if (objectArray.length > 1) {
                    Arrays.sort(objectArray);
                }
                this.list = objectArray;
            }
            return this.list;
        }
    }

    private static final class EnumChoices
    extends AutoCompletion.MinimalChoices {
        private boolean containWhitespaces = false;

        public EnumChoices(Data[] dataArray, Element element) {
            super(null);
            Object[] objectArray = new String[dataArray.length];
            int n = 0;
            while (n < dataArray.length) {
                String string = dataArray[n].formatData(element);
                objectArray[n] = string;
                if (!this.containWhitespaces && string.indexOf(32) >= 0) {
                    this.containWhitespaces = true;
                }
                ++n;
            }
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
            this.list = objectArray;
        }

        public boolean containWhitespaces() {
            return this.containWhitespaces;
        }
    }

    public static final class NameChoices
    implements AutoCompletion.Choices {
        private AttributeTableModel attributeTableModel;

        public NameChoices(AttributeTableModel attributeTableModel) {
            this.attributeTableModel = attributeTableModel;
        }

        public void getChoices(String string, AutoCompletion.ChoiceList choiceList) {
            AttributeInfo[] attributeInfoArray;
            AttributeInfo[] attributeInfoArray2 = this.attributeTableModel.getAttributeInfo();
            if (string.length() == 0) {
                choiceList.list = attributeInfoArray2;
                choiceList.first = -1;
                return;
            }
            int n = this.attributeTableModel.getRowCount();
            AttributeInfo[] attributeInfoArray3 = new AttributeInfo[attributeInfoArray2.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                attributeInfoArray = attributeInfoArray2[n3];
                if (attributeInfoArray.label.startsWith(string)) {
                    attributeInfoArray3[n2++] = attributeInfoArray;
                }
                ++n3;
            }
            if (n < attributeInfoArray2.length && XMLUtil.isName(string)) {
                int n4 = n;
                while (n4 < attributeInfoArray2.length) {
                    attributeInfoArray3[n2++] = attributeInfoArray2[n4];
                    ++n4;
                }
            }
            if (n2 != attributeInfoArray3.length) {
                attributeInfoArray = new AttributeInfo[n2];
                System.arraycopy(attributeInfoArray3, 0, attributeInfoArray, 0, n2);
                attributeInfoArray3 = attributeInfoArray;
            }
            choiceList.list = attributeInfoArray3;
            choiceList.first = n2 > 0 ? 0 : -1;
        }

        public boolean choiceListDependsOnPrefix() {
            return true;
        }
    }

    private static class Table
    extends JTable {
        public Table(AttributeTableModel attributeTableModel) {
            super(attributeTableModel);
        }

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null && !((AttributeCellEditor)tableCellEditor).cellHasBeenEdited()) {
                tableCellEditor.cancelCellEditing();
            }
            return super.editCellAt(n, n2, eventObject);
        }
    }
}

