/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.AttributeInfo;
import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.UnconstrainedAttributeType;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.StructureInfo;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.Base64BinaryType;
import com.xmlmind.xmledit.xsd.datatype.HexBinaryType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

class AttributeTableModel
extends AbstractTableModel
implements DocumentListener {
    private boolean editable = true;
    private Document document = null;
    private ElementEditor elementEditor = new ElementEditor();
    private Element element = null;
    private static final AttributeInfo[] NO_INFO = new AttributeInfo[0];
    private AttributeInfo[] infos = NO_INFO;
    private int rowCount = 0;
    private boolean batchEditing = false;
    private static final int RESET_ELEMENT = 1;
    private static final int UNSET_ELEMENT = 2;
    private int pendingActions = 0;
    private ArrayList addList = new ArrayList();
    private ArrayList infoList = new ArrayList();
    private HashMap labelEntries = new HashMap();

    AttributeTableModel() {
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.setElement(null);
            this.elementEditor.setDocumentType(null);
            this.document.removeDocumentListener(this);
            this.document = null;
            this.batchEditing = false;
            this.pendingActions = 0;
        }
        if (document != null) {
            this.document = document;
            this.document.addDocumentListener(this, false);
            DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
            this.elementEditor.setDocumentType(documentType);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setElement(Element element) {
        if (element == null && this.element == null) {
            return;
        }
        this.batchEditing = false;
        this.pendingActions = 0;
        this.element = element;
        this.elementEditor.setEditedElement(element);
        this.compileModel();
        this.fireTableDataChanged();
    }

    public void resetElement() {
        this.elementEditor.resetEditedElement();
        this.compileModel();
        this.fireTableDataChanged();
    }

    public Element getElement() {
        return this.element;
    }

    public ElementEditor getElementEditor() {
        return this.elementEditor;
    }

    public AttributeInfo[] getAttributeInfo() {
        return this.infos;
    }

    private void compileModel() {
        Object object;
        Object object2;
        Object object3;
        this.infos = NO_INFO;
        this.rowCount = 0;
        if (this.element == null) {
            return;
        }
        StructureInfo structureInfo = this.elementEditor.getEditedElementStructureInfo();
        Name[] nameArray = structureInfo.structure.attributeNames;
        Field[] fieldArray = structureInfo.structure.attributeFields;
        int n = structureInfo.structure.attributeFieldCount;
        ElementType elementType = structureInfo.elementType;
        this.labelEntries.clear();
        this.infoList.clear();
        int n2 = 0;
        while (n2 < n) {
            Name name = nameArray[n2];
            Field field = fieldArray[n2];
            object3 = this.element.getAttribute(name);
            object2 = elementType.getAttributeType(field, name);
            if (object2 == null) {
                object2 = UnconstrainedAttributeType.INSTANCE;
            }
            boolean bl = elementType.isRequiredAttribute(field);
            String string = name.format(true, this.element);
            object = new LabelEntry(string);
            ((LabelEntry)object).count = 1;
            this.labelEntries.put(string, object);
            this.infoList.add(new AttributeInfo(string, field, name, (AttributeType)object2, bl, (String)object3));
            ++this.rowCount;
            ++n2;
        }
        if (this.elementEditor.canAddAttribute(this.addList)) {
            int n3 = this.addList.size();
            int n4 = 0;
            while (n4 < n3) {
                object3 = (Field)this.addList.get(n4);
                object2 = object3.getFieldName();
                AttributeType attributeType = null;
                if (object2 != null && (attributeType = elementType.getAttributeType((Field)object3, (Name)object2)) == null) {
                    attributeType = UnconstrainedAttributeType.INSTANCE;
                }
                boolean bl = elementType.isRequiredAttribute((Field)object3);
                object = object3.getFieldLabel(true, this.element);
                if (object == null) {
                    object = object2 != null ? ((Name)object2).format(true, this.element) : Msg.msg("AE.wildcard");
                }
                object = this.checkLabel((String)object);
                this.infoList.add(new AttributeInfo((String)object, (Field)object3, (Name)object2, attributeType, bl, null));
                if (object2 != null) {
                    ++this.rowCount;
                }
                ++n4;
            }
        }
        this.infos = this.infoList.toArray(NO_INFO);
        if (this.infos.length > 1) {
            Arrays.sort(this.infos);
        }
    }

    private String checkLabel(String string) {
        LabelEntry labelEntry = (LabelEntry)this.labelEntries.get(string);
        if (labelEntry == null) {
            labelEntry = new LabelEntry(string);
            this.labelEntries.put(string, labelEntry);
        }
        ++labelEntry.count;
        if (labelEntry.count > 1) {
            string = string + "-" + Integer.toString(labelEntry.count);
        }
        return string;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0 || !this.editable || !this.elementEditor.canEditElement()) {
            return false;
        }
        AttributeInfo attributeInfo = this.infos[n];
        DataType dataType = attributeInfo.type.getAttributeDataType();
        return !(dataType instanceof Base64BinaryType) && !(dataType instanceof HexBinaryType);
    }

    public Object getValueAt(int n, int n2) {
        return n >= 0 && n < this.rowCount ? this.infos[n] : null;
    }

    public void setValueAt(Object object, int n, int n2) {
        AttributeInfo attributeInfo = (AttributeInfo)object;
        this.element.putAttribute(attributeInfo.name, attributeInfo.value);
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        if (this.element == null) {
            return;
        }
        this.batchEditing = true;
        this.pendingActions = 0;
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        if (this.element == null) {
            return;
        }
        if ((this.pendingActions & 2) != 0) {
            this.setElement(null);
        } else if ((this.pendingActions & 1) != 0) {
            this.resetElement();
        }
        this.batchEditing = false;
        this.pendingActions = 0;
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        if (this.element == null) {
            return;
        }
        if (this.batchEditing) {
            this.pendingActions |= 1;
        } else {
            this.resetElement();
        }
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        if (this.element == null) {
            return;
        }
        switch (elementStructureEvent.getId()) {
            case 10: {
                Node node = elementStructureEvent.getNewChild();
                if (node.getNodeType() != 4) {
                    return;
                }
                if (this.batchEditing) {
                    this.pendingActions |= 1;
                    break;
                }
                this.resetElement();
                break;
            }
            case 11: 
            case 12: {
                Node node = elementStructureEvent.getOldChild();
                Node node2 = elementStructureEvent.getNewChild();
                if (node.getNodeType() != 4 && (node2 == null || node2.getNodeType() != 4)) {
                    return;
                }
                if (this.element.isDescendantOf(node)) {
                    if (this.batchEditing) {
                        this.pendingActions |= 2;
                        break;
                    }
                    this.setElement(null);
                    break;
                }
                if (this.batchEditing) {
                    this.pendingActions |= 1;
                    break;
                }
                this.resetElement();
            }
        }
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
    }

    public void textChanged(TextEvent textEvent, int n) {
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
    }

    private static final class LabelEntry {
        public String label;
        public int count;

        public LabelEntry(String string) {
            this.label = string;
            this.count = 0;
        }
    }
}

