/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.AttributeEditor;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.guiutil.Tool;
import java.awt.Component;
import javax.swing.border.EmptyBorder;

public class AttributeTool
extends Tool {
    private String titlePrefix;
    private AttributeEditor attributeEditor;

    public AttributeTool(Component component, String string) {
        this(component, string, false);
    }

    public AttributeTool(Component component, String string, boolean bl) {
        super(component, string);
        this.titlePrefix = string;
        int n = 2;
        if (bl) {
            n |= 0x40;
        }
        this.initialize(component, n);
    }

    protected Component createForm() {
        this.attributeEditor = new AttributeEditor();
        this.attributeEditor.setBorder(new EmptyBorder(3, 3, 3, 3));
        return this.attributeEditor;
    }

    public void setTitle(String string) {
        this.titlePrefix = string;
        this.updateTitle(this.attributeEditor.getElement());
    }

    private void updateTitle(Element element) {
        String string;
        if (element == null) {
            string = this.titlePrefix;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.titlePrefix);
            stringBuffer.append(" : ");
            stringBuffer.append(element.getName().format(false, element));
            string = stringBuffer.toString();
        }
        super.setTitle(string);
    }

    protected void onOpen() {
        this.attributeEditor.getNameTextField().requestFocus();
    }

    public void close() {
        this.attributeEditor.setElement(null);
        super.close();
    }

    public void setDocument(Document document) {
        this.attributeEditor.setDocument(document);
        this.updateTitle(null);
    }

    public Document getDocument() {
        return this.attributeEditor.getDocument();
    }

    public void setElement(Element element) {
        Element element2 = this.attributeEditor.getElement();
        this.attributeEditor.setElement(element);
        if (element != element2) {
            this.updateTitle(element);
        }
    }

    public void resetElement() {
        this.attributeEditor.resetElement();
        this.updateTitle(this.attributeEditor.getElement());
    }

    public Element getElement() {
        return this.attributeEditor.getElement();
    }

    public void setEditable(boolean bl) {
        this.attributeEditor.setEditable(bl);
    }

    public boolean isEditable() {
        return this.attributeEditor.isEditable();
    }
}

