/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ChooseURL;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.EditText;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.PlaceholderIcon;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.Base16;
import com.xmlmind.xmledit.xsd.datatype.Base64;
import com.xmlmind.xmledit.xsd.datatype.Base64BinaryType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class BinaryValueDialog
extends JDialog
implements ActionListener {
    private Component dialogAnchor;
    private JLabel head;
    private JButton[] buttons;
    private Element element;
    private Name attributeName;
    private String encodedValue;
    private DataType binaryType;
    private String result = null;
    private URL lastLoadedURL = null;
    private URL lastSavedURL = null;
    private static final String[] UI_SPEC = new String[]{"open.gif", "BVD.loadEncode", "loadEncode", null, "BVD.loadGzipEncode", "loadGzipEncode", "save.gif", "BVD.decodeSave", "decodeSave", null, "BVD.decodeGunzipSave", "decodeGunzipSave", "edit.gif", "BVD.edit", "edit"};
    private static final int LOAD_ENCODE = 0;
    private static final int LOAD_GZIP_ENCODE = 1;
    private static final int DECODE_SAVE = 2;
    private static final int DECODE_GUNZIP_SAVE = 3;
    private static final int EDIT = 4;
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$FieldChooser;

    public BinaryValueDialog(Dialog dialog) {
        super(dialog, true);
        this.initialize(dialog);
    }

    public BinaryValueDialog(Component component) {
        super(AWTUtil.getFrame(component), true);
        this.initialize(component);
    }

    private void initialize(Component component) {
        Object object;
        this.dialogAnchor = AWTUtil.getDialogAnchor(component);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BinaryValueDialog.this.cancel();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        this.buttons = new JButton[UI_SPEC.length / 3];
        jPanel.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        this.head = new JLabel(Msg.msg("BVD.valueOfAttribute", "xxxxxxxxxxxxxxxxxxxx"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.top = 5;
        jPanel.add((Component)this.head, gridBagConstraints);
        int n = 0;
        while (n < UI_SPEC.length) {
            JButton jButton;
            object = UI_SPEC[n];
            String string = UI_SPEC[n + 1];
            String string2 = UI_SPEC[n + 2];
            this.buttons[n / 3] = jButton = new JButton(DialogUtil.buttonLabel(Msg.msg(string)));
            DialogUtil.setMnemonic(jButton, Msg.msg(string));
            jButton.setHorizontalAlignment(2);
            Icon icon = object != null ? new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$FieldChooser == null ? BinaryValueDialog.class$("com.xmlmind.xmledit.dialog.FieldChooser") : class$com$xmlmind$xmledit$dialog$FieldChooser, (String)object)) : new PlaceholderIcon(16, 16);
            jButton.setIcon(icon);
            DialogUtil.setIconic(jButton);
            jButton.setActionCommand(string2);
            jButton.addActionListener(this);
            ++gridBagConstraints.gridy;
            if (n > 0) {
                gridBagConstraints.insets.top = object != null ? 10 : 2;
            }
            gridBagConstraints.fill = 2;
            jPanel.add((Component)jButton, gridBagConstraints);
            n += 3;
        }
        object = new JButton();
        DialogUtil.setCancelText((AbstractButton)object);
        ((AbstractButton)object).setActionCommand("cancel");
        ((AbstractButton)object).addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)object, gridBagConstraints);
        this.pack();
        this.setResizable(false);
    }

    public String edit(Element element, Name name, String string, DataType dataType) {
        String string2 = BinaryValueDialog.getHead(element, name);
        this.head.setText(string2);
        this.setTitle(string2);
        this.element = element;
        this.attributeName = name;
        this.encodedValue = string;
        this.binaryType = dataType;
        boolean bl = string != null;
        this.buttons[2].setEnabled(bl);
        this.buttons[3].setEnabled(bl);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.buttons[0].requestFocus();
        this.result = null;
        this.setVisible(true);
        this.element = null;
        this.attributeName = null;
        this.encodedValue = null;
        this.binaryType = null;
        return this.result;
    }

    private static final String getHead(Element element, Name name) {
        if (name == null) {
            return Msg.msg("BVD.valueOfElement", element.getName().format(false, element));
        }
        return Msg.msg("BVD.valueOfAttribute", name.format(true, element));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("loadEncode")) {
            this.loadEncode(false);
        } else if (string.equals("loadGzipEncode")) {
            this.loadEncode(true);
        } else if (string.equals("decodeSave")) {
            this.decodeSave(false);
        } else if (string.equals("decodeGunzipSave")) {
            this.decodeSave(true);
        } else if (string.equals("edit")) {
            this.edit();
        } else if (string.equals("cancel")) {
            this.cancel();
        }
    }

    private void loadEncode(boolean bl) {
        byte[] byArray;
        URL uRL;
        URL uRL2 = this.lastLoadedURL;
        if (uRL2 == null) {
            uRL2 = this.element.getDocument().getLocation();
        }
        if ((uRL = ChooseURL.chooseOpenFileURL(this, uRL2)) == null) {
            return;
        }
        this.lastLoadedURL = uRL;
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            OutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
            if (bl) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            InputStream inputStream = uRLConnection.getInputStream();
            FileUtil.copy(inputStream, outputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Alert.showError(this, Msg.msg("BVD.cannotOpenFile", URLUtil.toLabel(uRL), MiscUtil.reason(iOException)));
            return;
        }
        this.result = this.binaryType instanceof Base64BinaryType ? Base64.encode(byArray) : Base16.encode(byArray);
        this.setVisible(false);
        this.dispose();
    }

    private void decodeSave(boolean bl) {
        byte[] byArray;
        Object object;
        if (this.encodedValue == null) {
            return;
        }
        URL uRL = this.lastSavedURL;
        if (uRL == null) {
            uRL = this.element.getDocument().getLocation();
        }
        if (uRL != null) {
            object = this.attributeName == null ? this.element.getLocalName() : this.attributeName.getLocalPart();
            try {
                uRL = new URL(uRL, (String)object + ".bin");
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
        }
        if ((object = ChooseURL.defaultChooseSaveFileURL(this, uRL)) == null) {
            return;
        }
        this.lastSavedURL = object;
        try {
            byArray = this.binaryType instanceof Base64BinaryType ? Base64.decode(this.encodedValue) : Base16.decode(this.encodedValue);
        }
        catch (InvalidDataException invalidDataException) {
            Alert.showError(this, Msg.msg("BVD.cannotDecode", this.binaryType.getDataTypeLabel(this.element), MiscUtil.reason(invalidDataException)));
            return;
        }
        File file = FileUtil.urlToFile((URL)object);
        try {
            InputStream inputStream = new ByteArrayInputStream(byArray);
            if (bl && FileUtil.isGzipped(byArray)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileUtil.copy(inputStream, fileOutputStream);
        }
        catch (IOException iOException) {
            Alert.showError(this, Msg.msg("BVD.cannotSaveFile", file, MiscUtil.reason(iOException)));
            return;
        }
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    private void edit() {
        String string = this.encodedValue;
        if (string != null && this.binaryType instanceof Base64BinaryType) {
            string = string.replace(' ', '\n');
        }
        this.result = EditText.editText(this, BinaryValueDialog.getHead(this.element, this.attributeName), string, false, 25, 80);
        if (this.result == null) {
            return;
        }
        this.result = this.result.trim();
        if (this.result.length() == 0) {
            Alert.showError(this, Msg.msg("BVD.emptyString", this.binaryType.getDataTypeLabel(this.element)));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

