/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.CharacterTable;
import com.xmlmind.xmledit.dialog.CharacterTableListener;
import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class CharacterChooser
extends JPanel
implements ActionListener,
MouseListener {
    protected JButton previousRangeButton;
    protected JComboBox rangeCombo;
    protected JButton nextRangeButton;
    protected CharacterTable characterTable;
    protected char[] favorites;
    protected boolean showFavorites;
    protected JPopupMenu popupMenu;
    protected char pickedChar;
    protected static final String favoritesLabel = Msg.msg("CC.favorites");
    protected static final Range[] RANGES = new Range[]{new Range("Basic Latin", '\u0000'), new Range("Latin-1 Supplement", '\u0080'), new Range("Latin Extended-A", '\u0100'), new Range("Latin Extended-B", '\u0180'), new Range("IPA Extensions", '\u0250'), new Range("Spacing Modifier Letters", '\u02b0'), new Range("Combining Diacritical Marks", '\u0300'), new Range("Greek", '\u0370'), new Range("Cyrillic", '\u0400'), new Range("Armenian", '\u0530'), new Range("Hebrew", '\u0590'), new Range("Arabic", '\u0600'), new Range("Latin Extended Additional", '\u1e00'), new Range("Greek Extended", '\u1f00'), new Range("General Punctuation", '\u2000'), new Range("Superscripts and Subscripts", '\u2070'), new Range("Currency Symbols", '\u20a0'), new Range("Combining Marks for Symbols", '\u20d0'), new Range("Letterlike Symbols", '\u2100'), new Range("Number Forms", '\u2150'), new Range("Arrows", '\u2190'), new Range("Mathematical Operators", '\u2200'), new Range("Miscellaneous Technical", '\u2300'), new Range("Enclosed Alphanumerics", '\u2460'), new Range("Box Drawing", '\u2500'), new Range("Block Elements", '\u2580'), new Range("Geometric Shapes", '\u25a0'), new Range("Miscellaneous Symbols", '\u2600'), new Range("Dingbats", '\u2700')};
    protected static final FavoritesRange FAVORITES_RANGE = new FavoritesRange();
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$CharacterChooser;

    public CharacterChooser() {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        this.previousRangeButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$CharacterChooser == null ? (class$com$xmlmind$xmledit$dialog$CharacterChooser = CharacterChooser.class$("com.xmlmind.xmledit.dialog.CharacterChooser")) : class$com$xmlmind$xmledit$dialog$CharacterChooser, "prevrange.gif")));
        DialogUtil.setIconic(this.previousRangeButton);
        this.previousRangeButton.setToolTipText(Msg.msg("CC.previousRangeToolTip"));
        this.previousRangeButton.setActionCommand("previousRange");
        this.previousRangeButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.previousRangeButton, gridBagConstraints);
        this.rangeCombo = new JComboBox<Range>(RANGES);
        Dimension dimension = this.rangeCombo.getPreferredSize();
        dimension.width = 50;
        this.rangeCombo.setMinimumSize(dimension);
        this.rangeCombo.setEditable(true);
        this.rangeCombo.setActionCommand("changeRange");
        this.rangeCombo.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rangeCombo, gridBagConstraints);
        this.nextRangeButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$CharacterChooser == null ? (class$com$xmlmind$xmledit$dialog$CharacterChooser = CharacterChooser.class$("com.xmlmind.xmledit.dialog.CharacterChooser")) : class$com$xmlmind$xmledit$dialog$CharacterChooser, "nextrange.gif")));
        DialogUtil.setIconic(this.nextRangeButton);
        this.nextRangeButton.setToolTipText(Msg.msg("CC.nextRangeToolTip"));
        this.nextRangeButton.setActionCommand("nextRange");
        this.nextRangeButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 2;
        this.add((Component)this.nextRangeButton, gridBagConstraints);
        this.characterTable = new CharacterTable();
        int n = this.getFont().getSize();
        if (n < 14) {
            n = 14;
        }
        this.characterTable.setFont(new Font("Serif", 0, n));
        Color color = this.getBackground();
        this.characterTable.setGridColor(color.darker());
        this.characterTable.setTableColor(color.brighter());
        color = new Color(color.getRed(), color.getGreen(), Math.min(160, color.getBlue()));
        this.characterTable.setPrivateUseAreaColor(color);
        this.characterTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.characterTable);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 2;
        this.add((Component)jScrollPane, gridBagConstraints);
        this.updateButtonState();
    }

    protected void updateButtonState() {
        char c = this.characterTable.getFirstDisplayedChar();
        int n = c - 256;
        if (n < 0) {
            n = 0;
        }
        this.previousRangeButton.setEnabled(n != c);
        n = c + 256;
        if (n > 65279) {
            n = 65279;
        }
        this.nextRangeButton.setEnabled(n != c);
    }

    public JComboBox getRangeComboBox() {
        return this.rangeCombo;
    }

    public CharacterTable getCharacterTable() {
        return this.characterTable;
    }

    public void setFirstDisplayedChar(char c) {
        this.characterTable.setFirstDisplayedChar(c);
        c = this.characterTable.getFirstDisplayedChar();
        String string = null;
        ComboBoxModel comboBoxModel = this.rangeCombo.getModel();
        int n = comboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            Object e = comboBoxModel.getElementAt(n2);
            if (e instanceof Range && ((Range)e).start == c) {
                string = e;
                break;
            }
            ++n2;
        }
        if (string == null) {
            string = CharacterChooser.toHexString(c);
        }
        this.rangeCombo.setSelectedItem(string);
        this.updateButtonState();
    }

    public char getFirstDisplayedChar() {
        return this.characterTable.getFirstDisplayedChar();
    }

    public void setShowingFavorites(boolean bl) {
        if (this.showFavorites != bl) {
            this.showFavorites = bl;
            this.popupMenu = null;
            this.characterTable.remapPrivateUseArea(this.favorites);
            DefaultComboBoxModel<Range> defaultComboBoxModel = new DefaultComboBoxModel<Range>(RANGES);
            if (bl) {
                defaultComboBoxModel.addElement(FAVORITES_RANGE);
            }
            this.rangeCombo.setModel(defaultComboBoxModel);
            this.rangeCombo.setSelectedIndex(0);
        }
    }

    public boolean isShowingFavorites() {
        return this.showFavorites;
    }

    public void setFavorites(char[] cArray) {
        this.favorites = cArray;
        if (this.showFavorites) {
            this.characterTable.remapPrivateUseArea(cArray);
        }
    }

    public char[] getFavorites() {
        return this.favorites;
    }

    public void addCharacterTableListener(CharacterTableListener characterTableListener) {
        this.characterTable.addCharacterTableListener(characterTableListener);
    }

    public void removeCharacterTableListener(CharacterTableListener characterTableListener) {
        this.characterTable.removeCharacterTableListener(characterTableListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("previousRange".equals(string)) {
            this.previousRange();
        } else if ("nextRange".equals(string)) {
            this.nextRange();
        } else if ("changeRange".equals(string)) {
            this.changeRange();
        } else if ("copyToClipboard".equals(string)) {
            this.copyToClipboard();
        } else if ("addToFavorites".equals(string)) {
            this.addToFavorites();
        } else if ("removeFromFavorites".equals(string)) {
            this.removeFromFavorites();
        } else if ("showFavorites".equals(string)) {
            this.showFavorites();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void popupMenu(MouseEvent mouseEvent) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem jMenuItem = this.popupMenu.add(Msg.msg("CC.copyToClipboard"));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("copyToClipboard");
            if (this.showFavorites) {
                this.popupMenu.addSeparator();
                jMenuItem = this.popupMenu.add(Msg.msg("CC.addToFavorites"));
                jMenuItem.addActionListener(this);
                jMenuItem.setActionCommand("addToFavorites");
                jMenuItem = this.popupMenu.add(Msg.msg("CC.removeFromFavorites"));
                jMenuItem.addActionListener(this);
                jMenuItem.setActionCommand("removeFromFavorites");
                this.popupMenu.addSeparator();
                jMenuItem = this.popupMenu.add(Msg.msg("CC.showFavorites"));
                jMenuItem.addActionListener(this);
                jMenuItem.setActionCommand("showFavorites");
            }
        }
        this.pickedChar = this.characterTable.pickChar(mouseEvent.getX(), mouseEvent.getY(), false);
        if (this.showFavorites) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (this.characterTable.getFirstDisplayedChar() == '\ue000') {
                if (this.characterTable.isMappedChar(this.pickedChar)) {
                    this.pickedChar = this.characterTable.getMappedChar(this.pickedChar);
                    bl3 = false;
                    bl2 = true;
                } else {
                    bl3 = true;
                    bl2 = false;
                }
                bl = false;
            } else {
                bl3 = true;
                bl2 = false;
                bl = true;
            }
            JMenuItem jMenuItem = (JMenuItem)this.popupMenu.getComponent(2);
            jMenuItem.setEnabled(bl3);
            jMenuItem = (JMenuItem)this.popupMenu.getComponent(3);
            jMenuItem.setEnabled(bl2);
            jMenuItem = (JMenuItem)this.popupMenu.getComponent(5);
            jMenuItem.setEnabled(bl);
        }
        this.popupMenu.show(this.characterTable, mouseEvent.getX(), mouseEvent.getY());
    }

    protected void previousRange() {
        char c = this.characterTable.getFirstDisplayedChar();
        int n = c - 256;
        if (n < 0) {
            n = 0;
        }
        this.setFirstDisplayedChar((char)n);
    }

    protected void nextRange() {
        char c = this.characterTable.getFirstDisplayedChar();
        int n = c + 256;
        if (n > 65279) {
            n = 65279;
        }
        this.setFirstDisplayedChar((char)n);
    }

    protected void changeRange() {
        Object object = this.rangeCombo.getSelectedItem();
        if (object == null) {
            return;
        }
        if (object instanceof Range) {
            this.setFirstDisplayedChar(((Range)object).start);
        } else if (object instanceof String) {
            int n;
            String string = ((String)object).trim();
            int n2 = string.indexOf(32);
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            if ((n = this.showFavorites && favoritesLabel.equals(string) ? 57344 : CharacterChooser.parseChar(string)) < 0) {
                this.getToolkit().beep();
                this.rangeCombo.requestFocus();
            } else {
                this.setFirstDisplayedChar((char)n);
            }
        }
    }

    public static final int parseChar(String string) {
        int n = -1;
        if ((string.startsWith("0x") || string.startsWith("0X")) && string.length() > 2) {
            try {
                n = Integer.parseInt(string.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.startsWith("0") && string.length() > 1) {
            try {
                n = Integer.parseInt(string.substring(1), 8);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n < 0 || n > 65535) {
            n = -1;
        }
        return n;
    }

    protected static final String toHexString(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        CharacterChooser.toHexString(c, stringBuffer);
        return stringBuffer.toString();
    }

    protected static final void toHexString(char c, StringBuffer stringBuffer) {
        stringBuffer.append("0x");
        String string = Integer.toString(c, 16);
        int n = string.length();
        while (n < 4) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string);
    }

    protected void copyToClipboard() {
        Clipboard.put(this, Character.toString(this.pickedChar));
    }

    protected void addToFavorites() {
        if (this.favorites == null) {
            this.favorites = new char[]{this.pickedChar};
        } else {
            int n = this.indexOfFavorite(this.pickedChar);
            if (n >= 0) {
                return;
            }
            char[] cArray = new char[this.favorites.length + 1];
            System.arraycopy(this.favorites, 0, cArray, 0, this.favorites.length);
            cArray[this.favorites.length] = this.pickedChar;
            this.favorites = cArray;
        }
        this.characterTable.remapPrivateUseArea(this.favorites);
    }

    private int indexOfFavorite(char c) {
        if (this.favorites != null) {
            int n = 0;
            while (n < this.favorites.length) {
                if (this.favorites[n] == c) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    protected void removeFromFavorites() {
        int n = this.indexOfFavorite(this.pickedChar);
        if (n < 0) {
            return;
        }
        if (this.favorites.length == 1) {
            this.favorites = null;
        } else {
            int n2;
            int n3;
            char[] cArray = new char[this.favorites.length - 1];
            if (n > 0) {
                System.arraycopy(this.favorites, 0, cArray, 0, n);
            }
            if ((n3 = this.favorites.length - (n2 = n + 1)) > 0) {
                System.arraycopy(this.favorites, n2, cArray, n, n3);
            }
            this.favorites = cArray;
        }
        this.characterTable.remapPrivateUseArea(this.favorites);
    }

    protected void showFavorites() {
        this.setFirstDisplayedChar('\ue000');
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final class FavoritesRange
    extends Range {
        public FavoritesRange() {
            super(favoritesLabel, '\ue000');
        }

        public String toString() {
            return this.name;
        }
    }

    protected static class Range {
        public String name;
        public char start;

        public Range(String string, char c) {
            this.name = string;
            this.start = c;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            CharacterChooser.toHexString(this.start, stringBuffer);
            stringBuffer.append(" (");
            stringBuffer.append(this.name);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

