/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.CharacterTableEvent;
import com.xmlmind.xmledit.dialog.CharacterTableListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.EventListenerList;

public class CharacterTable
extends JComponent
implements Scrollable {
    public static final char PRIVATE_USE_AREA_FIRST = '\ue000';
    public static final char PRIVATE_USE_AREA_LAST = '\uf8ff';
    private char firstDisplayedChar = '\u0000';
    private char firstMappedChar = '\u0000';
    private char[] privateUseAreaMap = null;
    private EventListenerList listenerList = new EventListenerList();
    private Color tableColor = null;
    private Color privateUseAreaColor = null;
    private Color gridColor = null;
    private int paddingWidth = 0;
    private int paddingHeight = 1;
    private int columnCount = 16;
    private int scrollableUnit = 10;
    private Insets insets = new Insets(0, 0, 0, 0);
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$CharacterTableListener;

    public CharacterTable() {
        this.setToolTipText("");
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    CharacterTable.this.notifyListeners(mouseEvent.getModifiers(), mouseEvent.getPoint());
                }
            }
        });
    }

    public void setTableColor(Color color) {
        this.tableColor = color;
        this.repaint();
    }

    public Color getTableColor() {
        return this.tableColor;
    }

    public void setPrivateUseAreaColor(Color color) {
        this.privateUseAreaColor = color;
        this.repaint();
    }

    public Color getPrivateUseAreaColor() {
        return this.privateUseAreaColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.repaint();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setPaddingWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.paddingWidth = n;
        this.revalidate();
        this.repaint();
    }

    public int getPaddingWidth() {
        return this.paddingWidth;
    }

    public void setPaddingHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.paddingHeight = n;
        this.revalidate();
        this.repaint();
    }

    public int getPaddingHeight() {
        return this.paddingHeight;
    }

    public Insets getInsets() {
        return super.getInsets(this.insets);
    }

    public void addCharacterTableListener(CharacterTableListener characterTableListener) {
        this.listenerList.add(class$com$xmlmind$xmledit$dialog$CharacterTableListener == null ? (class$com$xmlmind$xmledit$dialog$CharacterTableListener = CharacterTable.class$("com.xmlmind.xmledit.dialog.CharacterTableListener")) : class$com$xmlmind$xmledit$dialog$CharacterTableListener, characterTableListener);
    }

    public void removeCharacterTableListener(CharacterTableListener characterTableListener) {
        this.listenerList.remove(class$com$xmlmind$xmledit$dialog$CharacterTableListener == null ? (class$com$xmlmind$xmledit$dialog$CharacterTableListener = CharacterTable.class$("com.xmlmind.xmledit.dialog.CharacterTableListener")) : class$com$xmlmind$xmledit$dialog$CharacterTableListener, characterTableListener);
    }

    private void notifyListeners(int n, Point point) {
        char c = this.pickChar(point.x, point.y);
        this.fireCharacterSelected(new CharacterTableEvent(this, n, point, c));
    }

    private void fireCharacterSelected(CharacterTableEvent characterTableEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$xmlmind$xmledit$dialog$CharacterTableListener == null ? CharacterTable.class$("com.xmlmind.xmledit.dialog.CharacterTableListener") : class$com$xmlmind$xmledit$dialog$CharacterTableListener)) {
                ((CharacterTableListener)objectArray[n + 1]).characterSelected(characterTableEvent);
            }
            n -= 2;
        }
    }

    public void setFirstDisplayedChar(char c) {
        if (c < '\u0000') {
            c = '\u0000';
        } else if (c > '\ufeff') {
            c = (char)65279;
        }
        if (c != this.firstDisplayedChar) {
            this.firstDisplayedChar = c;
            this.repaint();
        }
    }

    public char getFirstDisplayedChar() {
        return this.firstDisplayedChar;
    }

    public void remapPrivateUseArea(char[] cArray) {
        this.remapPrivateUseArea(cArray, '\ue000');
    }

    public void remapPrivateUseArea(char[] cArray, char c) {
        if (cArray != null && cArray.length == 0) {
            cArray = null;
        }
        if (cArray == null) {
            c = '\u0000';
        } else if (c < '\ue000' || c + cArray.length > 63743) {
            throw new IllegalArgumentException("arguments from,map specify a range which is outside private use area U+E000-U+F8FF");
        }
        this.privateUseAreaMap = cArray;
        this.firstMappedChar = c;
        this.repaint();
    }

    public char[] getPrivateUseAreaMap() {
        return this.privateUseAreaMap;
    }

    public char getFirstMappedChar() {
        return this.firstMappedChar;
    }

    public char getMappedChar(char c) {
        if (this.isMappedChar(c)) {
            return this.privateUseAreaMap[c - this.firstMappedChar];
        }
        return c;
    }

    public boolean isMappedChar(char c) {
        return this.privateUseAreaMap != null && c >= this.firstMappedChar && c < this.firstMappedChar + this.privateUseAreaMap.length;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        dimension.width = 1 + this.columnCount * (fontMetrics.getMaxAdvance() + 2 * this.paddingWidth + 1);
        int n = (256 + this.columnCount - 1) / this.columnCount;
        dimension.height = 1 + n * (fontMetrics.getAscent() + fontMetrics.getDescent() + 2 * this.paddingHeight + 1);
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        graphics = graphics.create();
        graphics.translate(insets.left, insets.top);
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getMaxAdvance();
        int n5 = fontMetrics.getAscent();
        int n6 = n5 + fontMetrics.getDescent();
        int n7 = n4 + 2 * this.paddingWidth + 1;
        this.scrollableUnit = n3 = n6 + 2 * this.paddingHeight + 1;
        int n8 = (256 + this.columnCount - 1) / this.columnCount;
        int n9 = 1 + this.columnCount * n7;
        int n10 = 1 + n8 * n3;
        if (this.tableColor != null) {
            graphics.setColor(this.tableColor);
            graphics.fillRect(0, 0, n9, n10);
        }
        Color color = this.getForeground();
        graphics.setColor(color);
        int n11 = 1 + this.paddingWidth;
        int n12 = 1 + this.paddingHeight + n5;
        int n13 = n11;
        int n14 = n12;
        int n15 = this.firstDisplayedChar;
        int n16 = this.firstDisplayedChar + 256;
        char[] cArray = new char[1];
        int n17 = 0;
        while (n17 < n8) {
            n2 = 0;
            while (n2 < this.columnCount) {
                if (n15 <= n16) {
                    n = fontMetrics.charWidth(n15);
                    char c = (char)n15++;
                    if (this.privateUseAreaMap != null && c >= this.firstMappedChar && c < this.firstMappedChar + this.privateUseAreaMap.length) {
                        c = this.privateUseAreaMap[c - this.firstMappedChar];
                        if (this.privateUseAreaColor != null) {
                            graphics.setColor(this.privateUseAreaColor);
                            graphics.fillRect(n13 - (1 + this.paddingWidth), n14 - (1 + this.paddingHeight + n5), n7, n3);
                            graphics.setColor(color);
                        }
                    }
                    cArray[0] = c;
                    graphics.drawChars(cArray, 0, 1, n13 + (n4 - n) / 2, n14);
                }
                n13 += n7;
                ++n2;
            }
            n14 += n3;
            n13 = n11;
            ++n17;
        }
        if (this.gridColor != null) {
            graphics.setColor(this.gridColor);
        }
        n13 = n9 - 1;
        n14 = 0;
        n2 = 0;
        while (n2 < n8) {
            graphics.drawLine(0, n14, n13, n14);
            n14 += n3;
            ++n2;
        }
        graphics.drawLine(0, n14, n13, n14);
        n13 = 0;
        n14 = n10 - 1;
        n = 0;
        while (n < this.columnCount) {
            graphics.drawLine(n13, 0, n13, n14);
            n13 += n7;
            ++n;
        }
        graphics.drawLine(n13, 0, n13, n14);
        graphics.dispose();
    }

    public char pickChar(int n, int n2) {
        return this.pickChar(n, n2, true);
    }

    public char pickChar(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n6 = fontMetrics.getMaxAdvance() + 2 * this.paddingWidth + 1;
        int n7 = fontMetrics.getAscent() + fontMetrics.getDescent() + 2 * this.paddingHeight + 1;
        int n8 = (256 + this.columnCount - 1) / this.columnCount;
        if ((n5 = (n4 = (n2 -= insets.top + 1) < 0 ? 0 : (n2 >= n8 * n7 ? n8 - 1 : n2 / n7)) * this.columnCount + (n3 = n < 0 ? 0 : (n >= this.columnCount * n6 ? this.columnCount - 1 : (n -= insets.left + 1) / n6))) > 256) {
            n5 = 256;
        }
        char c = (char)(this.firstDisplayedChar + n5);
        if (bl) {
            c = this.getMappedChar(c);
        }
        return c;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        char c;
        char c2 = c = this.pickChar(mouseEvent.getX(), mouseEvent.getY());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html> <font size='+4' color='#B00000'>");
        stringBuffer.append(c);
        stringBuffer.append("</font><br>");
        stringBuffer.append(" 0x");
        String string = Integer.toString(c2, 16);
        int n = string.length();
        while (n < 4) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append(Integer.toString(c2));
        stringBuffer.append(" 0");
        stringBuffer.append(Integer.toString(c2, 8));
        return stringBuffer.toString();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.scrollableUnit;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.scrollableUnit;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        if (!(container instanceof JViewport)) {
            return false;
        }
        int n = ((JViewport)container).getWidth();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.getMaxAdvance() + 2 * this.paddingWidth + 1;
        Insets insets = this.getInsets();
        this.columnCount = (n - 1 - (insets.left + insets.right)) / n2;
        if (this.columnCount < 1) {
            this.columnCount = 1;
        } else if (this.columnCount > 256) {
            this.columnCount = 256;
        }
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

