/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.Diagnostic;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class DiagnosticsPane
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane htmlPane = new JEditorPane();
    private Diagnostic[] diagnostics = null;
    private DocumentView docView = null;

    public DiagnosticsPane() {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.htmlPane.getEditorKitForContentType("text/html");
        hTMLEditorKit.getStyleSheet().addRule("body { font-family: sans-serif; font-size: 12pt; }");
        this.htmlPane.setEditorKit(hTMLEditorKit);
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        this.getViewport().setView(this.htmlPane);
    }

    public void setDocumentView(DocumentView documentView) {
        this.docView = documentView;
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public void setDiagnostics(Diagnostic[] diagnosticArray) {
        if (diagnosticArray != null && diagnosticArray.length == 0) {
            diagnosticArray = null;
        }
        this.diagnostics = diagnosticArray;
        this.listDiagnostics();
    }

    public Diagnostic[] getDiagnostics() {
        return this.diagnostics;
    }

    private void listDiagnostics() {
        if (this.diagnostics == null) {
            this.htmlPane.setDocument(this.htmlPane.getEditorKit().createDefaultDocument());
        } else {
            this.doListDiagnostics();
            this.htmlPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        }
    }

    private void doListDiagnostics() {
        Document document = this.docView == null ? null : this.docView.getDocument();
        StringBuffer stringBuffer = new StringBuffer();
        FontMetrics fontMetrics = this.htmlPane.getFontMetrics(this.htmlPane.getFont());
        int n = 10 + fontMetrics.stringWidth("[" + this.diagnostics.length + "]");
        stringBuffer.append("<html><body><table border='0' cellspacing='1'>\n");
        int n2 = 0;
        while (n2 < this.diagnostics.length) {
            Object object;
            Diagnostic diagnostic = this.diagnostics[n2];
            Element element = diagnostic.getDiagnosedElement();
            boolean bl = false;
            if (element == null || document == null) {
                bl = true;
            } else {
                object = element.getDocument();
                if (object == null || object != document) {
                    bl = true;
                }
            }
            switch (diagnostic.getDiagnosticSeverity()) {
                case 5: {
                    object = "#FFC0C0";
                    break;
                }
                case 4: {
                    object = "#FFE0C0";
                    break;
                }
                case 3: {
                    object = "#FFFFC0";
                    break;
                }
                case 2: {
                    object = "#FF8080";
                    break;
                }
                case 1: {
                    object = "#FFFF80";
                    break;
                }
                default: {
                    object = "#FFFFFF";
                }
            }
            stringBuffer.append("<tr><td width='");
            stringBuffer.append(n);
            stringBuffer.append("' valign='top' bgcolor='");
            stringBuffer.append((String)object);
            if (bl) {
                stringBuffer.append("'>[");
                stringBuffer.append(1 + n2);
                stringBuffer.append("]</td>");
            } else {
                stringBuffer.append("'><a href='");
                stringBuffer.append(n2);
                stringBuffer.append("'>[");
                stringBuffer.append(1 + n2);
                stringBuffer.append("]</a></td>");
            }
            stringBuffer.append("<td valign='top' bgcolor='");
            stringBuffer.append((String)object);
            stringBuffer.append("'>");
            XMLUtil.escapeXML(diagnostic.getDiagnosticMessage(), stringBuffer);
            stringBuffer.append("</td></tr>\n");
            ++n2;
        }
        stringBuffer.append("</table></body></html>");
        try {
            this.htmlPane.read(new StringReader(stringBuffer.toString()), null);
        }
        catch (IOException iOException) {}
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        int n;
        if (this.docView == null || this.diagnostics == null || hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        try {
            n = Integer.parseInt(hyperlinkEvent.getDescription());
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0 || n >= this.diagnostics.length) {
            return;
        }
        Element element = this.diagnostics[n].getDiagnosedElement();
        Document document = element.getDocument();
        if (document == null || document != this.docView.getDocument()) {
            this.doListDiagnostics();
            return;
        }
        this.docView.selectNode(element);
        Rectangle rectangle = this.docView.modelToView(element);
        if (rectangle != null) {
            this.docView.makeRectangleVisible(rectangle);
        }
    }
}

