/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.edit.ElementTemplate;
import com.xmlmind.xmledit.edit.ElementTemplates;
import com.xmlmind.xmledit.guiutil.AutoCompletion;
import com.xmlmind.xmledit.xmlutil.Name;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public final class FieldChoice
implements Cloneable,
Comparable,
AutoCompletion.PossibleChoice {
    public String label;
    public boolean text;
    public Field field;
    public boolean wildcard;
    public Name name;
    public ElementTemplate template;
    public static final FieldChoice TEXT_CHOICE = new FieldChoice();
    private static Structure notUsed = new Structure();

    public FieldChoice() {
        this.label = "(" + Msg.msg("FC.textLabel") + ")";
        this.text = true;
        this.field = null;
        this.wildcard = false;
        this.name = null;
        this.template = null;
    }

    public FieldChoice(String string, Field field, Name name) {
        this.label = string;
        this.text = false;
        this.field = field;
        this.wildcard = field != null && field.getFieldName() == null;
        this.name = name;
        this.template = null;
    }

    public FieldChoice(String string, Field field, ElementTemplate elementTemplate) {
        this.label = string;
        this.text = false;
        this.field = field;
        this.wildcard = false;
        this.name = null;
        this.template = elementTemplate;
    }

    public FieldChoice copy() {
        try {
            return (FieldChoice)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isPossibleChoice() {
        return !this.wildcard;
    }

    public String toString() {
        return this.label;
    }

    public int compareTo(Object object) {
        FieldChoice fieldChoice = (FieldChoice)object;
        int n = 0;
        if (this.text) {
            n = 1;
        } else if (this.field != null) {
            n = !this.wildcard ? 2 : 3;
        }
        int n2 = 0;
        if (fieldChoice.text) {
            n2 = 1;
        } else if (fieldChoice.field != null) {
            n2 = !fieldChoice.wildcard ? 2 : 3;
        }
        if (n != n2) {
            return n - n2;
        }
        return this.label.compareTo(fieldChoice.label);
    }

    public static FieldChoice[] list(Field[] fieldArray, boolean bl, boolean bl2, boolean bl3, Element element) {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            arrayList.add(TEXT_CHOICE);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = 0;
        while (n < fieldArray.length) {
            block12: {
                Name name;
                block13: {
                    block11: {
                        objectArray = fieldArray[n];
                        object3 = objectArray.getFieldLabel(false, element);
                        name = objectArray.getFieldName();
                        if (name != null) break block11;
                        if (!bl2) break block12;
                        if (object3 == null) {
                            object3 = Msg.msg("FC.wildcardLabel");
                        }
                        break block13;
                    }
                    if (object3 == null) {
                        object3 = name.format(false, element);
                    }
                }
                object2 = (object2 = (Integer)hashMap.get(object3)) == null ? new Integer(1) : new Integer((Integer)object2 + 1);
                hashMap.put(object3, object2);
                if ((Integer)object2 > 1) {
                    object3 = (String)object3 + "-" + ((Integer)object2).toString();
                }
                object = new FieldChoice((String)object3, (Field)objectArray, name);
                arrayList.add(object);
            }
            ++n;
        }
        if (bl3) {
            objectArray = null;
            object3 = (ElementTemplates)element.getDocument().getProperty("ELEMENT_TEMPLATES");
            if (object3 != null) {
                objectArray = ((ElementTemplates)object3).getAllSelectable();
            }
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    object2 = objectArray[n2];
                    object = FieldChoice.checkTemplate((ElementTemplate)object2, fieldArray, element, (ElementTemplates)object3);
                    if (object != null) {
                        FieldChoice fieldChoice = new FieldChoice(FieldChoice.templateLabel((ElementTemplate)object2, element), (Field)object, (ElementTemplate)object2);
                        arrayList.add(fieldChoice);
                    }
                    ++n2;
                }
            }
        }
        objectArray = new FieldChoice[arrayList.size()];
        arrayList.toArray(objectArray);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public static final Field checkTemplate(ElementTemplate elementTemplate, Field[] fieldArray, Element element, ElementTemplates elementTemplates) {
        Field field = FieldChoice.findField(fieldArray, elementTemplate, element, elementTemplates);
        if (field == null) {
            return null;
        }
        XPath xPath = elementTemplate.getParentXPath();
        if (xPath != null && !xPath.match(element)) {
            return null;
        }
        return field;
    }

    public static final Field findField(Field[] fieldArray, ElementTemplate elementTemplate, Element element, ElementTemplates elementTemplates) {
        Object object;
        Name name = elementTemplate.getElementName();
        Object object2 = null;
        boolean bl = false;
        int n = 0;
        while (n < fieldArray.length) {
            object = fieldArray[n];
            if (object.getFieldName() == name) {
                if (object2 == null) {
                    object2 = object;
                } else {
                    bl = true;
                    break;
                }
            }
            ++n;
        }
        if (object2 == null) {
            return null;
        }
        if (bl) {
            object2 = null;
            object = DocumentTypeUtil.getElementType(element);
            if (object != null) {
                Element element2 = elementTemplate.getElement(elementTemplates);
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    ElementType elementType;
                    Field field = fieldArray[n2];
                    if (field.getFieldName() == name && (elementType = object.getChildElementType(field, name)) != null && elementType.getStructure(element2, true, notUsed)) {
                        object2 = field;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return object2;
    }

    private static final String templateLabel(ElementTemplate elementTemplate, Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(elementTemplate.getElementName().format(false, element));
        stringBuffer.append('(');
        stringBuffer.append(elementTemplate.getLocalizedTitle());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

