/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.util.FileUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class FileDragSupport
implements DragGestureListener,
Transferable {
    private Component component;
    private Draggable draggable;
    private URL draggedURL = null;
    private File draggedFile = null;
    private static DataFlavor[] FLAVORS0 = null;
    private static DataFlavor[] FLAVORS1 = null;
    private static DataFlavor[] FLAVORS2 = null;

    private static void initFlavors() {
        FLAVORS0 = new DataFlavor[0];
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        DataFlavor dataFlavor3 = null;
        DataFlavor dataFlavor4 = null;
        DataFlavor dataFlavor5 = null;
        try {
            dataFlavor = new DataFlavor("text/plain;charset=UTF-8");
            dataFlavor2 = new DataFlavor("text/plain;charset=UTF-16");
            dataFlavor3 = new DataFlavor("text/plain;charset=UTF-16BE");
            dataFlavor4 = new DataFlavor("text/plain;charset=UTF-16LE");
            dataFlavor5 = new DataFlavor("text/plain;charset=" + FileUtil.defaultEncoding());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        FLAVORS1 = new DataFlavor[]{DataFlavor.stringFlavor, dataFlavor, dataFlavor2, dataFlavor3, dataFlavor4, dataFlavor5};
        FLAVORS2 = new DataFlavor[]{DataFlavor.stringFlavor, dataFlavor, dataFlavor2, dataFlavor3, dataFlavor4, dataFlavor5, DataFlavor.javaFileListFlavor};
    }

    public FileDragSupport(Component component) {
        if (FLAVORS1 == null) {
            FileDragSupport.initFlavors();
        }
        this.component = component;
        this.draggable = (Draggable)((Object)component);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, 0x40000001, this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.draggedURL = this.draggable.getDraggedFile(dragGestureEvent.getDragOrigin());
        if (this.draggedURL != null) {
            this.draggedFile = FileUtil.urlToFile(this.draggedURL);
            try {
                dragGestureEvent.startDrag(null, this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {}
        } else {
            this.draggedFile = null;
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.draggedFile != null) {
            return FLAVORS2;
        }
        if (this.draggedURL != null) {
            return FLAVORS1;
        }
        return FLAVORS0;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].match(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        String string;
        Object object = null;
        if (dataFlavor.isFlavorJavaFileListType()) {
            if (this.draggedFile != null) {
                ArrayList<File> arrayList = new ArrayList<File>();
                arrayList.add(this.draggedFile);
                object = arrayList;
            }
        } else if (dataFlavor.isFlavorTextType() && (string = this.draggedFile != null ? this.draggedFile.getPath() : (this.draggedURL != null ? this.draggedURL.toExternalForm() : null)) != null) {
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                object = string;
            } else {
                String string2 = dataFlavor.getParameter("charset");
                byte[] byArray = string2 != null ? string.getBytes(string2.trim()) : string.getBytes();
                object = new ByteArrayInputStream(byArray);
            }
        }
        if (object == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return object;
    }

    public static interface Draggable {
        public URL getDraggedFile(Point var1);
    }
}

