/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.jclark.xml.parse.NotWellFormedException;
import com.jclark.xml.parse.OpenEntity;
import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.DocumentTypeError;
import com.xmlmind.xmledit.edit.Loader;
import com.xmlmind.xmledit.edit.XIncludeError;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public final class LoadDocument {
    public static Document loadDocument(URL uRL, Component component) {
        Loader loader = new Loader();
        loader.setXIncludeAware(true);
        return LoadDocument.loadDocument(uRL, loader, component);
    }

    public static Document loadDocument(URL uRL, Loader loader, Component component) {
        String string;
        XIncludeError[] xIncludeErrorArray;
        Document document = null;
        String string2 = null;
        try {
            document = LoadDocument.loadDocument(uRL, loader);
        }
        catch (NotWellFormedException notWellFormedException) {
            string2 = Msg.msg("LD.parseError", notWellFormedException.getEntityLocation(), new Integer(notWellFormedException.getLineNumber()), new Integer(notWellFormedException.getColumnNumber()), notWellFormedException.getMessageWithoutLocation());
        }
        catch (IOException iOException) {
            string2 = MiscUtil.reason(iOException);
        }
        catch (Exception exception) {
            string2 = MiscUtil.detailedReason(exception);
        }
        if (string2 != null) {
            Alert.showError(component, Msg.msg("LD.cannotOpen", URLUtil.toLabel(uRL), string2));
            return null;
        }
        DocumentTypeError[] documentTypeErrorArray = loader.getDocumentTypeErrors();
        DocumentTypeError[] documentTypeErrorArray2 = loader.getDocumentTypeWarnings();
        if (documentTypeErrorArray.length > 0 || documentTypeErrorArray2.length > 0) {
            xIncludeErrorArray = LoadDocument.docTypeErrorTitle(documentTypeErrorArray, documentTypeErrorArray2);
            string = LoadDocument.docTypeErrorMessage(documentTypeErrorArray, documentTypeErrorArray2);
            if (documentTypeErrorArray.length == 0) {
                Alert.showWarning(component, (String)xIncludeErrorArray, string, true, 10, 60);
            } else {
                Alert.showError(component, (String)xIncludeErrorArray, string, true, 10, 60);
            }
        }
        if ((xIncludeErrorArray = loader.getXIncludeErrors()).length > 0) {
            string = Msg.msg("LD.xincludeHasErrors", new Integer(xIncludeErrorArray.length));
            String string3 = LoadDocument.xincludeErrorMessage(xIncludeErrorArray);
            Alert.showWarning(component, string, string3, true, 10, 60);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(URL uRL, Loader loader) throws IOException {
        Document document;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            document = loader.load(new OpenEntity(inputStream, uRL.toExternalForm(), uRL));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return document;
    }

    private static String docTypeErrorTitle(DocumentTypeError[] documentTypeErrorArray, DocumentTypeError[] documentTypeErrorArray2) {
        if (documentTypeErrorArray.length > 0) {
            if (documentTypeErrorArray2.length > 0) {
                return Msg.msg("LD.docTypeHasErrorsAndWarnings", new Integer(documentTypeErrorArray.length), new Integer(documentTypeErrorArray2.length));
            }
            return Msg.msg("LD.docTypeHasErrors", new Integer(documentTypeErrorArray.length));
        }
        return Msg.msg("LD.docTypeHasWarnings", new Integer(documentTypeErrorArray2.length));
    }

    private static String docTypeErrorMessage(DocumentTypeError[] documentTypeErrorArray, DocumentTypeError[] documentTypeErrorArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < documentTypeErrorArray.length) {
            LoadDocument.appendDocTypeError(stringBuffer, documentTypeErrorArray[n], false);
            stringBuffer.append('\n');
            ++n;
        }
        int n2 = 0;
        while (n2 < documentTypeErrorArray2.length) {
            LoadDocument.appendDocTypeError(stringBuffer, documentTypeErrorArray2[n2], true);
            stringBuffer.append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void appendDocTypeError(StringBuffer stringBuffer, DocumentTypeError documentTypeError, boolean bl) {
        URL uRL = documentTypeError.getErrorLocation();
        int n = documentTypeError.getErrorLineNumber();
        int n2 = documentTypeError.getErrorColumnNumber();
        if (uRL != null) {
            stringBuffer.append(uRL);
        }
        stringBuffer.append(':');
        stringBuffer.append(bl ? (char)'W' : 'E');
        stringBuffer.append(':');
        if (n >= 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append(':');
        if (n2 >= 0) {
            stringBuffer.append(n2);
        }
        stringBuffer.append(": ");
        stringBuffer.append(documentTypeError.getErrorMessage());
        stringBuffer.append('\n');
    }

    private static String xincludeErrorMessage(XIncludeError[] xIncludeErrorArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < xIncludeErrorArray.length) {
            XIncludeError xIncludeError = xIncludeErrorArray[n];
            stringBuffer.append(xIncludeError.getElement().toString());
            stringBuffer.append(":\n");
            stringBuffer.append(xIncludeError.getMessage());
            stringBuffer.append("\n\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

