/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.FileDragSupport;
import com.xmlmind.xmledit.dialog.NodePathEvent;
import com.xmlmind.xmledit.dialog.NodePathListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.event.EventListenerList;

public class NodePath
extends Component
implements FileDragSupport.Draggable {
    public static final int RELIEF_FLAT = 0;
    public static final int RELIEF_SUNKEN = 1;
    public static final int RELIEF_RAISED = 2;
    protected Node displayedNode = null;
    protected Dimension intrinsicSize = null;
    protected Item[] items = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected int marginWidth = 1;
    protected int marginHeight = 1;
    protected int separatorSize = 7;
    protected Color readOnlyColor = Color.gray;
    protected Color separatorColor = Color.black;
    protected int separatorRelief = 0;
    protected int borderRelief = 0;
    protected boolean dragEnabled = false;
    protected FileDragSupport dragSupport = null;
    protected static Image docIcon = null;
    protected static int docIconWidth = -1;
    protected static int docIconHeight = -1;
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$NodePath;
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$NodePathListener;

    public NodePath() {
        this.enableEvents(16L);
        if (docIcon == null) {
            docIcon = ImageResource.get(class$com$xmlmind$xmledit$dialog$NodePath == null ? (class$com$xmlmind$xmledit$dialog$NodePath = NodePath.class$("com.xmlmind.xmledit.dialog.NodePath")) : class$com$xmlmind$xmledit$dialog$NodePath, "bookmark.gif");
            docIconWidth = docIcon.getWidth(null);
            docIconHeight = docIcon.getHeight(null);
        }
        this.dragSupport = new FileDragSupport(this);
    }

    public boolean isFocusable() {
        return false;
    }

    public void addNodePathListener(NodePathListener nodePathListener) {
        this.listenerList.add(class$com$xmlmind$xmledit$dialog$NodePathListener == null ? (class$com$xmlmind$xmledit$dialog$NodePathListener = NodePath.class$("com.xmlmind.xmledit.dialog.NodePathListener")) : class$com$xmlmind$xmledit$dialog$NodePathListener, nodePathListener);
    }

    public void removeNodePathListener(NodePathListener nodePathListener) {
        this.listenerList.remove(class$com$xmlmind$xmledit$dialog$NodePathListener == null ? (class$com$xmlmind$xmledit$dialog$NodePathListener = NodePath.class$("com.xmlmind.xmledit.dialog.NodePathListener")) : class$com$xmlmind$xmledit$dialog$NodePathListener, nodePathListener);
    }

    public void setNode(Node node) {
        this.displayedNode = node;
        this.invalidate();
        this.repaint();
    }

    public void invalidate() {
        this.intrinsicSize = null;
        this.items = null;
        super.invalidate();
    }

    public Node getNode() {
        return this.displayedNode;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.invalidate();
        this.repaint();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setReadOnlyColor(Color color) {
        this.readOnlyColor = color;
        this.repaint();
    }

    public Color getReadOnlyColor() {
        return this.readOnlyColor;
    }

    public void setMarginWidth(int n) {
        this.marginWidth = n;
        this.invalidate();
        this.repaint();
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginHeight(int n) {
        this.marginHeight = n;
        this.invalidate();
        this.repaint();
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public void setSeparatorSize(int n) {
        this.separatorSize = n;
        this.invalidate();
        this.repaint();
    }

    public int getSeparatorSize() {
        return this.separatorSize;
    }

    public void setSeparatorColor(Color color) {
        this.separatorColor = color;
        this.repaint();
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorRelief(int n) {
        this.separatorRelief = n;
        this.repaint();
    }

    public int getSeparatorRelief() {
        return this.separatorRelief;
    }

    public void setBorderRelief(int n) {
        this.borderRelief = n;
        this.repaint();
    }

    public int getBorderRelief() {
        return this.borderRelief;
    }

    public void setDragEnabled(boolean bl) {
        if (bl != this.dragEnabled) {
            this.dragEnabled = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.intrinsicSize == null) {
            this.relayout();
        }
        return this.intrinsicSize;
    }

    private void relayout() {
        this.intrinsicSize = new Dimension();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.intrinsicSize.height = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (this.dragEnabled) {
            this.intrinsicSize.height = Math.max(docIconHeight, this.intrinsicSize.height);
        }
        if (this.displayedNode == null) {
            this.items = null;
            this.intrinsicSize.width = 2 * this.marginWidth;
        } else {
            int n;
            int n2 = 0;
            Node node = this.displayedNode;
            while (node != null) {
                ++n2;
                node = node.getParentElement();
            }
            this.items = new Item[n2];
            node = this.displayedNode;
            while (node != null) {
                Comparable comparable;
                Item item = new Item();
                this.items[--n2] = item;
                item.node = node;
                n = node.getNodeType();
                if (n == 4) {
                    comparable = (Element)node;
                    item.tag = ((Element)comparable).getName().format(false, (NamespaceToPrefixes)((Object)comparable));
                } else {
                    comparable = new StringBuffer();
                    ((StringBuffer)comparable).append('#');
                    ((StringBuffer)comparable).append(Node.getNodeTypeName(n));
                    if (n == 2) {
                        ((StringBuffer)comparable).append('(');
                        ((StringBuffer)comparable).append(((ProcessingInstruction)node).getTarget());
                        ((StringBuffer)comparable).append(')');
                    }
                    item.tag = ((StringBuffer)comparable).toString();
                }
                node = node.getParentElement();
            }
            int n3 = this.displayedNode.getDocument().isReadOnly() ? 0 : -1;
            n = this.marginWidth;
            if (this.dragEnabled) {
                n += docIconWidth + this.separatorSize;
            }
            int n4 = 0;
            while (n4 < this.items.length) {
                Item item = this.items[n4];
                if (n4 > 0) {
                    n += this.separatorSize;
                }
                item.x = n;
                item.width = fontMetrics.stringWidth(item.tag);
                n += item.width;
                if (n3 < 0 && (item.node instanceof Element && ((Element)item.node).isReadOnly() || item.node instanceof ProcessingInstruction && ((ProcessingInstruction)item.node).isReadOnly())) {
                    n3 = n4;
                }
                ++n4;
            }
            this.intrinsicSize.width = n + this.marginWidth;
            if (n3 >= 0) {
                int n5 = n3;
                while (n5 < this.items.length) {
                    this.items[n5].readOnly = true;
                    ++n5;
                }
            }
        }
        this.intrinsicSize.height += 2 * this.marginHeight;
    }

    public void paint(Graphics graphics) {
        if (this.intrinsicSize == null) {
            this.relayout();
        }
        Dimension dimension = this.getSize();
        PaintUtil.configureTextRendering(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.borderRelief != 0 && this.marginWidth > 0 && this.marginHeight > 0) {
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, this.borderRelief == 2);
        }
        if (this.items == null) {
            return;
        }
        this.paintItems(graphics, dimension);
    }

    protected void paintItems(Graphics graphics, Dimension dimension) {
        Font font = this.getFont();
        graphics.setFont(font);
        Color color = this.getForeground();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getDescent();
        int n3 = this.marginHeight + n;
        int n4 = Math.min(this.intrinsicSize.width, dimension.width) - this.marginWidth;
        int n5 = this.intrinsicSize.height / 2 - this.separatorSize / 2 + 1;
        int n6 = this.separatorSize - 2;
        int n7 = this.items.length - 1;
        while (n7 >= 0) {
            Item item = this.items[n7];
            graphics.setColor(item.readOnly ? this.readOnlyColor : color);
            graphics.drawString(item.tag, n4 -= item.width, n3);
            if (n7 > 0) {
                n4 -= this.separatorSize;
                graphics.setColor(this.separatorColor);
                switch (this.separatorRelief) {
                    case 1: {
                        graphics.fill3DRect(n4 + 1, n5, n6, n6, false);
                        break;
                    }
                    case 2: {
                        graphics.fill3DRect(n4 + 1, n5, n6, n6, true);
                        break;
                    }
                    default: {
                        graphics.fillRect(n4 + 1, n5, n6, n6);
                    }
                }
            }
            --n7;
        }
        if (this.dragEnabled) {
            n5 = this.intrinsicSize.height / 2 - docIconHeight / 2 + 1;
            graphics.drawImage(docIcon, n4 -= docIconWidth + this.separatorSize / 2, n5, null);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.displayedNode != null && mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 1) {
            this.notifyListeners(mouseEvent.getModifiers(), mouseEvent.getPoint());
        }
        super.processMouseEvent(mouseEvent);
    }

    private void notifyListeners(int n, Point point) {
        int n2 = this.translateMouseClick(point.x);
        int n3 = this.separatorSize / 2;
        Node node = null;
        int n4 = this.items.length - 1;
        while (n4 >= 0) {
            Item item = this.items[n4];
            if (n2 >= item.x - n3 && n2 <= item.x + item.width + n3) {
                node = item.node;
                break;
            }
            --n4;
        }
        if (node != null) {
            this.fireNodeSelected(new NodePathEvent(this, n, point, node));
        }
    }

    private int translateMouseClick(int n) {
        if (this.intrinsicSize == null) {
            this.relayout();
        }
        Dimension dimension = this.getSize();
        if (this.intrinsicSize.width > dimension.width) {
            n += this.intrinsicSize.width - dimension.width;
        }
        return n;
    }

    private void fireNodeSelected(NodePathEvent nodePathEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$xmlmind$xmledit$dialog$NodePathListener == null ? NodePath.class$("com.xmlmind.xmledit.dialog.NodePathListener") : class$com$xmlmind$xmledit$dialog$NodePathListener)) {
                ((NodePathListener)objectArray[n + 1]).nodeSelected(nodePathEvent);
            }
            n -= 2;
        }
    }

    public URL getDraggedFile(Point point) {
        int n;
        URL uRL = null;
        if (this.displayedNode != null && this.dragEnabled && (n = this.translateMouseClick(point.x)) < this.items[0].x - this.separatorSize / 2) {
            uRL = this.displayedNode.getDocument().getLocation();
        }
        return uRL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class Item {
        public Node node;
        public String tag;
        public boolean readOnly;
        public int x;
        public int width;

        protected Item() {
        }
    }
}

