/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.dialog.PreferredPrefixEditorEvent;
import com.xmlmind.xmledit.dialog.PreferredPrefixEditorListener;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PreferredPrefixEditor
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final int SCROLL_PANE = 0;
    public static final int TABLE = 1;
    public static final int NAMESPACE_FIELD = 2;
    public static final int DEFAULT_TOGGLE = 3;
    public static final int PREFIX_FIELD = 4;
    public static final int REMOVE_BUTTON = 5;
    public static final int APPLY_BUTTON = 6;
    public static final int CANCEL_BUTTON = 7;
    private EventListenerList listenerList = new EventListenerList();
    private PreferredPrefixModel model;
    private JScrollPane scrollPane;
    private JTable table;
    private JTextField namespaceField;
    private JCheckBox defaultToggle;
    private JTextField prefixField;
    private JButton removeButton;
    private JButton applyButton;
    private JButton cancelButton;
    private static final String PREFIX_HEADER = Msg.msg("PPE.prefixHeader");
    private static final String NAMESPACE_HEADER = Msg.msg("PPE.namespaceHeader");
    private static PrefixEntryCompare prefixEntryCompare = new PrefixEntryCompare();
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor;
    static /* synthetic */ Class class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener;

    public PreferredPrefixEditor() {
        this.setLayout(new BorderLayout(0, 5));
        this.model = new PreferredPrefixModel();
        this.table = new JTable(this.model);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(3);
        this.table.setShowGrid(true);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setHeaderValue(PREFIX_HEADER);
        int n = Math.max(fontMetrics.stringWidth(PREFIX_HEADER) + 5, 8 * fontMetrics.charWidth('x'));
        tableColumn.setPreferredWidth(n);
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(new PrefixRenderer());
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setHeaderValue(NAMESPACE_HEADER);
        int n2 = Math.max(fontMetrics.stringWidth(NAMESPACE_HEADER) + 5, 60 * fontMetrics.charWidth('x'));
        tableColumn.setPreferredWidth(n2);
        tableColumn.setResizable(true);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(2 + n + 2 + n2 + 2, 2 + 10 * (fontMetrics.getHeight() + 2)));
        this.add((Component)this.scrollPane, "Center");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(2, 2, 2, 2)));
        this.add((Component)jPanel, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 1;
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(Msg.msg("PPE.namespaceLabel")));
        DialogUtil.setDisplayedMnemonic(jLabel, Msg.msg("PPE.namespaceLabel"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.namespaceField = new JTextField();
        this.namespaceField.setEnabled(false);
        this.namespaceField.setActionCommand("apply");
        this.namespaceField.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.namespaceField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jLabel.setLabelFor(this.namespaceField);
        this.defaultToggle = new JCheckBox(DialogUtil.buttonLabel(Msg.msg("PPE.defaultToggle")));
        DialogUtil.setMnemonic(this.defaultToggle, Msg.msg("PPE.defaultToggle"));
        this.defaultToggle.setEnabled(false);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.defaultToggle, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel(DialogUtil.buttonLabel(Msg.msg("PPE.prefixLabel")));
        DialogUtil.setDisplayedMnemonic(jLabel, Msg.msg("PPE.prefixLabel"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.prefixField = new JTextField();
        this.prefixField.setEnabled(false);
        this.prefixField.setActionCommand("apply");
        this.prefixField.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.prefixField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jLabel.setLabelFor(this.prefixField);
        this.removeButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor == null ? (class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor = PreferredPrefixEditor.class$("com.xmlmind.xmledit.dialog.PreferredPrefixEditor")) : class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor, "remove.gif")));
        DialogUtil.setIconic(this.removeButton);
        this.removeButton.setToolTipText(Msg.msg("PPE.removeToolTip"));
        this.removeButton.setEnabled(false);
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.applyButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor == null ? (class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor = PreferredPrefixEditor.class$("com.xmlmind.xmledit.dialog.PreferredPrefixEditor")) : class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor, "ok.gif")));
        DialogUtil.setIconic(this.applyButton);
        this.applyButton.setToolTipText(Msg.msg("PPE.applyToolTip"));
        this.applyButton.setEnabled(false);
        this.applyButton.setActionCommand("apply");
        this.applyButton.addActionListener(this);
        jPanel.add((Component)this.applyButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.cancelButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor == null ? (class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor = PreferredPrefixEditor.class$("com.xmlmind.xmledit.dialog.PreferredPrefixEditor")) : class$com$xmlmind$xmledit$dialog$PreferredPrefixEditor, "cancel.gif")));
        DialogUtil.setIconic(this.cancelButton);
        this.cancelButton.setToolTipText(Msg.msg("PPE.cancelToolTip"));
        this.cancelButton.setEnabled(false);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
    }

    public Component getComponentById(int n) {
        switch (n) {
            case 0: {
                return this.scrollPane;
            }
            case 1: {
                return this.table;
            }
            case 2: {
                return this.namespaceField;
            }
            case 3: {
                return this.defaultToggle;
            }
            case 4: {
                return this.prefixField;
            }
            case 5: {
                return this.removeButton;
            }
            case 6: {
                return this.applyButton;
            }
            case 7: {
                return this.cancelButton;
            }
        }
        return null;
    }

    public void addPreferredPrefixEditorListener(PreferredPrefixEditorListener preferredPrefixEditorListener) {
        this.listenerList.add(class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener == null ? (class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener = PreferredPrefixEditor.class$("com.xmlmind.xmledit.dialog.PreferredPrefixEditorListener")) : class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener, preferredPrefixEditorListener);
    }

    public void removePreferredPrefixEditorListener(PreferredPrefixEditorListener preferredPrefixEditorListener) {
        this.listenerList.remove(class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener == null ? (class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener = PreferredPrefixEditor.class$("com.xmlmind.xmledit.dialog.PreferredPrefixEditorListener")) : class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener, preferredPrefixEditorListener);
    }

    public void setPreferredPrefix(PreferredPrefix preferredPrefix) {
        this.model.setPreferredPrefix(preferredPrefix);
        this.enableForm(preferredPrefix != null);
    }

    private void enableForm(boolean bl) {
        this.namespaceField.setEnabled(bl);
        this.defaultToggle.setEnabled(bl);
        this.prefixField.setEnabled(bl);
        this.removeButton.setEnabled(bl);
        this.applyButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
    }

    public PreferredPrefix getPreferredPrefix() {
        return this.model.getPreferredPrefix();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("remove".equals(string)) {
            this.edit(true);
        } else if ("apply".equals(string)) {
            this.edit(false);
        } else if ("cancel".equals(string)) {
            this.cancel();
        }
    }

    private void edit(boolean bl) {
        String string = this.namespaceField.getText().trim();
        if (string.length() == 0) {
            DialogUtil.badField(this.namespaceField);
            return;
        }
        Namespace namespace = Namespace.get(string);
        if (namespace == Namespace.NONE || namespace == Namespace.XML) {
            DialogUtil.badField(this.namespaceField);
            Alert.showError(this, Msg.msg("PPE.nonEditableNS", string));
            return;
        }
        String string2 = this.prefixField.getText().trim();
        if (string2.length() == 0) {
            DialogUtil.badField(this.prefixField);
            return;
        }
        if (!XMLUtil.isNCName(string2) || string2.regionMatches(true, 0, "xml", 0, 3)) {
            DialogUtil.badField(this.prefixField);
            Alert.showError(this, Msg.msg("PPE.invalidPrefix", string2));
            return;
        }
        PreferredPrefix preferredPrefix = this.model.getPreferredPrefix();
        boolean bl2 = preferredPrefix.getDefaultNamespace() == namespace;
        String string3 = preferredPrefix.remove(namespace);
        String string4 = null;
        boolean bl3 = false;
        if (!bl) {
            string4 = preferredPrefix.add(namespace, string2);
            if (this.defaultToggle.isSelected()) {
                bl3 = true;
                preferredPrefix.setDefaultNamespace(namespace);
            }
        }
        PreferredPrefixEditorEvent preferredPrefixEditorEvent = null;
        if (string3 == null) {
            if (string4 != null) {
                preferredPrefixEditorEvent = new PreferredPrefixEditorEvent(this, 1, namespace, string4, bl3, null, false);
            }
        } else {
            preferredPrefixEditorEvent = string4 == null ? new PreferredPrefixEditorEvent(this, 2, namespace, string4, bl3, string3, bl2) : new PreferredPrefixEditorEvent(this, 3, namespace, string4, bl3, string3, bl2);
        }
        if (preferredPrefixEditorEvent == null) {
            this.cancel();
        } else {
            this.clearForm();
            this.model.editedMapChanged();
            this.firePreferredPrefixEdited(preferredPrefixEditorEvent);
        }
    }

    private void firePreferredPrefixEdited(PreferredPrefixEditorEvent preferredPrefixEditorEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener == null ? PreferredPrefixEditor.class$("com.xmlmind.xmledit.dialog.PreferredPrefixEditorListener") : class$com$xmlmind$xmledit$dialog$PreferredPrefixEditorListener)) {
                ((PreferredPrefixEditorListener)objectArray[n + 1]).preferredPrefixEdited(preferredPrefixEditorEvent);
            }
            n -= 2;
        }
    }

    private void cancel() {
        this.clearForm();
        this.firePreferredPrefixEdited(new PreferredPrefixEditorEvent(this, 0, null, null, false, null, false));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        PreferredPrefixModel preferredPrefixModel = (PreferredPrefixModel)this.table.getModel();
        PreferredPrefix preferredPrefix = preferredPrefixModel.getPreferredPrefix();
        PrefixEntry prefixEntry = null;
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            prefixEntry = preferredPrefixModel.getPrefixEntry(n);
        }
        this.setForm(preferredPrefix, prefixEntry);
    }

    private void clearForm() {
        this.setForm(null, null);
    }

    private void setForm(PreferredPrefix preferredPrefix, PrefixEntry prefixEntry) {
        if (prefixEntry == null) {
            this.table.clearSelection();
            this.namespaceField.setText("");
            this.defaultToggle.setSelected(false);
            this.prefixField.setText("");
        } else {
            Namespace namespace = prefixEntry.namespace;
            this.namespaceField.setText(namespace.getURI());
            this.defaultToggle.setSelected(preferredPrefix.getDefaultNamespace() == namespace);
            this.prefixField.setText(prefixEntry.prefix);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PrefixRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            PreferredPrefixModel preferredPrefixModel = (PreferredPrefixModel)jTable.getModel();
            PreferredPrefix preferredPrefix = preferredPrefixModel.getPreferredPrefix();
            PrefixEntry prefixEntry = preferredPrefixModel.getPrefixEntry(n);
            this.setEnabled(preferredPrefix.getDefaultNamespace() != prefixEntry.namespace || bl || bl2);
            return this;
        }
    }

    private static final class PreferredPrefixModel
    extends AbstractTableModel {
        private PreferredPrefix editedMap = null;
        private PrefixEntry[] entries = new PrefixEntry[0];

        private PreferredPrefixModel() {
        }

        public void setPreferredPrefix(PreferredPrefix preferredPrefix) {
            this.editedMap = preferredPrefix;
            this.editedMapChanged();
        }

        public PreferredPrefix getPreferredPrefix() {
            return this.editedMap;
        }

        public PrefixEntry getPrefixEntry(int n) {
            return this.entries[n];
        }

        public void editedMapChanged() {
            if (this.editedMap == null) {
                this.entries = new PrefixEntry[0];
            } else {
                this.entries = this.editedMap.getAll();
                if (this.entries.length > 1) {
                    Arrays.sort(this.entries, prefixEntryCompare);
                }
            }
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.entries.length;
        }

        public Object getValueAt(int n, int n2) {
            PrefixEntry prefixEntry = this.entries[n];
            if (n2 == 0) {
                return prefixEntry.prefix;
            }
            return prefixEntry.namespace;
        }
    }

    private static class PrefixEntryCompare
    implements Comparator {
        private PrefixEntryCompare() {
        }

        public int compare(Object object, Object object2) {
            return ((PrefixEntry)object).prefix.compareTo(((PrefixEntry)object2).prefix);
        }
    }
}

