/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.dialog;

import com.xmlmind.xmledit.dialog.BinaryValueDialog;
import com.xmlmind.xmledit.dialog.Msg;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.SelectItems;
import com.xmlmind.xmledit.guiutil.StringChooserDialog;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.Base64BinaryType;
import com.xmlmind.xmledit.xsd.datatype.HexBinaryType;
import com.xmlmind.xmledit.xsd.datatype.IDREFSType;
import com.xmlmind.xmledit.xsd.datatype.IDREFType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;

public final class SetAttributeValue {
    private static StringChooserDialog stringChooserDialog = null;
    private static BinaryValueDialog binaryValueDialog = null;

    public static boolean canSetValue(Element element, DataType dataType) {
        if (dataType instanceof IDREFType || dataType instanceof IDType || dataType instanceof IDREFSType) {
            DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
            return DocumentTypeUtil.isConstrainedDocumentType(documentType);
        }
        if (dataType instanceof Base64BinaryType || dataType instanceof HexBinaryType) {
            return true;
        }
        Data[] dataArray = dataType.getEnumeratedValues();
        return dataArray != null;
    }

    public static String setValue(Component component, Element element, Name name, String string, DataType dataType) {
        if (string == null) {
            string = "";
        }
        if (dataType instanceof IDREFType || dataType instanceof IDType || dataType instanceof IDREFSType) {
            DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
            if (DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
                String[] stringArray = DocumentTypeUtil.getIds(element.getDocument(), documentType);
                if (dataType instanceof IDREFType || dataType instanceof IDType) {
                    String string2 = dataType.normalizeWhiteSpace(string);
                    StringChooserDialog stringChooserDialog = SetAttributeValue.getStringChooserDialog(component);
                    stringChooserDialog.setPressSpaceToAppend(true);
                    String string3 = dataType instanceof IDType ? Msg.msg("SAV.specifyId") : Msg.msg("SAV.selectId");
                    stringChooserDialog.setTitle(string3);
                    return stringChooserDialog.chooseItem(stringArray, true, string2);
                }
                String[] stringArray2 = XMLUtil.splitList(string);
                stringArray2 = SelectItems.selectItems(component, Msg.msg("SAV.selectIds"), stringArray, stringArray2);
                if (stringArray2 != null) {
                    return StringUtil.join(stringArray2, ' ');
                }
                return null;
            }
            return null;
        }
        if (dataType instanceof Base64BinaryType || dataType instanceof HexBinaryType) {
            BinaryValueDialog binaryValueDialog = SetAttributeValue.getBinaryValueDialog(component);
            return binaryValueDialog.edit(element, name, string, dataType);
        }
        Data[] dataArray = dataType.getEnumeratedValues();
        if (dataArray != null) {
            String string4;
            boolean bl = true;
            String[] stringArray = new String[dataArray.length];
            int n = 0;
            while (n < dataArray.length) {
                stringArray[n] = string4 = dataArray[n].formatData(element);
                if (bl && string4.indexOf(32) >= 0) {
                    bl = false;
                }
                ++n;
            }
            string4 = dataType.normalizeWhiteSpace(string);
            StringChooserDialog stringChooserDialog = SetAttributeValue.getStringChooserDialog(component);
            stringChooserDialog.setPressSpaceToAppend(bl);
            stringChooserDialog.setTitle(Msg.msg("SAV.selectValue"));
            return stringChooserDialog.chooseItem(stringArray, false, string4);
        }
        return null;
    }

    private static BinaryValueDialog getBinaryValueDialog(Component component) {
        Window window = AWTUtil.getDialogOwner(component);
        if (binaryValueDialog == null || binaryValueDialog.getOwner() != window) {
            binaryValueDialog = window instanceof Dialog ? new BinaryValueDialog((Dialog)window) : new BinaryValueDialog(component);
        }
        return binaryValueDialog;
    }

    private static StringChooserDialog getStringChooserDialog(Component component) {
        Window window = AWTUtil.getDialogOwner(component);
        if (stringChooserDialog == null || stringChooserDialog.getOwner() != window) {
            stringChooserDialog = window instanceof Dialog ? new StringChooserDialog((Dialog)window, "", 15, 20) : new StringChooserDialog(component, "", 15, 20);
            stringChooserDialog.setSingleClick(true);
        }
        return stringChooserDialog;
    }
}

