/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.jclark.xml.parse.AttributeDefinition;
import com.jclark.xml.parse.CharacterDataEvent;
import com.jclark.xml.parse.CommentEvent;
import com.jclark.xml.parse.DTD;
import com.jclark.xml.parse.EndDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.EndElementEvent;
import com.jclark.xml.parse.EndEntityReferenceEvent;
import com.jclark.xml.parse.EndPrologEvent;
import com.jclark.xml.parse.Entity;
import com.jclark.xml.parse.EntityManager;
import com.jclark.xml.parse.MarkupDeclarationEvent;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.ProcessingInstructionEvent;
import com.jclark.xml.parse.StartDocumentTypeDeclarationEvent;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.parse.StartEntityReferenceEvent;
import com.jclark.xml.parse.io.Application;
import com.jclark.xml.parse.io.ApplicationImpl;
import com.jclark.xml.parse.io.ParserImpl;
import com.jclark.xml.sax.NamespaceStack;
import com.xmlmind.xmledit.doc.CharEntities;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentTypeDeclaration;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.InclusionStatus;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doc.TypedDocumentLoader;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public final class DocumentLoader
extends ApplicationImpl
implements EntityManager {
    public static final int NEVER = 0;
    public static final int ALWAYS = 1;
    public static final int UNLESS_DTD = 2;
    private ParserImpl parser;
    private TypedDocumentLoader typedDocLoader = null;
    private EntityManager delegateEntityManager = null;
    private boolean addLocationInfo = false;
    private boolean addNamespacePrefixMap = false;
    private boolean addDTD = false;
    private boolean addCharEntities = false;
    private boolean addDeclaredPrefixes = false;
    private boolean addLineColumn = false;
    private boolean addInclusionInfo = false;
    private int namespaceMode = 2;
    private boolean keepEntityPIs = false;
    private static final int CHAR_INITIAL_CAPACITY = 1024;
    private char[] chars = new char[1024];
    private int charCount = 0;
    private StackItem[] stack;
    private int stackSize;
    private String[] entityStack;
    private int entityStackSize;
    private boolean insideDTD;
    private StringBuffer internalSubset;
    private DTD dtd;
    private boolean hasDTD;
    private boolean isRootElement;
    private boolean namespaceAware;
    private NamespaceStack nsSupport = new NamespaceStack();
    private boolean processInclusions;
    private String[] nameParts = new String[3];
    private static final String IGNORE_ENTITY = "IGNORE_ENTITY";
    public static final String BEGIN_ENTITY = "BEGIN_ENTITY";
    public static final String END_ENTITY = "END_ENTITY";
    private static final BeginEntityPIFinder beginEntityPIFinder = new BeginEntityPIFinder();

    public DocumentLoader() {
        this.parser = new ParserImpl();
        this.parser.setApplication((Application)this);
        this.parser.setEntityManager((EntityManager)this);
    }

    public void setTypedDocumentLoader(TypedDocumentLoader typedDocumentLoader) {
        this.typedDocLoader = typedDocumentLoader;
    }

    public TypedDocumentLoader getTypedDocumentLoader() {
        return this.typedDocLoader;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.delegateEntityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.delegateEntityManager;
    }

    public void setAddedProperties(int n) {
        this.addLocationInfo = (n & 1) != 0;
        this.addNamespacePrefixMap = (n & 0x10) != 0;
        this.addDTD = (n & 0x20) != 0;
        this.addCharEntities = (n & 0x4000) != 0;
        this.addDeclaredPrefixes = (n & 4) != 0;
        this.addLineColumn = (n & 2) != 0;
        this.addInclusionInfo = (n & 8) != 0;
    }

    public int getAddedProperties() {
        int n = 0;
        if (this.addLocationInfo) {
            n |= 1;
        }
        if (this.addNamespacePrefixMap) {
            n |= 0x10;
        }
        if (this.addDTD) {
            n |= 0x20;
        }
        if (this.addCharEntities) {
            n |= 0x4000;
        }
        if (this.addDeclaredPrefixes) {
            n |= 4;
        }
        if (this.addLineColumn) {
            n |= 2;
        }
        if (this.addInclusionInfo) {
            n |= 8;
        }
        return n;
    }

    public void setNamespaceMode(int n) {
        this.namespaceMode = n;
    }

    public int getNamespaceMode() {
        return this.namespaceMode;
    }

    public void setKeepEntityPIs(boolean bl) {
        this.keepEntityPIs = bl;
    }

    public boolean getKeepEntityPIs() {
        return this.keepEntityPIs;
    }

    public Document load(File file) throws IOException {
        return this.load(FileUtil.fileToURL(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document load(URL uRL) throws IOException {
        Document document;
        InputStream inputStream = uRL.openStream();
        try {
            document = this.load(new OpenEntity(inputStream, uRL.toExternalForm(), uRL));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document load(OpenEntity openEntity) throws IOException {
        this.reset();
        Document document = new Document();
        URL uRL = null;
        try {
            uRL = new URL(openEntity.getBase(), openEntity.getLocation());
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        if (uRL == null) {
            throw new IllegalArgumentException("cannot get a valid document URL using location='" + openEntity.getLocation() + "' and base='" + openEntity.getBase() + "'");
        }
        String string = uRL.toExternalForm();
        if (this.addLocationInfo) {
            document.putLocationInfo(string, false);
        }
        this.pushEntity(string);
        this.push(document, uRL);
        try {
            Object object;
            this.parser.parseDocument(openEntity);
            if (this.addNamespacePrefixMap) {
                document.addNamespacePrefixMapProperty(true, !this.addDeclaredPrefixes);
            }
            if (this.addCharEntities) {
                object = new CharEntities();
                Enumeration enumeration = this.dtd.entityNames((byte)0);
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Entity entity = this.dtd.getEntity((byte)0, string2);
                    String string3 = entity.getReplacementText();
                    if (string3 == null || string3.length() != 1) continue;
                    ((CharEntities)object).add(string2, string3.charAt(0));
                }
                if (((CharEntities)object).size() > 0) {
                    document.putProperty("CHAR_ENTITIES", object);
                }
            }
            if (this.addInclusionInfo) {
                object = new InclusionStatus();
                if (this.processInclusions) {
                    this.checkInclusions(document, (InclusionStatus)object);
                    if (!this.keepEntityPIs) {
                        DocumentLoader.trimEntityPIs(document);
                    }
                }
                document.putProperty("INCLUSION_STATUS", object);
            }
            Object var11_11 = null;
            this.reset();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.reset();
            throw throwable;
        }
        return document;
    }

    private void checkInclusions(Tree tree, InclusionStatus inclusionStatus) {
        Node node = tree.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getNodeType()) {
                case 2: {
                    String string = ((ProcessingInstruction)node).getTarget();
                    if (string != BEGIN_ENTITY) break;
                    node2 = this.checkInclusion((ProcessingInstruction)node, inclusionStatus);
                    break;
                }
                case 4: {
                    this.checkInclusions((Tree)node, inclusionStatus);
                }
            }
            node = node2;
        }
    }

    private Node checkInclusion(ProcessingInstruction processingInstruction, InclusionStatus inclusionStatus) {
        Object object;
        String[] stringArray;
        boolean bl = true;
        Element element = null;
        boolean bl2 = false;
        int n = 0;
        Node node = null;
        Object object2 = processingInstruction.getNextSibling();
        block5: while (object2 != null) {
            switch (((Node)object2).getNodeType()) {
                case 4: {
                    if (element == null) {
                        element = (Element)object2;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 0: {
                    if (((Text)object2).isXMLSpace()) {
                        bl2 = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    stringArray = ((ProcessingInstruction)object2).getTarget();
                    if (stringArray == BEGIN_ENTITY) {
                        ++n;
                        bl = false;
                        break;
                    }
                    if (stringArray == END_ENTITY) {
                        if (n == 0) {
                            node = ((Node)object2).getNextSibling();
                            break block5;
                        }
                        --n;
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            object2 = ((Node)object2).getNextSibling();
        }
        bl = bl && element != null;
        stringArray = null;
        if (bl && (stringArray = StringUtil.split(processingInstruction.getText(), '\n')).length != 4) {
            bl = false;
        }
        if (bl && (object = (ProcessingInstruction)Traversal.traverse(element, beginEntityPIFinder)) != null) {
            bl = false;
        }
        if (!bl) {
            if (inclusionStatus.notManaged == null) {
                Object object3 = object = this.typedDocLoader == null ? null : this.typedDocLoader.getDocumentElementEntityName();
                if (!DocumentLoader.entityName(processingInstruction).equals(object)) {
                    inclusionStatus.notManaged = DocumentLoader.toEntityRef(processingInstruction);
                }
            }
            return node;
        }
        if (bl2) {
            object2 = processingInstruction.getNextSibling();
            while (object2 != null && !(object2 instanceof ProcessingInstruction)) {
                object = ((Node)object2).getNextSibling();
                if (object2 instanceof Text) {
                    ((Node)object2).getParent().removeChild((Node)object2);
                }
                object2 = object;
            }
        }
        object = stringArray[0];
        String string = stringArray[1].length() == 0 ? null : stringArray[1];
        String string2 = stringArray[2];
        boolean bl3 = stringArray[3].length() != 0;
        InclusionInfo inclusionInfo = new InclusionInfo((String)object, string, string2, bl3);
        element.putProperty("INCLUSION_INFO", inclusionInfo);
        if (inclusionStatus.managed == null) {
            String string3;
            String string4 = string3 = this.typedDocLoader == null ? null : this.typedDocLoader.getDocumentElementEntityName();
            if (!((String)object).equals(string3)) {
                inclusionStatus.managed = DocumentLoader.toEntityRef(processingInstruction);
            }
        }
        return node;
    }

    private static String toEntityRef(ProcessingInstruction processingInstruction) {
        String string = DocumentLoader.entityName(processingInstruction);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('&');
        stringBuffer.append(string);
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    private static String entityName(ProcessingInstruction processingInstruction) {
        String string = processingInstruction.getText();
        int n = string.indexOf(10);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static void trimEntityPIs(Tree tree) {
        Text text = null;
        Node node = tree.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getNodeType()) {
                case 2: {
                    String string = ((ProcessingInstruction)node).getTarget();
                    if (string == BEGIN_ENTITY || string == END_ENTITY) {
                        tree.removeChild(node);
                        break;
                    }
                    text = null;
                    break;
                }
                case 0: {
                    if (text != null) {
                        text.appendText(((Text)node).getText());
                        tree.removeChild(node);
                        break;
                    }
                    text = (Text)node;
                    break;
                }
                case 4: {
                    DocumentLoader.trimEntityPIs((Tree)node);
                    text = null;
                    break;
                }
                default: {
                    text = null;
                }
            }
            node = node2;
        }
    }

    private void reset() {
        if (this.chars.length > 1024) {
            this.chars = new char[1024];
        }
        this.charCount = 0;
        this.stack = new StackItem[10];
        int n = 0;
        while (n < this.stack.length) {
            this.stack[n] = new StackItem();
            ++n;
        }
        this.stackSize = 0;
        this.entityStack = new String[10];
        this.entityStackSize = 0;
        this.insideDTD = false;
        this.internalSubset = new StringBuffer();
        this.dtd = null;
        this.hasDTD = false;
        this.isRootElement = true;
        this.namespaceAware = true;
        this.nsSupport.reset();
        this.processInclusions = false;
    }

    private void push(Tree tree, URL uRL) {
        Object object;
        if (this.stackSize == this.stack.length) {
            object = new StackItem[2 * this.stack.length];
            System.arraycopy(this.stack, 0, object, 0, this.stack.length);
            int n = this.stack.length;
            while (n < ((StackItem[])object).length) {
                object[n] = new StackItem();
                ++n;
            }
            this.stack = object;
        }
        object = this.stack[this.stackSize++];
        object.tree = tree;
        object.url = uRL;
    }

    private void pop() {
        --this.stackSize;
    }

    private StackItem top() {
        return this.stack[this.stackSize - 1];
    }

    private URL documentURL() {
        return this.stack[0].url;
    }

    private void pushEntity(String string) {
        if (this.entityStackSize == this.entityStack.length) {
            String[] stringArray = new String[2 * this.entityStack.length];
            System.arraycopy(this.entityStack, 0, stringArray, 0, this.entityStack.length);
            this.entityStack = stringArray;
        }
        this.entityStack[this.entityStackSize++] = string;
    }

    private String popEntity() {
        return this.entityStack[--this.entityStackSize];
    }

    private String topEntity() {
        return this.entityStack[this.entityStackSize - 1];
    }

    public OpenEntity open(String string, URL uRL, String string2) throws IOException {
        OpenEntity openEntity = null;
        if (this.typedDocLoader != null && this.insideDTD && this.entityStackSize == 1) {
            openEntity = this.typedDocLoader.openExternalDTDSubset(string, uRL, string2);
        }
        if (openEntity == null) {
            URL uRL2;
            if (this.delegateEntityManager != null && (openEntity = this.delegateEntityManager.open(string, uRL, string2)) != null) {
                return openEntity;
            }
            try {
                uRL2 = XMLCatalogs.resolveEntity(string2, string, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("malformed URL '" + string + "': " + MiscUtil.reason(malformedURLException));
            }
            openEntity = new OpenEntity(uRL2.openStream(), uRL2.toExternalForm(), uRL2);
        }
        return openEntity;
    }

    public void startDocumentTypeDeclaration(StartDocumentTypeDeclarationEvent startDocumentTypeDeclarationEvent) throws IOException {
        this.insideDTD = true;
    }

    public void endDocumentTypeDeclaration(EndDocumentTypeDeclarationEvent endDocumentTypeDeclarationEvent) throws IOException {
        String string;
        String string2;
        this.insideDTD = false;
        Document document = (Document)this.top().tree;
        DTD dTD = endDocumentTypeDeclarationEvent.getDTD();
        if (this.addDTD) {
            document.putProperty("DTD", dTD);
        }
        this.hasDTD = dTD.elementTypeNames().hasMoreElements();
        Entity entity = dTD.getEntity((byte)1, "#DOCTYPE");
        if (entity != null) {
            string2 = entity.getPublicId();
            string = entity.getSystemId();
        } else {
            string2 = null;
            string = null;
        }
        String string3 = this.internalSubset.toString();
        this.internalSubset = null;
        if (string3.length() == 0) {
            string3 = null;
        }
        document.appendChild(new DocumentTypeDeclaration(string2, string, string3));
    }

    public void markupDeclaration(MarkupDeclarationEvent markupDeclarationEvent) throws IOException {
        if (this.entityStackSize == 1) {
            String string = markupDeclarationEvent.getName();
            DTD dTD = markupDeclarationEvent.getDTD();
            switch (markupDeclarationEvent.getType()) {
                case 1: {
                    this.appendElementDecl(dTD, string);
                    break;
                }
                case 2: {
                    this.appendEntityDecl(dTD, (byte)0, string);
                    break;
                }
                case 3: {
                    this.appendEntityDecl(dTD, (byte)1, string);
                    break;
                }
                case 4: {
                    this.appendEntityDecl(dTD, (byte)2, string);
                    break;
                }
                case 0: {
                    this.appendAttributeDef(dTD, string, markupDeclarationEvent.getAttributeName());
                }
            }
        }
    }

    private void appendEntityDecl(DTD dTD, byte by, String string) {
        Entity entity = dTD.getEntity(by, string);
        String string2 = entity.getReplacementText();
        String string3 = null;
        switch (by) {
            case 0: {
                string3 = entity.getNotationName();
                if (string2 == null && string3 == null) {
                    return;
                }
                this.internalSubset.append("<!ENTITY ");
                break;
            }
            case 1: {
                this.internalSubset.append("<!ENTITY % ");
                break;
            }
            case 2: {
                this.internalSubset.append("<!NOTATION ");
            }
        }
        this.internalSubset.append(string);
        this.internalSubset.append(' ');
        if (string2 == null) {
            this.appendExternalId(entity);
            if (string3 != null) {
                this.internalSubset.append(" NDATA ");
                this.internalSubset.append(string3);
            }
        } else {
            this.internalSubset.append('\"');
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string2.charAt(n2);
                switch (c) {
                    case '&': {
                        String string4;
                        int n3 = string2.indexOf(59, n2);
                        if (n3 > n2 && XMLUtil.isName(string4 = string2.substring(n2 + 1, n3))) {
                            this.internalSubset.append('&');
                            this.internalSubset.append(string4);
                            this.internalSubset.append(';');
                            n2 = n3;
                            break;
                        }
                    }
                    case '\r': 
                    case '\"': 
                    case '%': {
                        this.internalSubset.append("&#");
                        this.internalSubset.append((int)c);
                        this.internalSubset.append(';');
                        break;
                    }
                    default: {
                        if (c >= ' ' && c <= '~') {
                            this.internalSubset.append(c);
                            break;
                        }
                        this.internalSubset.append("&#");
                        this.internalSubset.append((int)c);
                        this.internalSubset.append(';');
                    }
                }
                ++n2;
            }
            this.internalSubset.append('\"');
        }
        this.internalSubset.append(">\n");
    }

    private void appendExternalId(Entity entity) {
        String string = entity.getPublicId();
        String string2 = entity.getSystemId();
        if (string != null) {
            this.internalSubset.append("PUBLIC \"");
            this.internalSubset.append(string);
            this.internalSubset.append('\"');
        }
        if (string2 != null) {
            if (string == null) {
                this.internalSubset.append("SYSTEM");
            }
            this.internalSubset.append(' ');
            char c = string2.indexOf(34) < 0 ? (char)'\"' : '\'';
            this.internalSubset.append(c);
            this.internalSubset.append(string2);
            this.internalSubset.append(c);
        }
    }

    private void appendElementDecl(DTD dTD, String string) {
        this.internalSubset.append("<!ELEMENT ");
        this.internalSubset.append(string);
        this.internalSubset.append(' ');
        this.internalSubset.append(dTD.getElementType(string).getContentSpec());
        this.internalSubset.append(">\n");
    }

    private void appendAttributeDef(DTD dTD, String string, String string2) {
        Enumeration enumeration;
        String string3;
        AttributeDefinition attributeDefinition = dTD.getElementType(string).getAttributeDefinition(string2);
        this.internalSubset.append("<!ATTLIST ");
        this.internalSubset.append(string);
        this.internalSubset.append(' ');
        this.internalSubset.append(string2);
        switch (attributeDefinition.getType()) {
            case 0: {
                string3 = "CDATA";
                break;
            }
            case 1: {
                string3 = "ID";
                break;
            }
            case 2: {
                string3 = "IDREF";
                break;
            }
            case 3: {
                string3 = "IDREFS";
                break;
            }
            case 4: {
                string3 = "ENTITY";
                break;
            }
            case 5: {
                string3 = "ENTITIES";
                break;
            }
            case 6: {
                string3 = "NMTOKEN";
                break;
            }
            case 7: {
                string3 = "NMTOKENS";
                break;
            }
            case 9: {
                string3 = "NOTATION";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            this.internalSubset.append(" " + string3);
        }
        if ((enumeration = attributeDefinition.allowedValues()) != null) {
            this.internalSubset.append(" (");
            this.internalSubset.append((String)enumeration.nextElement());
            while (enumeration.hasMoreElements()) {
                this.internalSubset.append('|');
                this.internalSubset.append((String)enumeration.nextElement());
            }
            this.internalSubset.append(')');
        }
        String string4 = attributeDefinition.getDefaultUnnormalizedValue();
        boolean bl = attributeDefinition.isRequired();
        if (string4 == null) {
            this.internalSubset.append(bl ? " #REQUIRED" : " #IMPLIED");
        } else {
            if (bl) {
                this.internalSubset.append(" #FIXED ");
            } else {
                this.internalSubset.append(' ');
            }
            char c = string4.indexOf(34) < 0 ? (char)'\"' : '\'';
            this.internalSubset.append(c);
            this.internalSubset.append(string4);
            this.internalSubset.append(c);
        }
        this.internalSubset.append(">\n");
    }

    public void endProlog(EndPrologEvent endPrologEvent) {
        this.dtd = endPrologEvent.getDTD();
    }

    public void comment(CommentEvent commentEvent) throws IOException {
        if (this.insideDTD) {
            if (this.entityStackSize == 1) {
                this.internalSubset.append("<!--");
                this.internalSubset.append(commentEvent.getComment());
                this.internalSubset.append("-->\n");
            }
        } else {
            StackItem stackItem = this.top();
            if (this.charCount > 0) {
                stackItem.tree.appendChild(new Text(this.chars, 0, this.charCount));
                this.charCount = 0;
            }
            stackItem.tree.appendChild(new Comment(commentEvent.getComment()));
        }
    }

    public void processingInstruction(ProcessingInstructionEvent processingInstructionEvent) throws IOException {
        if (this.insideDTD) {
            if (this.entityStackSize == 1) {
                this.internalSubset.append("<?");
                this.internalSubset.append(processingInstructionEvent.getName());
                this.internalSubset.append(' ');
                this.internalSubset.append(processingInstructionEvent.getInstruction());
                this.internalSubset.append("?>\n");
            }
        } else {
            StackItem stackItem = this.top();
            if (this.charCount > 0) {
                stackItem.tree.appendChild(new Text(this.chars, 0, this.charCount));
                this.charCount = 0;
            }
            stackItem.tree.appendChild(new ProcessingInstruction(processingInstructionEvent.getName(), processingInstructionEvent.getInstruction()));
        }
    }

    public void startEntityReference(StartEntityReferenceEvent startEntityReferenceEvent) throws IOException {
        String string = startEntityReferenceEvent.getName();
        String string2 = IGNORE_ENTITY;
        if (this.insideDTD) {
            if (this.entityStackSize == 1 && !string.equals("#DOCTYPE")) {
                this.internalSubset.append('%');
                this.internalSubset.append(string);
                this.internalSubset.append(";\n");
            }
        } else {
            Entity entity = this.dtd.getEntity((byte)0, string);
            if (entity != null) {
                String string3;
                String string4 = entity.getSystemId();
                if (string4 != null) {
                    string2 = string4;
                    if (this.addInclusionInfo) {
                        Serializable serializable;
                        boolean bl;
                        Tree tree = this.top().tree;
                        if (this.charCount > 0) {
                            tree.appendChild(new Text(this.chars, 0, this.charCount));
                            this.charCount = 0;
                        }
                        URL uRL = entity.getBase();
                        if (this.documentURL().equals(uRL)) {
                            bl = false;
                        } else {
                            bl = true;
                            try {
                                serializable = new URL(uRL, string4);
                                string4 = ((URL)serializable).toExternalForm();
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                        serializable = new StringBuffer();
                        ((StringBuffer)serializable).append(string);
                        ((StringBuffer)serializable).append('\n');
                        String string5 = entity.getPublicId();
                        if (string5 != null) {
                            ((StringBuffer)serializable).append(string5);
                        }
                        ((StringBuffer)serializable).append('\n');
                        ((StringBuffer)serializable).append(string4);
                        ((StringBuffer)serializable).append('\n');
                        if (bl) {
                            ((StringBuffer)serializable).append("isDTDModule");
                        }
                        tree.appendChild(new ProcessingInstruction(BEGIN_ENTITY, ((StringBuffer)serializable).toString()));
                        this.processInclusions = true;
                    }
                } else if (this.addInclusionInfo && (string3 = entity.getReplacementText()) != null && string3.length() > 1) {
                    string2 = string;
                    Tree tree = this.top().tree;
                    if (this.charCount > 0) {
                        tree.appendChild(new Text(this.chars, 0, this.charCount));
                        this.charCount = 0;
                    }
                    tree.appendChild(new ProcessingInstruction(BEGIN_ENTITY, string));
                    this.processInclusions = true;
                }
            }
        }
        this.pushEntity(string2);
    }

    public void endEntityReference(EndEntityReferenceEvent endEntityReferenceEvent) throws IOException {
        if (this.popEntity() == IGNORE_ENTITY) {
            return;
        }
        if (this.addInclusionInfo) {
            Tree tree = this.top().tree;
            if (this.charCount > 0) {
                tree.appendChild(new Text(this.chars, 0, this.charCount));
                this.charCount = 0;
            }
            tree.appendChild(new ProcessingInstruction(END_ENTITY));
        }
    }

    public void startElement(StartElementEvent startElementEvent) throws IOException {
        Element element;
        Object object;
        StackItem stackItem = this.top();
        if (this.isRootElement) {
            this.isRootElement = false;
            if (this.typedDocLoader != null) {
                this.typedDocLoader.startRootElement((Document)stackItem.tree, this.hasDTD, startElementEvent);
            }
            switch (this.namespaceMode) {
                case 2: {
                    this.namespaceAware = !this.hasDTD;
                    break;
                }
                case 0: {
                    this.namespaceAware = false;
                    break;
                }
                default: {
                    this.namespaceAware = true;
                }
            }
        }
        if (this.charCount > 0) {
            stackItem.tree.appendChild(new Text(this.chars, 0, this.charCount));
            this.charCount = 0;
        }
        int n = startElementEvent.getAttributeSpecifiedCount();
        if (this.namespaceAware) {
            this.nsSupport.pushContext();
            object = this.declarePrefixes(startElementEvent);
            element = new Element(this.newName(startElementEvent.getName(), false));
            int n2 = 0;
            while (n2 < n) {
                String string = startElementEvent.getAttributeName(n2);
                if (string.indexOf("xmlns") != 0) {
                    element.putAttribute(this.newName(string, true), startElementEvent.getAttributeValue(n2));
                }
                ++n2;
            }
            if (object != null && (this.addNamespacePrefixMap || this.addDeclaredPrefixes)) {
                element.putProperty("DECLARED_PREFIXES", object);
            }
        } else {
            element = new Element(this.newName2(startElementEvent.getName()));
            int n3 = 0;
            while (n3 < n) {
                element.putAttribute(this.newName2(startElementEvent.getAttributeName(n3)), startElementEvent.getAttributeValue(n3));
                ++n3;
            }
        }
        if (this.addLineColumn) {
            object = startElementEvent.getLocation();
            element.putProperty("LINE_COLUMN", new int[]{object.getLineNumber(), 1 + object.getColumnNumber()});
        }
        if (this.addLocationInfo) {
            object = startElementEvent.getLocation().getEntityBase();
            if (object != null && !((URL)object).equals(stackItem.url)) {
                element.putLocationInfo(this.topEntity(), false);
            }
        } else {
            object = null;
        }
        stackItem.tree.appendChild(element);
        this.push(element, (URL)object);
    }

    private final PrefixEntry[] declarePrefixes(StartElementEvent startElementEvent) {
        PrefixEntry[] prefixEntryArray = null;
        int n = startElementEvent.getAttributeCount();
        int n2 = 0;
        while (n2 < n) {
            String string = startElementEvent.getAttributeName(n2);
            if (string.indexOf("xmlns") == 0) {
                int n3 = string.length();
                String string2 = startElementEvent.getAttributeValue(n2);
                Namespace namespace = Namespace.get(string2);
                String string3 = null;
                if (n3 == 5) {
                    string3 = "";
                } else if (string.charAt(5) == ':') {
                    String string4 = string3 = n3 > 6 ? string.substring(6) : "";
                    if (!XMLUtil.isNCName(string3)) {
                        string3 = null;
                    }
                }
                if (string3 != null) {
                    this.nsSupport.declarePrefix(string3, string2);
                    if (prefixEntryArray == null) {
                        prefixEntryArray = new PrefixEntry[]{new PrefixEntry(string3, namespace)};
                    } else {
                        PrefixEntry[] prefixEntryArray2 = new PrefixEntry[prefixEntryArray.length + 1];
                        System.arraycopy(prefixEntryArray, 0, prefixEntryArray2, 0, prefixEntryArray.length);
                        prefixEntryArray2[prefixEntryArray.length] = new PrefixEntry(string3, namespace);
                        prefixEntryArray = prefixEntryArray2;
                    }
                }
            }
            ++n2;
        }
        return prefixEntryArray;
    }

    private final Name newName(String string, boolean bl) {
        this.nameParts[1] = null;
        this.nameParts[0] = null;
        this.nsSupport.processName(string, this.nameParts, bl);
        if (this.nameParts[0] == null || this.nameParts[1] == null) {
            return Name.get(string);
        }
        return Name.get(this.nameParts[0], this.nameParts[1]);
    }

    private final Name newName2(String string) {
        String string2;
        Namespace namespace;
        if ("xml:".regionMatches(true, 0, string, 0, 4) && string.length() > 4) {
            namespace = Namespace.XML;
            string2 = string.substring(4);
        } else {
            namespace = Namespace.NONE;
            string2 = string;
        }
        return Name.get(namespace, string2);
    }

    public void endElement(EndElementEvent endElementEvent) throws IOException {
        if (this.charCount > 0) {
            this.top().tree.appendChild(new Text(this.chars, 0, this.charCount));
            this.charCount = 0;
        }
        this.pop();
        if (this.namespaceAware) {
            this.nsSupport.popContext();
        }
    }

    public void characterData(CharacterDataEvent characterDataEvent) throws IOException {
        int n = characterDataEvent.getLengthMax();
        if (this.charCount + n > this.chars.length) {
            int n2 = Math.max(this.charCount + n, 2 * this.chars.length);
            char[] cArray = new char[n2];
            if (this.charCount > 0) {
                System.arraycopy(this.chars, 0, cArray, 0, this.charCount);
            }
            this.chars = cArray;
        }
        this.charCount += characterDataEvent.copyChars(this.chars, this.charCount);
    }

    private static class BeginEntityPIFinder
    extends Traversal.HandlerBase {
        private BeginEntityPIFinder() {
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            if (processingInstruction.getTarget() == DocumentLoader.BEGIN_ENTITY) {
                return processingInstruction;
            }
            return null;
        }
    }

    private static final class StackItem {
        public Tree tree;
        public URL url;

        private StackItem() {
        }
    }
}

