/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.AttributeDefaultValue;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.PreserveSpaceDefaultValue;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;

public final class Element
extends Tree
implements NamespacePrefixMap {
    private Name name;
    private LinearHashtable attributes;
    private Document document;
    private static final Element[] NO_ELEMENTS = new Element[0];
    private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    private static final LinearHashtable NO_ATTRIBUTE_SET = new LinearHashtable();

    public Element(Name name) {
        this.name = name;
    }

    public Node copy() {
        Element element = new Element(this.name);
        if (this.properties != null) {
            element.properties = (LinearHashtable)this.properties.clone();
        }
        element.readOnly = this.readOnly;
        if (this.attributes != null) {
            element.attributes = (LinearHashtable)this.attributes.clone();
        }
        Node node = this.getFirstChild();
        while (node != null) {
            element.appendChild(node.copy());
            node = node.getNextSibling();
        }
        return element;
    }

    public Name getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.name.getNamespace();
    }

    public String getLocalName() {
        return this.name.getLocalPart();
    }

    public void setName(Name name) throws IllegalStateException {
        if (this.document != null) {
            throw new IllegalStateException();
        }
        this.name = name;
    }

    public int getNodeType() {
        return 4;
    }

    public Document getDocument() {
        return this.document;
    }

    public void insertChild(Node node, Node node2) {
        super.insertChild(node, node2);
        if (this.document != null) {
            this.document.elementStructureNotification(this, 10, node, null, node2);
        }
    }

    public void replaceChild(Node node, Node node2) {
        Node node3 = node.getNextSibling();
        super.replaceChild(node, node2);
        if (this.document != null) {
            if (node2 == null) {
                this.document.elementStructureNotification(this, 12, node3, node, null);
            } else {
                this.document.elementStructureNotification(this, 11, node3, node, node2);
            }
        }
    }

    void setDocument(Document document, int n) {
        super.setDocument(document, n);
        this.document = document;
    }

    public String putAttribute(Name name, String string) {
        String string2;
        if (this.attributes == null) {
            this.attributes = new LinearHashtable();
        }
        if ((string2 = (String)this.attributes.put(name, string)) == null) {
            if (this.document != null) {
                this.document.elementAttributeNotification(this, 20, name, null, string);
            }
        } else if (!string.equals(string2) && this.document != null) {
            this.document.elementAttributeNotification(this, 21, name, string2, string);
        }
        return string2;
    }

    public String removeAttribute(Name name) {
        if (this.attributes == null) {
            return null;
        }
        String string = (String)this.attributes.remove(name);
        if (this.attributes.size() == 0) {
            this.attributes = null;
        }
        if (string != null && this.document != null) {
            this.document.elementAttributeNotification(this, 22, name, string, null);
        }
        return string;
    }

    public boolean hasAttribute(Name name) {
        return this.attributes == null ? false : this.attributes.get(name) != null;
    }

    public String getAttribute(Name name) {
        return this.attributes == null ? null : (String)this.attributes.get(name);
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Attribute[] getAllAttributes() {
        if (this.attributes == null) {
            return NO_ATTRIBUTES;
        }
        Attribute[] attributeArray = new Attribute[this.attributes.size()];
        int n = 0;
        Enumeration enumeration = this.attributes.entries();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            attributeArray[n++] = new Attribute(this, (Name)objectArray[0], (String)objectArray[1]);
        }
        return attributeArray;
    }

    public Enumeration getAttributes() {
        return this.getAttributes(false);
    }

    public Enumeration getAttributes(boolean bl) {
        if (this.attributes == null) {
            return new AttributeEnumeration(this, NO_ATTRIBUTE_SET, false);
        }
        return new AttributeEnumeration(this, this.attributes, bl);
    }

    public void removeProperties(final int n) {
        Traversal.traverse(this, new Traversal.HandlerBase(){

            public Object enterElement(Element element) {
                if ((n & 1) != 0) {
                    Element.this.removeProperty("LOCATION_INFO");
                }
                if ((n & 2) != 0) {
                    Element.this.removeProperty("LINE_COLUMN");
                }
                if ((n & 4) != 0) {
                    Element.this.removeProperty("DECLARED_PREFIXES");
                }
                if ((n & 8) != 0) {
                    Element.this.removeProperty("INCLUSION_INFO");
                }
                return null;
            }
        });
    }

    public Namespace prefixToNamespace(String string) {
        NamespacePrefixMap namespacePrefixMap;
        if (this.document != null && (namespacePrefixMap = (NamespacePrefixMap)this.document.getProperty("NAMESPACE_PREFIX_MAP")) != null) {
            return namespacePrefixMap.prefixToNamespace(string);
        }
        Tree tree = this;
        while (tree != null) {
            PrefixEntry[] prefixEntryArray = (PrefixEntry[])tree.getProperty("DECLARED_PREFIXES");
            if (prefixEntryArray != null) {
                int n = 0;
                while (n < prefixEntryArray.length) {
                    if (string.equals(prefixEntryArray[n].prefix)) {
                        return prefixEntryArray[n].namespace;
                    }
                    ++n;
                }
            }
            tree = tree.getParent();
        }
        return "xml".equals(string) ? Namespace.XML : null;
    }

    public String[] namespaceToPrefixes(Namespace namespace) {
        NamespacePrefixMap namespacePrefixMap;
        if (this.document != null && (namespacePrefixMap = (NamespacePrefixMap)this.document.getProperty("NAMESPACE_PREFIX_MAP")) != null) {
            return namespacePrefixMap.namespaceToPrefixes(namespace);
        }
        LinearHashtable linearHashtable = null;
        String[] stringArray = null;
        Tree tree = this;
        while (tree != null) {
            PrefixEntry[] prefixEntryArray = (PrefixEntry[])tree.getProperty("DECLARED_PREFIXES");
            if (prefixEntryArray != null) {
                if (linearHashtable == null) {
                    linearHashtable = new LinearHashtable();
                }
                int n = 0;
                while (n < prefixEntryArray.length) {
                    PrefixEntry prefixEntry = prefixEntryArray[n];
                    Namespace namespace2 = prefixEntry.namespace;
                    String string = prefixEntry.prefix;
                    if (namespace == namespace2 && !linearHashtable.containsKey(string)) {
                        stringArray = stringArray == null ? new String[]{string} : StringUtil.append(stringArray, string);
                    }
                    linearHashtable.put(string, string);
                    ++n;
                }
            }
            tree = tree.getParent();
        }
        if (stringArray == null && namespace == Namespace.XML) {
            return NamespaceToPrefixes.XML_PREFIXES;
        }
        return stringArray;
    }

    public boolean hasNoContent() {
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        return true;
    }

    public int getContentChildCount() {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    ++n;
                }
            }
            node = node.getNextSibling();
        }
        return n;
    }

    public Node getFirstContentChild() {
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    return node;
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Node getLastContentChild() {
        Node node = this.getLastChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    return node;
                }
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    public boolean hasChildElements() {
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    return true;
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    public int getChildElementCount() {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    ++n;
                }
            }
            node = node.getNextSibling();
        }
        return n;
    }

    public Element getChildElement(int n) {
        int n2 = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (n2 == n) {
                        return (Element)node;
                    }
                    ++n2;
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public int indexOfChildElement(Element element) {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (node == element) {
                        return n;
                    }
                    ++n;
                }
            }
            node = node.getNextSibling();
        }
        return -1;
    }

    public Element[] getChildElements() {
        int n = this.getChildElementCount();
        if (n == 0) {
            return NO_ELEMENTS;
        }
        Element[] elementArray = new Element[n];
        n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    elementArray[n++] = (Element)node;
                }
            }
            node = node.getNextSibling();
        }
        return elementArray;
    }

    public Element getFirstChildElement() {
        Node node = this.first;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Element getLastChildElement() {
        Node node = this.getLastChild();
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = this.first;
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                case 0: {
                    stringBuffer.append(((Text)node).getTextChars());
                    break;
                }
                default: {
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString();
    }

    public boolean setText(String string) {
        Node node = this.first;
        while (node != null) {
            if (node instanceof Element) {
                return false;
            }
            node = node.getNextSibling();
        }
        boolean bl = false;
        node = this.first;
        while (node != null) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (!bl) {
                    bl = true;
                    if (this.document != null) {
                        this.document.beginBatchEditing();
                    }
                    text.setText(string);
                } else {
                    this.removeChild(text);
                }
            }
            node = node.getNextSibling();
        }
        if (bl && this.document != null) {
            this.document.endBatchEditing();
        }
        return bl;
    }

    public String getSpaceAttribute() {
        return this.getAttribute(Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
    }

    public String getAttribute(Name name, AttributeDefaultValue attributeDefaultValue) {
        String string = this.getAttribute(name);
        if (string == null && attributeDefaultValue != null) {
            string = attributeDefaultValue.getAttributeDefaultValue(this, name);
        }
        return string;
    }

    public String lookupAttribute(Name name, AttributeDefaultValue attributeDefaultValue) {
        Tree tree = this;
        while (tree instanceof Element) {
            String string = tree.getAttribute(name, attributeDefaultValue);
            if (string != null) {
                return string;
            }
            tree = tree.parent;
        }
        return null;
    }

    public boolean hasPreserveSpace() {
        String string = this.lookupAttribute(Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
        if (string == null) {
            return false;
        }
        return string.trim().equals("preserve");
    }

    public int getIntAttribute(Name name, int n) {
        int n2;
        block2: {
            n2 = n;
            String string = this.getAttribute(name);
            if (string == null) break block2;
            try {
                n2 = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public int getIntAttribute(Name name, int n, int n2, int n3) {
        int n4;
        block3: {
            n4 = n3;
            String string = this.getAttribute(name);
            if (string == null) break block3;
            try {
                n4 = Integer.parseInt(string.trim());
                if (n4 < n || n4 > n2) {
                    n4 = n3;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n4;
    }

    public double getDoubleAttribute(Name name, double d) {
        double d2;
        block2: {
            d2 = d;
            String string = this.getAttribute(name);
            if (string == null) break block2;
            try {
                d2 = Double.parseDouble(string.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d2;
    }

    public double getDoubleAttribute(Name name, double d, double d2, double d3) {
        double d4;
        block3: {
            d4 = d3;
            String string = this.getAttribute(name);
            if (string == null) break block3;
            try {
                d4 = Double.parseDouble(string.trim());
                if (d4 < d || d4 > d2) {
                    d4 = d3;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d4;
    }

    public boolean getBooleanAttribute(Name name, boolean bl) {
        boolean bl2 = bl;
        String string = this.getAttribute(name);
        if (string != null) {
            if ((string = string.trim()).equals("true")) {
                bl2 = true;
            } else if (string.equals("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public String getTokenAttribute(Name name, String string) {
        String string2 = this.getAttribute(name);
        string2 = string2 != null ? XMLUtil.collapseWhiteSpace(string2) : string;
        return string2;
    }

    public String getNmtokenAttribute(Name name, String string) {
        String string2 = this.getAttribute(name);
        if (string2 != null) {
            if (!XMLUtil.isNmtoken(string2 = XMLUtil.collapseWhiteSpace(string2))) {
                string2 = string;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    public String getNormalizedStringAttribute(Name name, String string) {
        String string2 = this.getAttribute(name);
        string2 = string2 != null ? XMLUtil.replaceWhiteSpace(string2) : string;
        return string2;
    }

    public String getEnumAttribute(Name name, String[] stringArray, String string) {
        String string2 = this.getTokenAttribute(name, null);
        if (string2 != null) {
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                string2 = string;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    public String[] getListAttribute(Name name, String[] stringArray) {
        String string = this.getAttribute(name);
        String[] stringArray2 = string != null ? XMLUtil.splitList(string) : stringArray;
        return stringArray2;
    }

    public String getAnyURIAttribute(Name name, String string) {
        String string2 = this.getAttribute(name);
        if (string2 == null) {
            return string;
        }
        URI uRI = null;
        string2 = string2.trim();
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uRI == null ? string : string2;
    }

    public Name name() {
        return this.name;
    }

    public NamespacePrefixMap namespacePrefixMap() {
        return this;
    }

    public String attributeValue(Name name) {
        return this.getAttribute(name);
    }

    public Enumeration attributes() {
        return this.getAttributes(true);
    }

    private static final class AttributeEnumeration
    implements Enumeration {
        private Element element;
        private Enumeration entries;
        private boolean copyAttributes;
        private Attribute attr = new Attribute();

        public AttributeEnumeration(Element element, LinearHashtable linearHashtable, boolean bl) {
            this.element = element;
            this.entries = linearHashtable.entries();
            this.copyAttributes = bl;
        }

        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        public Object nextElement() {
            Object[] objectArray = (Object[])this.entries.nextElement();
            this.attr.element = this.element;
            this.attr.name = (Name)objectArray[0];
            this.attr.value = (String)objectArray[1];
            return this.copyAttributes ? this.attr.copy() : this.attr;
        }
    }
}

