/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Step;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;

public final class Path
implements Serializable {
    private Step[] steps;
    private boolean isAbsolute;
    private static Path DOCUMENT_PATH = new Path();

    private Path() {
    }

    public static Path fromString(String string, PrefixToNamespace prefixToNamespace) {
        return Path.fromString(string, prefixToNamespace, false);
    }

    public static Path fromString(String string, PrefixToNamespace prefixToNamespace, boolean bl) {
        Step step;
        Object object;
        int n;
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String[] stringArray = StringUtil.split(string, '/');
        boolean bl2 = false;
        Step[] stepArray = new Step[stringArray.length];
        int n2 = 0;
        int n3 = 0;
        if (stringArray[n3].length() == 0) {
            bl2 = true;
            ++n3;
        }
        if ((n = stringArray.length - 1) >= 0 && stringArray[n].length() == 0) {
            --n;
        }
        while (n3 <= n) {
            object = stringArray[n3];
            if (((String)object).length() == 0) {
                step = new Step();
                step.axis = 1;
                step.test = 0;
            } else {
                step = Step.fromString((String)object, prefixToNamespace, bl);
                if (step == null) {
                    return null;
                }
            }
            stepArray[n2++] = step;
            ++n3;
        }
        if (n2 == 0) {
            if (bl2) {
                return DOCUMENT_PATH;
            }
            return null;
        }
        object = new Path();
        ((Path)object).isAbsolute = bl2;
        if (n2 != stepArray.length) {
            ((Path)object).steps = new Step[n2];
            System.arraycopy(stepArray, 0, ((Path)object).steps, 0, n2);
        } else {
            ((Path)object).steps = stepArray;
        }
        n = n2 - 1;
        n3 = 0;
        while (n3 <= n) {
            step = ((Path)object).steps[n3];
            if (step.axis == 3 && n3 != n) {
                return null;
            }
            ++n3;
        }
        return object;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public boolean isSelectingAttributes() {
        return this.steps.length > 0 && this.steps[this.steps.length - 1].axis == 3;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Path)) {
            return false;
        }
        Path path = (Path)object;
        if (this.steps == null || path.steps == null) {
            return this.steps == path.steps && this.isAbsolute == path.isAbsolute;
        }
        if (this.steps.length != path.steps.length || this.isAbsolute != path.isAbsolute) {
            return false;
        }
        int n = 0;
        while (n < this.steps.length) {
            if (!this.steps[n].equals(path.steps[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, namespaceToPrefixes);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer, NamespaceToPrefixes namespaceToPrefixes) {
        if (this.isAbsolute) {
            stringBuffer.append('/');
        }
        int n = 0;
        while (n < this.steps.length) {
            if (n > 0) {
                stringBuffer.append('/');
            }
            this.steps[n].toString(stringBuffer, namespaceToPrefixes);
            ++n;
        }
    }

    public XNode[] select(Document document) {
        return this.select(document, false);
    }

    public XNode[] select(Document document, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Path.select(document, this.steps, 0, bl, arrayList);
        return Path.toXNodeArray(arrayList);
    }

    public XNode[] select(Element element) {
        return this.select(element, false);
    }

    public XNode[] select(Element element, boolean bl) {
        if (this.isAbsolute) {
            return this.select(element.getDocument());
        }
        ArrayList arrayList = new ArrayList();
        Path.select(element, this.steps, 0, bl, arrayList);
        return Path.toXNodeArray(arrayList);
    }

    private static XNode[] toXNodeArray(ArrayList arrayList) {
        XNode[] xNodeArray;
        int n = arrayList.size();
        XNode[] xNodeArray2 = new XNode[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            xNodeArray = (XNode[])arrayList.get(n3);
            boolean bl = false;
            int n4 = 0;
            while (n4 < n2) {
                if (xNodeArray.equals(xNodeArray2[n4])) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                xNodeArray2[n2++] = xNodeArray;
            }
            ++n3;
        }
        if (n2 != n) {
            xNodeArray = new XNode[n2];
            System.arraycopy(xNodeArray2, 0, xNodeArray, 0, n2);
            xNodeArray2 = xNodeArray;
        }
        return xNodeArray2;
    }

    private static void select(Tree tree, Step[] stepArray, int n, boolean bl, ArrayList arrayList) {
        Step step = stepArray[n];
        boolean bl2 = n == stepArray.length - 1;
        switch (step.axis) {
            case 0: 
            case 1: {
                Node node;
                boolean bl3 = false;
                if (tree instanceof Element) {
                    node = (Element)tree;
                    switch (step.test) {
                        case 0: 
                        case 1: {
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            bl3 = ((Element)node).getName() == step.name;
                            break;
                        }
                        case 3: {
                            bl3 = ((Element)node).getName().getNamespace() == step.namespace;
                        }
                    }
                } else {
                    boolean bl4 = bl3 = step.test == 0;
                }
                if (bl3) {
                    if (bl2) {
                        arrayList.add(tree);
                    } else {
                        Path.select(tree, stepArray, n + 1, bl, arrayList);
                    }
                }
                if (step.axis != 1) break;
                node = tree.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 4) {
                        Path.select((Element)node, stepArray, n, bl, arrayList);
                    }
                    node = node.getNextSibling();
                }
                break;
            }
            case 2: {
                Node node = tree.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 4) {
                        Element element = (Element)node;
                        boolean bl5 = false;
                        switch (step.test) {
                            case 0: 
                            case 1: {
                                bl5 = true;
                                break;
                            }
                            case 2: {
                                bl5 = element.getName() == step.name;
                                break;
                            }
                            case 3: {
                                boolean bl6 = bl5 = element.getName().getNamespace() == step.namespace;
                            }
                        }
                        if (bl5) {
                            if (bl2) {
                                arrayList.add(element);
                            } else {
                                Path.select(element, stepArray, n + 1, bl, arrayList);
                            }
                        }
                    }
                    node = node.getNextSibling();
                }
                break;
            }
            case 3: {
                if (!(tree instanceof Element)) {
                    return;
                }
                boolean bl7 = false;
                Enumeration enumeration = ((Element)tree).getAttributes();
                while (enumeration.hasMoreElements()) {
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    switch (step.test) {
                        case 0: 
                        case 1: {
                            arrayList.add(attribute.copy());
                            break;
                        }
                        case 2: {
                            if (attribute.name != step.name) break;
                            arrayList.add(attribute.copy());
                            bl7 = true;
                            break;
                        }
                        case 3: {
                            if (attribute.name.getNamespace() != step.namespace) break;
                            arrayList.add(attribute.copy());
                        }
                    }
                }
                if (!bl || bl7 || step.test != 2) break;
                arrayList.add(new Attribute((Element)tree, step.name, null));
            }
        }
    }

    public boolean match(XNode xNode) {
        int n = this.steps.length;
        if (n > 0) {
            Step step = this.steps[n - 1];
            if (step.axis == 3) {
                if (!(xNode instanceof Attribute)) {
                    return false;
                }
                Attribute attribute = (Attribute)xNode;
                switch (step.test) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (attribute.name == step.name) break;
                        return false;
                    }
                    case 3: {
                        if (attribute.name.getNamespace() == step.namespace) break;
                        return false;
                    }
                    default: {
                        throw new RuntimeException("unknown Step test " + step.test);
                    }
                }
                xNode = attribute.element;
                --n;
            }
        }
        if (xNode == null || !(xNode instanceof Node)) {
            return false;
        }
        return Path.match(this.steps, n, this.isAbsolute, (Node)xNode);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean match(Step[] stepArray, int n, boolean bl, Node node) {
        int n2 = n - 1;
        while (n2 >= 0) {
            Step step = stepArray[n2];
            switch (step.axis) {
                case 0: {
                    if (node == null) return false;
                    if (Path.match(step, node)) break;
                    return false;
                }
                case 1: {
                    if (node == null) return false;
                    if (!Path.match(step, node)) {
                        return false;
                    }
                    while (true) {
                        if (node == null || Path.match(stepArray, n2, bl, node)) {
                            if (node == null) return false;
                            return true;
                        }
                        node = node.getParent();
                    }
                }
                case 2: {
                    if (node == null) return false;
                    if (!Path.match(step, node)) {
                        return false;
                    }
                    node = node.getParent();
                    break;
                }
                case 3: {
                    return false;
                }
                default: {
                    throw new RuntimeException("unknown Step axis " + step.axis);
                }
            }
            --n2;
        }
        if (!bl) return true;
        if (node == null) return false;
        if (node instanceof Document) return true;
        return false;
    }

    private static final boolean match(Step step, Node node) {
        switch (step.test) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (node instanceof Element) {
                    if (((Element)node).getName() == step.name) break;
                    return false;
                }
                return false;
            }
            case 3: {
                if (node instanceof Element) {
                    if (((Element)node).getNamespace() == step.namespace) break;
                    return false;
                }
                return false;
            }
            default: {
                throw new RuntimeException("unknown Step test " + step.test);
            }
        }
        return true;
    }

    static {
        Path.DOCUMENT_PATH.isAbsolute = true;
        Path.DOCUMENT_PATH.steps = new Step[]{Step.fromString(".", null)};
    }
}

