/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Path;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doc.XNodeSelector;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import java.io.Serializable;

public final class XPath
implements XNodeSelector,
Serializable {
    private Path[] paths;
    private static final XNode[] EMPTY_SET = new XNode[0];

    private XPath() {
    }

    public static XPath fromString(String string, PrefixToNamespace prefixToNamespace) {
        return XPath.fromString(string, prefixToNamespace, false);
    }

    public static XPath fromString(String string, PrefixToNamespace prefixToNamespace, boolean bl) {
        Object object;
        String[] stringArray = StringUtil.split(string, '|');
        Path[] pathArray = new Path[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = stringArray[n2].trim();
            if (((String)object).length() != 0) {
                pathArray[n] = Path.fromString((String)object, prefixToNamespace, bl);
                if (pathArray[n] == null) {
                    return null;
                }
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        object = new XPath();
        if (n != pathArray.length) {
            ((XPath)object).paths = new Path[n];
            System.arraycopy(pathArray, 0, ((XPath)object).paths, 0, n);
        } else {
            ((XPath)object).paths = pathArray;
        }
        return object;
    }

    public Path[] getPaths() {
        return this.paths;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XPath)) {
            return false;
        }
        XPath xPath = (XPath)object;
        if (this.paths == null || xPath.paths == null) {
            return this.paths == xPath.paths;
        }
        if (this.paths.length != xPath.paths.length) {
            return false;
        }
        int n = 0;
        while (n < this.paths.length) {
            if (!this.paths[n].equals(xPath.paths[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.paths.length) {
            if (n > 0) {
                stringBuffer.append('|');
            }
            this.paths[n].toString(stringBuffer, namespaceToPrefixes);
            ++n;
        }
        return stringBuffer.toString();
    }

    public XNode[] select(Document document) {
        return this.select(document, false);
    }

    public XNode[] select(Document document, boolean bl) {
        XNode[] xNodeArray = EMPTY_SET;
        int n = 0;
        while (n < this.paths.length) {
            XNode[] xNodeArray2 = this.paths[n].select(document, bl);
            if (xNodeArray2 != null && xNodeArray2.length != 0) {
                xNodeArray = xNodeArray == EMPTY_SET ? xNodeArray2 : XPath.union(xNodeArray, xNodeArray2);
            }
            ++n;
        }
        return xNodeArray;
    }

    public XNode[] select(Element element) {
        return this.select(element, false);
    }

    public XNode[] select(Element element, boolean bl) {
        XNode[] xNodeArray = EMPTY_SET;
        int n = 0;
        while (n < this.paths.length) {
            XNode[] xNodeArray2 = this.paths[n].select(element, bl);
            if (xNodeArray2 != null && xNodeArray2.length != 0) {
                xNodeArray = xNodeArray == EMPTY_SET ? xNodeArray2 : XPath.union(xNodeArray, xNodeArray2);
            }
            ++n;
        }
        return xNodeArray;
    }

    public static XNode[] union(XNode[] xNodeArray, XNode[] xNodeArray2) {
        XNode[] xNodeArray3;
        int n = xNodeArray.length;
        XNode[] xNodeArray4 = new XNode[n + xNodeArray2.length];
        System.arraycopy(xNodeArray, 0, xNodeArray4, 0, n);
        int n2 = n;
        int n3 = 0;
        while (n3 < xNodeArray2.length) {
            xNodeArray3 = xNodeArray2[n3];
            boolean bl = false;
            int n4 = 0;
            while (n4 < n) {
                if (xNodeArray3.equals(xNodeArray4[n4])) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                xNodeArray4[n2++] = xNodeArray3;
            }
            ++n3;
        }
        if (n2 != xNodeArray4.length) {
            xNodeArray3 = new XNode[n2];
            System.arraycopy(xNodeArray4, 0, xNodeArray3, 0, n2);
            xNodeArray4 = xNodeArray3;
        }
        return xNodeArray4;
    }

    public boolean match(XNode xNode) {
        int n = 0;
        while (n < this.paths.length) {
            if (this.paths[n].match(xNode)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

