/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doctype;

import com.xmlmind.xmledit.doc.AttributeDefaultValue;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.PreserveSpaceDefaultValue;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.IdEntry;
import com.xmlmind.xmledit.doctype.IdRefItem;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.ElementXPointer;
import com.xmlmind.xmledit.xmlutil.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class DocumentTypeUtil {
    private static ArrayList fieldList = new ArrayList();
    private static Structure structure = new Structure();
    private static final String[] NO_IDS = new String[0];
    private static final Element[] NO_ID_REFS = new Element[0];

    public static DocumentType getDocumentType(Element element) {
        Document document = element.getDocument();
        if (document == null) {
            return null;
        }
        return DocumentTypeUtil.getDocumentType(document);
    }

    public static DocumentType getDocumentType(Document document) {
        return (DocumentType)document.getProperty("DOCUMENT_TYPE");
    }

    public static boolean isConstrainedDocumentType(DocumentType documentType) {
        return documentType != null && !(documentType instanceof UnconstrainedDocumentType);
    }

    public static boolean isNamespaceAware(Document document) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(document);
        return documentType == null || !documentType.isDTD();
    }

    public static boolean isNamespaceAware(Element element) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        return documentType == null || !documentType.isDTD();
    }

    public static String getElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (documentType == null) {
            return element.getAttribute(name, attributeDefaultValue);
        }
        return documentType.getElementAttribute(element, name, attributeDefaultValue);
    }

    public static String lookupElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (documentType == null) {
            return element.lookupAttribute(name, attributeDefaultValue);
        }
        return documentType.lookupElementAttribute(element, name, attributeDefaultValue);
    }

    public static String getElementSpaceAttribute(Element element) {
        return DocumentTypeUtil.getElementAttribute(element, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
    }

    public static boolean hasPreserveSpace(Element element) {
        String string = DocumentTypeUtil.lookupElementAttribute(element, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
        if (string == null) {
            return false;
        }
        return string.trim().equals("preserve");
    }

    public static ElementType getElementType(Element element) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (documentType == null) {
            return null;
        }
        return documentType.getElementType(element);
    }

    public static AttributeType getAttributeType(Element element, Name name) {
        return DocumentTypeUtil.getAttributeType(element, name, null);
    }

    public static AttributeType getAttributeType(Element element, Name name, boolean[] blArray) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        elementType.getAttributeFields(name, fieldList);
        switch (fieldList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return DocumentTypeUtil.attributeType(elementType, (Field)fieldList.get(0), name, blArray);
            }
        }
        if (!elementType.getStructure(element, false, structure)) {
            return null;
        }
        int n = DocumentTypeUtil.structure.attributeFieldCount;
        Name[] nameArray = DocumentTypeUtil.structure.attributeNames;
        Field[] fieldArray = DocumentTypeUtil.structure.attributeFields;
        int n2 = 0;
        while (n2 < n) {
            if (nameArray[n2].equals(name)) {
                return DocumentTypeUtil.attributeType(elementType, fieldArray[n2], name, blArray);
            }
            ++n2;
        }
        Field[] fieldArray2 = new Field[n + 1];
        if (n > 0) {
            System.arraycopy(fieldArray, 0, fieldArray2, 0, n);
        }
        int n3 = fieldList.size();
        int n4 = 0;
        while (n4 < n3) {
            Field field;
            fieldArray2[n] = field = (Field)fieldList.get(n4);
            if (elementType.checkAttributeStructure(fieldArray2, n + 1, DocumentTypeUtil.structure.childNodeItems, DocumentTypeUtil.structure.childNodeItemCount)) {
                return DocumentTypeUtil.attributeType(elementType, field, name, blArray);
            }
            ++n4;
        }
        return null;
    }

    private static AttributeType attributeType(ElementType elementType, Field field, Name name, boolean[] blArray) {
        AttributeType attributeType = elementType.getAttributeType(field, name);
        if (blArray != null) {
            blArray[0] = elementType.isRequiredAttribute(field);
        }
        return attributeType;
    }

    public static DataType getDataType(Element element, Name name) {
        DataType dataType = name != null ? DocumentTypeUtil.getAttributeDataType(element, name) : DocumentTypeUtil.getElementDataType(element);
        return dataType;
    }

    public static DataType getElementDataType(Element element) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        return elementType.getElementDataType();
    }

    public static DataType getAttributeDataType(Element element, Name name) {
        AttributeType attributeType = DocumentTypeUtil.getAttributeType(element, name);
        if (attributeType == null) {
            return null;
        }
        return attributeType.getAttributeDataType();
    }

    public static String getDefaultValue(Element element, Name name) {
        String string = name != null ? DocumentTypeUtil.getAttributeDefaultValue(element, name) : DocumentTypeUtil.getElementDefaultValue(element);
        return string;
    }

    public static String getElementDefaultValue(Element element) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        if (elementType.getElementContentType() == 1) {
            Data data = (Data)elementType.getElementDefaultValue();
            if (data == null) {
                return null;
            }
            return data.formatData(element);
        }
        return (String)elementType.getElementDefaultValue();
    }

    public static String getAttributeDefaultValue(Element element, Name name) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        Data data = elementType.getAttributeDefaultValue(name);
        if (data == null) {
            return null;
        }
        return data.formatData(element);
    }

    public static Element findElement(Document document, ElementXPointer elementXPointer) {
        return DocumentTypeUtil.findElement(document, elementXPointer, DocumentTypeUtil.getDocumentType(document));
    }

    public static Element findElement(Document document, ElementXPointer elementXPointer, DocumentType documentType) {
        int n;
        Element element;
        String string = elementXPointer.getId();
        if (string != null && !DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            return null;
        }
        int[] nArray = elementXPointer.getDescendant();
        if (string == null) {
            if (nArray.length == 0 || nArray[0] != 1) {
                return null;
            }
            element = document.getRootElement();
            n = 1;
        } else {
            element = documentType.findElementById(document.getRootElement(), string, true);
            if (element == null) {
                return null;
            }
            n = 0;
        }
        int n2 = n;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if ((element = element.getChildElement(n3 - 1)) == null) {
                return null;
            }
            ++n2;
        }
        return element;
    }

    public static String[] getIds(Document document) {
        return DocumentTypeUtil.getIds(document.getRootElement());
    }

    public static String[] getIds(Element element) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            return NO_IDS;
        }
        return DocumentTypeUtil.getIds(element, documentType);
    }

    public static String[] getIds(Document document, DocumentType documentType) {
        return DocumentTypeUtil.getIds(document.getRootElement(), documentType);
    }

    public static String[] getIds(Element element, DocumentType documentType) {
        HashMap hashMap = new HashMap();
        documentType.collectIds(element, hashMap);
        String[] stringArray = new String[hashMap.size()];
        int n = 0;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            IdEntry idEntry = (IdEntry)iterator.next();
            stringArray[n++] = idEntry.id;
        }
        return stringArray;
    }

    public static Element[] getIdRefs(Document document, String string) {
        return DocumentTypeUtil.getIdRefs(document.getRootElement(), string);
    }

    public static Element[] getIdRefs(Element element, String string) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            return NO_ID_REFS;
        }
        return DocumentTypeUtil.getIdRefs(element, string, documentType);
    }

    public static Element[] getIdRefs(Document document, String string, DocumentType documentType) {
        return DocumentTypeUtil.getIdRefs(document.getRootElement(), string, documentType);
    }

    public static Element[] getIdRefs(Element element, String string, DocumentType documentType) {
        Element[] elementArray;
        ArrayList arrayList = new ArrayList();
        documentType.collectIdRefs(element, arrayList);
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            elementArray = (IdRefItem)arrayList.get(n2);
            if (StringUtil.contains(elementArray.idRefs, string)) {
                arrayList2.add(elementArray.element);
            }
            ++n2;
        }
        elementArray = new Element[arrayList2.size()];
        arrayList2.toArray(elementArray);
        return elementArray;
    }
}

