/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doctype;

import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Msg;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public abstract class DocumentationGeneratorBase
implements NamespaceToPrefixes {
    public static final String INDEX_PAGE_NAME = "index.html";
    public static final String NAMESPACES_PAGE_NAME = "namespaces.html";
    public static final byte TOP_NAVIGATION_BAR = 1;
    public static final byte BOTTOM_NAVIGATION_BAR = 2;
    public static final byte BOTH_NAVIGATION_BARS = 3;
    protected String css = null;
    protected boolean addContentMeta = true;
    protected String charset = null;
    protected PreferredPrefix userPreferredPrefix = null;
    protected PreferredPrefix preferredPrefix = new PreferredPrefix();
    protected byte navigationBars = (byte)3;
    protected static final String indexPageTitle = Msg.msg("DG.indexPageTitle");
    protected static final String namespacesPageTitle = Msg.msg("DG.namespacesPageTitle");
    protected static final String namespacePrefixLabel = Msg.msg("DG.namespacePrefix");
    protected static final String namespaceURILabel = Msg.msg("DG.namespaceURI");
    protected static final String defaultNamespaceLabel = Msg.msg("DG.defaultNamespace");

    public void setCSS(String string) {
        this.css = string;
    }

    public String getCSS() {
        return this.css;
    }

    public void setContentMetaAdded(boolean bl) {
        this.addContentMeta = bl;
    }

    public boolean isContentMetaAdded() {
        return this.addContentMeta;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setPreferredPrefix(PreferredPrefix preferredPrefix) {
        this.userPreferredPrefix = preferredPrefix;
    }

    public PreferredPrefix getPreferredPrefix() {
        return this.userPreferredPrefix;
    }

    public void setNavigationBars(int n) {
        this.navigationBars = (byte)n;
    }

    public int getNavigationBars() {
        return this.navigationBars;
    }

    public abstract DocumentType getDocumentType();

    public abstract void generateAll(File var1) throws IOException;

    public abstract void generateIndexPage(PageInfo var1);

    public abstract void generateNamespacesPage(PageInfo var1);

    public abstract ElementType getElementType(String var1);

    public abstract boolean generateElementPage(ElementType var1, PageInfo var2);

    protected void generateNamespacesPage(PrefixEntry[] prefixEntryArray, PageInfo pageInfo) {
        PreferredPrefix preferredPrefix = this.userPreferredPrefix == null ? this.preferredPrefix : this.userPreferredPrefix;
        Namespace namespace = preferredPrefix.getDefaultNamespace();
        Object[] objectArray = preferredPrefix.getAll();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPageStart(stringBuffer);
        stringBuffer.append("<title>");
        String string = namespacesPageTitle;
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</title>\n");
        this.appendPageMiddle(true, false, stringBuffer);
        stringBuffer.append("<h1>");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</h1>\n");
        stringBuffer.append("<table border='1'>\n");
        stringBuffer.append("<tr><th>");
        XMLUtil.escapeXML(namespacePrefixLabel, stringBuffer);
        stringBuffer.append("</th><th>");
        XMLUtil.escapeXML(namespaceURILabel, stringBuffer);
        stringBuffer.append("</th></tr>\n");
        if (namespace != null) {
            stringBuffer.append("<tr><td>&#160;</td><td><b>");
            XMLUtil.escapeXML(namespace.toString(), stringBuffer);
            stringBuffer.append("</b> (");
            XMLUtil.escapeXML(defaultNamespaceLabel, stringBuffer);
            stringBuffer.append(")</td></tr>\n");
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            stringBuffer.append("<tr><td>");
            XMLUtil.escapeXML(((PrefixEntry)object).prefix, stringBuffer);
            stringBuffer.append("</td><td>");
            XMLUtil.escapeXML(((PrefixEntry)object).namespace.toString(), stringBuffer);
            stringBuffer.append("</td></tr>\n");
            ++n;
        }
        if (prefixEntryArray != null) {
            int n2 = 0;
            while (n2 < prefixEntryArray.length) {
                PrefixEntry prefixEntry = prefixEntryArray[n2];
                String string2 = preferredPrefix.get(prefixEntry.namespace);
                if (string2 == null || !prefixEntry.prefix.equals(string2)) {
                    stringBuffer.append("<tr><td>");
                    XMLUtil.escapeXML(prefixEntry.prefix, stringBuffer);
                    stringBuffer.append("</td><td>");
                    XMLUtil.escapeXML(prefixEntry.namespace.toString(), stringBuffer);
                    stringBuffer.append("</td></tr>\n");
                }
                ++n2;
            }
        }
        stringBuffer.append("</table>\n");
        this.appendPageEnd(true, false, stringBuffer);
        pageInfo.html = stringBuffer.toString();
        pageInfo.name = NAMESPACES_PAGE_NAME;
        pageInfo.title = string;
    }

    protected void appendPageStart(StringBuffer stringBuffer) {
        stringBuffer.append("<html>\n<head>\n");
        if (this.addContentMeta) {
            stringBuffer.append("<meta http-equiv='Content-Type'");
            stringBuffer.append(" content='text/html; charset=");
            stringBuffer.append(this.charset == null ? FileUtil.defaultEncoding() : this.charset);
            stringBuffer.append("'>\n");
        }
        if (this.css != null) {
            stringBuffer.append("<link href='");
            stringBuffer.append(this.css);
            stringBuffer.append("' rel='stylesheet' type='text/css'>\n");
        }
    }

    protected void appendPageMiddle(boolean bl, boolean bl2, StringBuffer stringBuffer) {
        stringBuffer.append("</head>\n<body>\n");
        this.appendNavigationBar(bl, bl2, false, stringBuffer);
    }

    protected void appendPageEnd(boolean bl, boolean bl2, StringBuffer stringBuffer) {
        this.appendNavigationBar(bl, bl2, true, stringBuffer);
        stringBuffer.append("</body>\n</html>\n");
    }

    protected void appendNavigationBar(boolean bl, boolean bl2, boolean bl3, StringBuffer stringBuffer) {
        if (bl3 && (this.navigationBars & 2) == 0 || !bl3 && (this.navigationBars & 1) == 0) {
            return;
        }
        if (bl2 && this.getDocumentType().isDTD()) {
            bl2 = false;
        }
        if (bl || bl2) {
            if (bl3) {
                stringBuffer.append("<p></p>\n");
                stringBuffer.append("<hr>\n");
            }
            stringBuffer.append("<table border='0' cellpadding='0' cellspacing='0'>\n");
            stringBuffer.append("<tr>\n");
        }
        if (bl) {
            stringBuffer.append("<td><small>");
            stringBuffer.append("<a href='index.html'>");
            XMLUtil.escapeXML(indexPageTitle, stringBuffer);
            stringBuffer.append("</a>");
            stringBuffer.append("</small></td>\n");
        }
        if (bl && bl2) {
            stringBuffer.append("<td><small>&#160;&#160;&#160;&#160;</small></td>\n");
        }
        if (bl2) {
            stringBuffer.append("<td><small>");
            stringBuffer.append("<a href='namespaces.html'>");
            XMLUtil.escapeXML(namespacesPageTitle, stringBuffer);
            stringBuffer.append("</a>");
            stringBuffer.append("</small></td>\n");
        }
        if (bl || bl2) {
            stringBuffer.append("</tr>\n");
            stringBuffer.append("</table>\n");
            if (!bl3) {
                stringBuffer.append("<hr>\n");
                stringBuffer.append("<p></p>\n");
            }
        }
    }

    public String[] namespaceToPrefixes(Namespace namespace) {
        if (this.userPreferredPrefix == null) {
            Namespace[] namespaceArray;
            if (this.preferredPrefix.size() == 0 && (namespaceArray = this.getTargetNamespaces()) != null) {
                Namespace[] namespaceArray2 = new Namespace[]{Namespace.NONE, Namespace.XML};
                int n = 0;
                block0: while (n < namespaceArray.length) {
                    Namespace namespace2 = namespaceArray[n];
                    int n2 = 0;
                    while (n2 < namespaceArray2.length) {
                        if (namespace2 != namespaceArray2[n2]) {
                            this.preferredPrefix.add(namespace2, "ns");
                            this.preferredPrefix.setDefaultNamespace(namespace2);
                            break block0;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            if (this.preferredPrefix.get(namespace) == null) {
                this.preferredPrefix.add(namespace, "ns");
            }
            return this.preferredPrefix.namespaceToPrefixes(namespace);
        }
        return this.userPreferredPrefix.namespaceToPrefixes(namespace);
    }

    protected abstract Namespace[] getTargetNamespaces();

    public static final class PageInfo {
        public String html;
        public String name;
        public String title;
    }
}

