/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.sax.ReaderInputStream;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;

public final class ClipboardFormat {
    public static final Namespace CLIPBOARD_NAMESPACE = Namespace.get("http://www.xmlmind.com/xmleditor/namespace/clipboard");
    public static final Name ENVELOPE_NAME = Name.get(CLIPBOARD_NAMESPACE, "clipboard");
    private DocumentWriter documentWriter = null;
    private DocumentLoader documentLoader = null;

    public String formatNodes(Node[] nodeArray, int n, PrefixEntry[] prefixEntryArray) {
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (nodeArray[n2].getNodeType() != 0) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            if (n == 1) {
                return ((Text)nodeArray[0]).getText();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(((Text)nodeArray[n3]).getText());
                ++n3;
            }
            return stringBuffer.toString();
        }
        Element element = new Element(ENVELOPE_NAME);
        int n4 = 0;
        while (n4 < n) {
            element.appendChild(nodeArray[n4].copy());
            ++n4;
        }
        Document document = new Document();
        document.appendChild(element);
        DocumentWriter documentWriter = this.getDocumentWriter(prefixEntryArray);
        StringWriter stringWriter = new StringWriter();
        try {
            documentWriter.writeXMLDeclaration(null, null, stringWriter);
            stringWriter.write(10);
            documentWriter.writeDocument(document, stringWriter);
            stringWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return stringWriter.toString();
    }

    private DocumentWriter getDocumentWriter(PrefixEntry[] prefixEntryArray) {
        if (this.documentWriter == null) {
            this.documentWriter = new DocumentWriter();
        }
        this.documentWriter.setPreferredPrefixes(prefixEntryArray);
        return this.documentWriter;
    }

    public Node[] parseNodes(String string) {
        if (!string.startsWith("<?xml ")) {
            return null;
        }
        ReaderInputStream readerInputStream = new ReaderInputStream((Reader)new StringReader(string));
        URL uRL = FileUtil.fileToURL("string");
        OpenEntity openEntity = new OpenEntity((InputStream)readerInputStream, uRL.toExternalForm(), uRL, "UTF-16");
        return this.parseNodes(openEntity);
    }

    public Node[] parseNodes(File file) throws IOException {
        return this.parseNodes(FileUtil.fileToURL(file));
    }

    public Node[] parseNodes(URL uRL) throws IOException {
        return this.parseNodes(new OpenEntity(uRL.openStream(), uRL.toExternalForm(), uRL));
    }

    private Node[] parseNodes(OpenEntity openEntity) {
        Document document;
        DocumentLoader documentLoader = this.getDocumentLoader();
        try {
            document = documentLoader.load(openEntity);
        }
        catch (IOException iOException) {
            document = null;
        }
        if (document == null) {
            return null;
        }
        return this.convertToNodes(document);
    }

    public Node[] convertToNodes(Document document) {
        Node node;
        Node[] nodeArray;
        int n;
        PreferredPrefix preferredPrefix = (PreferredPrefix)document.getProperty("NAMESPACE_PREFIX_MAP");
        PrefixEntry[] prefixEntryArray = null;
        if (preferredPrefix != null) {
            preferredPrefix.remove(CLIPBOARD_NAMESPACE);
            prefixEntryArray = preferredPrefix.getAll();
            if (prefixEntryArray.length == 0) {
                prefixEntryArray = null;
            }
        }
        Element element = document.getRootElement();
        document.removeChild(element);
        if (element.getName() == ENVELOPE_NAME) {
            n = element.getChildCount();
            if (n == 0) {
                return null;
            }
            nodeArray = new Node[n];
            n = 0;
            node = element.getFirstChild();
            while (node != null) {
                Node node2 = node.getNextSibling();
                element.removeChild(node);
                nodeArray[n++] = node;
                node = node2;
            }
        } else {
            nodeArray = new Node[]{element};
        }
        if (prefixEntryArray != null) {
            n = 0;
            while (n < nodeArray.length) {
                node = nodeArray[n];
                if (node instanceof Element) {
                    ((Element)node).putProperty("DECLARED_PREFIXES", prefixEntryArray);
                }
                ++n;
            }
        }
        return nodeArray;
    }

    private DocumentLoader getDocumentLoader() {
        if (this.documentLoader == null) {
            this.documentLoader = new DocumentLoader();
            this.documentLoader.setAddedProperties(16);
        }
        return this.documentLoader;
    }
}

