/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.ClipboardFormat;
import com.xmlmind.xmledit.edit.Trimmer;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;

public final class ClipboardSupport {
    private DocumentType documentType;
    public static final Node[] PLAIN_TEXT = new Node[]{new Text("#text")};
    private ClipboardFormat clipboardFormat = null;
    private String pastableString = null;
    private Node[] pastableNodes = null;
    private Trimmer trimmer = null;

    public ClipboardSupport(DocumentType documentType) {
        if (documentType == null) {
            documentType = UnconstrainedDocumentType.INSTANCE;
        }
        this.documentType = documentType;
    }

    public String formatNodes(Node[] nodeArray, int n, PrefixEntry[] prefixEntryArray) {
        if (this.clipboardFormat == null) {
            this.clipboardFormat = new ClipboardFormat();
        }
        return this.clipboardFormat.formatNodes(nodeArray, n, prefixEntryArray);
    }

    public Node[] parseNodes(String string) {
        if (this.clipboardFormat == null) {
            this.clipboardFormat = new ClipboardFormat();
        }
        return this.clipboardFormat.parseNodes(string);
    }

    public Node[] getPastableNodes(String string) {
        if (string != this.pastableString && !string.equals(this.pastableString)) {
            this.pastableNodes = this.parseNodes(string);
            if (this.pastableNodes == null) {
                this.pastableNodes = PLAIN_TEXT;
            }
            this.pastableString = string;
        }
        return this.pastableNodes;
    }

    public Node[] copyPastableNodes(String string) {
        Node[] nodeArray = this.getPastableNodes(string);
        if (nodeArray != PLAIN_TEXT) {
            Node[] nodeArray2 = new Node[nodeArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                nodeArray2[n] = nodeArray[n].copy();
                ++n;
            }
            nodeArray = nodeArray2;
        }
        return nodeArray;
    }

    public void trimPastedNodes(Node[] nodeArray) {
        if (this.trimmer == null && !(this.documentType instanceof UnconstrainedDocumentType)) {
            this.trimmer = new Trimmer(this.documentType);
        }
        if (this.trimmer == null) {
            return;
        }
        int n = 0;
        while (n < nodeArray.length) {
            Node node = nodeArray[n];
            if (node instanceof Element && node.getDocument() != null) {
                this.trimmer.trim((Element)node);
            }
            ++n;
        }
    }
}

