/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.edit.CommandEntry;
import com.xmlmind.xmledit.edit.CommandHistoryEvent;
import com.xmlmind.xmledit.edit.CommandHistoryListener;
import com.xmlmind.xmledit.gadget.Command;

public class CommandHistory {
    public static final int DEFAULT_SIZE = 20;
    private CommandEntry[] entries = new CommandEntry[20];
    private int entryCount = 0;
    private long nextSerialNumber = 0L;
    private boolean readOnly = false;
    private CommandHistoryListener[] commandHistoryListeners = null;
    private CommandHistoryEvent commandHistoryEvent = new CommandHistoryEvent(this, null);
    private static final CommandHistoryListener[] NO_COMMAND_HISTORY_LISTENERS = new CommandHistoryListener[0];

    public void addCommandHistoryListener(CommandHistoryListener commandHistoryListener) {
        if (this.commandHistoryListeners == null) {
            this.commandHistoryListeners = new CommandHistoryListener[]{commandHistoryListener};
            return;
        }
        if (this.indexOfCommandHistoryListener(commandHistoryListener) >= 0) {
            return;
        }
        CommandHistoryListener[] commandHistoryListenerArray = new CommandHistoryListener[this.commandHistoryListeners.length + 1];
        System.arraycopy(this.commandHistoryListeners, 0, commandHistoryListenerArray, 0, this.commandHistoryListeners.length);
        commandHistoryListenerArray[this.commandHistoryListeners.length] = commandHistoryListener;
        this.commandHistoryListeners = commandHistoryListenerArray;
    }

    private int indexOfCommandHistoryListener(CommandHistoryListener commandHistoryListener) {
        int n = this.commandHistoryListeners.length - 1;
        while (n >= 0) {
            if (this.commandHistoryListeners[n] == commandHistoryListener) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void removeCommandHistoryListener(CommandHistoryListener commandHistoryListener) {
        int n;
        int n2;
        int n3;
        if (this.commandHistoryListeners == null || (n3 = this.indexOfCommandHistoryListener(commandHistoryListener)) < 0) {
            return;
        }
        if (this.commandHistoryListeners.length == 1) {
            this.commandHistoryListeners = null;
            return;
        }
        CommandHistoryListener[] commandHistoryListenerArray = new CommandHistoryListener[this.commandHistoryListeners.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.commandHistoryListeners, 0, commandHistoryListenerArray, 0, n3);
        }
        if ((n2 = this.commandHistoryListeners.length - (n = n3 + 1)) > 0) {
            System.arraycopy(this.commandHistoryListeners, n, commandHistoryListenerArray, n3, n2);
        }
        this.commandHistoryListeners = commandHistoryListenerArray;
    }

    public CommandHistoryListener[] getCommandHistoryListeners() {
        if (this.commandHistoryListeners == null) {
            return NO_COMMAND_HISTORY_LISTENERS;
        }
        return this.commandHistoryListeners;
    }

    private void notifyCommandHistoryListeners(CommandEntry commandEntry) {
        CommandHistoryListener[] commandHistoryListenerArray = this.commandHistoryListeners;
        if (commandHistoryListenerArray == null) {
            return;
        }
        this.commandHistoryEvent.entry = commandEntry;
        int n = commandHistoryListenerArray.length - 1;
        while (n >= 0) {
            commandHistoryListenerArray[n].commandAdded(this.commandHistoryEvent);
            --n;
        }
    }

    public void setHistorySize(int n) {
        if (n <= 0) {
            n = 1;
        }
        CommandEntry[] commandEntryArray = new CommandEntry[n];
        if (this.entryCount > 0) {
            int n2;
            if (this.entryCount > n) {
                n2 = this.entryCount - n;
                this.entryCount = n;
            } else {
                n2 = 0;
            }
            System.arraycopy(this.entries, n2, commandEntryArray, 0, this.entryCount);
        }
        this.entries = commandEntryArray;
    }

    public int getHistorySize() {
        return this.entries.length;
    }

    public int getCommandCount() {
        return this.entryCount;
    }

    public CommandEntry getCommand(int n) {
        if (n < 0 || n >= this.entryCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.entries[n];
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getNextSerialNumber() {
        return this.nextSerialNumber;
    }

    public boolean addCommand(Command command, String string, String string2) {
        if (this.readOnly) {
            return false;
        }
        CommandEntry commandEntry = new CommandEntry(command, string, string2, this.nextSerialNumber++);
        if (this.nextSerialNumber == Long.MAX_VALUE) {
            this.nextSerialNumber = 0L;
        }
        this.removeEntry(commandEntry);
        if (this.entryCount == this.entries.length) {
            --this.entryCount;
            System.arraycopy(this.entries, 1, this.entries, 0, this.entryCount);
        }
        this.entries[this.entryCount++] = commandEntry;
        this.notifyCommandHistoryListeners(commandEntry);
        return true;
    }

    private void removeEntry(CommandEntry commandEntry) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.entryCount) {
            CommandEntry commandEntry2 = this.entries[n2];
            if (commandEntry.equals(commandEntry2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            return;
        }
        int n3 = n + 1;
        int n4 = this.entryCount - n3;
        if (n4 > 0) {
            System.arraycopy(this.entries, n3, this.entries, n, n4);
        }
        --this.entryCount;
    }

    public boolean clearCommands() {
        if (this.readOnly) {
            return false;
        }
        this.entryCount = 0;
        return true;
    }
}

