/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import java.awt.Container;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Commands {
    private static HashMap nameToEntry = new HashMap();
    private static IdentityHashMap commandToEntry = new IdentityHashMap();
    private static Gadget emptyDocumentView = null;
    static /* synthetic */ Class class$java$awt$Container;

    public static void register(String string, String string2) {
        Commands.register(string, string2, null, true);
    }

    public static void register(String string, Command command) {
        Commands.register(string, null, command, true);
    }

    public static void register(String string, String string2, Command command, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        if (string2 == null && command == null) {
            throw new IllegalArgumentException("className and command cannot both be null");
        }
        Entry entry = new Entry(string, string2, command, bl);
        Entry entry2 = nameToEntry.put(entry.name, entry);
        if (entry2 != null && entry2.command != null) {
            commandToEntry.remove(entry2.command);
        }
        if (entry.command != null) {
            commandToEntry.put(entry.command, entry);
        }
    }

    public static Command getCommand(String string) {
        Entry entry;
        block3: {
            entry = (Entry)nameToEntry.get(string);
            if (entry == null) {
                return null;
            }
            if (entry.command != null) break block3;
            try {
                Class<?> clazz = Class.forName(entry.className);
                entry.command = (Command)clazz.newInstance();
                commandToEntry.put(entry.command, entry);
            }
            catch (Exception exception) {
                nameToEntry.remove(string);
            }
        }
        return entry.command;
    }

    public static boolean isRegistered(String string) {
        return nameToEntry.containsKey(string);
    }

    public static boolean isFinal(String string) {
        Entry entry = (Entry)nameToEntry.get(string);
        return entry != null && entry.isFinal;
    }

    public static void resetAllCommands() {
        Object object;
        Object object2;
        Class<?> clazz;
        if (emptyDocumentView == null) {
            try {
                clazz = Class.forName("com.xmlmind.xmledit.view.DocumentPane");
                object2 = (Container)clazz.newInstance();
                clazz = Class.forName("com.xmlmind.xmledit.view.DocumentView");
                object = clazz.getConstructor(class$java$awt$Container == null ? (class$java$awt$Container = Commands.class$("java.awt.Container")) : class$java$awt$Container);
                emptyDocumentView = (Gadget)((Constructor)object).newInstance(object2);
            }
            catch (Exception exception) {
                System.err.println("Commands.resetAllCommands: cannot create empty DocumentView:");
                System.err.println("---------------------------------------");
                exception.printStackTrace();
                System.err.println("---------------------------------------");
            }
            if (emptyDocumentView == null) {
                return;
            }
        }
        clazz = nameToEntry.entrySet().iterator();
        while (clazz.hasNext()) {
            object2 = (Map.Entry)clazz.next();
            object = (Entry)object2.getValue();
            if (((Entry)object).command == null) continue;
            try {
                boolean bl = ((Entry)object).command.prepareCommand(emptyDocumentView, null, -1, -1);
                if (!bl) continue;
                throw new RuntimeException("command '" + ((Entry)object).name + "' should not be ready to be executed" + " when passed an empty DocumentView");
            }
            catch (Exception exception) {
                System.err.println("Commands.resetAllCommands: cannot ``reset'' command '" + ((Entry)object).name + "':");
                System.err.println("-----------------------------------");
                exception.printStackTrace();
                System.err.println("-----------------------------------");
            }
        }
    }

    public static String getName(Command command) {
        Entry entry = (Entry)commandToEntry.get(command);
        return entry == null ? null : entry.name;
    }

    public static String getLabel(Command command) {
        String string = Commands.getName(command);
        if (string == null) {
            Iterator iterator = nameToEntry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Entry entry2 = (Entry)entry.getValue();
                if (entry2.command == null || !entry2.command.getClass().isInstance(command)) continue;
                string = entry2.name;
                break;
            }
            if (string == null) {
                string = command.getClass().getName();
            }
        }
        return string;
    }

    public static String[] getAllNames() {
        Set set = nameToEntry.keySet();
        Object[] objectArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectArray[n++] = (String)iterator.next();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static String[][] getDescriptions(Binding[] bindingArray) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((String[])object)[0];
                String string2 = ((String[])object2)[0];
                return string.compareTo(string2);
            }
        };
        String[][] stringArray = new String[bindingArray.length][];
        int n = 0;
        int n2 = 0;
        while (n2 < bindingArray.length) {
            Binding binding = bindingArray[n2];
            if (binding.isMouseBinding()) {
                stringArray[n++] = Commands.getDescription(binding);
            }
            ++n2;
        }
        if (n > 1) {
            Arrays.sort(stringArray, 0, n, comparator);
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < bindingArray.length) {
            Binding binding = bindingArray[n4];
            if (binding.isKeyBinding()) {
                stringArray[n3++] = Commands.getDescription(binding);
            }
            ++n4;
        }
        if (n3 - n > 1) {
            Arrays.sort(stringArray, n, n3, comparator);
        }
        n = n3;
        int n5 = 0;
        while (n5 < bindingArray.length) {
            Binding binding = bindingArray[n5];
            if (binding.isAppEventBinding()) {
                stringArray[n3++] = Commands.getDescription(binding);
            }
            ++n5;
        }
        if (n3 - n > 1) {
            Arrays.sort(stringArray, n, n3, comparator);
        }
        return stringArray;
    }

    public static String[] getDescription(Binding binding) {
        String string;
        String[] stringArray = new String[3];
        stringArray[0] = binding.triggerToString();
        Command command = binding.getCommand();
        if (command != null) {
            stringArray[1] = Commands.getName(command);
            if (stringArray[1] == null) {
                stringArray[1] = Msg.msg("C.unknown");
            }
        } else {
            stringArray[1] = Msg.msg("C.menu");
        }
        stringArray[2] = (string = binding.getParameter()) == null ? "" : string;
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Entry {
        public String name;
        public String className;
        public Command command;
        public boolean isFinal;

        public Entry(String string, String string2, Command command, boolean bl) {
            this.name = string;
            this.className = string2;
            this.command = command;
            this.isFinal = bl;
        }
    }
}

