/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SerializedSchemas;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class DocumentTypeCache {
    public static final int ID_TYPE_DTD = 1;
    public static final int ID_TYPE_WXS = 3;
    public static final int ID_TYPE_RNG = 5;
    public static final int CHECK_LOCAL_SOURCES = 1;
    public static final int CHECK_REMOTE_SOURCES = 2;
    private OpenedDocuments openedDocuments;
    private SerializedSchemas serializedSchemas;
    private boolean checkLocalSources;
    private boolean checkRemoteSources;
    private HashMap entries;
    private static final Document[] NO_DOCUMENTS = new Document[0];
    private static final boolean trace = false;

    public static Id dtd(String string) {
        return new Id(1, string);
    }

    public static Id wxs(String string) {
        return new Id(3, string);
    }

    public static Id wxs(String[] stringArray) {
        return new Id(3, stringArray);
    }

    public static Id rng(String string) {
        return new Id(5, string);
    }

    public DocumentTypeCache(OpenedDocuments openedDocuments, File file) throws IOException {
        this(openedDocuments, file == null ? null : new SerializedSchemas(file));
    }

    public DocumentTypeCache(OpenedDocuments openedDocuments, SerializedSchemas serializedSchemas) {
        this.openedDocuments = openedDocuments;
        this.serializedSchemas = serializedSchemas;
        this.checkLocalSources = true;
        this.checkRemoteSources = false;
        this.entries = new HashMap();
    }

    public SerializedSchemas getSerializedSchemas() {
        return this.serializedSchemas;
    }

    public void setCheckSources(int n) {
        this.checkLocalSources = (n & 1) != 0;
        boolean bl = this.checkRemoteSources = (n & 2) != 0;
        if (this.serializedSchemas != null) {
            this.serializedSchemas.setCheckSources(n);
        }
    }

    public int getCheckSources() {
        int n = 0;
        if (this.checkLocalSources) {
            n |= 1;
        }
        if (this.checkRemoteSources) {
            n |= 2;
        }
        return n;
    }

    public Entry put(Id id, DocumentType documentType, String string) throws IOException {
        return this.put(id, documentType, string, null);
    }

    public Entry put(Id id, DocumentType documentType, String string, Console console) throws IOException {
        this.remove(id);
        this.sweep(null);
        DocumentTypeCache.trace("caching " + id);
        Entry entry = null;
        if (this.serializedSchemas != null && id.type != 5 && id.ids.length == 1) {
            if (console != null) {
                console.showMessage(Msg.msg("DTC.serializing", id), 0);
            }
            SerializedSchemas.Entry entry2 = this.serializedSchemas.save(id.ids[0], (Schema)documentType, string);
            entry = new Entry(id, documentType, string, entry2.getSerializationDate(), entry2.getLocalSources(), entry2.getRemoteSources());
        } else {
            Serializable[] serializableArray;
            Serializable[] serializableArray2;
            URL[] uRLArray = documentType.getSourceURLs();
            if (uRLArray == null || uRLArray.length == 0) {
                serializableArray2 = new File[]{};
                serializableArray = new URL[]{};
            } else {
                Serializable[] serializableArray3;
                serializableArray2 = new File[uRLArray.length];
                int n = 0;
                serializableArray = new URL[uRLArray.length];
                int n2 = 0;
                int n3 = 0;
                while (n3 < uRLArray.length) {
                    serializableArray3 = uRLArray[n3];
                    File file = FileUtil.urlToFile((URL)serializableArray3);
                    if (file != null) {
                        serializableArray2[n++] = file;
                    } else {
                        serializableArray[n2++] = serializableArray3;
                    }
                    ++n3;
                }
                if (n != serializableArray2.length) {
                    serializableArray3 = new File[n];
                    System.arraycopy(serializableArray2, 0, serializableArray3, 0, n);
                    serializableArray2 = serializableArray3;
                }
                if (n2 != serializableArray.length) {
                    serializableArray3 = new URL[n2];
                    System.arraycopy(serializableArray, 0, serializableArray3, 0, n2);
                    serializableArray = serializableArray3;
                }
            }
            entry = new Entry(id, documentType, string, System.currentTimeMillis(), (File[])serializableArray2, (URL[])serializableArray);
        }
        if (console != null) {
            console.showMessage(Msg.msg("DTC.caching", id), 0);
        }
        this.entries.put(id, entry);
        return entry;
    }

    private void sweep(DocumentType documentType) {
        Document[] documentArray = this.openedDocuments == null ? NO_DOCUMENTS : this.openedDocuments.getOpenedDocuments();
        Iterator iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Entry entry2 = (Entry)entry.getValue();
            if (entry2.docType == documentType || DocumentTypeCache.findDocType(documentArray, entry2.docType)) continue;
            DocumentTypeCache.trace("uncaching " + entry2.id);
            iterator.remove();
        }
    }

    private static final boolean findDocType(Document[] documentArray, DocumentType documentType) {
        int n = 0;
        while (n < documentArray.length) {
            DocumentType documentType2 = (DocumentType)documentArray[n].getProperty("DOCUMENT_TYPE");
            if (documentType == documentType2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Entry remove(Id id) throws IOException {
        Entry entry = (Entry)this.entries.remove(id);
        if (entry != null && this.serializedSchemas != null && id.type != 5 && id.ids.length == 1) {
            this.serializedSchemas.delete(id.ids[0]);
        }
        return entry;
    }

    public void clear() throws IOException {
        this.entries.clear();
        if (this.serializedSchemas != null) {
            this.serializedSchemas.deleteAll();
        }
    }

    public Entry get(Id id) throws IOException, ClassNotFoundException {
        return this.get(id, null);
    }

    public Entry get(Id id, Console console) throws IOException, ClassNotFoundException {
        Entry entry = (Entry)this.entries.get(id);
        if (entry == null) {
            SerializedSchemas.Entry entry2;
            if (this.serializedSchemas != null && id.type != 5 && id.ids.length == 1 && (entry2 = this.serializedSchemas.get(id.ids[0])) != null) {
                if (console != null) {
                    console.showMessage(Msg.msg("DTC.deserializing", id), 0);
                }
                Schema schema = entry2.loadSchema();
                String string = null;
                File file = entry2.getGeneralEntitiesFile();
                if (file != null) {
                    string = FileUtil.loadString(file, "UTF-8");
                }
                entry = new Entry(id, schema, string, entry2.getSerializationDate(), entry2.getLocalSources(), entry2.getRemoteSources());
                this.entries.put(id, entry);
                DocumentTypeCache.trace("caching deserialized " + id);
            }
        } else {
            int n;
            Serializable[] serializableArray;
            long l;
            boolean bl = true;
            if (this.checkLocalSources) {
                l = entry.cachingDate;
                serializableArray = entry.localSources;
                n = 0;
                while (n < serializableArray.length) {
                    Serializable serializable = serializableArray[n];
                    if (!((File)serializable).isFile() || ((File)serializable).lastModified() >= l) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (bl && this.checkRemoteSources) {
                l = entry.cachingDate;
                serializableArray = entry.remoteSources;
                n = 0;
                while (n < serializableArray.length) {
                    if (DocumentTypeCache.lastModified((URL)serializableArray[n]) >= l) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                DocumentTypeCache.trace(id + " is obsolete, removing it");
                entry = null;
                try {
                    this.remove(id);
                }
                catch (IOException iOException) {}
            } else {
                DocumentTypeCache.trace(id + " is up to date");
            }
        }
        if (entry != null) {
            this.sweep(entry.docType);
            DocumentTypeCache.trace("found " + id);
            if (console != null) {
                console.showMessage(Msg.msg("DTC.fetching", id), 0);
            }
        } else {
            DocumentTypeCache.trace(id + " not found");
        }
        return entry;
    }

    private static final long lastModified(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            uRLConnection.connect();
            long l = uRLConnection.getLastModified();
            return l <= 0L ? Long.MAX_VALUE : l;
        }
        catch (IOException iOException) {
            return Long.MAX_VALUE;
        }
    }

    private static final void trace(String string) {
    }

    public static final class Entry {
        private Id id;
        private DocumentType docType;
        private String entities;
        private long cachingDate;
        private File[] localSources;
        private URL[] remoteSources;

        private Entry(Id id, DocumentType documentType, String string, long l, File[] fileArray, URL[] uRLArray) {
            this.id = id;
            this.docType = documentType;
            this.entities = string;
            this.cachingDate = l;
            this.localSources = fileArray;
            this.remoteSources = uRLArray;
        }

        public Id getId() {
            return this.id;
        }

        public DocumentType getDocumentType() {
            return this.docType;
        }

        public String getGeneralEntities() {
            return this.entities;
        }

        public long getCachingDate() {
            return this.cachingDate;
        }

        public File[] getLocalSources() {
            return this.localSources;
        }

        public URL[] getRemoteSources() {
            return this.remoteSources;
        }
    }

    public static final class Id {
        private int type;
        private String[] ids;

        public Id(int n, String string) {
            this(n, new String[]{string});
        }

        public Id(int n, String[] stringArray) throws IllegalArgumentException {
            this.type = n;
            this.ids = stringArray;
            switch (n) {
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid type");
                }
            }
            if (stringArray == null || stringArray.length == 0) {
                throw new IllegalArgumentException("null or empty ids");
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] == null || (this.ids[n2] = stringArray[n2].trim()).length() == 0) {
                    throw new IllegalArgumentException("null or empty id");
                }
                ++n2;
            }
        }

        public int getType() {
            return this.type;
        }

        public String[] getIds() {
            return this.ids;
        }

        public int hashCode() {
            int n = this.type;
            int n2 = 0;
            while (n2 < this.ids.length) {
                n ^= this.ids[n2].hashCode();
                ++n2;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Id)) {
                return false;
            }
            Id id = (Id)object;
            if (this.type != id.type) {
                return false;
            }
            if (this.ids.length != id.ids.length) {
                return false;
            }
            int n = 0;
            while (n < this.ids.length) {
                String string = this.ids[n];
                boolean bl = false;
                int n2 = 0;
                while (n2 < id.ids.length) {
                    if (id.ids[n2].equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.type) {
                case 1: {
                    stringBuffer.append("DTD '");
                    break;
                }
                case 3: {
                    stringBuffer.append("W3C XML Schema '");
                    break;
                }
                case 5: {
                    stringBuffer.append("RELAX NG Schema '");
                }
            }
            int n = 0;
            while (n < this.ids.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.ids[n]);
                ++n;
            }
            stringBuffer.append('\'');
            return stringBuffer.toString();
        }
    }

    public static interface OpenedDocuments {
        public Document[] getOpenedDocuments();
    }
}

