/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.edit.ApplyChangesEvent;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.CommitChangesEvent;
import com.xmlmind.xmledit.edit.Formatter;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.PendingChangesEvent;
import com.xmlmind.xmledit.edit.PrefixesChangedEvent;
import com.xmlmind.xmledit.edit.SaveOptions;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class DocumentUtil {
    public static final int DEFAULT_CREATE_INSTANCE_OPTIONS = 29;
    static /* synthetic */ Class class$com$xmlmind$xmledit$edit$DocumentUtil;

    public static Document documentFromTemplate(Document document) {
        return DocumentUtil.documentFromTemplate(document, 29);
    }

    public static Document documentFromTemplate(Document document, int n) {
        Element element;
        ElementType elementType;
        Document document2 = (Document)document.copy();
        boolean bl = document2.removeProperty("LOCATION_INFO") != null;
        boolean bl2 = document2.removeProperty("MARK_MANAGER") != null;
        boolean bl3 = document2.removeProperty("UNDO_MANAGER") != null;
        CommandHistory commandHistory = (CommandHistory)document2.removeProperty("COMMAND_HISTORY");
        boolean bl4 = commandHistory != null;
        document2.removeProperty("INCLUSION_STATUS");
        DocumentType documentType = (DocumentType)document2.getProperty("DOCUMENT_TYPE");
        if (documentType == null) {
            documentType = UnconstrainedDocumentType.INSTANCE;
        }
        if ((elementType = documentType.getElementType(element = document.getRootElement())) == null) {
            elementType = UnconstrainedElementType.INSTANCE;
        }
        Element element2 = elementType.createInstance(element.getName(), n);
        Node node = document2.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                document2.replaceChild(node, element2);
                break;
            }
            node = node.getNextSibling();
        }
        if (bl) {
            document2.putLocationInfo(FileUtil.fileToURL("untitled.xml").toExternalForm(), false);
        }
        if (bl2) {
            document2.putProperty("MARK_MANAGER", new MarkManager(document2));
        }
        if (bl3) {
            document2.putProperty("UNDO_MANAGER", new UndoManager(document2));
        }
        if (bl4) {
            document2.putProperty("COMMAND_HISTORY", new CommandHistory());
        }
        return document2;
    }

    public static void pendingChanges(Document document) {
        if (document != null) {
            document.notifyDocumentListeners(new PendingChangesEvent((Object)(class$com$xmlmind$xmledit$edit$DocumentUtil == null ? (class$com$xmlmind$xmledit$edit$DocumentUtil = DocumentUtil.class$("com.xmlmind.xmledit.edit.DocumentUtil")) : class$com$xmlmind$xmledit$edit$DocumentUtil), document));
        }
    }

    public static void commitChanges(Document document) {
        if (document != null) {
            document.beginBatchEditing();
            document.notifyDocumentListeners(new CommitChangesEvent((Object)(class$com$xmlmind$xmledit$edit$DocumentUtil == null ? (class$com$xmlmind$xmledit$edit$DocumentUtil = DocumentUtil.class$("com.xmlmind.xmledit.edit.DocumentUtil")) : class$com$xmlmind$xmledit$edit$DocumentUtil), document));
            document.notifyDocumentListeners(new ApplyChangesEvent((Object)(class$com$xmlmind$xmledit$edit$DocumentUtil == null ? (class$com$xmlmind$xmledit$edit$DocumentUtil = DocumentUtil.class$("com.xmlmind.xmledit.edit.DocumentUtil")) : class$com$xmlmind$xmledit$edit$DocumentUtil), document));
            document.endBatchEditing();
        }
    }

    public static void prefixesChanged(Document document) {
        if (document != null) {
            document.notifyDocumentListeners(new PrefixesChangedEvent((Object)(class$com$xmlmind$xmledit$edit$DocumentUtil == null ? (class$com$xmlmind$xmledit$edit$DocumentUtil = DocumentUtil.class$("com.xmlmind.xmledit.edit.DocumentUtil")) : class$com$xmlmind$xmledit$edit$DocumentUtil), document));
        }
    }

    public static void saveDocument(Document document, File file) throws IOException, UnsupportedEncodingException {
        SaveOptions saveOptions = new SaveOptions();
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            saveOptions.indent = -1;
        }
        DocumentUtil.saveDocument(document, file, saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocument(Document document, File file, SaveOptions saveOptions) throws IOException, UnsupportedEncodingException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            DocumentUtil.saveDocument(document, fileOutputStream, saveOptions);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public static void saveDocument(Document document, OutputStream outputStream, SaveOptions saveOptions) throws IOException, UnsupportedEncodingException {
        DocumentWriter documentWriter = saveOptions.indent < 0 ? new DocumentWriter() : new Formatter((DocumentType)document.getProperty("DOCUMENT_TYPE"));
        int n = 0;
        if (saveOptions.preserveEntityRefs) {
            n |= 1;
        }
        if (saveOptions.preserveXIncludes) {
            n |= 2;
        }
        documentWriter.setPreserveInclusions(n);
        documentWriter.setEncoding(saveOptions.xmlEncoding);
        if (saveOptions.usePreferredPrefixes) {
            documentWriter.setPreferredPrefixes(document.getPreferredPrefixes(saveOptions.useDefaultNamespace));
        }
        documentWriter.setSaveCharsAsEntityRefs(saveOptions.saveCharsAsEntityRefs);
        documentWriter.setCharsSavedAsEntityRefs(saveOptions.charsSavedAsEntityRefs);
        documentWriter.setCdataSectionElements(saveOptions.cdataSectionElements);
        documentWriter.setIgnoredProcessingInstructions(saveOptions.ignoredProcessingInstructions);
        if (saveOptions.indent >= 0) {
            Formatter formatter = (Formatter)documentWriter;
            formatter.setFavorInteroperability(saveOptions.favorInteroperability);
            formatter.setIndent(saveOptions.indent);
            formatter.setMaxLineLength(saveOptions.maxLineLength);
            formatter.setAddingOpenLines(saveOptions.addOpenLines);
        }
        documentWriter.writeDocument(document, outputStream);
    }

    public static void describeUndo(Document document, String string) {
        UndoManager.Action action;
        UndoManager undoManager = (UndoManager)document.getProperty("UNDO_MANAGER");
        if (undoManager != null && (action = undoManager.getTopUndoAction()) != null && action.getDescription() == null) {
            action.setDescription(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

