/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Path;
import com.xmlmind.xmledit.doc.Step;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.edit.ClipboardSupport;
import com.xmlmind.xmledit.edit.ElementTemplate;
import com.xmlmind.xmledit.edit.ElementTemplates;
import com.xmlmind.xmledit.edit.Trimmer;
import com.xmlmind.xmledit.xmlutil.Name;

public abstract class Editor {
    public static final int NO = 0;
    public static final int YES = 1;
    public static final int YES_INCLUDING_TEXT = 2;
    protected DocumentType documentType;
    protected ClipboardSupport clipboardSupport;
    protected Trimmer trimmer;
    protected int createInstanceOptions = 29;
    private static Structure notUsed = new Structure();

    protected Editor(DocumentType documentType) {
        this.setDocumentType(documentType);
    }

    public void setDocumentType(DocumentType documentType) {
        if (documentType == null) {
            documentType = UnconstrainedDocumentType.INSTANCE;
        }
        this.documentType = documentType;
        this.clipboardSupport = new ClipboardSupport(documentType);
        this.trimmer = new Trimmer(documentType);
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setCreateInstanceOptions(int n) {
        this.createInstanceOptions = n;
    }

    public int getCreateInstanceOptions() {
        return this.createInstanceOptions;
    }

    public Node[] getPastableNodes(String string) {
        Node[] nodeArray = this.clipboardSupport.getPastableNodes(string);
        if (nodeArray == ClipboardSupport.PLAIN_TEXT) {
            return null;
        }
        return nodeArray;
    }

    protected Element createInstance(Element element, ElementType elementType, Field field, ElementTemplate elementTemplate) {
        ElementType elementType2 = elementType.getChildElementType(field, elementTemplate.getElementName());
        if (elementType2 == null) {
            elementType2 = UnconstrainedElementType.INSTANCE;
        }
        return this.copyTemplate(elementTemplate, elementType2, element, Editor.getElementTemplates(element));
    }

    private Element copyTemplate(ElementTemplate elementTemplate, ElementType elementType, Element element, ElementTemplates elementTemplates) {
        Element element2 = elementTemplate.copyElement(elementTemplates);
        this.trimmer.trim(element2, elementType, element);
        return element2;
    }

    private static final ElementTemplates getElementTemplates(Element element) {
        return (ElementTemplates)element.getDocument().getProperty("ELEMENT_TEMPLATES");
    }

    protected Element createInstance(Element element, ElementType elementType, Field field, Name name) {
        ElementType elementType2 = elementType.getChildElementType(field, name);
        if (elementType2 == null) {
            elementType2 = UnconstrainedElementType.INSTANCE;
        }
        return this.createInstance(element, elementType2, name);
    }

    protected Element createInstance(Element element, ElementType elementType, Name name) {
        ElementTemplates elementTemplates = Editor.getElementTemplates(element);
        if (elementTemplates == null) {
            return elementType.createInstance(name, this.createInstanceOptions);
        }
        ElementTemplate elementTemplate = Editor.getOverride(elementType, name, element, element, elementTemplates);
        if (elementTemplate != null) {
            return this.copyTemplate(elementTemplate, elementType, element, elementTemplates);
        }
        Element element2 = elementType.createInstance(name, this.createInstanceOptions);
        this.processInstance(element2, elementType, element, elementTemplates);
        return element2;
    }

    private static final ElementTemplate getOverride(ElementType elementType, Name name, Element element, Element element2, ElementTemplates elementTemplates) {
        ElementTemplate[] elementTemplateArray = elementTemplates.getOverride(name);
        if (elementTemplateArray == null) {
            return null;
        }
        int n = 0;
        while (n < elementTemplateArray.length) {
            ElementTemplate elementTemplate = elementTemplateArray[n];
            XPath xPath = elementTemplate.getParentXPath();
            if (xPath == null || Editor.match(xPath, element, element2)) {
                Element element3 = elementTemplate.getElement(elementTemplates);
                if (!(elementType instanceof UnconstrainedElementType) && elementType.getStructure(element3, true, notUsed)) {
                    return elementTemplate;
                }
            }
            ++n;
        }
        return null;
    }

    private void processInstance(Element element, ElementType elementType, Element element2, ElementTemplates elementTemplates) {
        if (Editor.processInstance1(element, elementType, element2, elementTemplates)) {
            this.trimmer.trim(element, elementType, element2);
        }
    }

    private static final boolean processInstance1(Element element, ElementType elementType, Element element2, ElementTemplates elementTemplates) {
        Structure structure = new Structure();
        if (!elementType.getStructure(element, true, structure)) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node instanceof Element) {
                boolean bl2;
                Element element3 = (Element)node;
                ElementType elementType2 = elementType.getChildElementType((Field)structure.childNodeItems[n], element3.getName());
                if (elementType2 == null) {
                    elementType2 = UnconstrainedElementType.INSTANCE;
                }
                if (bl2 = Editor.processInstance2(element3, elementType2, element, element2, elementTemplates)) {
                    bl = true;
                }
            }
            node = node2;
            ++n;
        }
        return bl;
    }

    private static final boolean processInstance2(Element element, ElementType elementType, Element element2, Element element3, ElementTemplates elementTemplates) {
        ElementTemplate elementTemplate = Editor.getOverride(elementType, element.getName(), element2, element3, elementTemplates);
        if (elementTemplate != null) {
            Element element4 = elementTemplate.copyElement(elementTemplates);
            element2.replaceChild(element, element4);
            return true;
        }
        return Editor.processInstance1(element, elementType, element3, elementTemplates);
    }

    private static final boolean match(XPath xPath, Element element, Element element2) {
        if (element == element2) {
            return xPath.match(element);
        }
        Path[] pathArray = xPath.getPaths();
        int n = 0;
        while (n < pathArray.length) {
            if (Editor.match(pathArray[n], element, element2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean match(Path path, Element element, Element element2) {
        Step[] stepArray = path.getSteps();
        return Editor.match(stepArray, stepArray.length, path.isAbsolute(), element, element2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean match(Step[] stepArray, int n, boolean bl, Node node, Element element) {
        int n2 = n - 1;
        while (n2 >= 0) {
            Step step = stepArray[n2];
            switch (step.getAxis()) {
                case 0: {
                    if (node == null) return false;
                    if (Editor.match(step, node)) break;
                    return false;
                }
                case 1: {
                    if (node == null) return false;
                    if (!Editor.match(step, node)) {
                        return false;
                    }
                    while (true) {
                        if (node == null || Editor.match(stepArray, n2, bl, node, element)) {
                            if (node == null) return false;
                            return true;
                        }
                        if ((node = node.getParent()) != null || element == null) continue;
                        node = element;
                        element = null;
                    }
                }
                case 2: {
                    if (node == null) return false;
                    if (!Editor.match(step, node)) {
                        return false;
                    }
                    if ((node = node.getParent()) != null || element == null) break;
                    node = element;
                    element = null;
                    break;
                }
                case 3: {
                    return false;
                }
                default: {
                    throw new RuntimeException("unknown Step axis " + step.getAxis());
                }
            }
            --n2;
        }
        if (!bl) return true;
        if (node == null) return false;
        if (node instanceof Document) return true;
        return false;
    }

    private static final boolean match(Step step, Node node) {
        switch (step.getTest()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (node instanceof Element) {
                    if (((Element)node).getName() == step.getTestedName()) break;
                    return false;
                }
                return false;
            }
            case 3: {
                if (node instanceof Element) {
                    if (((Element)node).getNamespace() == step.getTestedNamespace()) break;
                    return false;
                }
                return false;
            }
            default: {
                throw new RuntimeException("unknown Step test " + step.getTest());
            }
        }
        return true;
    }
}

