/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataFormatException;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.Item;
import com.xmlmind.xmledit.doctype.NameClass;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.doctype.TextItem;
import com.xmlmind.xmledit.doctype.UncheckedElementType;
import com.xmlmind.xmledit.doctype.UncheckedUnparsedEntities;
import com.xmlmind.xmledit.doctype.UnconstrainedAttributeType;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.edit.ClipboardSupport;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.Editor;
import com.xmlmind.xmledit.edit.ElementTemplate;
import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.edit.StructureInfo;
import com.xmlmind.xmledit.edit.TextTransferEvent;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.util.ArrayList;
import java.util.Enumeration;

public final class ElementEditor
extends Editor {
    private Element editedElement;
    private boolean canEditElement;
    private StructureInfo editedElementStructureInfo;
    private Attribute[] editedElementAttributes;
    private int editedElementAttributeCount;
    private Node[] editedElementNodes;
    private int editedElementNodeCount;
    private Structure structure = new Structure();
    private Attribute[] editedElementAttributeList = new Attribute[0];
    private Node[] editedElementNodeList = new Node[0];
    private Field[] fieldList = new Field[0];
    private Node[] nodes1 = new Node[1];
    private Node[] nodeList = new Node[0];
    private Item[] itemList = new Item[0];
    private Attribute[] attributeList = new Attribute[0];
    private TextTransferEvent textTransferEvent = new TextTransferEvent();
    private static final TextItem[] textItems1 = new TextItem[]{TextItem.INSTANCE};
    private static final Node[] nodes0 = new Node[0];
    private static final Text textSample = new Text("#text");
    private static final Attribute[] attributes0 = new Attribute[0];

    public ElementEditor() {
        this(null, null);
    }

    public ElementEditor(DocumentType documentType) {
        this(documentType, null);
    }

    public ElementEditor(DocumentType documentType, Element element) {
        super(documentType);
        this.setEditedElement(element);
    }

    public void setDocumentType(DocumentType documentType) {
        super.setDocumentType(documentType);
        this.resetEditedElement();
    }

    public void editElement(Element element) {
        if (element != this.editedElement) {
            this.setEditedElement(element);
        }
    }

    public void setEditedElement(Element element) {
        if (this.editedElement != null) {
            this.editedElement = null;
            this.canEditElement = false;
            this.editedElementStructureInfo = null;
            this.editedElementAttributes = null;
            this.editedElementAttributeCount = 0;
            this.editedElementNodes = null;
            this.editedElementNodeCount = 0;
            this.structure = new Structure();
            int n = this.editedElementAttributeList.length;
            int n2 = 0;
            while (n2 < n) {
                this.editedElementAttributeList[n2] = null;
                ++n2;
            }
            n = this.editedElementNodeList.length;
            int n3 = 0;
            while (n3 < n) {
                this.editedElementNodeList[n3] = null;
                ++n3;
            }
            n = this.fieldList.length;
            int n4 = 0;
            while (n4 < n) {
                this.fieldList[n4] = null;
                ++n4;
            }
            this.nodes1[0] = null;
            n = this.nodeList.length;
            int n5 = 0;
            while (n5 < n) {
                this.nodeList[n5] = null;
                ++n5;
            }
            n = this.itemList.length;
            int n6 = 0;
            while (n6 < n) {
                this.itemList[n6] = null;
                ++n6;
            }
        }
        if (element != null) {
            this.editedElement = element;
            this.canEditElement = element.isEditable();
        }
    }

    public void resetEditedElement() {
        Element element = this.editedElement;
        if (element != null) {
            this.setEditedElement(element);
        }
    }

    public Element getEditedElement() {
        return this.editedElement;
    }

    public boolean canEditElement() {
        return this.canEditElement;
    }

    public StructureInfo getEditedElementStructureInfo() {
        if (this.editedElementStructureInfo == null && this.editedElement != null) {
            ElementType elementType = this.documentType.getElementType(this.editedElement);
            if (elementType == null) {
                elementType = UnconstrainedElementType.INSTANCE;
            }
            if (!elementType.getStructure(this.editedElement, false, this.structure)) {
                elementType = new UncheckedElementType(elementType);
                elementType.getStructure(this.editedElement, false, this.structure);
            }
            this.editedElementStructureInfo = new StructureInfo(this.structure.copy(), elementType);
        }
        return this.editedElementStructureInfo;
    }

    public ElementType getEditedElementType() {
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        return structureInfo == null ? null : structureInfo.elementType;
    }

    public Name[] getEditedAttributeNames() {
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        return structureInfo == null ? null : structureInfo.structure.attributeNames;
    }

    public Field[] getEditedAttributeFields() {
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        return structureInfo == null ? null : structureInfo.structure.attributeFields;
    }

    public Field getEditedAttributeField(Name name) {
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        if (structureInfo != null) {
            Name[] nameArray = structureInfo.structure.attributeNames;
            int n = 0;
            while (n < nameArray.length) {
                if (name == nameArray[n]) {
                    return structureInfo.structure.attributeFields[n];
                }
                ++n;
            }
        }
        return null;
    }

    public AttributeType getAttributeType(Field field, Name name) {
        ElementType elementType = this.getEditedElementType();
        if (elementType == null) {
            return null;
        }
        AttributeType attributeType = elementType.getAttributeType(field, name);
        if (attributeType == null) {
            attributeType = UnconstrainedAttributeType.INSTANCE;
        }
        return attributeType;
    }

    public String checkAttributeValue(Field field, Name name, String string) {
        AttributeType attributeType = this.getAttributeType(field, name);
        if (attributeType instanceof UnconstrainedAttributeType) {
            return null;
        }
        return this.checkAttributeValue(attributeType, string);
    }

    public String checkAttributeValue(AttributeType attributeType, String string) {
        DataType dataType = attributeType.getAttributeDataType();
        Data data = null;
        try {
            data = dataType.parseData(string, this.editedElement, UncheckedUnparsedEntities.INSTANCE);
        }
        catch (DataFormatException dataFormatException) {
            return MiscUtil.reason(dataFormatException);
        }
        Data data2 = attributeType.getAttributeFixedValue();
        if (data2 != null && !data2.equals(data)) {
            return Msg.msg("EE.attributeValueDifferentFromFixedValue", data.formatData(this.editedElement), data2.formatData(this.editedElement));
        }
        return null;
    }

    public boolean hasAttribute(Name name) {
        return this.editedElement.hasAttribute(name);
    }

    public String getAttribute(Name name) {
        return this.editedElement.getAttribute(name);
    }

    public boolean isAttribute(Name name) {
        ElementType elementType = this.getEditedElementType();
        if (elementType == null) {
            return false;
        }
        Field[] fieldArray = elementType.getAttributeFields();
        int n = 0;
        while (n < fieldArray.length) {
            NameClass nameClass = fieldArray[n].getFieldNameClass();
            if (nameClass != null ? nameClass.containsName(name) : fieldArray[n].getFieldName() == name) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean canPutAttribute(Name name, String string) {
        Field field = this.getEditedAttributeField(name);
        if (field == null) {
            return this.canAddAttribute(name, string);
        }
        return this.canEditElement && this.checkAttributeValue(field, name, string) == null;
    }

    public boolean canAddAttribute(Name name, String string) {
        if (!this.canEditElement) {
            return false;
        }
        ElementType elementType = this.getEditedElementType();
        Attribute[] attributeArray = this.getEditedElementAttributes();
        int n = this.editedElementAttributeCount;
        Node[] nodeArray = this.getEditedElementNodes();
        int n2 = this.editedElementNodeCount;
        Attribute[] attributeArray2 = new Attribute[n + 1];
        attributeArray2[0] = new Attribute(this.editedElement, name, string);
        int n3 = 0;
        while (n3 < n) {
            Attribute attribute = attributeArray[n3];
            if (attribute.name == name) {
                return false;
            }
            attributeArray2[1 + n3] = attribute;
            ++n3;
        }
        if (!elementType.getAttributeStructure(attributeArray2, attributeArray2.length, nodeArray, n2, false, this.structure)) {
            return false;
        }
        int n4 = -1;
        Name[] nameArray = this.structure.attributeNames;
        int n5 = this.structure.attributeFieldCount;
        int n6 = 0;
        while (n6 < n5) {
            if (nameArray[n6] == name) {
                n4 = n6;
                break;
            }
            ++n6;
        }
        Field field = this.structure.attributeFields[n4];
        return this.checkAttributeValue(field, name, string) == null;
    }

    public boolean canAddAttribute(ArrayList arrayList) {
        if (!this.canEditElement) {
            return false;
        }
        arrayList.clear();
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        Name[] nameArray = structureInfo.structure.attributeNames;
        Field[] fieldArray = structureInfo.structure.attributeFields;
        int n = fieldArray.length;
        Item[] itemArray = structureInfo.structure.childNodeItems;
        ElementType elementType = structureInfo.elementType;
        Field[] fieldArray2 = this.getFieldList(n + 1);
        System.arraycopy(fieldArray, 0, fieldArray2, 0, n);
        Field[] fieldArray3 = elementType.getAttributeFields();
        int n2 = 0;
        while (n2 < fieldArray3.length) {
            Field field = fieldArray3[n2];
            Name name = field.getFieldName();
            if (name != null) {
                int n3 = 0;
                while (n3 < n) {
                    if (name == nameArray[n3]) {
                        field = null;
                        break;
                    }
                    ++n3;
                }
            }
            if (field != null) {
                fieldArray2[n] = field;
                if (elementType.checkAttributeStructure(fieldArray2, n + 1, itemArray, itemArray.length)) {
                    arrayList.add(field);
                }
            }
            ++n2;
        }
        return arrayList.size() > 0;
    }

    public boolean canAddAttribute(Name name) {
        if (!this.canEditElement) {
            return false;
        }
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        Name[] nameArray = structureInfo.structure.attributeNames;
        Field[] fieldArray = structureInfo.structure.attributeFields;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nameArray[n2] == name) {
                return false;
            }
            ++n2;
        }
        Item[] itemArray = structureInfo.structure.childNodeItems;
        ElementType elementType = structureInfo.elementType;
        Field[] fieldArray2 = this.getFieldList(n + 1);
        System.arraycopy(fieldArray, 0, fieldArray2, 0, n);
        Field[] fieldArray3 = elementType.getAttributeFields();
        int n3 = 0;
        while (n3 < fieldArray3.length) {
            Field field = fieldArray3[n3];
            Name name2 = field.getFieldName();
            if (name2 != null && name2 == name || name2 == null && field.getFieldNameClass().containsName(name)) {
                fieldArray2[n] = field;
                if (elementType.checkAttributeStructure(fieldArray2, n + 1, itemArray, itemArray.length)) {
                    return true;
                }
            }
            ++n3;
        }
        return false;
    }

    public String putAttribute(Name name, String string) {
        String string2 = this.editedElement.putAttribute(name, string);
        this.resetEditedElement();
        return string2;
    }

    public boolean canRemoveAttribute(Name name) {
        if (!this.canEditElement) {
            return false;
        }
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        Field[] fieldArray = structureInfo.structure.attributeFields;
        if (fieldArray.length == 0) {
            return true;
        }
        ElementType elementType = structureInfo.elementType;
        Name[] nameArray = structureInfo.structure.attributeNames;
        Item[] itemArray = structureInfo.structure.childNodeItems;
        Field[] fieldArray2 = this.getFieldList(fieldArray.length);
        return ElementEditor.canRemoveAttribute(name, elementType, nameArray, fieldArray, itemArray, fieldArray2);
    }

    private static final boolean canRemoveAttribute(Name name, ElementType elementType, Name[] nameArray, Field[] fieldArray, Item[] itemArray, Field[] fieldArray2) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < nameArray.length) {
            if (nameArray[n2] == name) {
                bl = true;
            } else {
                fieldArray2[n++] = fieldArray[n2];
            }
            ++n2;
        }
        if (!bl) {
            return true;
        }
        return elementType.checkAttributeStructure(fieldArray2, n, itemArray, itemArray.length);
    }

    public boolean canRemoveAttribute(ArrayList arrayList) {
        if (!this.canEditElement) {
            return false;
        }
        arrayList.clear();
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        Field[] fieldArray = structureInfo.structure.attributeFields;
        if (fieldArray.length == 0) {
            return false;
        }
        ElementType elementType = structureInfo.elementType;
        Name[] nameArray = structureInfo.structure.attributeNames;
        Item[] itemArray = structureInfo.structure.childNodeItems;
        Field[] fieldArray2 = this.getFieldList(fieldArray.length);
        int n = 0;
        while (n < nameArray.length) {
            Name name = nameArray[n];
            if (ElementEditor.canRemoveAttribute(name, elementType, nameArray, fieldArray, itemArray, fieldArray2)) {
                arrayList.add(name);
            }
            ++n;
        }
        return arrayList.size() > 0;
    }

    public String removeAttribute(Name name) {
        String string = this.editedElement.removeAttribute(name);
        if (string != null) {
            this.resetEditedElement();
        }
        return string;
    }

    public boolean mayContainText() {
        ElementType elementType = this.getEditedElementType();
        return elementType == null ? false : EditUtil.mayContainText(elementType);
    }

    public String getText() {
        ElementType elementType = this.getEditedElementType();
        switch (elementType.getElementContentType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return this.editedElement.getText();
            }
        }
        return null;
    }

    public boolean canSetText(String string) {
        if (!this.canEditElement) {
            return false;
        }
        ElementType elementType = this.getEditedElementType();
        switch (elementType.getElementContentType()) {
            case 1: {
                Data data;
                DataType dataType = elementType.getElementDataType();
                try {
                    data = dataType.parseData(string, this.editedElement, UncheckedUnparsedEntities.INSTANCE);
                }
                catch (DataFormatException dataFormatException) {
                    return false;
                }
                Data data2 = (Data)elementType.getElementFixedValue();
                return data2 == null || data2.equals(data);
            }
            case 3: 
            case 4: 
            case 5: {
                StructureInfo structureInfo = this.getEditedElementStructureInfo();
                Field[] fieldArray = structureInfo.structure.attributeFields;
                if (!elementType.checkElementStructure(fieldArray, fieldArray.length, textItems1, 1)) {
                    return false;
                }
                String string2 = (String)elementType.getElementFixedValue();
                return string2 == null || string2.equals(string);
            }
        }
        return false;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        EditUtil.setText(this.editedElement, string);
        this.resetEditedElement();
    }

    public boolean canDelete(Node node, Node node2) {
        return this.canReplace(node, node2, nodes0, 0);
    }

    public void delete(Node node, Node node2) {
        this.doReplace(node, node2, nodes0, 0);
    }

    public boolean canReplace(Node node, Node node2, Node node3) {
        this.nodes1[0] = node3;
        return this.canReplace(node, node2, this.nodes1, 1);
    }

    public boolean canReplace(Node nodeArray, Node node, Node[] nodeArray2, int n) {
        Node[] nodeArray3;
        if (!this.canEditElement) {
            return false;
        }
        switch (EditUtil.checkRange(this.editedElement, (Node)nodeArray, node)) {
            case 0: {
                return false;
            }
            case 2: {
                nodeArray3 = nodeArray;
                nodeArray = node;
                node = nodeArray3;
            }
        }
        nodeArray3 = this.getNodeList(this.editedElement.getChildCount() + n);
        int n2 = 0;
        Node node2 = this.editedElement.getFirstChild();
        while (node2 != null) {
            if (node2 == nodeArray) {
                int n3 = 0;
                while (n3 < n) {
                    nodeArray3[n2++] = nodeArray2[n3];
                    ++n3;
                }
                node2 = node;
            } else {
                nodeArray3[n2++] = node2;
            }
            node2 = node2.getNextSibling();
        }
        ElementType elementType = this.getEditedElementType();
        Attribute[] attributeArray = this.getEditedElementAttributes();
        int n4 = this.editedElementAttributeCount;
        return elementType.getElementStructure(attributeArray, n4, nodeArray3, n2, false, this.structure);
    }

    public boolean canReplace(Node node, Node node2) {
        return this.canReplace(node, node2, (ArrayList)null) != 0;
    }

    public int canReplace(Node node, Node object, ArrayList arrayList) {
        boolean bl;
        Object object2;
        if (!this.canEditElement) {
            return 0;
        }
        switch (EditUtil.checkRange(this.editedElement, node, (Node)object)) {
            case 0: {
                return 0;
            }
            case 2: {
                object2 = node;
                node = object;
                object = object2;
            }
        }
        object2 = this.getEditedElementStructureInfo();
        Field[] fieldArray = ((StructureInfo)object2).structure.attributeFields;
        Item[] itemArray = ((StructureInfo)object2).structure.childNodeItems;
        ElementType elementType = ((StructureInfo)object2).elementType;
        Item[] itemArray2 = this.getItemList(itemArray.length + 1);
        int n = 0;
        int n2 = -1;
        boolean bl2 = false;
        int n3 = 0;
        Node node2 = this.editedElement.getFirstChild();
        while (node2 != null) {
            if (node2 == node) {
                n2 = n;
                itemArray2[n++] = null;
                bl2 = true;
            }
            if (bl2) {
                ++n3;
            } else {
                itemArray2[n++] = itemArray[n3++];
            }
            if (node2 == object) {
                bl2 = false;
            }
            node2 = node2.getNextSibling();
        }
        Field[] fieldArray2 = elementType.getChildElementFields();
        boolean bl3 = false;
        if (arrayList != null) {
            arrayList.clear();
        }
        int n4 = 0;
        while (n4 < fieldArray2.length) {
            itemArray2[n2] = fieldArray2[n4];
            if (elementType.checkElementStructure(fieldArray, fieldArray.length, itemArray2, n)) {
                bl3 = true;
                if (arrayList == null) break;
                arrayList.add(fieldArray2[n4]);
            }
            ++n4;
        }
        node2 = node.getPreviousSibling();
        boolean bl4 = bl = !(node2 != null && node2.getNodeType() == 0 || (node2 = ((Node)object).getNextSibling()) != null && node2.getNodeType() == 0);
        if (bl) {
            switch (elementType.getElementContentType()) {
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    itemArray2[n2] = TextItem.INSTANCE;
                    bl = elementType.checkElementStructure(fieldArray, fieldArray.length, itemArray2, n);
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl3 || bl ? (bl ? 2 : 1) : 0;
    }

    public Element replace(Node node, Node node2, Field field, Name name) {
        Element element = this.createInstance(this.editedElement, this.getEditedElementType(), field, name);
        this.replace(node, node2, element);
        return element;
    }

    public Element replace(Node node, Node node2, Field field, ElementTemplate elementTemplate) {
        Element element = this.createInstance(this.editedElement, this.getEditedElementType(), field, elementTemplate);
        this.replace(node, node2, element);
        return element;
    }

    public void replace(Node node, Node node2, Node node3) {
        this.nodes1[0] = node3;
        this.doReplace(node, node2, this.nodes1, 1);
    }

    public void replace(Node node, Node node2, Node[] nodeArray, int n) {
        this.doReplace(node, node2, nodeArray, n);
    }

    private Node[] doReplace(Node node, Node node2, Node[] nodeArray, int n) {
        Node node3;
        Node node4;
        switch (EditUtil.checkRange(this.editedElement, node, node2)) {
            case 0: {
                return null;
            }
            case 2: {
                node4 = node;
                node = node2;
                node2 = node4;
            }
        }
        node4 = this.editedElement.getDocument();
        if (node4 != null) {
            ((Document)node4).beginBatchEditing();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node5 = node;
        while (node5 != node2) {
            node3 = node5.getNextSibling();
            this.editedElement.removeChild(node5);
            arrayList.add(node5);
            node5 = node3;
        }
        node3 = node2.getNextSibling();
        this.editedElement.removeChild(node2);
        arrayList.add(node2);
        int n2 = 0;
        while (n2 < n) {
            this.editedElement.insertChild(node3, nodeArray[n2]);
            ++n2;
        }
        ElementType elementType = this.getEditedElementType();
        EditUtil.normalizeText(this.editedElement, elementType);
        if (node4 != null) {
            ((Document)node4).endBatchEditing();
        }
        this.resetEditedElement();
        return arrayList.toArray(nodes0);
    }

    public boolean canInsert(Node node, Node node2) {
        this.nodes1[0] = node2;
        return this.canInsert(node, this.nodes1, 1);
    }

    public boolean canInsert(Node node, Node[] nodeArray, int n) {
        int n2;
        if (!this.canEditElement) {
            return false;
        }
        if (node != null && node.getParent() != this.editedElement) {
            return false;
        }
        Node[] nodeArray2 = this.getNodeList(this.editedElement.getChildCount() + n);
        int n3 = 0;
        Node node2 = this.editedElement.getFirstChild();
        while (node2 != null) {
            if (node2 == node) {
                n2 = 0;
                while (n2 < n) {
                    nodeArray2[n3++] = nodeArray[n2];
                    ++n2;
                }
            }
            nodeArray2[n3++] = node2;
            node2 = node2.getNextSibling();
        }
        if (node == null) {
            n2 = 0;
            while (n2 < n) {
                nodeArray2[n3++] = nodeArray[n2];
                ++n2;
            }
        }
        ElementType elementType = this.getEditedElementType();
        Attribute[] attributeArray = this.getEditedElementAttributes();
        int n4 = this.editedElementAttributeCount;
        return elementType.getElementStructure(attributeArray, n4, nodeArray2, n3, false, this.structure);
    }

    public boolean canInsert(Node node) {
        return this.canInsert(node, (ArrayList)null) != 0;
    }

    public int canInsert(Node node, ArrayList arrayList) {
        boolean bl;
        if (!this.canEditElement) {
            return 0;
        }
        if (node != null && node.getParent() != this.editedElement) {
            return 0;
        }
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        Field[] fieldArray = structureInfo.structure.attributeFields;
        Item[] itemArray = structureInfo.structure.childNodeItems;
        ElementType elementType = structureInfo.elementType;
        Item[] itemArray2 = this.getItemList(itemArray.length + 1);
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        Node node2 = this.editedElement.getFirstChild();
        while (node2 != null) {
            if (node2 == node) {
                n2 = n;
                itemArray2[n++] = null;
            }
            itemArray2[n++] = itemArray[n3++];
            node2 = node2.getNextSibling();
        }
        if (node == null) {
            n2 = n;
            itemArray2[n++] = null;
        }
        Field[] fieldArray2 = elementType.getChildElementFields();
        boolean bl2 = false;
        if (arrayList != null) {
            arrayList.clear();
        }
        int n4 = 0;
        while (n4 < fieldArray2.length) {
            itemArray2[n2] = fieldArray2[n4];
            if (elementType.checkElementStructure(fieldArray, fieldArray.length, itemArray2, n)) {
                bl2 = true;
                if (arrayList == null) break;
                arrayList.add(fieldArray2[n4]);
            }
            ++n4;
        }
        if (node == null) {
            node2 = this.editedElement.getLastChild();
            bl = node2 == null || node2.getNodeType() != 0;
        } else {
            boolean bl3 = bl = node.getNodeType() != 0 && ((node2 = node.getPreviousSibling()) == null || node2.getNodeType() != 0);
        }
        if (bl) {
            switch (elementType.getElementContentType()) {
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    itemArray2[n2] = TextItem.INSTANCE;
                    bl = elementType.checkElementStructure(fieldArray, fieldArray.length, itemArray2, n);
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl2 || bl ? (bl ? 2 : 1) : 0;
    }

    public Element insert(Node node, Field field, Name name) {
        Element element = this.createInstance(this.editedElement, this.getEditedElementType(), field, name);
        this.insert(node, element);
        return element;
    }

    public Element insert(Node node, Field field, ElementTemplate elementTemplate) {
        Element element = this.createInstance(this.editedElement, this.getEditedElementType(), field, elementTemplate);
        this.insert(node, element);
        return element;
    }

    public void insert(Node node, Node node2) {
        this.nodes1[0] = node2;
        this.insert(node, this.nodes1, 1);
    }

    public void insert(Node node, Node[] nodeArray, int n) {
        Object object;
        if (node != null && node.getParent() != this.editedElement) {
            return;
        }
        Document document = this.editedElement.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            object = nodeArray[n2];
            if (((Node)object).getNodeType() == 0) {
                bl = true;
            }
            this.editedElement.insertChild(node, (Node)object);
            ++n2;
        }
        if (bl) {
            object = this.getEditedElementType();
            EditUtil.normalizeText(this.editedElement, (ElementType)object);
        }
        if (document != null) {
            document.endBatchEditing();
        }
        this.resetEditedElement();
    }

    public Node findInsertBefore(Node node, Name name, ArrayList arrayList) {
        while (node != null) {
            Element element = node.getParentElement();
            if (element == null) {
                return null;
            }
            if (this.canInsert(element, node, name, arrayList)) {
                return node;
            }
            node = element;
        }
        return null;
    }

    public Node findInsertAfter(Node node, Name name, ArrayList arrayList) {
        while (node != null) {
            Element element = node.getParentElement();
            if (element == null) {
                return null;
            }
            if (this.canInsert(element, node.getNextSibling(), name, arrayList)) {
                return node;
            }
            node = element;
        }
        return null;
    }

    private boolean canInsert(Element element, Node node, Name name, ArrayList arrayList) {
        int n;
        int n2;
        Field[] fieldArray;
        Item[] itemArray;
        Object object;
        boolean bl;
        Object object2;
        ElementType elementType;
        block33: {
            block34: {
                if (!element.isEditable()) {
                    return false;
                }
                if (node != null && node.getParent() != element) {
                    return false;
                }
                if (element == this.editedElement) {
                    elementType = this.getEditedElementType();
                } else {
                    elementType = this.documentType.getElementType(element);
                    if (elementType == null) {
                        elementType = UnconstrainedElementType.INSTANCE;
                    }
                }
                if (arrayList != null) {
                    arrayList.clear();
                }
                if (name != null) break block33;
                if (node == null) {
                    object2 = element.getLastChild();
                    bl = object2 == null || ((Node)object2).getNodeType() != 0;
                } else {
                    boolean bl2 = bl = node.getNodeType() != 0 && ((object2 = node.getPreviousSibling()) == null || ((Node)object2).getNodeType() != 0);
                }
                if (!bl) break block34;
                switch (elementType.getElementContentType()) {
                    case 1: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                    case 5: {
                        break block33;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        object2 = null;
        if (name != null) {
            object2 = elementType.getChildElementFields();
            bl = false;
            int n3 = 0;
            while (n3 < ((Object)object2).length) {
                Object object3 = object2[n3];
                object = object3.getFieldName();
                if (object == null) {
                    if (object3.getFieldNameClass().containsName(name)) {
                        bl = true;
                        break;
                    }
                } else if (object == name) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
        }
        if (element == this.editedElement) {
            itemArray = this.getEditedElementStructureInfo();
            fieldArray = itemArray.structure.attributeFields;
            n2 = fieldArray.length;
            object = itemArray.structure.childNodeItems;
            n = ((Item[])object).length;
        } else {
            if (!elementType.getStructure(element, false, this.structure)) {
                elementType = new UncheckedElementType(elementType);
                elementType.getStructure(element, false, this.structure);
            }
            fieldArray = this.structure.attributeFields;
            n2 = this.structure.attributeFieldCount;
            object = this.structure.childNodeItems;
            n = this.structure.childNodeItemCount;
        }
        itemArray = this.getItemList(n + 1);
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        Node node2 = element.getFirstChild();
        while (node2 != null) {
            if (node2 == node) {
                n5 = n4;
                itemArray[n4++] = null;
            }
            itemArray[n4++] = object[n6++];
            node2 = node2.getNextSibling();
        }
        if (node == null) {
            n5 = n4;
            itemArray[n4++] = null;
        }
        if (name != null) {
            bl = false;
            int n7 = 0;
            while (n7 < ((Object)object2).length) {
                Object object4 = object2[n7];
                Name name2 = object4.getFieldName();
                if (!(name2 == null ? !object4.getFieldNameClass().containsName(name) : name2 != name)) {
                    itemArray[n5] = object4;
                    if (elementType.checkElementStructure(fieldArray, n2, itemArray, n4)) {
                        bl = true;
                        if (arrayList == null) break;
                        arrayList.add(object4);
                    }
                }
                ++n7;
            }
        } else {
            itemArray[n5] = TextItem.INSTANCE;
            bl = elementType.checkElementStructure(fieldArray, n2, itemArray, n4);
        }
        return bl;
    }

    public boolean canInsert(TextNode textNode, int n) {
        return this.canInsert(textNode, n, (ArrayList)null) != 0;
    }

    public int canInsert(TextNode textNode, int n, ArrayList arrayList) {
        int n2 = textNode.getTextLength();
        if (textNode.getParent() != this.editedElement || n < 0 || n > n2) {
            return 0;
        }
        Node node = n == 0 ? textNode : (n == n2 ? textNode.getNextSibling() : textNode);
        return this.canInsert(node, arrayList);
    }

    public boolean canInsert(TextNode textNode, int n, Node node) {
        this.nodes1[0] = node;
        return this.canInsert(textNode, n, this.nodes1, 1);
    }

    public boolean canInsert(TextNode textNode, int n, Node[] nodeArray, int n2) {
        int n3 = textNode.getTextLength();
        if (textNode.getParent() != this.editedElement || n < 0 || n > n3) {
            return false;
        }
        Node node = n == 0 ? textNode : (n == n3 ? textNode.getNextSibling() : textNode);
        return this.canInsert(node, nodeArray, n2);
    }

    public Element insert(TextNode textNode, int n, Field field, Name name) {
        Element element = this.createInstance(this.editedElement, this.getEditedElementType(), field, name);
        this.insert(textNode, n, element);
        return element;
    }

    public Element insert(TextNode textNode, int n, Field field, ElementTemplate elementTemplate) {
        Element element = this.createInstance(this.editedElement, this.getEditedElementType(), field, elementTemplate);
        this.insert(textNode, n, element);
        return element;
    }

    public void insert(TextNode textNode, int n, Node node) {
        this.nodes1[0] = node;
        this.insert(textNode, n, this.nodes1, 1);
    }

    public void insert(TextNode textNode, int n, Node[] nodeArray, int n2) {
        Object object;
        TextNode textNode2;
        int n3 = textNode.getTextLength();
        if (textNode.getParent() != this.editedElement || n < 0 || n > n3) {
            return;
        }
        if (n == 0) {
            this.insert((Node)textNode, nodeArray, n2);
            return;
        }
        if (n == n3) {
            this.insert(textNode.getNextSibling(), nodeArray, n2);
            return;
        }
        Document document = this.editedElement.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        char[] cArray = textNode.getTextChars();
        switch (textNode.getNodeType()) {
            case 1: {
                textNode2 = new Comment(cArray, n, n3 - n);
                break;
            }
            case 2: {
                textNode2 = new ProcessingInstruction(((ProcessingInstruction)textNode).getTarget(), cArray, n, n3 - n);
                break;
            }
            default: {
                textNode2 = new Text(cArray, n, n3 - n);
            }
        }
        this.editedElement.insertChild(textNode.getNextSibling(), textNode2);
        if (document != null) {
            this.textTransferEvent.initialize(this, textNode, n, textNode2, 0, n3);
            document.notifyDocumentListeners(this.textTransferEvent);
        }
        textNode.deleteText(n, n3 - n);
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            object = nodeArray[n4];
            if (((Node)object).getNodeType() == 0) {
                bl = true;
            }
            this.editedElement.insertChild(textNode2, (Node)object);
            ++n4;
        }
        if (bl) {
            object = this.getEditedElementType();
            EditUtil.normalizeText(this.editedElement, (ElementType)object);
        }
        if (document != null) {
            document.endBatchEditing();
        }
        this.resetEditedElement();
    }

    public boolean canConvertToText(Node node, Node node2) {
        switch (EditUtil.checkRange(this.editedElement, node, node2)) {
            case 0: {
                return false;
            }
            case 2: {
                Node node3 = node;
                node = node2;
                node2 = node3;
            }
        }
        boolean bl = true;
        boolean bl2 = true;
        Node node4 = node;
        block8: while (node4 != null) {
            switch (node4.getNodeType()) {
                case 0: {
                    break;
                }
                case 4: {
                    bl = false;
                    if (ElementEditor.isConvertibleToText((Element)node4)) break;
                    bl2 = false;
                    break block8;
                }
                default: {
                    bl = false;
                }
            }
            if (node4 == node2) break;
            node4 = node4.getNextSibling();
        }
        if (bl || !bl2) {
            return false;
        }
        return this.canReplace(node, node2, textSample);
    }

    private static final boolean isConvertibleToText(Element element) {
        if (element.hasNoChildren()) {
            return false;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && !ElementEditor.isConvertibleToText((Element)node)) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    public Text convertToText(Node node, Node node2) {
        Comparable comparable;
        switch (EditUtil.checkRange(this.editedElement, node, node2)) {
            case 0: {
                return null;
            }
            case 2: {
                comparable = node;
                node = node2;
                node2 = comparable;
            }
        }
        comparable = new StringBuffer();
        Node node3 = node;
        while (node3 != null) {
            ElementEditor.appendNodeText(node3, (StringBuffer)comparable);
            if (node3 == node2) break;
            node3 = node3.getNextSibling();
        }
        Text text = new Text(((StringBuffer)comparable).toString());
        this.replace(node, node2, text);
        return text;
    }

    private static final void appendNodeText(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 0: 
            case 1: 
            case 2: {
                stringBuffer.append(((TextNode)node).getText());
                break;
            }
            case 4: {
                Node node2 = ((Element)node).getFirstChild();
                while (node2 != null) {
                    ElementEditor.appendNodeText(node2, stringBuffer);
                    node2 = node2.getNextSibling();
                }
                break;
            }
        }
    }

    public boolean canConvert(Element element) {
        return this.canConvert(element, null);
    }

    public boolean canConvert(Element element, ArrayList arrayList) {
        if (element.hasNoChildren()) {
            return false;
        }
        return this.canWrap(element, element, element.getChildren(), arrayList);
    }

    public Element convert(Element element, Field field, Name name) {
        return this.wrap(element, element, element.getChildren(), field, name);
    }

    public boolean canWrap(Node node, Node node2) {
        return this.canWrap(node, node2, null);
    }

    public boolean canWrap(Node node, Node node2, ArrayList arrayList) {
        Node[] nodeArray = EditUtil.getRange(this.editedElement, node, node2);
        if (nodeArray == null) {
            return false;
        }
        if (nodeArray[0] != node) {
            Node node3 = node;
            node = node2;
            node2 = node3;
        }
        return this.canWrap(node, node2, nodeArray, arrayList);
    }

    private boolean canWrap(Node node, Node node2, Node[] nodeArray, ArrayList arrayList) {
        if (!this.canEditElement) {
            return false;
        }
        StructureInfo structureInfo = this.getEditedElementStructureInfo();
        Field[] fieldArray = structureInfo.structure.attributeFields;
        Item[] itemArray = structureInfo.structure.childNodeItems;
        ElementType elementType = structureInfo.elementType;
        Item[] itemArray2 = this.getItemList(itemArray.length + 1);
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        Item item = null;
        Node node3 = this.editedElement.getFirstChild();
        while (node3 != null) {
            if (node3 == node) {
                n2 = n;
                itemArray2[n++] = null;
                bl = true;
            }
            if (bl) {
                if (node3 == node && node == node2) {
                    item = itemArray[n3];
                }
                ++n3;
            } else {
                itemArray2[n++] = itemArray[n3++];
            }
            if (node3 == node2) {
                bl = false;
            }
            node3 = node3.getNextSibling();
        }
        Field[] fieldArray2 = elementType.getChildElementFields();
        boolean bl2 = false;
        if (arrayList != null) {
            arrayList.clear();
        }
        int n4 = 0;
        while (n4 < fieldArray2.length) {
            if (fieldArray2[n4] != item && this.checkPossibleField(elementType, fieldArray2[n4], nodeArray)) {
                itemArray2[n2] = fieldArray2[n4];
                if (elementType.checkElementStructure(fieldArray, fieldArray.length, itemArray2, n)) {
                    bl2 = true;
                    if (arrayList == null) break;
                    arrayList.add(fieldArray2[n4]);
                }
            }
            ++n4;
        }
        return bl2;
    }

    private boolean checkPossibleField(ElementType elementType, Field field, Node[] nodeArray) {
        int n;
        Attribute[] attributeArray;
        Name name = field.getFieldName();
        if (name == null) {
            return false;
        }
        ElementType elementType2 = elementType.getChildElementType(field, name);
        if (elementType2 == null) {
            elementType2 = UnconstrainedElementType.INSTANCE;
        }
        if (elementType2.getElementContentType() == 1) {
            return false;
        }
        if (elementType2.canCheckAttributeStructure()) {
            attributeArray = attributes0;
            n = 0;
        } else {
            Field[] fieldArray = elementType2.getAttributeFields();
            attributeArray = this.getAttributeList(fieldArray.length);
            n = 0;
            int n2 = 0;
            while (n2 < fieldArray.length) {
                Name name2;
                Field field2 = fieldArray[n2];
                if (elementType2.isRequiredAttribute(field2) && (name2 = field2.getFieldName()) != null) {
                    Attribute attribute = attributeArray[n++];
                    attribute.element = null;
                    attribute.name = name2;
                    attribute.value = "";
                }
                ++n2;
            }
        }
        return elementType2.getElementStructure(attributeArray, n, nodeArray, nodeArray.length, false, this.structure);
    }

    public Element wrap(Node node, Node node2, Field field, Name name) {
        Node[] nodeArray = EditUtil.getRange(this.editedElement, node, node2);
        if (nodeArray == null) {
            return null;
        }
        if (nodeArray[0] != node) {
            Node node3 = node;
            node = node2;
            node2 = node3;
        }
        return this.wrap(node, node2, nodeArray, field, name);
    }

    private Element wrap(Node node, Node node2, Node[] nodeArray, Field field, Name name) {
        ElementType elementType = this.getEditedElementType().getChildElementType(field, name);
        if (elementType == null) {
            elementType = UnconstrainedElementType.INSTANCE;
        }
        Element element = this.createInstance(this.editedElement, elementType, name);
        element.removeAllChildren();
        int n = 0;
        while (n < nodeArray.length) {
            element.appendChild(nodeArray[n].copy());
            ++n;
        }
        EditUtil.normalizeText(element, elementType);
        this.replace(node, node2, element);
        return element;
    }

    public String copy() {
        this.nodes1[0] = this.editedElement;
        return this.doCopy(this.nodes1, 1);
    }

    public String copy(Node node, Node node2) {
        Node[] nodeArray = EditUtil.getRange(this.editedElement, node, node2);
        if (nodeArray == null) {
            return null;
        }
        return this.doCopy(nodeArray, nodeArray.length);
    }

    private String doCopy(Node[] nodeArray, int n) {
        PrefixEntry[] prefixEntryArray = null;
        Document document = this.editedElement.getDocument();
        if (document != null) {
            prefixEntryArray = document.getPreferredPrefixes(false);
        }
        return this.clipboardSupport.formatNodes(nodeArray, n, prefixEntryArray);
    }

    public boolean canCut(Node node, Node node2) {
        return this.canDelete(node, node2);
    }

    public String cut(Node node, Node node2) {
        Document document = this.editedElement.getDocument();
        Node[] nodeArray = this.doReplace(node, node2, nodes0, 0);
        if (nodeArray == null) {
            return null;
        }
        PrefixEntry[] prefixEntryArray = null;
        if (document != null) {
            prefixEntryArray = document.getPreferredPrefixes(false);
        }
        return this.clipboardSupport.formatNodes(nodeArray, nodeArray.length, prefixEntryArray);
    }

    public boolean canPaste(Node node, Node node2, String string) {
        Node[] nodeArray = this.clipboardSupport.getPastableNodes(string);
        return this.canReplace(node, node2, nodeArray, nodeArray.length);
    }

    public boolean canPaste(Node node, Node node2, Node[] nodeArray) {
        return this.canReplace(node, node2, nodeArray, nodeArray.length);
    }

    public Node[] paste(Node node, Node node2, String string) {
        Node[] nodeArray = this.clipboardSupport.copyPastableNodes(string);
        return this.doPaste(node, node2, string, nodeArray);
    }

    public Node[] paste(Node node, Node node2, Node[] nodeArray) {
        return this.doPaste(node, node2, null, nodeArray);
    }

    private Node[] doPaste(Node node, Node node2, String string, Node[] nodeArray) {
        Node[] nodeArray2 = nodeArray == ClipboardSupport.PLAIN_TEXT ? new Node[]{new Text(XMLUtil.filterText(string))} : nodeArray;
        Element element = this.editedElement;
        Document document = element.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        this.replace(node, node2, nodeArray2, nodeArray2.length);
        if (document != null) {
            this.clipboardSupport.trimPastedNodes(nodeArray);
            if (nodeArray != ClipboardSupport.PLAIN_TEXT) {
                document.addPreferredPrefixes(element, false, true);
            }
            document.endBatchEditing();
        }
        return nodeArray2;
    }

    public boolean canPaste(Node node, String string) {
        Node[] nodeArray = this.clipboardSupport.getPastableNodes(string);
        return this.canInsert(node, nodeArray, nodeArray.length);
    }

    public Node[] paste(Node node, String string) {
        Node[] nodeArray = this.clipboardSupport.copyPastableNodes(string);
        return this.doPaste(node, string, nodeArray);
    }

    public Node[] paste(Node node, Node[] nodeArray) {
        return this.doPaste(node, null, nodeArray);
    }

    private Node[] doPaste(Node node, String string, Node[] nodeArray) {
        Node[] nodeArray2 = nodeArray == ClipboardSupport.PLAIN_TEXT ? new Node[]{new Text(XMLUtil.filterText(string))} : nodeArray;
        Element element = this.editedElement;
        Document document = element.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        this.insert(node, nodeArray2, nodeArray2.length);
        if (document != null) {
            this.clipboardSupport.trimPastedNodes(nodeArray);
            if (nodeArray != ClipboardSupport.PLAIN_TEXT) {
                document.addPreferredPrefixes(element, false, true);
            }
            document.endBatchEditing();
        }
        return nodeArray2;
    }

    public boolean canPaste(TextNode textNode, int n, String string) {
        Node[] nodeArray = this.clipboardSupport.getPastableNodes(string);
        if (nodeArray == ClipboardSupport.PLAIN_TEXT) {
            if (textNode.getParent() != this.editedElement || n < 0 || n > textNode.getTextLength()) {
                return false;
            }
            return this.canEditElement;
        }
        return this.canInsert(textNode, n, nodeArray, nodeArray.length);
    }

    public Node[] paste(TextNode textNode, int n, String string) {
        Node[] nodeArray = this.clipboardSupport.copyPastableNodes(string);
        return this.doPaste(textNode, n, string, nodeArray);
    }

    public Node[] paste(TextNode textNode, int n, Node[] nodeArray) {
        return this.doPaste(textNode, n, null, nodeArray);
    }

    private Node[] doPaste(TextNode textNode, int n, String string, Node[] nodeArray) {
        if (nodeArray == ClipboardSupport.PLAIN_TEXT) {
            if (textNode.getParent() != this.editedElement || n < 0 || n > textNode.getTextLength()) {
                return null;
            }
            string = XMLUtil.filterText(string);
            textNode.insertText(n, string);
            return new Node[]{new Text(string)};
        }
        Element element = this.editedElement;
        Document document = element.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        this.insert(textNode, n, nodeArray, nodeArray.length);
        if (document != null) {
            this.clipboardSupport.trimPastedNodes(nodeArray);
            document.addPreferredPrefixes(element, false, true);
            document.endBatchEditing();
        }
        return nodeArray;
    }

    private Attribute[] getEditedElementAttributes() {
        if (this.editedElementAttributes == null && this.editedElement != null) {
            this.editedElementAttributeCount = this.editedElement.getAttributeCount();
            this.editedElementAttributes = this.getEditedElementAttributeList(this.editedElementAttributeCount);
            int n = 0;
            Enumeration enumeration = this.editedElement.getAttributes();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                this.editedElementAttributes[n++] = attribute.copy();
            }
        }
        return this.editedElementAttributes;
    }

    private Attribute[] getEditedElementAttributeList(int n) {
        if (n > this.editedElementAttributeList.length) {
            this.editedElementAttributeList = new Attribute[Math.max(n, 2 * this.editedElementAttributeList.length)];
        }
        return this.editedElementAttributeList;
    }

    private Node[] getEditedElementNodes() {
        if (this.editedElementNodes == null && this.editedElement != null) {
            this.editedElementNodeCount = this.editedElement.getChildCount();
            this.editedElementNodes = this.getEditedElementNodeList(this.editedElementNodeCount);
            int n = 0;
            Node node = this.editedElement.getFirstChild();
            while (node != null) {
                this.editedElementNodes[n++] = node;
                node = node.getNextSibling();
            }
        }
        return this.editedElementNodes;
    }

    private Node[] getEditedElementNodeList(int n) {
        if (n > this.editedElementNodeList.length) {
            this.editedElementNodeList = new Node[Math.max(n, 2 * this.editedElementNodeList.length)];
        }
        return this.editedElementNodeList;
    }

    private Field[] getFieldList(int n) {
        if (n > this.fieldList.length) {
            this.fieldList = new Field[Math.max(n, 2 * this.fieldList.length)];
        }
        return this.fieldList;
    }

    private Node[] getNodeList(int n) {
        if (n > this.nodeList.length) {
            this.nodeList = new Node[Math.max(n, 2 * this.nodeList.length)];
        }
        return this.nodeList;
    }

    private Item[] getItemList(int n) {
        if (n > this.itemList.length) {
            this.itemList = new Item[Math.max(n, 2 * this.itemList.length)];
        }
        return this.itemList;
    }

    private Attribute[] getAttributeList(int n) {
        if (n > this.attributeList.length) {
            Attribute[] attributeArray = new Attribute[Math.max(n, 2 * this.attributeList.length)];
            System.arraycopy(this.attributeList, 0, attributeArray, 0, this.attributeList.length);
            int n2 = this.attributeList.length;
            while (n2 < attributeArray.length) {
                attributeArray[n2] = new Attribute();
                ++n2;
            }
            this.attributeList = attributeArray;
        }
        return this.attributeList;
    }
}

