/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.ElementTemplate;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public final class ElementTemplates {
    private HashMap templates = new HashMap();
    private ElementTemplate[] templateList;
    private ElementTemplate[] selectableList;
    private IdentityHashMap override = null;
    private ElementTemplateKey probe = new ElementTemplateKey(null, null);
    private static final Name TEMPLATE_ATTRIBUTE = Name.get(Namespace.CONFIGURATION, "template");

    public void put(ElementTemplate elementTemplate) {
        this.templates.put(new ElementTemplateKey(elementTemplate.template.getName(), elementTemplate.title), elementTemplate);
        this.uncompile();
    }

    public void removeAll(String string) {
        Iterator iterator = this.templates.values().iterator();
        while (iterator.hasNext()) {
            ElementTemplate elementTemplate = (ElementTemplate)iterator.next();
            if (!elementTemplate.title.equals(string)) continue;
            iterator.remove();
        }
        this.uncompile();
    }

    public void removeAll() {
        this.templates.clear();
        this.uncompile();
    }

    private void uncompile() {
        this.templateList = null;
        this.selectableList = null;
        this.override = null;
    }

    public ElementTemplate get(Name name, String string) {
        this.probe.name = name;
        this.probe.title = string;
        return (ElementTemplate)this.templates.get(this.probe);
    }

    public ElementTemplate[] getOverride(Name name) {
        if (this.override == null) {
            this.compile();
        }
        return (ElementTemplate[])this.override.get(name);
    }

    public ElementTemplate[] getAll() {
        if (this.templateList == null) {
            this.compile();
        }
        return this.templateList;
    }

    public int size() {
        return this.templates.size();
    }

    public ElementTemplate[] getAllSelectable() {
        if (this.selectableList == null) {
            this.compile();
        }
        return this.selectableList;
    }

    private void compile() {
        this.templateList = new ElementTemplate[this.templates.size()];
        int n = 0;
        ArrayList<ElementTemplate> arrayList = new ArrayList<ElementTemplate>();
        this.override = new IdentityHashMap();
        Iterator iterator = this.templates.values().iterator();
        while (iterator.hasNext()) {
            ElementTemplate elementTemplate = (ElementTemplate)iterator.next();
            this.templateList[n++] = elementTemplate;
            switch (elementTemplate.selectable) {
                case 1: {
                    arrayList.add(elementTemplate);
                    break;
                }
                case 2: {
                    Name name = elementTemplate.template.getName();
                    ElementTemplate[] elementTemplateArray = (ElementTemplate[])this.override.get(name);
                    if (elementTemplateArray == null) {
                        elementTemplateArray = new ElementTemplate[]{elementTemplate};
                    } else {
                        ElementTemplate[] elementTemplateArray2 = new ElementTemplate[elementTemplateArray.length + 1];
                        System.arraycopy(elementTemplateArray, 0, elementTemplateArray2, 0, elementTemplateArray.length);
                        elementTemplateArray2[elementTemplateArray.length] = elementTemplate;
                        elementTemplateArray = elementTemplateArray2;
                    }
                    this.override.put(name, elementTemplateArray);
                }
            }
        }
        this.selectableList = new ElementTemplate[arrayList.size()];
        arrayList.toArray(this.selectableList);
    }

    public Element expandElement(Element element) {
        element = (Element)element.copy();
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node instanceof Element) {
                this.doExpandElement((Element)node);
            }
            node = node2;
        }
        return element;
    }

    private final void doExpandElement(Element node) {
        Node node2;
        Object object;
        String string = node.getAttribute(TEMPLATE_ATTRIBUTE);
        if (string != null) {
            object = this.get(node.getName(), XMLUtil.collapseWhiteSpace(string));
            if (object == null) {
                node.removeAttribute(TEMPLATE_ATTRIBUTE);
            } else {
                node2 = ((ElementTemplate)object).copyElement();
                node.getParent().replaceChild(node, node2);
                node = node2;
            }
        }
        object = node.getFirstChild();
        while (object != null) {
            node2 = ((Node)object).getNextSibling();
            if (object instanceof Element) {
                this.doExpandElement((Element)object);
            }
            object = node2;
        }
    }

    private static final class ElementTemplateKey {
        public Name name;
        public String title;

        public ElementTemplateKey(Name name, String string) {
            this.name = name;
            this.title = string;
        }

        public int hashCode() {
            return System.identityHashCode(this.name) ^ this.title.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null && !(object instanceof ElementTemplateKey)) {
                return false;
            }
            ElementTemplateKey elementTemplateKey = (ElementTemplateKey)object;
            return this.name == elementTemplateKey.name && this.title.equals(elementTemplateKey.title);
        }
    }
}

