/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.Item;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.doctype.UncheckedElementType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.LineWriter;
import com.xmlmind.xmledit.xmlutil.Name;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import java.util.StringTokenizer;

public final class Formatter
extends DocumentWriter {
    private static final int VERTICAL = 0;
    private static final int HORIZONTAL = 1;
    private static final int VERBATIM = 2;
    private static final char SPACE_CHAR = '\u0000';
    public static final int MAX_INDENT = 16;
    public static final int MIN_LINE_LENGTH = 40;
    private DocumentType documentType;
    private boolean guessContentType;
    private int indent = 2;
    private int maxLineLength = 78;
    private boolean addOpenLines = true;
    private boolean favorInteroperability = true;
    private int minLineLength;
    private Stack stateStack = new Stack();
    private Structure structure = new Structure();
    private boolean[] guessed = new boolean[1];

    /*
     * Unable to fully structure code
     */
    private static final int nextOffset(char[] var0, int var1_1) {
        if (var1_1 >= var0.length) {
            return var1_1;
        }
        if (var0[var1_1] != '\u0000') ** GOTO lbl6
        return var1_1;
lbl-1000:
        // 1 sources

        {
            ++var1_1;
lbl6:
            // 2 sources

            ** while (var1_1 + 1 < var0.length && var0[var1_1 + 1] != '\u0000')
        }
lbl7:
        // 1 sources

        return var1_1;
    }

    public Formatter(DocumentType documentType) {
        this.setDocumentType(documentType);
    }

    public void setDocumentType(DocumentType documentType) {
        if (documentType == null) {
            documentType = UnconstrainedDocumentType.INSTANCE;
        }
        this.documentType = documentType;
        this.guessContentType = documentType instanceof UnconstrainedDocumentType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setIndent(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 16) {
            n = 16;
        }
        this.indent = n;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setMaxLineLength(int n) {
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        } else if (n < 40) {
            n = 40;
        }
        this.maxLineLength = n;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setAddingOpenLines(boolean bl) {
        this.addOpenLines = bl;
    }

    public boolean isAddingOpenLines() {
        return this.addOpenLines;
    }

    public void setFavorInteroperability(boolean bl) {
        this.favorInteroperability = bl;
    }

    public boolean getFavorInteroperability() {
        return this.favorInteroperability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(Document document, Writer writer) throws IOException {
        this.initState(writer);
        try {
            super.writeDocument(document, this.out);
            Object var4_3 = null;
            this.clearState();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clearState();
            throw throwable;
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocumentElement(Element element, Writer writer) throws IOException {
        this.initState(writer);
        try {
            super.writeDocumentElement(element, this.out);
            Object var4_3 = null;
            this.clearState();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clearState();
            throw throwable;
        }
    }

    private void initState(Writer writer) {
        this.out = new LineWriter(writer);
        this.minLineLength = Math.max(40, 2 * this.maxLineLength / 3);
        State state = new State(null, false);
        state.elementType = null;
        state.childElementTypes = null;
        state.hasPreserveSpace = false;
        state.layout = 0;
        state.lineFirst = -this.indent;
        state.lineEnd = this.maxLineLength;
        state.wrappedLine = null;
        state.elementTag = null;
        this.stateStack.push(state);
    }

    private void clearState() {
        while (!this.stateStack.empty()) {
            this.stateStack.pop();
        }
    }

    private State pushState(Element element, boolean bl) {
        String string;
        State state = this.getState();
        if (state.isXInclude) {
            bl = true;
        }
        State state2 = new State(element, bl);
        if (bl) {
            string = element.getSpaceAttribute();
            state2.hasPreserveSpace = string == null ? state.hasPreserveSpace : string.trim().equals("preserve");
        } else {
            Data data;
            if (state.element == null) {
                state2.elementType = this.documentType.getElementType(element);
                if (state2.elementType == null) {
                    state2.elementType = UnconstrainedElementType.INSTANCE;
                }
            } else {
                int n = state.element.indexOfChildElement(element);
                state2.elementType = state.childElementTypes[n];
            }
            if (!state2.elementType.getStructure(element, false, this.structure)) {
                state2.elementType = new UncheckedElementType(state2.elementType);
                state2.elementType.getStructure(element, false, this.structure);
            }
            state2.init(this.structure);
            string = element.getSpaceAttribute();
            state2.hasPreserveSpace = string == null ? ((data = state2.elementType.getAttributeDefaultValue(Name.XML_SPACE)) != null ? data.formatData(element).equals("preserve") : state.hasPreserveSpace) : string.trim().equals("preserve");
        }
        state2.parentIsVertical = state.layout == 0;
        int n = state2.getElementContentType(this.guessed);
        boolean bl2 = this.guessed[0];
        switch (n) {
            case 0: 
            case 1: {
                state2.layout = 2;
                break;
            }
            case 2: {
                if (bl2 && state2.hasPreserveSpace) {
                    state2.layout = 2;
                    break;
                }
                state2.layout = 0;
                break;
            }
            default: {
                state2.layout = state2.hasPreserveSpace ? 2 : 1;
            }
        }
        if (state.layout == 1) {
            if (this.isEmptyElement(element)) {
                state2.layout = 1;
            }
            if (state2.layout == 1) {
                state2.lineFirst = state.lineFirst;
                state2.lineEnd = state.lineEnd;
            } else {
                state2.lineFirst = state.lineFirst + this.indent;
                state2.lineEnd = this.computeLineEnd(state2.lineFirst);
            }
            state2.wrappedLine = state.wrappedLine;
        } else {
            state2.lineFirst = state.lineFirst + this.indent;
            state2.lineEnd = this.computeLineEnd(state2.lineFirst);
            state2.wrappedLine = state2.layout == 1 ? new WrappedLine(state2.lineFirst, state2.lineEnd) : null;
        }
        this.stateStack.push(state2);
        return state2;
    }

    private boolean isEmptyElement(Element element) {
        switch (element.getChildCount()) {
            case 0: {
                return true;
            }
            case 1: {
                Node node = element.getFirstChild();
                return node instanceof Text && ((Text)node).getTextLength() == 0;
            }
        }
        return false;
    }

    private int computeLineEnd(int n) {
        if (this.maxLineLength - n < this.minLineLength) {
            return n + this.minLineLength;
        }
        return this.maxLineLength;
    }

    private void popState() {
        this.stateStack.pop();
    }

    private State getState() {
        return (State)this.stateStack.peek();
    }

    private int getColumnNumber() {
        return ((LineWriter)this.out).getColumnNumber();
    }

    private void writeIndent(int n) throws IOException {
        this.out.write(10);
        while (n > 0) {
            this.out.write(32);
            --n;
        }
    }

    protected void writeElement(Element element) throws IOException {
        Object object;
        State state = this.getState();
        boolean bl = false;
        if ((this.preserveEntityRefs || this.preserveXIncludes) && (object = (InclusionInfo)element.getProperty("INCLUSION_INFO")) != null) {
            if (((InclusionInfo)object).getEntityName() != null) {
                if (this.preserveEntityRefs) {
                    if (state.wrappedLine != null) {
                        state.wrappedLine.add('&');
                        state.wrappedLine.add(this.getEntityName((InclusionInfo)object));
                        state.wrappedLine.add(';');
                    } else {
                        this.out.write(38);
                        this.out.write(this.getEntityName((InclusionInfo)object));
                        this.out.write(59);
                    }
                    return;
                }
            } else if (this.preserveXIncludes) {
                element = ((InclusionInfo)object).getXIncludeElement();
                bl = true;
            }
        }
        object = this.pushState(element, bl);
        this.doWriteElement(element);
        this.popState();
        if (((State)object).wrappedLine != null && ((State)object).wrappedLine != state.wrappedLine) {
            ((State)object).wrappedLine.flush();
        }
    }

    protected void writeElementStartTag(Element element, String string) throws IOException {
        State state = this.getState();
        state.elementTag = string;
        if (state.wrappedLine != null) {
            state.wrappedLine.add('<');
            state.wrappedLine.add(string);
            if (state.layout == 0) {
                state.wrappedLine.flush();
                state.wrappedLine = null;
            }
        } else {
            this.out.write(60);
            this.out.write(string);
        }
    }

    protected void writeElementAttribute(Element element, String string, Name name, String string2) throws IOException {
        State state = this.getState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("=\"");
        char[] cArray = string2.toCharArray();
        this.escapeXML(true, cArray, 0, cArray.length, stringBuffer);
        stringBuffer.append('\"');
        if (state.wrappedLine != null) {
            state.wrappedLine.addSpace();
            state.wrappedLine.add(stringBuffer.toString());
        } else {
            int n = state.parentIsVertical ? state.lineFirst + 1 + state.elementTag.length() + 1 : state.lineFirst + this.indent;
            int n2 = this.getColumnNumber();
            if (n2 <= n || n2 + 1 + stringBuffer.length() <= state.lineEnd) {
                this.out.write(32);
            } else {
                this.writeIndent(n);
            }
            this.out.write(stringBuffer.toString());
        }
    }

    protected void writeElementChildren(Element element) throws IOException {
        State state = this.getState();
        if (!this.isEmptyElement(element)) {
            if (state.wrappedLine != null) {
                state.wrappedLine.add('>');
                if (state.layout == 2) {
                    state.wrappedLine.flush();
                    state.wrappedLine = null;
                }
            } else {
                this.out.write(62);
            }
            Node node = element.getFirstChild();
            while (node != null) {
                if (state.layout == 0) {
                    this.writeIndent(state.lineFirst + this.indent);
                }
                switch (node.getNodeType()) {
                    case 1: {
                        this.writeComment((Comment)node);
                        break;
                    }
                    case 2: {
                        this.writeProcessingInstruction((ProcessingInstruction)node);
                        break;
                    }
                    case 0: {
                        this.writeText((Text)node);
                        break;
                    }
                    case 4: {
                        this.writeElement((Element)node);
                        break;
                    }
                    default: {
                        throw new RuntimeException("internal error: unexpected node type: " + node.getNodeType());
                    }
                }
                node = node.getNextSibling();
                if (state.layout != 0 || !this.addOpenLines || node == null) continue;
                this.out.write(10);
            }
        }
    }

    protected void writeElementEndTag(Element element, String string) throws IOException {
        State state = this.getState();
        if (this.isEmptyElement(element)) {
            if (this.favorInteroperability) {
                if (state.getElementContentType() == 0) {
                    if (state.wrappedLine != null) {
                        state.wrappedLine.add(" />");
                    } else {
                        this.out.write(" />");
                    }
                } else if (state.wrappedLine != null) {
                    state.wrappedLine.add("></");
                    state.wrappedLine.add(string);
                    state.wrappedLine.add('>');
                } else {
                    this.out.write("></");
                    this.out.write(string);
                    this.out.write(62);
                }
            } else if (state.wrappedLine != null) {
                state.wrappedLine.add("/>");
            } else {
                this.out.write("/>");
            }
        } else if (state.wrappedLine != null) {
            state.wrappedLine.add("</");
            state.wrappedLine.add(string);
            state.wrappedLine.add('>');
        } else {
            if (state.layout == 0) {
                this.writeIndent(state.lineFirst);
            }
            this.out.write("</");
            this.out.write(string);
            this.out.write(62);
        }
    }

    protected void writeCdataSection(String string) throws IOException {
        State state = this.getState();
        if (state.wrappedLine != null) {
            state.wrappedLine.add("><![CDATA[");
            state.wrappedLine.flush();
        } else {
            this.out.write("><![CDATA[");
        }
        this.out.write(string);
        this.out.write("]]>");
    }

    protected void writeComment(Comment comment) throws IOException {
        DocumentWriter.checkComment(comment);
        State state = this.getState();
        if (state.wrappedLine != null) {
            state.wrappedLine.add("<!--");
            state.wrappedLine.flush();
        } else {
            this.out.write("<!--");
        }
        this.out.write(comment.getText());
        this.out.write("-->");
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        if (this.ignoreProcessingInstruction(processingInstruction)) {
            return;
        }
        DocumentWriter.checkProcessingInstruction(processingInstruction);
        State state = this.getState();
        if (state.wrappedLine != null) {
            state.wrappedLine.add("<?");
            state.wrappedLine.add(processingInstruction.getTarget());
            state.wrappedLine.add(' ');
            state.wrappedLine.flush();
        } else {
            this.out.write("<?");
            this.out.write(processingInstruction.getTarget());
            this.out.write(32);
        }
        this.out.write(processingInstruction.getText());
        this.out.write("?>");
    }

    protected void writeText(Text text) throws IOException {
        State state = this.getState();
        StringBuffer stringBuffer = new StringBuffer();
        this.escapeXML(false, text.getTextChars(), 0, text.getTextLength(), stringBuffer);
        if (state.wrappedLine != null) {
            state.wrappedLine.addAll(stringBuffer.toString());
        } else {
            this.out.write(stringBuffer.toString());
        }
    }

    private final class WrappedLine {
        private int lineFirst;
        private int lineEnd;
        private StringBuffer buffer;

        public WrappedLine(int n, int n2) {
            this.lineFirst = n;
            this.lineEnd = n2;
            this.buffer = new StringBuffer();
        }

        public void add(char c) {
            this.buffer.append(c);
        }

        public void add(String string) {
            this.buffer.append(string);
        }

        public void addSpace() {
            int n = this.buffer.length();
            if (n == 0 || this.buffer.charAt(n - 1) != '\u0000') {
                this.buffer.append('\u0000');
            }
        }

        public void addAll(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 1) {
                    switch (string2.charAt(0)) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            this.addSpace();
                            break;
                        }
                        default: {
                            this.add(string2);
                            break;
                        }
                    }
                    continue;
                }
                this.add(string2);
            }
        }

        public void flush() throws IOException {
            if (this.buffer.length() > 0) {
                char[] cArray = this.buffer.toString().toCharArray();
                this.buffer = new StringBuffer();
                int n = 0;
                int n2 = Formatter.nextOffset(cArray, n);
                while (n < cArray.length) {
                    int n3 = n2 + 1;
                    int n4 = Formatter.nextOffset(cArray, n3);
                    if (n == n2 && cArray[n] == '\u0000') {
                        if (n3 < cArray.length) {
                            int n5 = Formatter.this.getColumnNumber();
                            if (n5 <= this.lineFirst || n5 + 1 + (n4 - n3 + 1) <= this.lineEnd) {
                                Formatter.this.out.write(32);
                            } else {
                                Formatter.this.writeIndent(this.lineFirst);
                            }
                        } else {
                            Formatter.this.out.write(32);
                        }
                    } else {
                        Formatter.this.out.write(cArray, n, n2 - n + 1);
                    }
                    n = n3;
                    n2 = n4;
                }
            }
        }
    }

    private final class State {
        public Element element;
        public boolean isXInclude;
        public ElementType elementType;
        public ElementType[] childElementTypes;
        public boolean hasPreserveSpace;
        public boolean parentIsVertical;
        public int layout;
        public int lineFirst;
        public int lineEnd;
        public WrappedLine wrappedLine;
        public String elementTag;

        public State(Element element, boolean bl) {
            this.element = element;
            this.isXInclude = bl;
        }

        public void init(Structure structure) {
            Item[] itemArray = structure.childNodeItems;
            int n = structure.childNodeItemCount;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (itemArray[n3] instanceof Field) {
                    ++n2;
                }
                ++n3;
            }
            this.childElementTypes = new ElementType[n2];
            n2 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (itemArray[n4] instanceof Field) {
                    Element element = (Element)this.element.getChild(n4);
                    ElementType elementType = this.elementType.getChildElementType((Field)itemArray[n4], element);
                    if (elementType == null) {
                        elementType = UnconstrainedElementType.INSTANCE;
                    }
                    this.childElementTypes[n2++] = elementType;
                }
                ++n4;
            }
        }

        public int getElementContentType() {
            return this.getElementContentType(null);
        }

        public int getElementContentType(boolean[] blArray) {
            if (Formatter.this.guessContentType || this.isXInclude || this.elementType == null || this.elementType instanceof UnconstrainedElementType) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return EditUtil.guessElementContentType(this.element, true);
            }
            if (blArray != null) {
                blArray[0] = false;
            }
            return this.elementType.getElementContentType();
        }
    }
}

