/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.HelperElementType;
import com.xmlmind.xmledit.xmlutil.Name;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;

final class HelperDocumentType
extends UnconstrainedDocumentType
implements Traversal.Handler,
DocumentListener {
    private IdentityHashMap elementTypes;
    private boolean batchEditing = false;
    private IdentityHashMap pendingElementAttributes = new IdentityHashMap();
    private IdentityHashMap pendingElementChildren = new IdentityHashMap();
    private IdentityHashMap pendingNewElements = new IdentityHashMap();

    public HelperDocumentType(Document document) {
        this.initElementTypes(document);
        document.addDocumentListener(this, false);
    }

    private void initElementTypes(Document document) {
        this.elementTypes = new IdentityHashMap();
        this.updateElement(document.getRootElement());
    }

    private void updateElement(Element element) {
        Traversal.traverse(element, this);
    }

    public ElementType getElementType(Element element) {
        return this.getElementType(element.getName());
    }

    ElementType getElementType(Name name) {
        return (ElementType)this.elementTypes.get(name);
    }

    public Object enterElement(Element element) {
        HelperElementType helperElementType = this.getHelperElementType(element);
        HelperDocumentType.updateElementAttributes(helperElementType, element);
        HelperDocumentType.updateElementChildren(helperElementType, element);
        return null;
    }

    private HelperElementType getHelperElementType(Element element) {
        Name name = element.getName();
        HelperElementType helperElementType = (HelperElementType)this.elementTypes.get(name);
        if (helperElementType == null) {
            helperElementType = new HelperElementType(this);
            this.elementTypes.put(name, helperElementType);
        }
        return helperElementType;
    }

    private static final void updateElementAttributes(HelperElementType helperElementType, Element element) {
        if (element.getAttributeCount() > 0) {
            Enumeration enumeration = element.getAttributes();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                helperElementType.addAttribute(attribute.name);
            }
        }
    }

    private static final void updateElementChildren(HelperElementType helperElementType, Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                helperElementType.addChildElement(((Element)node).getName());
            }
            node = node.getNextSibling();
        }
    }

    public Object processText(Text text) {
        return null;
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return null;
    }

    public Object processComment(Comment comment) {
        return null;
    }

    public Object leaveElement(Element element) {
        return null;
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        this.batchEditing = true;
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        int n2;
        HelperElementType helperElementType;
        Name[] nameArray;
        Element element;
        Object object;
        Iterator iterator;
        this.batchEditing = false;
        if (this.pendingElementAttributes.size() > 0) {
            iterator = this.pendingElementAttributes.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                element = (Element)object.getKey();
                nameArray = (Name[])object.getValue();
                helperElementType = this.getHelperElementType(element);
                n2 = 0;
                while (n2 < nameArray.length) {
                    helperElementType.addAttribute(nameArray[n2]);
                    ++n2;
                }
            }
            this.pendingElementAttributes.clear();
        }
        if (this.pendingElementChildren.size() > 0) {
            iterator = this.pendingElementChildren.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                element = (Element)object.getKey();
                nameArray = (Name[])object.getValue();
                helperElementType = this.getHelperElementType(element);
                n2 = 0;
                while (n2 < nameArray.length) {
                    helperElementType.addChildElement(nameArray[n2]);
                    ++n2;
                }
            }
            this.pendingElementChildren.clear();
        }
        if (this.pendingNewElements.size() > 0) {
            iterator = this.pendingNewElements.values().iterator();
            while (iterator.hasNext()) {
                object = (Element)((Object)iterator.next());
                this.updateElement((Element)object);
            }
            this.pendingNewElements.clear();
        }
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        if (elementAttributeEvent.getId() == 20) {
            Element element = elementAttributeEvent.getElementSource();
            Name name = elementAttributeEvent.getName();
            if (this.batchEditing) {
                this.pendingAttribute(element, name);
            } else {
                HelperElementType helperElementType = this.getHelperElementType(element);
                helperElementType.addAttribute(name);
            }
        }
    }

    private void pendingAttribute(Element element, Name name) {
        Name[] nameArray = (Name[])this.pendingElementAttributes.get(element);
        if (nameArray == null) {
            nameArray = new Name[]{name};
        } else {
            Name[] nameArray2 = new Name[nameArray.length + 1];
            System.arraycopy(nameArray, 0, nameArray2, 0, nameArray.length);
            nameArray2[nameArray.length] = name;
            nameArray = nameArray2;
        }
        this.pendingElementAttributes.put(element, nameArray);
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        Node node = elementStructureEvent.getNewChild();
        if (node != null && node instanceof Element) {
            Element element = elementStructureEvent.getElementSource();
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (this.batchEditing) {
                this.pendingChildElement(element, name);
                this.pendingNewElements.put(element2, element2);
            } else {
                HelperElementType helperElementType = this.getHelperElementType(element);
                helperElementType.addChildElement(name);
                this.updateElement(element2);
            }
        }
    }

    private void pendingChildElement(Element element, Name name) {
        Name[] nameArray = (Name[])this.pendingElementChildren.get(element);
        if (nameArray == null) {
            nameArray = new Name[]{name};
        } else {
            Name[] nameArray2 = new Name[nameArray.length + 1];
            System.arraycopy(nameArray, 0, nameArray2, 0, nameArray.length);
            nameArray2[nameArray.length] = name;
            nameArray = nameArray2;
        }
        this.pendingElementChildren.put(element, nameArray);
    }

    public void textChanged(TextEvent textEvent, int n) {
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
    }
}

