/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentTrimmer;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.DocumentTypeCache;
import com.xmlmind.xmledit.edit.DocumentTypeDetector;
import com.xmlmind.xmledit.edit.LoaderBase;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.edit.Trimmer;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.edit.XIncludeError;
import com.xmlmind.xmledit.edit.XIncluder;
import java.io.IOException;
import java.util.HashMap;

public final class Loader
extends LoaderBase {
    private XIncluder xincluder = new XIncluder();
    private DocumentTrimmer docTrimmer = new DocumentTrimmer();
    private Trimmer trimmer = new Trimmer(UnconstrainedDocumentType.INSTANCE);
    private boolean addXXEProcessingInstructions = false;
    private boolean addInclusionInfo = false;
    private boolean addStyleSheetInfo = true;
    private boolean addMarkManager = true;
    private boolean addUndoManager = true;
    private boolean addCommandHistory = true;
    private boolean xincludeAware = false;
    private boolean markInclusionsAsReadOnly = false;
    private boolean guessIgnorableWhitespace = true;
    private XIncludeError[] xincludeErrors = null;
    private static final XIncludeError[] NO_XINCLUDE_ERRORS = new XIncludeError[0];

    public void setDocumentTypeCache(DocumentTypeCache documentTypeCache) {
        super.setDocumentTypeCache(documentTypeCache);
        this.xincluder.setDocumentTypeCache(documentTypeCache);
    }

    public void setDocumentTypeDetector(DocumentTypeDetector documentTypeDetector) {
        super.setDocumentTypeDetector(documentTypeDetector);
        this.xincluder.setDocumentTypeDetector(documentTypeDetector);
    }

    public void setAddedProperties(int n) {
        this.addXXEProcessingInstructions = (n & 0x8000) != 0;
        this.addInclusionInfo = (n & 8) != 0;
        this.addStyleSheetInfo = (n & 0x200) != 0;
        this.addMarkManager = (n & 0x80) != 0;
        this.addUndoManager = (n & 0x100) != 0;
        this.addCommandHistory = (n & 0x800) != 0;
        super.setAddingInclusionInfo(this.addInclusionInfo);
        this.xincluder.setAddingInclusionInfo(this.addInclusionInfo);
    }

    public int getAddedProperties() {
        int n = 0;
        if (this.addXXEProcessingInstructions) {
            n |= 0x8000;
        }
        if (this.addInclusionInfo) {
            n |= 8;
        }
        if (this.addStyleSheetInfo) {
            n |= 0x200;
        }
        if (this.addMarkManager) {
            n |= 0x80;
        }
        if (this.addUndoManager) {
            n |= 0x100;
        }
        if (this.addCommandHistory) {
            n |= 0x800;
        }
        return n;
    }

    public void setXIncludeAware(boolean bl) {
        this.xincludeAware = bl;
    }

    public boolean isXIncludeAware() {
        return this.xincludeAware;
    }

    public void setMarkingInclusionsAsReadOnly(boolean bl) {
        this.markInclusionsAsReadOnly = bl;
    }

    public boolean isMarkingInclusionsAsReadOnly() {
        return this.markInclusionsAsReadOnly;
    }

    public void setGuessingIgnorableWhitespace(boolean bl) {
        this.guessIgnorableWhitespace = bl;
    }

    public boolean isGuessingIgnorableWhitespace() {
        return this.guessIgnorableWhitespace;
    }

    public void setCacheIncludedDocuments(int n) {
        this.xincluder.setDocumentCacheSize(n);
    }

    public int getCacheIncludedDocuments() {
        return this.xincluder.getDocumentCacheSize();
    }

    public XIncludeError[] getXIncludeErrors() {
        return this.xincludeErrors;
    }

    protected void annotateInstance(Document document) throws IOException {
        Object object;
        super.annotateInstance(document);
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        if (this.addStyleSheetInfo && (object = StyleSheetInfo.loadStyleSheetPI(document)) != null && ((StyleSheetInfo[])object).length > 0) {
            document.putProperty("STYLE_SHEET_INFO", object);
        }
        object = this.getConsole();
        if (this.xincludeAware) {
            if (object != null) {
                object.showMessage(Msg.msg("L.processingXIncludes", document.getLocation()), 0);
            }
            this.xincluder.processDocument(document);
            this.xincludeErrors = this.xincluder.getErrors();
        } else {
            this.xincludeErrors = NO_XINCLUDE_ERRORS;
        }
        this.processProperties(document);
        if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            if (this.guessIgnorableWhitespace) {
                if (object != null) {
                    object.showMessage(Msg.msg("L.trimmingDocument", document.getLocation()), 0);
                }
                this.docTrimmer.trim(document);
            }
        } else {
            if (object != null) {
                object.showMessage(Msg.msg("L.trimmingDocument", document.getLocation()), 0);
            }
            this.trimmer.setDocumentType(documentType);
            this.trimmer.trim(document);
        }
        if (this.addMarkManager) {
            document.putProperty("MARK_MANAGER", new MarkManager(document));
        }
        if (this.addUndoManager) {
            document.putProperty("UNDO_MANAGER", new UndoManager(document));
        }
        if (this.addCommandHistory) {
            document.putProperty("COMMAND_HISTORY", new CommandHistory());
        }
    }

    private void processProperties(Document document) {
        String[] stringArray;
        document.removeProperty("DTD");
        PropertyProcessor propertyProcessor = new PropertyProcessor();
        propertyProcessor.traverse(document.getRootElement());
        if (this.addXXEProcessingInstructions && (stringArray = propertyProcessor.getXXEPITargets()) != null) {
            document.putProperty("XXE_PROCESSING_INSTRUCTIONS", stringArray);
        }
    }

    private final class PropertyProcessor
    extends Traversal.HandlerBase {
        private Element rootElement;
        private HashMap xxePITargets;

        private PropertyProcessor() {
        }

        public void traverse(Element element) {
            this.rootElement = element;
            this.xxePITargets = null;
            Traversal.traverse(element, this);
        }

        public String[] getXXEPITargets() {
            if (this.xxePITargets == null) {
                return null;
            }
            String[] stringArray = new String[this.xxePITargets.size()];
            this.xxePITargets.values().toArray(stringArray);
            return stringArray;
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            String string;
            if (Loader.this.addXXEProcessingInstructions && (string = processingInstruction.getTarget()).startsWith("xxe-")) {
                if (this.xxePITargets == null) {
                    this.xxePITargets = new HashMap();
                }
                this.xxePITargets.put(string, string);
            }
            return null;
        }

        public Object enterElement(Element element) {
            if (Loader.this.addInclusionInfo && element.hasProperty("INCLUSION_INFO")) {
                if (Loader.this.markInclusionsAsReadOnly) {
                    element.setReadOnly(true);
                }
                return Traversal.LEAVE_ELEMENT;
            }
            if (element != this.rootElement) {
                element.removeProperty("LOCATION_INFO");
            }
            return null;
        }
    }
}

