/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.jclark.xml.parse.DTD;
import com.jclark.xml.parse.EntityManager;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.sax.NamespaceStack;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doc.TypedDocumentLoader;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeError;
import com.xmlmind.xmledit.doctype.DocumentTypeLoader;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.DetectedDocumentType;
import com.xmlmind.xmledit.edit.DocumentTypeCache;
import com.xmlmind.xmledit.edit.DocumentTypeDetector;
import com.xmlmind.xmledit.edit.HelperDocumentType;
import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.edit.RelaxngInfo;
import com.xmlmind.xmledit.rng.doctype.RNGSchemaForSchemas;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceURLPair;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDUtil;
import com.xmlmind.xmledit.xsd.load.DocumentTypeLoaderImpl;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SchemaUtil;
import com.xmlmind.xmledit.xsd.validate.XMLSchemaForSchemas;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;

public class LoaderBase
implements TypedDocumentLoader {
    private static DocumentTypeCache defaultDocTypeCache;
    private static DocumentTypeDetector defaultDocTypeDetect;
    private DocumentLoader docLoader;
    private DocumentTypeLoader dtdLoader;
    private DocumentTypeLoader wxsLoader;
    private DocumentTypeLoader rngLoader;
    private DocumentTypeCache appDocTypeCache = null;
    private DocumentTypeDetector appDocTypeDetect = null;
    private Console console = null;
    private boolean useHelperDocumentType = false;
    private boolean useSchemaForSchemas = true;
    private boolean useSchemaForRelaxng = true;
    private URL docURL = null;
    private boolean loadingInstanceWithDTD = false;
    private DocumentType cachedDTD = null;
    private DetectedDocumentType detectedDocType = null;
    private boolean usedDocTypeDetect = false;
    private DocumentTypeLoader docTypeLoader = null;
    private NamespaceStack nsSupport = new NamespaceStack();
    private RelaxngInfo relaxngInfo = new RelaxngInfo();
    private String[] nameParts = new String[3];
    private static final DocumentTypeError[] NO_DOCUMENT_TYPE_ERRORS;
    private static final String DOCUMENT_ELEMENT_ENTITY_NAME = "__wrapped_document_element__";
    private static byte[] START_XML_PI;
    private static byte[] END_XML_PI;
    private static byte[] ENCODING_NAME;
    private static byte[] ENCODING_SPEC;

    public static void setDefaultDocumentTypeCache(DocumentTypeCache documentTypeCache) {
        defaultDocTypeCache = documentTypeCache;
    }

    public static DocumentTypeCache getDefaultDocumentTypeCache() {
        return defaultDocTypeCache;
    }

    public static void setDefaultDocumentTypeDetector(DocumentTypeDetector documentTypeDetector) {
        defaultDocTypeDetect = documentTypeDetector;
    }

    public static DocumentTypeDetector getDefaultDocumentTypeDetector() {
        return defaultDocTypeDetect;
    }

    public LoaderBase() {
        this.docLoader = new DocumentLoader();
        this.docLoader.setTypedDocumentLoader(this);
        this.docLoader.setAddedProperties(16433);
        this.dtdLoader = new com.xmlmind.xmledit.xsd.dtdtoxsd.DocumentTypeLoaderImpl();
        this.wxsLoader = new DocumentTypeLoaderImpl();
        this.rngLoader = new com.xmlmind.xmledit.rng.doctype.DocumentTypeLoaderImpl();
    }

    public DocumentLoader getDocumentLoader() {
        return this.docLoader;
    }

    public void setDocumentTypeCache(DocumentTypeCache documentTypeCache) {
        this.appDocTypeCache = documentTypeCache;
    }

    public DocumentTypeCache getDocumentTypeCache() {
        return this.appDocTypeCache;
    }

    private DocumentTypeCache docTypeCache() {
        return this.appDocTypeCache != null ? this.appDocTypeCache : defaultDocTypeCache;
    }

    public void setDocumentTypeDetector(DocumentTypeDetector documentTypeDetector) {
        this.appDocTypeDetect = documentTypeDetector;
    }

    public DocumentTypeDetector getDocumentTypeDetector() {
        return this.appDocTypeDetect;
    }

    private DocumentTypeDetector docTypeDetector() {
        return this.appDocTypeDetect != null ? this.appDocTypeDetect : defaultDocTypeDetect;
    }

    public void setConsole(Console console) {
        this.console = console;
        this.dtdLoader.setDocumentTypeLoadConsole(console);
        this.wxsLoader.setDocumentTypeLoadConsole(console);
        this.rngLoader.setDocumentTypeLoadConsole(console);
    }

    public Console getConsole() {
        return this.console;
    }

    public void setUsingHelperDocumentType(boolean bl) {
        this.useHelperDocumentType = bl;
    }

    public boolean isUsingHelperDocumentType() {
        return this.useHelperDocumentType;
    }

    public void setUsingBuiltinSchemaForSchemas(boolean bl) {
        this.useSchemaForSchemas = bl;
    }

    public boolean isUsingBuiltinSchemaForSchemas() {
        return this.useSchemaForSchemas;
    }

    public void setUsingBuiltinSchemaForRelaxng(boolean bl) {
        this.useSchemaForRelaxng = bl;
    }

    public boolean isUsingBuiltinSchemaForRelaxng() {
        return this.useSchemaForRelaxng;
    }

    public void setAddingInclusionInfo(boolean bl) {
        int n = this.docLoader.getAddedProperties();
        n = bl ? (n |= 8) : (n &= 0xFFFFFFF7);
        this.docLoader.setAddedProperties(n);
    }

    public boolean isAddingInclusionInfo() {
        int n = this.docLoader.getAddedProperties();
        return (n & 8) != 0;
    }

    public Document load(File file) throws IOException {
        return this.load(FileUtil.fileToURL(file));
    }

    public Document load(URL uRL) throws IOException {
        Document document = this.loadInstance(new OpenEntity(uRL.openStream(), uRL.toExternalForm(), uRL));
        this.annotateInstance(document);
        return document;
    }

    public Document load(OpenEntity openEntity) throws IOException {
        Document document = this.loadInstance(openEntity);
        this.annotateInstance(document);
        return document;
    }

    public DocumentTypeError[] getDocumentTypeErrors() {
        return this.docTypeLoader == null ? NO_DOCUMENT_TYPE_ERRORS : this.docTypeLoader.getDocumentTypeErrors();
    }

    public DocumentTypeError[] getDocumentTypeWarnings() {
        return this.docTypeLoader == null ? NO_DOCUMENT_TYPE_ERRORS : this.docTypeLoader.getDocumentTypeWarnings();
    }

    public OpenEntity openExternalDTDSubset(String string, URL uRL, String string2) throws IOException {
        this.cachedDTD = null;
        if (string2 == null) {
            return null;
        }
        DocumentTypeCache documentTypeCache = this.docTypeCache();
        if (documentTypeCache == null) {
            return null;
        }
        DocumentTypeCache.Entry entry = null;
        try {
            entry = documentTypeCache.get(DocumentTypeCache.dtd(string2), this.console);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entry == null) {
            return null;
        }
        this.cachedDTD = entry.getDocumentType();
        return DTDUtil.toOpenEntity(entry.getGeneralEntities());
    }

    public void startRootElement(Document document, boolean bl, StartElementEvent startElementEvent) throws IOException {
        if (this.loadingInstanceWithDTD) {
            return;
        }
        if (this.cachedDTD != null) {
            this.docLoader.setNamespaceMode(0);
            return;
        }
        if (bl) {
            return;
        }
        if (LoaderBase.hasRelaxngPI(document)) {
            return;
        }
        Element element = this.startElementEventToElement(startElementEvent);
        if (LoaderBase.getSchemaLocations(element) != null) {
            return;
        }
        DocumentTypeDetector documentTypeDetector = this.docTypeDetector();
        if (documentTypeDetector != null) {
            this.detectedDocType = documentTypeDetector.detectDocumentType(element, this.docURL);
            this.usedDocTypeDetect = true;
            if (this.detectedDocType != null && this.detectedDocType.dtdSystemId != null && document.getDocumentTypeDeclaration() == null) {
                throw new StopLoadingException();
            }
        }
    }

    private Element startElementEventToElement(StartElementEvent startElementEvent) {
        String string;
        int n;
        Object object;
        this.nsSupport.reset();
        this.nsSupport.pushContext();
        int n2 = startElementEvent.getAttributeSpecifiedCount();
        int n3 = 0;
        while (n3 < n2) {
            object = startElementEvent.getAttributeName(n3);
            if (((String)object).indexOf("xmlns") == 0) {
                n = ((String)object).length();
                string = startElementEvent.getAttributeValue(n3);
                String string2 = null;
                if (n == 5) {
                    string2 = "";
                } else if (((String)object).charAt(5) == ':') {
                    String string3 = string2 = n > 6 ? ((String)object).substring(6) : "";
                    if (!XMLUtil.isNCName(string2)) {
                        string2 = null;
                    }
                }
                if (string2 != null) {
                    this.nsSupport.declarePrefix(string2, string);
                }
            }
            ++n3;
        }
        object = new Element(this.newName(startElementEvent.getName(), false));
        n = 0;
        while (n < n2) {
            string = startElementEvent.getAttributeName(n);
            if (string.indexOf("xmlns") != 0) {
                ((Element)object).putAttribute(this.newName(string, true), startElementEvent.getAttributeValue(n));
            }
            ++n;
        }
        return object;
    }

    private Name newName(String string, boolean bl) {
        this.nameParts[1] = null;
        this.nameParts[0] = null;
        this.nsSupport.processName(string, this.nameParts, bl);
        if (this.nameParts[0] == null || this.nameParts[1] == null) {
            return Name.get(string);
        }
        return Name.get(this.nameParts[0], this.nameParts[1]);
    }

    private static final NamespaceURLPair[] getSchemaLocations(Element element) {
        NamespaceURLPair[] namespaceURLPairArray = null;
        try {
            namespaceURLPairArray = SchemaUtil.getSchemaLocations(element);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (namespaceURLPairArray.length == 0) {
            return null;
        }
        return namespaceURLPairArray;
    }

    public String getDocumentElementEntityName() {
        return DOCUMENT_ELEMENT_ENTITY_NAME;
    }

    private Document loadInstance(OpenEntity openEntity) throws IOException {
        this.docURL = openEntity.getBase();
        this.loadingInstanceWithDTD = false;
        this.docLoader.setNamespaceMode(2);
        this.cachedDTD = null;
        this.detectedDocType = null;
        this.usedDocTypeDetect = false;
        try {
            return this.docLoader.load(openEntity);
        }
        catch (StopLoadingException stopLoadingException) {
            return this.loadInstanceWithDTD(this.docURL, this.detectedDocType.dtdPublicId, this.detectedDocType.dtdSystemId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadInstanceWithDTD(final URL uRL, String string, URL uRL2) throws IOException {
        Object object;
        Document document;
        this.loadingInstanceWithDTD = true;
        boolean bl = this.detectedDocType != null && (this.detectedDocType.wxsLocations != null && this.detectedDocType.wxsLocations.length > 0 || this.detectedDocType.rngLocation != null);
        this.docLoader.setNamespaceMode(bl ? 1 : 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8' ?>\n");
        if (string == null) {
            stringBuffer.append("<!DOCTYPE __document_element_wrapper__ SYSTEM ");
        } else {
            stringBuffer.append("<!DOCTYPE __document_element_wrapper__ PUBLIC '" + string + "' ");
        }
        LoaderBase.appendQuoted(stringBuffer, uRL2.toExternalForm());
        stringBuffer.append(" [\n");
        stringBuffer.append("<!ENTITY __wrapped_document_element__ SYSTEM ");
        final String string2 = uRL.toExternalForm();
        LoaderBase.appendQuoted(stringBuffer, string2);
        stringBuffer.append('>');
        stringBuffer.append("\n]>\n");
        stringBuffer.append("<__document_element_wrapper__>&__wrapped_document_element__;</__document_element_wrapper__>\n");
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        URL uRL3 = FileUtil.fileToURL("bytes");
        OpenEntity openEntity = new OpenEntity((InputStream)byteArrayInputStream, uRL3.toExternalForm(), uRL3);
        try {
            this.docLoader.setEntityManager(new EntityManager(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public OpenEntity open(String string, URL uRL2, String string22) throws IOException {
                    if (string2.equals(string)) {
                        InputStream inputStream = uRL.openStream();
                        byte[] byArray = null;
                        try {
                            byArray = FileUtil.loadBytes(inputStream);
                            Object var7_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        byArray = LoaderBase.checkXMLDeclaration(byArray);
                        return new OpenEntity((InputStream)new ByteArrayInputStream(byArray), string2, uRL);
                    }
                    return null;
                }
            });
            document = this.docLoader.load(openEntity);
            object = null;
            this.docLoader.setEntityManager(null);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.docLoader.setEntityManager(null);
            throw throwable;
        }
        Document document2 = new Document();
        document2.putLocationInfo(string2, false);
        document2.putProperty("DTD", document.getProperty("DTD"));
        object = document.getProperty("NAMESPACE_PREFIX_MAP");
        document2.putProperty("NAMESPACE_PREFIX_MAP", object);
        object = document.getProperty("CHAR_ENTITIES");
        if (object != null) {
            document2.putProperty("CHAR_ENTITIES", object);
        }
        if ((object = document.getProperty("INCLUSION_STATUS")) != null) {
            document2.putProperty("INCLUSION_STATUS", object);
        }
        Tree tree = null;
        Element element = document.getRootElement();
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getNodeType()) {
                case 4: {
                    tree = (Element)node;
                }
                case 1: 
                case 2: {
                    element.removeChild(node);
                    document2.appendChild(node);
                }
            }
            node = node2;
        }
        tree.removeProperty("LOCATION_INFO");
        tree.removeProperty("INCLUSION_INFO");
        return document2;
    }

    private static final void appendQuoted(StringBuffer stringBuffer, String string) {
        char c = string.indexOf(34) < 0 ? (char)'\"' : '\'';
        stringBuffer.append(c);
        stringBuffer.append(string);
        stringBuffer.append(c);
    }

    private static final byte[] checkXMLDeclaration(byte[] byArray) {
        int n;
        int n2;
        if (START_XML_PI == null) {
            try {
                START_XML_PI = "<?xml ".getBytes("US-ASCII");
                END_XML_PI = "?>".getBytes("US-ASCII");
                ENCODING_NAME = "encoding".getBytes("US-ASCII");
                ENCODING_SPEC = " encoding='UTF-8'".getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if ((n2 = LoaderBase.indexOf(byArray, 0, n = Math.min(1024, byArray.length), START_XML_PI)) < 0) {
            return byArray;
        }
        int n3 = LoaderBase.indexOf(byArray, n2 += START_XML_PI.length, n, END_XML_PI);
        if (n3 < 0) {
            return byArray;
        }
        int n4 = LoaderBase.indexOf(byArray, n2, n, ENCODING_NAME);
        if (n4 >= n2 && n4 < n3) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + ENCODING_SPEC.length];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        System.arraycopy(ENCODING_SPEC, 0, byArray2, n3, ENCODING_SPEC.length);
        System.arraycopy(byArray, n3, byArray2, n3 + ENCODING_SPEC.length, byArray.length - n3);
        return byArray2;
    }

    private static final int indexOf(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = byArray2.length;
        if (n3 > 0) {
            byte by = byArray2[0];
            int n4 = n;
            while (n4 < n2) {
                if (byArray[n4] == by) {
                    boolean bl = true;
                    int n5 = 1;
                    while (n5 < n3) {
                        if (byArray[n4 + n5] != byArray2[n5]) {
                            bl = false;
                            break;
                        }
                        ++n5;
                    }
                    if (bl) {
                        return n4;
                    }
                }
                ++n4;
            }
        }
        return -1;
    }

    protected void annotateInstance(Document document) throws IOException {
        Object object;
        DocumentType documentType;
        if (this.console != null) {
            this.console.showMessage(Msg.msg("L.documentLoaded", document.getLocation()), 0);
        }
        if ((documentType = this.loadDocumentTypeForInstance(document)) != null) {
            document.putProperty("DOCUMENT_TYPE", documentType);
        }
        if (documentType != null) {
            if (documentType.isDTD()) {
                document.removeProperty("NAMESPACE_PREFIX_MAP");
            } else {
                object = document.getProperty("NAMESPACE_PREFIX_MAP");
                if (object instanceof PreferredPrefix) {
                    PreferredPrefix preferredPrefix = (PreferredPrefix)object;
                    PrefixEntry[] prefixEntryArray = documentType.getPreferredPrefixes();
                    if (prefixEntryArray != null) {
                        int n = 0;
                        while (n < prefixEntryArray.length) {
                            PrefixEntry prefixEntry = prefixEntryArray[n];
                            preferredPrefix.add(prefixEntry.namespace, prefixEntry.prefix);
                            ++n;
                        }
                    }
                    if (documentType instanceof Schema) {
                        preferredPrefix.add(Namespace.XSI, "xsi");
                    }
                }
            }
        }
        if (this.detectedDocType == null && !this.usedDocTypeDetect && (object = this.docTypeDetector()) != null) {
            this.detectedDocType = object.detectDocumentType(document.getRootElement(), document.getLocation());
        }
        if (this.detectedDocType != null && this.detectedDocType.preserveSpaceElements != null) {
            document.putProperty("PRESERVE_SPACE_ELEMENTS", this.detectedDocType.preserveSpaceElements);
        }
    }

    private DocumentType loadDocumentTypeForInstance(Document document) throws IOException {
        DocumentType documentType = null;
        this.docTypeLoader = null;
        if (this.cachedDTD != null) {
            documentType = this.cachedDTD;
            this.cachedDTD = null;
        } else {
            Object object;
            documentType = this.dtdLoader.loadDocumentTypeForInstance(document);
            if (documentType == null) {
                if (this.dtdLoader.getDocumentTypeErrors().length > 0) {
                    this.docTypeLoader = this.dtdLoader;
                    documentType = UnconstrainedDocumentType.INSTANCE;
                }
            } else {
                this.docTypeLoader = this.dtdLoader;
                this.cacheDTD((com.xmlmind.xmledit.xsd.dtdtoxsd.DTD)documentType, document);
            }
            if (documentType == null) {
                documentType = this.detectedDocType != null && this.detectedDocType.wxsLocations != null && this.detectedDocType.wxsLocations.length > 0 ? this.fetchWXS(this.detectedDocType.wxsLocations) : this.fetchWXS(document);
            }
            if (documentType == null) {
                object = this.detectedDocType != null && this.detectedDocType.wxsLocations != null && this.detectedDocType.wxsLocations.length > 0 ? LoaderBase.createDocTypeSource(this.detectedDocType.wxsLocations) : document;
                documentType = this.wxsLoader.loadDocumentTypeForInstance((Document)object);
                if (documentType == null) {
                    if (this.wxsLoader.getDocumentTypeErrors().length > 0) {
                        this.docTypeLoader = this.wxsLoader;
                        documentType = UnconstrainedDocumentType.INSTANCE;
                    }
                } else {
                    this.docTypeLoader = this.wxsLoader;
                    this.cacheWXS((Schema)documentType);
                }
            }
            if (documentType == null) {
                object = null;
                if (this.detectedDocType != null && this.detectedDocType.rngLocation != null) {
                    object = this.detectedDocType.rngName;
                } else if (LoaderBase.getRelaxngPI(document, this.relaxngInfo)) {
                    object = this.relaxngInfo.name;
                }
                if (object != null) {
                    // empty if block
                }
                documentType = this.fetchRNG((String)object);
            }
            if (documentType == null) {
                object = null;
                URL uRL = null;
                String string = null;
                String string2 = null;
                if (this.detectedDocType != null && this.detectedDocType.rngLocation != null) {
                    object = this.detectedDocType.rngName;
                    uRL = this.detectedDocType.rngLocation;
                    switch (this.detectedDocType.rngSyntax) {
                        case 1: {
                            string = "application/x-rng";
                            break;
                        }
                        case 2: {
                            string = "application/x-rnc";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    string2 = this.detectedDocType.rncEncoding;
                } else if (LoaderBase.getRelaxngPI(document, this.relaxngInfo)) {
                    object = this.relaxngInfo.name;
                    uRL = this.relaxngInfo.url;
                    switch (this.relaxngInfo.syntax) {
                        case 1: {
                            string = "application/x-rng";
                            break;
                        }
                        case 2: {
                            string = "application/x-rnc";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    string2 = this.relaxngInfo.encoding;
                }
                if (uRL != null) {
                    documentType = this.rngLoader.loadDocumentType(uRL, string, string2);
                    if (documentType == null) {
                        if (this.rngLoader.getDocumentTypeErrors().length > 0) {
                            this.docTypeLoader = this.rngLoader;
                            documentType = UnconstrainedDocumentType.INSTANCE;
                        }
                    } else {
                        this.docTypeLoader = this.rngLoader;
                        this.cacheRNG((String)object, documentType);
                    }
                }
            }
            if (documentType == null && this.detectedDocType != null && this.detectedDocType.dtdPublicId != null) {
                documentType = this.fetchDTD(this.detectedDocType.dtdPublicId);
            }
            if (documentType == null && this.detectedDocType != null && this.detectedDocType.dtdSystemId != null && (object = LoaderBase.createDocTypeSource(this.detectedDocType.dtdPublicId, this.detectedDocType.dtdSystemId)) != null) {
                documentType = this.dtdLoader.loadDocumentTypeForInstance((Document)object);
                if (documentType == null) {
                    if (this.dtdLoader.getDocumentTypeErrors().length > 0) {
                        this.docTypeLoader = this.dtdLoader;
                        documentType = UnconstrainedDocumentType.INSTANCE;
                    }
                } else {
                    this.docTypeLoader = this.dtdLoader;
                    this.cacheDTD((com.xmlmind.xmledit.xsd.dtdtoxsd.DTD)documentType, (Document)object);
                }
            }
            if (documentType == null && this.useSchemaForSchemas) {
                documentType = this.checkSchemaForSchemas(document);
            }
            if (documentType == null && this.useSchemaForRelaxng) {
                documentType = this.checkSchemaForRelaxng(document);
            }
            if (documentType == null && this.useHelperDocumentType) {
                documentType = new HelperDocumentType(document);
            }
        }
        return documentType == UnconstrainedDocumentType.INSTANCE ? null : documentType;
    }

    private DocumentType checkSchemaForSchemas(Document document) {
        XMLSchemaForSchemas xMLSchemaForSchemas = null;
        Name name = document.getRootElement().getName();
        if (name.getNamespace() == Namespace.XSD) {
            xMLSchemaForSchemas = XMLSchemaForSchemas.getInstance();
        }
        return xMLSchemaForSchemas;
    }

    private DocumentType checkSchemaForRelaxng(Document document) {
        DocumentType documentType = null;
        Name name = document.getRootElement().getName();
        if (name.getNamespace() == Namespace.RNG) {
            documentType = RNGSchemaForSchemas.getInstance();
        }
        return documentType;
    }

    private static final Document createDocTypeSource(String string, URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8' ?>\n");
        if (string == null) {
            stringBuffer.append("<!DOCTYPE dummy SYSTEM ");
        } else {
            stringBuffer.append("<!DOCTYPE dummy PUBLIC '" + string + "' ");
        }
        LoaderBase.appendQuoted(stringBuffer, uRL.toExternalForm());
        stringBuffer.append(">\n");
        stringBuffer.append("<dummy/>\n");
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        URL uRL2 = FileUtil.fileToURL("bytes");
        OpenEntity openEntity = new OpenEntity((InputStream)byteArrayInputStream, uRL2.toExternalForm(), uRL2);
        DocumentLoader documentLoader = new DocumentLoader();
        documentLoader.setAddedProperties(32);
        documentLoader.setNamespaceMode(0);
        Document document = null;
        try {
            document = documentLoader.load(openEntity);
        }
        catch (IOException iOException) {}
        return document;
    }

    private DocumentType fetchDTD(String string) {
        DocumentTypeCache documentTypeCache = this.docTypeCache();
        if (documentTypeCache == null) {
            return null;
        }
        DocumentTypeCache.Entry entry = null;
        try {
            entry = documentTypeCache.get(DocumentTypeCache.dtd(string), this.console);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entry == null) {
            return null;
        }
        return entry.getDocumentType();
    }

    private void cacheDTD(com.xmlmind.xmledit.xsd.dtdtoxsd.DTD dTD, Document document) {
        int n;
        int n2;
        String string = dTD.getPublicId();
        if (string == null) {
            return;
        }
        DocumentTypeCache documentTypeCache = this.docTypeCache();
        if (documentTypeCache == null) {
            return;
        }
        DTD dTD2 = (DTD)document.getProperty("DTD");
        if (dTD2 == null) {
            return;
        }
        String string2 = DTDUtil.getGeneralEntities(dTD2);
        if (string2 != null && (n2 = string2.indexOf("<!ENTITY __wrapped_document_element__")) >= 0 && (n = string2.indexOf(62, n2 + 20)) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > 0) {
                stringBuffer.append(string2.substring(0, n2));
            }
            if (n + 1 < string2.length()) {
                stringBuffer.append(string2.substring(n + 1));
            }
            string2 = stringBuffer.toString();
        }
        try {
            documentTypeCache.put(DocumentTypeCache.dtd(string), dTD, string2, this.console);
        }
        catch (IOException iOException) {}
    }

    private static final Document createDocTypeSource(NamespaceURLPair[] namespaceURLPairArray) {
        Document document = new Document();
        Element element = new Element(Name.get("dummy"));
        document.appendChild(element);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while (n < namespaceURLPairArray.length) {
            NamespaceURLPair namespaceURLPair = namespaceURLPairArray[n];
            if (namespaceURLPair.namespace == Namespace.NONE) {
                string = namespaceURLPair.url.toExternalForm();
            } else {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(namespaceURLPair.namespace.getURI());
                stringBuffer.append(' ');
                stringBuffer.append(namespaceURLPair.url.toExternalForm());
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            element.putAttribute(Name.XSI_SCHEMA_LOCATION, stringBuffer.toString());
        }
        if (string != null) {
            element.putAttribute(Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION, string);
        }
        return document;
    }

    private DocumentType fetchWXS(Document document) {
        NamespaceURLPair[] namespaceURLPairArray = LoaderBase.getSchemaLocations(document.getRootElement());
        if (namespaceURLPairArray == null) {
            return null;
        }
        return this.fetchWXS(namespaceURLPairArray);
    }

    private DocumentType fetchWXS(NamespaceURLPair[] namespaceURLPairArray) {
        Object object;
        DocumentTypeCache documentTypeCache = this.docTypeCache();
        if (documentTypeCache == null) {
            return null;
        }
        String[] stringArray = new String[namespaceURLPairArray.length];
        int n = 0;
        while (n < namespaceURLPairArray.length) {
            object = namespaceURLPairArray[n].namespace;
            if (object == Namespace.NONE) {
                return null;
            }
            stringArray[n] = ((Namespace)object).getURI();
            ++n;
        }
        object = null;
        try {
            object = documentTypeCache.get(DocumentTypeCache.wxs(stringArray), this.console);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object == null) {
            return null;
        }
        return ((DocumentTypeCache.Entry)object).getDocumentType();
    }

    private void cacheWXS(Schema schema) {
        DocumentTypeCache documentTypeCache = this.docTypeCache();
        if (documentTypeCache == null) {
            return;
        }
        Namespace[] namespaceArray = SchemaUtil.getTargetNamespaces(schema);
        if (namespaceArray == null || namespaceArray.length == 0) {
            return;
        }
        String[] stringArray = new String[namespaceArray.length];
        int n = 0;
        while (n < namespaceArray.length) {
            Namespace namespace = namespaceArray[n];
            if (namespace == Namespace.NONE) {
                return;
            }
            stringArray[n] = namespace.getURI();
            ++n;
        }
        try {
            documentTypeCache.put(DocumentTypeCache.wxs(stringArray), schema, null, this.console);
        }
        catch (IOException iOException) {}
    }

    private DocumentType fetchRNG(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        DocumentTypeCache documentTypeCache = this.docTypeCache();
        if (documentTypeCache == null) {
            return null;
        }
        DocumentTypeCache.Entry entry = null;
        try {
            entry = documentTypeCache.get(DocumentTypeCache.rng(string), this.console);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entry == null) {
            return null;
        }
        return entry.getDocumentType();
    }

    private void cacheRNG(String string, DocumentType documentType) {
        if (string == null || string.length() == 0) {
            return;
        }
        DocumentTypeCache documentTypeCache = this.docTypeCache();
        if (documentTypeCache == null) {
            return;
        }
        try {
            documentTypeCache.put(DocumentTypeCache.rng(string), documentType, null, this.console);
        }
        catch (IOException iOException) {}
    }

    private static final boolean hasRelaxngPI(Document document) {
        return RelaxngInfo.findPI(document) != null;
    }

    private static final boolean getRelaxngPI(Document document, RelaxngInfo relaxngInfo) {
        ProcessingInstruction processingInstruction = RelaxngInfo.findPI(document);
        if (processingInstruction == null) {
            return false;
        }
        return RelaxngInfo.parsePI(processingInstruction, document.getLocation(), relaxngInfo);
    }

    static {
        NO_DOCUMENT_TYPE_ERRORS = new DocumentTypeError[0];
        START_XML_PI = null;
        END_XML_PI = null;
        ENCODING_NAME = null;
        ENCODING_SPEC = null;
    }

    private static class StopLoadingException
    extends IOException {
        private StopLoadingException() {
        }
    }
}

