/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;

public class MarkChangeEvent {
    public static final int NODE_MARK_ADDED = 0;
    public static final int NODE_MARK_MOVED = 1;
    public static final int NODE_MARK_REMOVED = 2;
    public static final int TEXT_LOCATION_ADDED = 3;
    public static final int TEXT_LOCATION_MOVED = 4;
    public static final int TEXT_LOCATION_REMOVED = 5;
    private MarkManager source;
    private Change[] changes;

    public MarkChangeEvent() {
    }

    public MarkChangeEvent(MarkManager markManager, Change[] changeArray) {
        this.initialize(markManager, changeArray);
    }

    public void initialize(MarkManager markManager, Change[] changeArray) {
        this.source = markManager;
        this.changes = changeArray;
    }

    public MarkManager getSource() {
        return this.source;
    }

    public Change[] getChanges() {
        return this.changes;
    }

    public static final class Change {
        public int type;
        public Mark mark;
        public Node previousLocation;
        public int previousOffset;

        public Change(int n, NodeMark nodeMark, Node node) {
            this.type = n;
            this.mark = nodeMark;
            this.previousLocation = node;
            this.previousOffset = -1;
        }

        public Change(int n, TextLocation textLocation, TextNode textNode, int n2) {
            this.type = n;
            this.mark = textLocation;
            this.previousLocation = textNode;
            this.previousOffset = n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('[');
            switch (this.type) {
                case 0: {
                    stringBuffer.append("NODE_MARK_ADDED");
                    break;
                }
                case 1: {
                    stringBuffer.append("NODE_MARK_MOVED");
                    break;
                }
                case 2: {
                    stringBuffer.append("NODE_MARK_REMOVED");
                    break;
                }
                case 3: {
                    stringBuffer.append("TEXT_LOCATION_ADDED");
                    break;
                }
                case 4: {
                    stringBuffer.append("TEXT_LOCATION_MOVED");
                    break;
                }
                case 5: {
                    stringBuffer.append("TEXT_LOCATION_REMOVED");
                }
            }
            stringBuffer.append(',');
            stringBuffer.append(this.mark);
            stringBuffer.append(',');
            stringBuffer.append(this.previousLocation);
            stringBuffer.append(',');
            stringBuffer.append(this.previousOffset);
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

