/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.ContextChangeEvent;
import com.xmlmind.xmledit.edit.ContextChangeListener;
import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.MarkChangeEvent;
import com.xmlmind.xmledit.edit.MarkChangeListener;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextTransferEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class MarkManager
implements DocumentListener {
    private Document doc;
    private boolean autoAddDot;
    private TextLocation dot = null;
    private TextLocation mark = null;
    private NodeMark selected = null;
    private NodeMark selected2 = null;
    private Hashtable marks = new Hashtable();
    private Mark[] markList = null;
    private int batchMarkingNesting = 0;
    private static final MarkChangeEvent.Change[] NO_CHANGES = new MarkChangeEvent.Change[0];
    private MarkChangeEvent.Change[] changeBatch = NO_CHANGES;
    private MarkChangeListener[] markChangeListeners = new MarkChangeListener[0];
    private ContextChangeListener[] contextChangeListeners = new ContextChangeListener[0];
    private MarkChangeEvent.Change[] changes1 = new MarkChangeEvent.Change[1];
    private MarkChangeEvent markChangeEvent = new MarkChangeEvent();
    private ContextChangeEvent contextChangeEvent = new ContextChangeEvent();
    private Traversal.TextNodeMatcher textNodeMatcher = new Traversal.TextNodeMatcher();

    public MarkManager() {
        this(null, true);
    }

    public MarkManager(Document document) {
        this(document, true);
    }

    public MarkManager(Document document, boolean bl) {
        this.autoAddDot = bl;
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        if (this.doc != null) {
            this.removeAll();
            this.doc.removeDocumentListener(this);
            this.doc = null;
        }
        if (document != null) {
            this.doc = document;
            document.addDocumentListener(this, false);
            if (this.autoAddDot) {
                this.autoAddDot(this.doc.getRootElement());
            }
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setAutoAddingDot(boolean bl) {
        this.autoAddDot = bl;
        if (bl && this.getDot() == null && this.doc != null) {
            this.autoAddDot(this.doc.getRootElement());
        }
    }

    private void autoAddDot(Node node) {
        TextNode textNode = (TextNode)Traversal.traverse(node, Traversal.textNodeFinder);
        if (textNode != null) {
            this.add("DOT", textNode, 0, true);
        }
    }

    public boolean isAutoAddingDot() {
        return this.autoAddDot;
    }

    public NodeMark set(Object object, Node node) {
        NodeMark nodeMark = (NodeMark)this.get(object);
        if (nodeMark != null) {
            nodeMark.moveTo(node);
        } else {
            nodeMark = new NodeMark(object, node);
            this.add(nodeMark);
        }
        return nodeMark;
    }

    public TextLocation set(Object object, TextNode textNode, int n) {
        return this.set(object, textNode, n, false);
    }

    public TextLocation set(Object object, TextNode textNode, int n, boolean bl) {
        TextLocation textLocation = (TextLocation)this.get(object);
        if (textLocation != null) {
            textLocation.moveTo(textNode, n);
        } else {
            textLocation = new TextLocation(object, textNode, n, bl);
            this.add(textLocation);
        }
        return textLocation;
    }

    public NodeMark add(Object object, Node node) {
        if (this.get(object) != null) {
            return null;
        }
        NodeMark nodeMark = new NodeMark(object, node);
        this.add(nodeMark);
        return nodeMark;
    }

    public TextLocation add(Object object, TextNode textNode, int n) {
        return this.add(object, textNode, n, false);
    }

    public TextLocation add(Object object, TextNode textNode, int n, boolean bl) {
        if (this.get(object) != null) {
            return null;
        }
        TextLocation textLocation = new TextLocation(object, textNode, n, bl);
        this.add(textLocation);
        return textLocation;
    }

    private void add(Mark mark) {
        if (mark.id == "DOT") {
            this.dot = (TextLocation)mark;
        } else if (mark.id == "MARK") {
            this.mark = (TextLocation)mark;
        } else if (mark.id == "SELECTED") {
            this.selected = (NodeMark)mark;
        } else if (mark.id == "SELECTED2") {
            this.selected2 = (NodeMark)mark;
        } else {
            this.marks.put(mark.id, mark);
        }
        this.markList = null;
        mark.manager = this;
        this.markAdded(mark);
    }

    public Mark remove(Object object) {
        Mark mark;
        if (object == "DOT") {
            mark = this.dot;
            this.dot = null;
        } else if (object == "MARK") {
            mark = this.mark;
            this.mark = null;
        } else if (object == "SELECTED") {
            mark = this.selected;
            this.selected = null;
        } else if (object == "SELECTED2") {
            mark = this.selected2;
            this.selected2 = null;
        } else {
            mark = (Mark)this.marks.remove(object);
        }
        if (mark != null) {
            this.markList = null;
            mark.manager = null;
            this.markRemoved(mark);
        }
        return mark;
    }

    public void removeAll(Object object, Object object2) {
        Mark[] markArray = this.getAll();
        int n = 0;
        while (n < markArray.length) {
            Mark mark = markArray[n];
            Object object3 = mark.getProperty(object);
            if (object3 != null && object3.equals(object2)) {
                this.remove(mark.id);
            }
            ++n;
        }
    }

    public void removeAll() {
        Mark[] markArray = this.getAll();
        int n = 0;
        while (n < markArray.length) {
            this.remove(markArray[n].id);
            ++n;
        }
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public int getCount() {
        Mark[] markArray = this.getAll();
        return markArray.length;
    }

    public TextLocation getDot() {
        return this.dot;
    }

    public TextLocation getMark() {
        return this.mark;
    }

    public NodeMark getSelected() {
        return this.selected;
    }

    public NodeMark getSelected2() {
        return this.selected2;
    }

    public Mark get(Object object) {
        if (object == "DOT") {
            return this.dot;
        }
        if (object == "MARK") {
            return this.mark;
        }
        if (object == "SELECTED") {
            return this.selected;
        }
        if (object == "SELECTED2") {
            return this.selected2;
        }
        return (Mark)this.marks.get(object);
    }

    public Mark[] getAll() {
        if (this.markList == null) {
            int n = 0;
            if (this.dot != null) {
                ++n;
            }
            if (this.mark != null) {
                ++n;
            }
            if (this.selected != null) {
                ++n;
            }
            if (this.selected2 != null) {
                ++n;
            }
            int n2 = this.marks.size();
            this.markList = new Mark[n + n2];
            n = 0;
            if (this.dot != null) {
                this.markList[n++] = this.dot;
            }
            if (this.mark != null) {
                this.markList[n++] = this.mark;
            }
            if (this.selected != null) {
                this.markList[n++] = this.selected;
            }
            if (this.selected2 != null) {
                this.markList[n++] = this.selected2;
            }
            if (n2 > 0) {
                Enumeration enumeration = this.marks.elements();
                while (enumeration.hasMoreElements()) {
                    this.markList[n++] = (Mark)enumeration.nextElement();
                }
            }
        }
        return this.markList;
    }

    public void beginBatchMarking() {
        if (this.batchMarkingNesting == 0) {
            this.changeBatch = NO_CHANGES;
        }
        ++this.batchMarkingNesting;
    }

    public void endBatchMarking() {
        if (this.batchMarkingNesting > 0) {
            --this.batchMarkingNesting;
            if (this.batchMarkingNesting == 0 && this.changeBatch.length > 0) {
                this.notifyMarkChangeListeners(this.changeBatch);
                this.changeBatch = NO_CHANGES;
            }
        }
    }

    private void markAdded(Mark mark) {
        MarkChangeEvent.Change change;
        switch (mark.getType()) {
            case 0: {
                change = new MarkChangeEvent.Change(0, (NodeMark)mark, null);
                break;
            }
            case 1: {
                change = new MarkChangeEvent.Change(3, (TextLocation)mark, null, -1);
                break;
            }
            default: {
                throw new RuntimeException("internal error: unknown mark type");
            }
        }
        if (this.batchMarkingNesting == 0) {
            this.notifyMarkChangeListeners(change);
        } else {
            this.addChangeToBatch(change);
        }
    }

    private void addChangeToBatch(MarkChangeEvent.Change change) {
        MarkChangeEvent.Change[] changeArray = new MarkChangeEvent.Change[this.changeBatch.length + 1];
        if (this.changeBatch.length > 0) {
            System.arraycopy(this.changeBatch, 0, changeArray, 0, this.changeBatch.length);
        }
        changeArray[this.changeBatch.length] = change;
        this.changeBatch = changeArray;
    }

    private void markRemoved(Mark mark) {
        MarkChangeEvent.Change change;
        switch (mark.getType()) {
            case 0: {
                change = new MarkChangeEvent.Change(2, (NodeMark)mark, null);
                break;
            }
            case 1: {
                change = new MarkChangeEvent.Change(5, (TextLocation)mark, null, -1);
                break;
            }
            default: {
                throw new RuntimeException("internal error: unknown mark type");
            }
        }
        if (this.batchMarkingNesting == 0) {
            this.notifyMarkChangeListeners(change);
        } else {
            this.addChangeToBatch(change);
        }
    }

    void markMoved(NodeMark nodeMark, Node node) {
        MarkChangeEvent.Change change = new MarkChangeEvent.Change(1, nodeMark, node);
        if (this.batchMarkingNesting == 0) {
            this.notifyMarkChangeListeners(change);
        } else {
            this.addChangeToBatch(change);
        }
    }

    void markMoved(TextLocation textLocation, TextNode textNode, int n) {
        MarkChangeEvent.Change change = new MarkChangeEvent.Change(4, textLocation, textNode, n);
        if (this.batchMarkingNesting == 0) {
            this.notifyMarkChangeListeners(change);
        } else {
            this.addChangeToBatch(change);
        }
    }

    public void addMarkChangeListener(MarkChangeListener markChangeListener) {
        if (this.indexOfMarkChangeListener(markChangeListener) >= 0) {
            return;
        }
        MarkChangeListener[] markChangeListenerArray = new MarkChangeListener[this.markChangeListeners.length + 1];
        if (this.markChangeListeners.length > 0) {
            System.arraycopy(this.markChangeListeners, 0, markChangeListenerArray, 0, this.markChangeListeners.length);
        }
        markChangeListenerArray[this.markChangeListeners.length] = markChangeListener;
        this.markChangeListeners = markChangeListenerArray;
    }

    public void removeMarkChangeListener(MarkChangeListener markChangeListener) {
        int n;
        int n2;
        int n3 = this.indexOfMarkChangeListener(markChangeListener);
        if (n3 < 0) {
            return;
        }
        MarkChangeListener[] markChangeListenerArray = new MarkChangeListener[this.markChangeListeners.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.markChangeListeners, 0, markChangeListenerArray, 0, n3);
        }
        if ((n2 = this.markChangeListeners.length - (n = n3 + 1)) > 0) {
            System.arraycopy(this.markChangeListeners, n, markChangeListenerArray, n3, n2);
        }
        this.markChangeListeners = markChangeListenerArray;
    }

    private int indexOfMarkChangeListener(MarkChangeListener markChangeListener) {
        int n = 0;
        while (n < this.markChangeListeners.length) {
            if (this.markChangeListeners[n] == markChangeListener) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void notifyMarkChangeListeners(MarkChangeEvent.Change change) {
        this.changes1[0] = change;
        this.notifyMarkChangeListeners(this.changes1);
    }

    private void notifyMarkChangeListeners(MarkChangeEvent.Change[] changeArray) {
        if ((changeArray = this.compressChanges(changeArray)).length == 0) {
            return;
        }
        this.markChangeEvent.initialize(this, changeArray);
        MarkChangeListener[] markChangeListenerArray = this.markChangeListeners;
        int n = 0;
        while (n < markChangeListenerArray.length) {
            markChangeListenerArray[n].markChanged(this.markChangeEvent);
            ++n;
        }
        this.notifyContextChangeListeners(changeArray);
    }

    /*
     * Unable to fully structure code
     */
    private MarkChangeEvent.Change[] compressChanges(MarkChangeEvent.Change[] var1_1) {
        var2_2 = var1_1.length;
        if (var2_2 <= 1) {
            return var1_1;
        }
        var3_3 = 0;
        while (var3_3 < var2_2) {
            var4_4 = var1_1[var3_3];
            block0 : switch (var4_4.type) {
                case 1: 
                case 4: {
                    var5_6 = var4_4.mark.id;
                    var6_8 = var4_4;
                    var7_10 = var3_3 + 1;
                    while (var7_10 < var2_2) {
                        var8_12 = var1_1[var7_10];
                        if (var8_12.mark.id.equals(var5_6)) {
                            switch (var8_12.type) {
                                case 1: 
                                case 4: {
                                    var8_12.previousLocation = var6_8.previousLocation;
                                    var8_12.previousOffset = var6_8.previousOffset;
                                    var6_8.type = -1;
                                    var6_8 = var8_12;
                                    break;
                                }
                                case 2: 
                                case 5: {
                                    var6_8.type = -1;
                                    break block0;
                                }
                            }
                        }
                        ++var7_10;
                    }
                    break;
                }
            }
            ++var3_3;
        }
        var4_5 = 0;
        while (var4_5 < var2_2) {
            var5_6 = var1_1[var4_5];
            switch (var5_6.type) {
                case 0: 
                case 3: {
                    var6_8 = var5_6.mark.id;
                    var7_10 = -1;
                    var8_13 = var4_5 + 1;
                    block16: while (var8_13 < var2_2) {
                        var9_15 = var1_1[var8_13];
                        if (!var9_15.mark.id.equals(var6_8)) ** GOTO lbl-1000
                        switch (var9_15.type) {
                            case 2: 
                            case 5: {
                                var7_10 = var8_13;
                                break block16;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                ++var8_13;
                            }
                        }
                    }
                    if (var7_10 < 0) break;
                    var5_6.type = -1;
                    var9_16 = var4_5 + 1;
                    while (var9_16 <= var7_10) {
                        var10_17 = var1_1[var9_16];
                        if (var10_17.mark.id.equals(var6_8)) {
                            var10_17.type = -1;
                        }
                        ++var9_16;
                    }
                    break;
                }
            }
            ++var4_5;
        }
        var5_7 = 0;
        var6_9 = 0;
        while (var6_9 < var2_2) {
            if (var1_1[var6_9].type != -1) {
                ++var5_7;
            }
            ++var6_9;
        }
        if (var5_7 == var2_2) {
            return var1_1;
        }
        if (var5_7 == 0) {
            return MarkManager.NO_CHANGES;
        }
        var7_11 = new MarkChangeEvent.Change[var5_7];
        var5_7 = 0;
        var8_14 = 0;
        while (var8_14 < var2_2) {
            if (var1_1[var8_14].type != -1) {
                var7_11[var5_7++] = var1_1[var8_14];
            }
            ++var8_14;
        }
        return var7_11;
    }

    public void addContextChangeListener(ContextChangeListener contextChangeListener) {
        if (this.indexOfContextChangeListener(contextChangeListener) >= 0) {
            return;
        }
        ContextChangeListener[] contextChangeListenerArray = new ContextChangeListener[this.contextChangeListeners.length + 1];
        if (this.contextChangeListeners.length > 0) {
            System.arraycopy(this.contextChangeListeners, 0, contextChangeListenerArray, 0, this.contextChangeListeners.length);
        }
        contextChangeListenerArray[this.contextChangeListeners.length] = contextChangeListener;
        this.contextChangeListeners = contextChangeListenerArray;
    }

    public void removeContextChangeListener(ContextChangeListener contextChangeListener) {
        int n;
        int n2;
        int n3 = this.indexOfContextChangeListener(contextChangeListener);
        if (n3 < 0) {
            return;
        }
        ContextChangeListener[] contextChangeListenerArray = new ContextChangeListener[this.contextChangeListeners.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.contextChangeListeners, 0, contextChangeListenerArray, 0, n3);
        }
        if ((n2 = this.contextChangeListeners.length - (n = n3 + 1)) > 0) {
            System.arraycopy(this.contextChangeListeners, n, contextChangeListenerArray, n3, n2);
        }
        this.contextChangeListeners = contextChangeListenerArray;
    }

    private int indexOfContextChangeListener(ContextChangeListener contextChangeListener) {
        int n = 0;
        while (n < this.contextChangeListeners.length) {
            if (this.contextChangeListeners[n] == contextChangeListener) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void notifyContextChangeListeners(MarkChangeEvent.Change[] changeArray) {
        boolean bl = false;
        int n = 0;
        block5: while (n < changeArray.length) {
            MarkChangeEvent.Change change = changeArray[n];
            switch (change.type) {
                case 0: 
                case 1: 
                case 2: {
                    Object object = change.mark.id;
                    if (object != "SELECTED" && object != "SELECTED2") break;
                    bl = true;
                    break block5;
                }
                case 3: 
                case 5: {
                    Object object = (TextLocation)change.mark;
                    Object object2 = ((TextLocation)object).id;
                    if (object2 != "DOT" && object2 != "MARK") break;
                    bl = true;
                    break block5;
                }
                case 4: {
                    int n2;
                    TextLocation textLocation;
                    Object object = (TextLocation)change.mark;
                    Object object2 = ((TextLocation)object).id;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (object2 == "DOT") {
                        textLocation = this.getMark();
                        bl2 = textLocation != null && (change.previousLocation != textLocation.text || change.previousOffset != textLocation.offset);
                        boolean bl4 = bl3 = textLocation != null && (((TextLocation)object).text != textLocation.text || ((TextLocation)object).offset != textLocation.offset);
                        if (bl3 && bl2 && ((TextLocation)object).text == change.previousLocation) {
                            n2 = ((TextLocation)object).text.getTextLength();
                            if (change.previousOffset == 0 || change.previousOffset == n2 || ((TextLocation)object).offset == 0 || ((TextLocation)object).offset == n2) {
                                bl = true;
                                break block5;
                            }
                        }
                    } else if (object2 == "MARK") {
                        textLocation = this.getDot();
                        bl2 = textLocation != null && (change.previousLocation != textLocation.text || change.previousOffset != textLocation.offset);
                        boolean bl5 = bl3 = textLocation != null && (((TextLocation)object).text != textLocation.text || ((TextLocation)object).offset != textLocation.offset);
                        if (bl3 && bl2 && ((TextLocation)object).text == change.previousLocation) {
                            n2 = ((TextLocation)object).text.getTextLength();
                            if (change.previousOffset == 0 || change.previousOffset == n2 || ((TextLocation)object).offset == 0 || ((TextLocation)object).offset == n2) {
                                bl = true;
                                break block5;
                            }
                        }
                    }
                    if (bl3 != bl2) {
                        bl = true;
                        break block5;
                    }
                    if (object2 == "DOT") {
                        if (((TextLocation)object).text == change.previousLocation) break;
                        bl = true;
                        break block5;
                    }
                    if (object2 != "MARK" || !bl3 || ((TextLocation)object).text == change.previousLocation) break;
                    bl = true;
                    break block5;
                }
            }
            ++n;
        }
        if (bl) {
            this.notifyContextChangeListeners(false);
        }
    }

    public void notifyContextChangeListeners() {
        this.notifyContextChangeListeners(true);
    }

    private void notifyContextChangeListeners(boolean bl) {
        this.contextChangeEvent.initialize(this, bl);
        ContextChangeListener[] contextChangeListenerArray = this.contextChangeListeners;
        int n = 0;
        while (n < contextChangeListenerArray.length) {
            contextChangeListenerArray[n].contextChanged(this.contextChangeEvent);
            ++n;
        }
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        this.beginBatchMarking();
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        this.endBatchMarking();
    }

    public void textChanged(TextEvent textEvent, int n) {
        TextNode textNode = textEvent.getTextSource();
        int n2 = textEvent.getOffset();
        Mark[] markArray = this.getAll();
        int n3 = 0;
        while (n3 < markArray.length) {
            if (markArray[n3].getType() == 1) {
                TextLocation textLocation = (TextLocation)markArray[n3];
                if (textLocation.text == textNode && textLocation.offset >= n2) {
                    int n4 = 0;
                    int n5 = 0;
                    switch (textEvent.getId()) {
                        case 0: {
                            n4 = textEvent.getNewString().length();
                            textLocation.moveTo(textNode, textLocation.offset + n4);
                            break;
                        }
                        case 1: {
                            n4 = textEvent.getNewString().length();
                        }
                        case 2: {
                            n5 = textEvent.getOldString().length();
                            if (n2 + n5 <= textLocation.offset) {
                                textLocation.moveTo(textNode, textLocation.offset - n5 + n4);
                                break;
                            }
                            if (textLocation.cursor) {
                                textLocation.moveTo(textNode, n2 + n4);
                                break;
                            }
                            this.remove(textLocation);
                        }
                    }
                }
            }
            ++n3;
        }
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
        if (!(documentEvent instanceof TextTransferEvent)) {
            return;
        }
        TextTransferEvent textTransferEvent = (TextTransferEvent)documentEvent;
        Mark[] markArray = this.getAll();
        int n2 = 0;
        while (n2 < markArray.length) {
            if (markArray[n2].getType() == 1) {
                TextLocation textLocation = (TextLocation)markArray[n2];
                if (textLocation.cursor) {
                    int n3;
                    if (textLocation.text == textTransferEvent.srcText) {
                        textLocation.moveTo(textTransferEvent.dstText, textTransferEvent.dstOffset + (textLocation.offset - textTransferEvent.srcOffset));
                    } else if (textLocation.text == textTransferEvent.dstText && textTransferEvent.dstOffset + textTransferEvent.charCount == (n3 = textTransferEvent.dstText.getTextLength()) && textLocation.offset == n3) {
                        textLocation.moveTo(textTransferEvent.dstText, textTransferEvent.dstOffset);
                    }
                }
            }
            ++n2;
        }
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        switch (elementStructureEvent.getId()) {
            case 10: {
                if (!this.autoAddDot || this.getDot() != null) break;
                this.autoAddDot(elementStructureEvent.getNewChild());
                break;
            }
            case 11: 
            case 12: {
                Mark[] markArray = this.getAll();
                Node node = elementStructureEvent.getOldChild();
                int n2 = 0;
                while (n2 < markArray.length) {
                    switch (markArray[n2].getType()) {
                        case 0: {
                            Mark mark = (NodeMark)markArray[n2];
                            if (mark.marked != node) break;
                            this.remove(mark.id);
                            break;
                        }
                        case 1: {
                            Mark mark = (TextLocation)markArray[n2];
                            this.textNodeMatcher.searchedNode = ((TextLocation)mark).text;
                            if (Traversal.traverse(node, this.textNodeMatcher) == null) break;
                            if (((TextLocation)mark).cursor) {
                                this.moveCursor((TextLocation)mark, elementStructureEvent);
                                break;
                            }
                            this.remove(((TextLocation)mark).id);
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
    }

    private void moveCursor(TextLocation textLocation, ElementStructureEvent elementStructureEvent) {
        int n;
        Element element = elementStructureEvent.getElementSource();
        Node node = elementStructureEvent.getBeforeChild();
        TextNode textNode = node == null ? ((node = element.getLastChild()) == null ? (TextNode)Traversal.traverseBefore(element, Traversal.textNodeFinder) : (TextNode)Traversal.traverseBackwardsFrom(node, Traversal.textNodeFinder)) : (TextNode)Traversal.traverseBefore(node, Traversal.textNodeFinder);
        if (textNode == null) {
            textNode = (TextNode)Traversal.traverseFrom(element, Traversal.textNodeFinder);
            n = 0;
        } else {
            n = textNode.getTextLength();
        }
        if (textNode == null) {
            this.remove(textLocation.id);
        } else {
            textLocation.moveTo(textNode, n);
        }
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
    }
}

