/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.Mark;
import java.util.Stack;

public final class NodeMark
extends Mark {
    Node marked;
    private Stack stack = null;

    NodeMark(Object object, Node node) {
        super(object);
        this.marked = node;
    }

    public int getType() {
        return 0;
    }

    public Node getNode() {
        return this.marked;
    }

    public boolean moveTo(Node node) {
        if (!this.doMoveTo(node)) {
            return false;
        }
        this.popAll();
        return true;
    }

    private void popAll() {
        if (this.stack != null) {
            while (!this.stack.empty()) {
                this.stack.pop();
            }
        }
    }

    private boolean doMoveTo(Node node) {
        if (node == this.marked) {
            return false;
        }
        Node node2 = this.marked;
        this.marked = node;
        if (this.manager != null) {
            this.manager.markMoved(this, node2);
        }
        return true;
    }

    public boolean moveToParent() {
        Element element = this.marked.getParentElement();
        if (element == null) {
            return false;
        }
        this.push(this.marked);
        return this.doMoveTo(element);
    }

    private void push(Node node) {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        this.stack.push(node);
    }

    public boolean moveToChild() {
        Node node = this.pop();
        if (node == null) {
            if (this.marked.getNodeType() != 4) {
                return false;
            }
            Node node2 = ((Element)this.marked).getFirstChild();
            if (node2 == null) {
                return false;
            }
            return this.doMoveTo(node2);
        }
        return this.doMoveTo(node);
    }

    private Node pop() {
        if (this.stack == null || this.stack.empty()) {
            return null;
        }
        Node node = (Node)this.stack.peek();
        this.stack.pop();
        return node;
    }

    public boolean moveToPreviousSibling() {
        Node node = this.marked.getPreviousSibling();
        if (node == null || this.marked.getParentElement() == null) {
            return false;
        }
        return this.moveTo(node);
    }

    public boolean moveToNextSibling() {
        Node node = this.marked.getNextSibling();
        if (node == null || this.marked.getParentElement() == null) {
            return false;
        }
        return this.moveTo(node);
    }

    public int getPreviouslyMarkedChildCount() {
        return this.stack == null ? 0 : this.stack.size();
    }

    public Node getPreviouslyMarkedChild(int n) {
        if (this.stack == null) {
            return null;
        }
        int n2 = this.stack.size();
        int n3 = n2 - 1 - n;
        if (n3 < 0 || n3 >= n2) {
            return null;
        }
        return (Node)this.stack.elementAt(n3);
    }
}

