/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.TextOffset;

public final class PositionToTextOffset
extends Traversal.HandlerBase {
    private int searchedPosition;
    private boolean fromEnd;
    private int position;
    public static final PositionToTextOffset INSTANCE = new PositionToTextOffset();

    public TextOffset getFromBegin(Document document, int n) {
        return this.get(document, n, false);
    }

    public TextOffset getFromEnd(Document document, int n) {
        return this.get(document, n, true);
    }

    public TextOffset get(Document document, int n, boolean bl) {
        if (document == null) {
            return null;
        }
        this.searchedPosition = n;
        this.fromEnd = bl;
        this.position = 0;
        if (bl) {
            return (TextOffset)Traversal.traverseBackwards(document.getRootElement(), this);
        }
        return (TextOffset)Traversal.traverse(document.getRootElement(), this);
    }

    public Object processText(Text text) {
        return this.processTextNode(text);
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return this.processTextNode(processingInstruction);
    }

    public Object processComment(Comment comment) {
        return this.processTextNode(comment);
    }

    private Object processTextNode(TextNode textNode) {
        int n = textNode.getTextLength();
        if (this.searchedPosition >= this.position && this.searchedPosition < this.position + ++n) {
            TextOffset textOffset = new TextOffset();
            textOffset.text = textNode;
            textOffset.offset = this.fromEnd ? n - 1 - (this.searchedPosition - this.position) : this.searchedPosition - this.position;
            return textOffset;
        }
        this.position += n;
        return null;
    }
}

