/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.edit.RelaxngSyntax;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;

class RelaxngInfo
implements RelaxngSyntax {
    public static final String PI_TARGET = "xxe-relaxng-schema";
    public String name;
    public URL url;
    public int syntax;
    public String encoding;

    RelaxngInfo() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ProcessingInstruction findPI(Document document) {
        Node node = document.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 2: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    if (!PI_TARGET.equals(processingInstruction.getTarget())) break;
                    return processingInstruction;
                }
                case 4: {
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parsePI(ProcessingInstruction processingInstruction, URL uRL, RelaxngInfo relaxngInfo) {
        relaxngInfo.name = null;
        relaxngInfo.url = null;
        relaxngInfo.syntax = 0;
        relaxngInfo.encoding = null;
        String[] stringArray = processingInstruction.getPseudoAttributes();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1].trim();
            if (string2.length() == 0) {
                return false;
            }
            if ("location".equals(string)) {
                String string3 = XMLUtil.unescapeXML(string2);
                try {
                    relaxngInfo.url = XMLCatalogs.resolveURI(string3, uRL);
                }
                catch (MalformedURLException malformedURLException) {}
            } else if ("name".equals(string)) {
                relaxngInfo.name = XMLUtil.unescapeXML(string2);
            } else if ("compactSyntax".equals(string)) {
                if ("true".equals(string2)) {
                    relaxngInfo.syntax = 2;
                } else {
                    if (!"false".equals(string2)) return false;
                    relaxngInfo.syntax = 1;
                }
            } else if ("encoding".equals(string)) {
                relaxngInfo.encoding = XMLUtil.unescapeXML(string2);
            }
            n += 2;
        }
        if (relaxngInfo.url == null) return false;
        return true;
    }
}

