/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.jclark.xml.parse.NotWellFormedException;
import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doc.XNodeSelector;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.DocumentTypeCache;
import com.xmlmind.xmledit.edit.DocumentTypeDetector;
import com.xmlmind.xmledit.edit.LoaderBase;
import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public final class ResourceScanner {
    public static final int ENTITY_RESOURCE = 0;
    public static final int XINCLUDE_RESOURCE = 1;
    public static final int APPLICATION_RESOURCE = 2;
    private LoaderBase loader = new LoaderBase();
    private XNodeSelector[] resourceSelectors = null;
    private String[] errors;
    private static final Name XI_INCLUDE_NAME = Name.get("xi:include");
    private static final Name HREF_NAME = Name.get("href");
    private static final Name XPOINTER_NAME = Name.get("xpointer");
    private static final Name PARSE_NAME = Name.get("parse");
    private static final Name ENCODING_NAME = Name.get("encoding");

    public ResourceScanner() {
        this.loader.setAddingInclusionInfo(true);
        this.loader.getDocumentLoader().setKeepEntityPIs(true);
    }

    public void setDocumentTypeCache(DocumentTypeCache documentTypeCache) {
        this.loader.setDocumentTypeCache(documentTypeCache);
    }

    public DocumentTypeCache getDocumentTypeCache() {
        return this.loader.getDocumentTypeCache();
    }

    public void setDocumentTypeDetector(DocumentTypeDetector documentTypeDetector) {
        this.loader.setDocumentTypeDetector(documentTypeDetector);
    }

    public DocumentTypeDetector getDocumentTypeDetector() {
        return this.loader.getDocumentTypeDetector();
    }

    public void setResourceSelectors(XNodeSelector[] xNodeSelectorArray) {
        if (xNodeSelectorArray != null && xNodeSelectorArray.length == 0) {
            xNodeSelectorArray = null;
        }
        this.resourceSelectors = xNodeSelectorArray;
    }

    public XNodeSelector[] getResourceSelectors() {
        return this.resourceSelectors;
    }

    public Resource[] scan(File file) throws IOException {
        return this.scan(FileUtil.fileToURL(file));
    }

    public Resource[] scan(URL uRL) throws IOException {
        ArrayList arrayList = new ArrayList();
        URL uRL2 = uRL;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.scan(uRL, uRL2, hashMap, hashMap2, arrayList);
        Resource[] resourceArray = new Resource[hashMap.size()];
        hashMap.values().toArray(resourceArray);
        this.errors = new String[arrayList.size()];
        arrayList.toArray(this.errors);
        return resourceArray;
    }

    public String[] getErrors() {
        return this.errors;
    }

    private void scan(URL uRL, URL uRL2, HashMap hashMap, HashMap hashMap2, ArrayList arrayList) throws IOException {
        if (hashMap2.containsKey(uRL)) {
            return;
        }
        hashMap2.put(uRL, uRL);
        Document document = this.loader.load(uRL);
        this.trimDocumentElementEntityPI(document);
        ResourceScanner.scanExternalEntities(document, uRL2, hashMap);
        if (this.resourceSelectors != null) {
            this.scanAppResources(document, uRL2, hashMap);
        }
        this.scanXIncludes(document, uRL2, hashMap, hashMap2, arrayList);
    }

    private void trimDocumentElementEntityPI(Document document) {
        String string = this.loader.getDocumentElementEntityName();
        if (string == null) {
            return;
        }
        int n = 0;
        Node node = document.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node instanceof ProcessingInstruction) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                String string2 = processingInstruction.getTarget();
                if (string2.equals("BEGIN_ENTITY")) {
                    if (n == 0) {
                        if (!string.equals(ResourceScanner.entityName(processingInstruction))) break;
                        document.removeChild(processingInstruction);
                    }
                    ++n;
                } else if (string2.equals("END_ENTITY") && --n == 0) {
                    document.removeChild(processingInstruction);
                    break;
                }
            }
            node = node2;
        }
    }

    private static String entityName(ProcessingInstruction processingInstruction) {
        String string = processingInstruction.getText();
        int n = string.indexOf(10);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static void scanExternalEntities(Tree tree, URL uRL, HashMap hashMap) {
        Node node = tree.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getNodeType()) {
                case 2: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    if (!processingInstruction.getTarget().equals("BEGIN_ENTITY")) break;
                    node2 = ResourceScanner.processEntityPI(processingInstruction, uRL, hashMap);
                    break;
                }
                case 4: {
                    ResourceScanner.scanExternalEntities((Element)node, uRL, hashMap);
                }
            }
            node = node2;
        }
    }

    private static Node processEntityPI(ProcessingInstruction processingInstruction, URL uRL, HashMap hashMap) {
        boolean bl;
        String[] stringArray = StringUtil.split(processingInstruction.getText(), '\n');
        if (stringArray.length != 4) {
            return processingInstruction.getNextSibling();
        }
        String string = stringArray[2];
        boolean bl2 = bl = stringArray[3].length() != 0;
        if (bl) {
            return ResourceScanner.deleteEntityPI(processingInstruction);
        }
        URL uRL2 = processingInstruction.getParent().getLocation();
        Resource resource = ResourceScanner.createResource(0, string, uRL2, uRL);
        if (resource == null) {
            return processingInstruction.getNextSibling();
        }
        ResourceScanner.addResource(hashMap, resource);
        if (ResourceScanner.isAbsoluteSystemId(string)) {
            return ResourceScanner.deleteEntityPI(processingInstruction);
        }
        return processingInstruction.getNextSibling();
    }

    private static Resource createResource(int n, String string, URL uRL, URL uRL2) {
        URL uRL3 = null;
        try {
            uRL3 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL3 != null) {
            if (uRL3.getProtocol().equals("file") && uRL2.getProtocol().equals("file")) {
                return new Resource(n, uRL3.getPath(), uRL2);
            }
            return new Resource(n, uRL3.toExternalForm(), uRL2);
        }
        try {
            uRL3 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL3 == null) {
            return null;
        }
        if (!URLUtil.getRoot(uRL3, true).equals(URLUtil.getRoot(uRL2, true))) {
            return new Resource(n, uRL3.toExternalForm(), uRL2);
        }
        String string2 = URLUtil.getRelativeRawPath(uRL3, uRL2, false);
        return new Resource(n, string2, uRL2);
    }

    private static void addResource(HashMap hashMap, Resource resource) {
        if (resource.getLocation().equals(resource.getScannedURL())) {
            return;
        }
        hashMap.put(resource.getSystemId(), resource);
    }

    private static boolean isAbsoluteSystemId(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL != null;
    }

    private static Node deleteEntityPI(ProcessingInstruction processingInstruction) {
        Node node = null;
        int n = 0;
        Tree tree = processingInstruction.getParent();
        Node node2 = processingInstruction;
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            tree.removeChild(node2);
            if (node2 instanceof ProcessingInstruction) {
                String string = node2.getTarget();
                if (string.equals("BEGIN_ENTITY")) {
                    ++n;
                } else if (string.equals("END_ENTITY") && --n == 0) {
                    node = node3;
                    break;
                }
            }
            node2 = node3;
        }
        return node;
    }

    private void scanAppResources(Document document, URL uRL, HashMap hashMap) {
        Element element = document.getRootElement();
        int n = 0;
        while (n < this.resourceSelectors.length) {
            XNode[] xNodeArray = this.resourceSelectors[n].select(element);
            int n2 = 0;
            while (n2 < xNodeArray.length) {
                Object object;
                XNode xNode = xNodeArray[n2];
                String string = null;
                URL uRL2 = null;
                if (xNode instanceof Attribute) {
                    object = (Attribute)xNode;
                    string = ((Attribute)object).value;
                    uRL2 = ((Attribute)object).element.getLocation();
                } else if (xNode instanceof Element) {
                    object = (Element)xNode;
                    string = ((Element)object).getText();
                    uRL2 = ((Tree)object).getLocation();
                }
                if (string != null && (string = string.trim()).length() == 0) {
                    string = null;
                }
                if (string != null && (object = ResourceScanner.createResource(2, string, uRL2, uRL)) != null) {
                    ResourceScanner.addResource(hashMap, (Resource)object);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void scanXIncludes(Document document, URL uRL, HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        Name name = DocumentTypeUtil.isNamespaceAware(document) ? Name.XI_INCLUDE : XI_INCLUDE_NAME;
        this.doScanXIncludes(document, name, uRL, hashMap, hashMap2, arrayList);
    }

    private void doScanXIncludes(Tree tree, Name name, URL uRL, HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        Node node = tree.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element = (Element)node;
                if (element.getName() == name) {
                    this.processXInclude(element, uRL, hashMap, hashMap2, arrayList);
                } else {
                    this.doScanXIncludes(element, name, uRL, hashMap, hashMap2, arrayList);
                }
            }
            node = node.getNextSibling();
        }
    }

    private void processXInclude(Element element, URL uRL, HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        Resource resource;
        boolean bl;
        String string;
        String string2;
        int n;
        String string3 = element.getAnyURIAttribute(HREF_NAME, null);
        String string4 = null;
        if (string3 != null && (n = string3.lastIndexOf(35)) >= 0) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        if ((string2 = element.getAttribute(XPOINTER_NAME)) == null && string4 != null) {
            string2 = string4;
            string4 = null;
        }
        if ((string = element.getAttribute(PARSE_NAME)) == null) {
            bl = false;
        } else if ("text".equals(string = string.trim())) {
            bl = true;
        } else if ("xml".equals(string)) {
            bl = false;
        } else {
            return;
        }
        if (bl) {
            if (string2 != null) {
                return;
            }
            if (string3 == null) {
                return;
            }
        } else if (string3 == null) {
            if (string2 == null) {
                return;
            }
            string3 = "";
        } else if (string4 != null) {
            return;
        }
        if ((resource = ResourceScanner.createResource(1, string3, element.getBase(), uRL)) == null) {
            return;
        }
        ResourceScanner.addResource(hashMap, resource);
        if (!bl && !ResourceScanner.isAbsoluteSystemId(string3)) {
            URL uRL2 = resource.getLocation();
            String string5 = null;
            try {
                this.scan(uRL2, uRL, hashMap, hashMap2, arrayList);
            }
            catch (NotWellFormedException notWellFormedException) {
                string5 = Msg.msg("RS.xmlError", notWellFormedException.getEntityLocation(), new Integer(notWellFormedException.getLineNumber()), new Integer(notWellFormedException.getColumnNumber()), notWellFormedException.getMessageWithoutLocation());
            }
            catch (IOException iOException) {
                string5 = MiscUtil.reason(iOException);
            }
            catch (Exception exception) {
                string5 = MiscUtil.detailedReason(exception);
            }
            if (string5 != null) {
                arrayList.add(Msg.msg("RS.cannotScan", URLUtil.toLabel(uRL2), string5));
            }
        }
    }

    public static final class Resource {
        private int type;
        private String systemId;
        private URL scannedURL;

        public Resource(int n, String string, URL uRL) {
            this.type = n;
            this.systemId = string;
            this.scannedURL = uRL;
        }

        public int getType() {
            return this.type;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public URL getScannedURL() {
            return this.scannedURL;
        }

        public URL getLocation() {
            return this.getLocation(this.scannedURL);
        }

        public URL getLocation(URL uRL) {
            URL uRL2 = null;
            try {
                uRL2 = new URL(uRL, this.systemId);
            }
            catch (MalformedURLException malformedURLException) {}
            return uRL2;
        }
    }
}

