/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.edit.Loader;
import com.xmlmind.xmledit.edit.LoaderBase;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xpath.DocumentManager;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public final class SimpleDocumentCache
implements DocumentManager {
    private int capacity;
    private LoaderBase loader;
    private LinkedList entries;

    public SimpleDocumentCache(int n) {
        this(n, null);
    }

    public SimpleDocumentCache(int n, LoaderBase loaderBase) {
        if (n <= 0) {
            n = 1;
        }
        this.capacity = n;
        if (loaderBase == null) {
            Loader loader = new Loader();
            loader.setAddedProperties(0);
            loader.setXIncludeAware(true);
            loaderBase = loader;
        }
        this.loader = loaderBase;
        this.entries = new LinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public LoaderBase getLoader() {
        return this.loader;
    }

    public Document get(URL uRL) throws IOException {
        Document document = this.fetch(uRL);
        if (document == null) {
            document = this.loader.load(uRL);
            this.add(uRL, document);
        }
        return document;
    }

    private Document fetch(URL uRL) {
        Entry entry = null;
        int n = 0;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry2 = (Entry)iterator.next();
            if (entry2.location.equals(uRL)) {
                entry = entry2;
                break;
            }
            ++n;
        }
        if (entry == null) {
            SimpleDocumentCache.trace("document '" + uRL + "' not cached");
            return null;
        }
        if (entry.source != null && entry.source.lastModified() >= entry.loadDate) {
            SimpleDocumentCache.trace("cached document '" + uRL + "' is obsolete: removing it");
            this.entries.remove(n);
            return null;
        }
        if (n > 0) {
            this.entries.remove(n);
            this.entries.addFirst(entry);
        }
        SimpleDocumentCache.trace("fetched document '" + uRL + "' from cache");
        return entry.document;
    }

    private void add(URL uRL, Document document) {
        Entry entry;
        if (this.entries.size() >= this.capacity) {
            entry = (Entry)this.entries.removeLast();
            SimpleDocumentCache.trace("reached cache capacity " + this.capacity + ":" + " discarding document '" + entry.location + "'");
        }
        entry = new Entry();
        entry.location = uRL;
        entry.document = document;
        entry.source = FileUtil.urlToFile(uRL);
        if (entry.source != null) {
            entry.loadDate = System.currentTimeMillis();
        }
        SimpleDocumentCache.trace("caching document '" + uRL + "'");
        this.entries.addFirst(entry);
    }

    public Document remove(URL uRL) {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.location.equals(uRL)) continue;
            iterator.remove();
            SimpleDocumentCache.trace("removed document '" + entry.location + "'");
            return entry.document;
        }
        SimpleDocumentCache.trace("cannot remove document '" + uRL + "': not cached");
        return null;
    }

    public void clear() {
        this.entries.clear();
        SimpleDocumentCache.trace("document cache cleared");
    }

    private static final void trace(String string) {
    }

    public Document getDocument(URL uRL) throws EvalException {
        Document document;
        try {
            document = this.get(uRL);
        }
        catch (IOException iOException) {
            throw new EvalException("cannot load document '" + uRL + "': " + MiscUtil.reason(iOException));
        }
        return document;
    }

    public static void installDefaultDocumentManager() {
        if (SimpleExprContext.getDefaultDocumentManager() == null) {
            SimpleExprContext.setDefaultDocumentManager(new SimpleDocumentCache(10));
        }
    }

    private static final class Entry {
        public URL location;
        public Document document;
        public File source;
        public long loadDate;

        private Entry() {
        }
    }
}

