/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class StyleSheetInfo {
    public URL url;
    public String type;
    public String title;
    public String media;
    public String charset;
    public boolean alternate;
    public String content;
    private static final StyleSheetInfo[] NO_INFO = new StyleSheetInfo[0];

    public StyleSheetInfo() {
    }

    public StyleSheetInfo(URL uRL, boolean bl, String string) {
        this.url = uRL;
        this.type = "text/css";
        this.alternate = bl;
        this.title = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (this.url != null) {
            StyleSheetInfo.appendField(stringBuffer, "url", this.url);
        }
        if (this.type != null) {
            StyleSheetInfo.appendField(stringBuffer, "type", this.type);
        }
        if (this.title != null) {
            StyleSheetInfo.appendField(stringBuffer, "title", this.title);
        }
        if (this.media != null) {
            StyleSheetInfo.appendField(stringBuffer, "media", this.media);
        }
        if (this.charset != null) {
            StyleSheetInfo.appendField(stringBuffer, "charset", this.charset);
        }
        StyleSheetInfo.appendField(stringBuffer, "alternate", this.alternate ? Boolean.TRUE : Boolean.FALSE);
        if (this.content != null) {
            StyleSheetInfo.appendField(stringBuffer, "content", this.content);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static final void appendField(StringBuffer stringBuffer, String string, Object object) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(',');
        }
        stringBuffer.append(string);
        stringBuffer.append("='");
        stringBuffer.append(object);
        stringBuffer.append('\'');
    }

    public String getLabel() {
        String string = this.title;
        if (string == null && this.url != null) {
            string = URLPathUtil.trimExtension(URLUtil.getRawBaseName(this.url));
            string = URIUtil.unescape(string);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StyleSheetInfo[] loadStyleSheetPI(Document document) {
        ArrayList<StyleSheetInfo> arrayList = new ArrayList<StyleSheetInfo>();
        URL uRL = document.getLocation();
        Node node = document.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 2: {
                    StyleSheetInfo styleSheetInfo;
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    if (!"xml-stylesheet".equals(processingInstruction.getTarget()) || !StyleSheetInfo.parseStyleSheetPI(processingInstruction, uRL, styleSheetInfo = new StyleSheetInfo())) break;
                    arrayList.add(styleSheetInfo);
                    break;
                }
                case 4: {
                    return arrayList.toArray(NO_INFO);
                }
            }
            node = node.getNextSibling();
        }
        return arrayList.toArray(NO_INFO);
    }

    private static boolean parseStyleSheetPI(ProcessingInstruction processingInstruction, URL uRL, StyleSheetInfo styleSheetInfo) {
        styleSheetInfo.url = null;
        styleSheetInfo.content = null;
        styleSheetInfo.type = null;
        styleSheetInfo.title = null;
        styleSheetInfo.media = null;
        styleSheetInfo.charset = null;
        styleSheetInfo.alternate = false;
        String[] stringArray = processingInstruction.getPseudoAttributes();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1].trim();
            if ("href".equals(string)) {
                String string3 = XMLUtil.unescapeXML(string2);
                try {
                    styleSheetInfo.url = XMLCatalogs.resolveURI(string3, uRL);
                }
                catch (MalformedURLException malformedURLException) {}
            } else if ("type".equals(string)) {
                styleSheetInfo.type = XMLUtil.unescapeXML(string2);
            } else if ("title".equals(string)) {
                styleSheetInfo.title = XMLUtil.unescapeXML(string2);
            } else if ("media".equals(string)) {
                styleSheetInfo.media = XMLUtil.unescapeXML(string2);
            } else if ("charset".equals(string)) {
                styleSheetInfo.charset = XMLUtil.unescapeXML(string2);
            } else if ("alternate".equals(string)) {
                if ("yes".equals(string2)) {
                    styleSheetInfo.alternate = true;
                } else if ("no".equals(string2)) {
                    styleSheetInfo.alternate = false;
                } else {
                    return false;
                }
            }
            n += 2;
        }
        return styleSheetInfo.url != null && styleSheetInfo.type != null;
    }
}

