/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.Item;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.doctype.TextItem;
import com.xmlmind.xmledit.doctype.UncheckedElementType;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.edit.CanEditChecker;
import com.xmlmind.xmledit.edit.ClipboardSupport;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.Editor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextCollector;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.edit.TextRange;
import com.xmlmind.xmledit.edit.TextRangeList;
import com.xmlmind.xmledit.edit.TextTransferEvent;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Stack;

public final class TextEditor
extends Editor {
    private CanEditChecker canEditChecker = new CanEditChecker();
    private TextCollector textCollector = new TextCollector();
    private TextRangeList rangeList = new TextRangeList();
    private Traversal.NodeMatcher nodeMatcher = new Traversal.NodeMatcher();
    private Structure structure = new Structure();
    private ElementCopier elementCopier = new ElementCopier();
    private TextTransferEvent textTransferEvent = new TextTransferEvent();
    private ReplaceInfo replaceInfo = new ReplaceInfo();
    private Node[] nodeList = new Node[0];
    private Item[] itemList = new Item[0];
    private Attribute[] attributeList = new Attribute[0];
    private EmptyElementFinder emptyElementFinder = new EmptyElementFinder();
    private static final Attribute[] attributes0 = new Attribute[0];

    public TextEditor() {
        this(null);
    }

    public TextEditor(DocumentType documentType) {
        super(documentType);
    }

    public boolean canEdit(TextLocation textLocation, TextLocation textLocation2) {
        return this.canEdit(textLocation.getTextNode(), textLocation.getOffset(), textLocation2.getTextNode(), textLocation2.getOffset());
    }

    public boolean canEdit(TextNode textNode, int n, TextNode textNode2, int n2) {
        if (!EditUtil.checkOffsets(textNode, n, textNode2, n2)) {
            return false;
        }
        if (textNode == textNode2) {
            return textNode.isEditable();
        }
        this.canEditChecker.setEndNode(textNode2);
        Boolean bl = (Boolean)Traversal.traverseFrom(textNode, this.canEditChecker);
        if (bl == null) {
            this.canEditChecker.setEndNode(textNode2);
            bl = (Boolean)Traversal.traverseBackwardsFrom(textNode, this.canEditChecker);
            if (bl == null) {
                return false;
            }
        }
        return bl;
    }

    public String copyChars(TextNode textNode, int n, TextNode textNode2, int n2) {
        if (!EditUtil.checkOffsets(textNode, n, textNode2, n2)) {
            return null;
        }
        this.rangeList.removeAll();
        this.textCollector.collect(textNode, n, textNode2, n2, this.rangeList);
        if (this.rangeList.size == 0) {
            return null;
        }
        String string = TextEditor.copyChars(this.rangeList);
        this.rangeList.removeAll();
        return string;
    }

    private static final String copyChars(TextRangeList textRangeList) {
        StringBuffer stringBuffer = new StringBuffer();
        TextRange[] textRangeArray = textRangeList.list;
        int n = textRangeList.size;
        int n2 = 0;
        while (n2 < n) {
            TextRange textRange = textRangeArray[n2];
            if (textRange.count > 0) {
                stringBuffer.append(textRange.text.getTextChars(), textRange.offset, textRange.count);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean deleteChars(TextNode textNode, int n, TextNode textNode2, int n2) {
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return false;
        }
        this.rangeList.removeAll();
        this.textCollector.collect(textNode, n, textNode2, n2, this.rangeList);
        if (this.rangeList.size == 0) {
            return false;
        }
        Document document = textNode.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        TextEditor.deleteChars(this.rangeList);
        this.rangeList.removeAll();
        if (document != null) {
            document.endBatchEditing();
        }
        return true;
    }

    private static final void deleteChars(TextRangeList textRangeList) {
        TextRange[] textRangeArray = textRangeList.list;
        int n = textRangeList.size;
        int n2 = 0;
        while (n2 < n) {
            TextRange textRange = textRangeArray[n2];
            if (textRange.count > 0) {
                textRange.text.deleteText(textRange.offset, textRange.count);
            }
            ++n2;
        }
    }

    public String cutChars(TextNode textNode, int n, TextNode textNode2, int n2) {
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return null;
        }
        this.rangeList.removeAll();
        this.textCollector.collect(textNode, n, textNode2, n2, this.rangeList);
        if (this.rangeList.size == 0) {
            return null;
        }
        String string = TextEditor.copyChars(this.rangeList);
        Document document = textNode.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        TextEditor.deleteChars(this.rangeList);
        this.rangeList.removeAll();
        if (document != null) {
            document.endBatchEditing();
        }
        return string;
    }

    public boolean canPasteChars(TextNode textNode, int n, TextNode textNode2, int n2, String string) {
        return this.canEdit(textNode, n, textNode2, n2) && TextEditor.isPastableText(string);
    }

    private static final boolean isPastableText(String string) {
        return string.length() > 0 && !string.startsWith("<?xml ");
    }

    public boolean pasteChars(TextNode textNode, int n, TextNode textNode2, int n2, String string) {
        Node node;
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return false;
            }
            case 2: {
                node = textNode;
                textNode = textNode2;
                textNode2 = node;
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        }
        string = XMLUtil.filterText(string);
        if (textNode == textNode2) {
            if (n == n2) {
                textNode.insertText(n, string);
            } else {
                textNode.replaceText(n, n2 - n, string);
            }
        } else {
            node = textNode.getDocument();
            if (node != null) {
                ((Document)node).beginBatchEditing();
            }
            this.deleteChars(textNode, n, textNode2, n2);
            textNode2.insertText(0, string);
            if (node != null) {
                ((Document)node).endBatchEditing();
            }
        }
        return true;
    }

    public boolean delete(TextNode textNode, int n, TextNode textNode2, int n2) {
        Node node;
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return false;
        }
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return false;
            }
            case 2: {
                node = textNode;
                textNode = textNode2;
                textNode2 = node;
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        }
        node = textNode.getDocument();
        if (node != null) {
            ((Document)node).beginBatchEditing();
        }
        Element element = TextEditor.findCommonAncestor(textNode, textNode2);
        this.rangeList.removeAll();
        this.prune(element, textNode, n, textNode2, n2);
        if (node != null) {
            ((Document)node).endBatchEditing();
        }
        return true;
    }

    private static final Element findCommonAncestor(Node node, Node node2) {
        Node node3 = node.findCommonAncestor(node2);
        if (!(node3 instanceof Element)) {
            node3 = node3.getParentElement();
        }
        return (Element)node3;
    }

    public boolean delete(TextLocation textLocation, TextLocation textLocation2) {
        boolean bl;
        TextNode textNode = textLocation.getTextNode();
        int n = textLocation.getOffset();
        TextNode textNode2 = textLocation2.getTextNode();
        int n2 = textLocation2.getOffset();
        boolean bl2 = true;
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return false;
        }
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return false;
            }
            case 2: {
                TextNode textNode3 = textNode;
                textNode = textNode2;
                textNode2 = textNode3;
                int n3 = n;
                n = n2;
                n2 = n3;
                bl2 = false;
            }
        }
        int n4 = bl2 ? textLocation2.getPositionFromEnd() : textLocation2.getPositionFromBegin();
        MarkManager markManager = textLocation2.getManager();
        if (markManager != null) {
            markManager.beginBatchMarking();
        }
        if (bl = this.delete(textNode, n, textNode2, n2)) {
            textLocation.remove();
            if (bl2) {
                textLocation2.setPositionFromEnd(n4);
            } else {
                textLocation2.setPositionFromBegin(n4);
            }
        }
        if (markManager != null) {
            markManager.endBatchMarking();
        }
        return bl;
    }

    private void prune(Element element, TextNode textNode, int n, TextNode textNode2, int n2) {
        this.prune(element, textNode, n, textNode2, n2, null);
    }

    private void prune(Element element, TextNode textNode, int n, TextNode textNode2, int n2, IdentityHashMap identityHashMap) {
        Node node;
        TextNode textNode3 = textNode;
        int n3 = n;
        TextNode textNode4 = textNode2;
        int n4 = n2;
        if (textNode3 == null) {
            textNode3 = (TextNode)Traversal.traverse(element, Traversal.textNodeFinder);
            n3 = 0;
        }
        if (textNode4 == null && (textNode4 = (TextNode)Traversal.traverseBackwards(element, Traversal.textNodeFinder)) != null) {
            n4 = textNode4.getTextLength();
        }
        if (textNode3 != null) {
            this.deleteChars(textNode3, n3, textNode4, n4);
        }
        Node node2 = null;
        Node node3 = null;
        if (textNode == null) {
            node2 = element.getFirstChild();
            if (node2 != null) {
                while (node2 instanceof Element) {
                    node = ((Element)node2).getFirstChild();
                    if (node != null) {
                        node2 = node;
                        continue;
                    }
                    break;
                }
            }
        } else if (textNode.getTextLength() == 0) {
            node2 = textNode;
        } else {
            node2 = (Node)Traversal.traverseAfter(textNode, Traversal.nodeFinder);
            if (node2 != null) {
                while (node2 instanceof Element) {
                    node = ((Element)node2).getFirstChild();
                    if (node != null) {
                        node2 = node;
                        continue;
                    }
                    break;
                }
            }
        }
        if (textNode2 == null) {
            node3 = element.getLastChild();
            if (node3 != null) {
                while (node3 instanceof Element) {
                    node = ((Element)node3).getLastChild();
                    if (node != null) {
                        node3 = node;
                        continue;
                    }
                    break;
                }
            }
        } else if (textNode2.getTextLength() == 0) {
            node3 = textNode2;
        } else {
            node3 = (Node)Traversal.traverseBefore(textNode2, Traversal.nodeFinder);
            if (node3 != null) {
                while (node3 instanceof Element) {
                    node = ((Element)node3).getLastChild();
                    if (node != null) {
                        node3 = node;
                        continue;
                    }
                    break;
                }
            }
        }
        if (node2 != null && node3 != null) {
            this.nodeMatcher.searchedNode = node2;
            if (Traversal.traverseAfter(node3, this.nodeMatcher) == null) {
                this.pruneNodes(element, node2, node3, identityHashMap);
            }
        }
    }

    private void pruneNodes(Element element, Node node, Node node2, IdentityHashMap identityHashMap) {
        IdentityHashMap identityHashMap2 = new IdentityHashMap();
        TextEditor.collectDiscardableNodes(element, node, node2, identityHashMap2);
        this.pruneNodes(element, identityHashMap2, identityHashMap);
    }

    private static final void collectDiscardableNodes(Element element, Node node, final Node node2, final IdentityHashMap identityHashMap) {
        Node node3;
        Traversal.traverseFrom(node, new Traversal.Handler(){

            public Object processText(Text text) {
                return this.processNode(text);
            }

            public Object processPI(ProcessingInstruction processingInstruction) {
                return this.processNode(processingInstruction);
            }

            public Object processComment(Comment comment) {
                return this.processNode(comment);
            }

            public Object enterElement(Element element) {
                return null;
            }

            public Object leaveElement(Element element) {
                return this.processNode(element);
            }

            private Object processNode(Node node) {
                identityHashMap.put(node, node);
                if (node == node2) {
                    return node;
                }
                return null;
            }
        });
        Node node4 = node;
        Element element2 = node4.getParentElement();
        while (element2 != element) {
            if (node4 != element2.getFirstChild() || !identityHashMap.containsKey(node3 = element2.getLastChild()) && !TextEditor.isRightmostDescendant(node2, node3)) break;
            identityHashMap.put(element2, element2);
            node4 = element2;
            element2 = node4.getParentElement();
        }
        node4 = node2;
        element2 = node4.getParentElement();
        while (element2 != element) {
            if (node4 != element2.getLastChild() || !identityHashMap.containsKey(node3 = element2.getFirstChild()) && !TextEditor.isLeftmostDescendant(node, node3)) break;
            identityHashMap.put(element2, element2);
            node4 = element2;
            element2 = node4.getParentElement();
        }
    }

    private static final boolean isRightmostDescendant(Node node, Node node2) {
        while (node != null) {
            if (node == node2) {
                return true;
            }
            Element element = node.getParentElement();
            if (element == null) {
                return false;
            }
            if (node != element.getLastChild()) {
                return false;
            }
            node = element;
        }
        return false;
    }

    private static final boolean isLeftmostDescendant(Node node, Node node2) {
        while (node != null) {
            if (node == node2) {
                return true;
            }
            Element element = node.getParentElement();
            if (element == null) {
                return false;
            }
            if (node != element.getFirstChild()) {
                return false;
            }
            node = element;
        }
        return false;
    }

    private void pruneNodes(Element element, IdentityHashMap identityHashMap, IdentityHashMap identityHashMap2) {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        Object object = element.getFirstChild();
        while (object != null) {
            boolean bl2 = identityHashMap.containsKey(object);
            if (bl2) {
                bl = true;
                if (n < 0) {
                    n = n3;
                }
                n2 = n3;
            }
            ++n3;
            object = ((Node)object).getNextSibling();
        }
        if (bl) {
            int n4;
            Item[] itemArray;
            ElementType elementType = identityHashMap2 != null ? (ElementType)identityHashMap2.get(element) : this.documentType.getElementType(element);
            if (elementType == null) {
                elementType = UnconstrainedElementType.INSTANCE;
            }
            boolean bl3 = false;
            if (n2 >= 0) {
                if (elementType.getStructure(element, false, this.structure)) {
                    itemArray = new Item[this.structure.childNodeItemCount];
                    while (n <= n2) {
                        n4 = 0;
                        n3 = 0;
                        object = element.getFirstChild();
                        while (object != null) {
                            if (n3 < n || n3 > n2) {
                                itemArray[n4++] = this.structure.childNodeItems[n3];
                            }
                            ++n3;
                            object = ((Node)object).getNextSibling();
                        }
                        if (!elementType.checkElementStructure(this.structure.attributeFields, this.structure.attributeFieldCount, itemArray, n4)) {
                            ++n;
                            continue;
                        }
                        break;
                    }
                } else {
                    n2 = -1;
                    n = -1;
                }
            }
            n3 = 0;
            object = element.getFirstChild();
            while (object != null) {
                itemArray = ((Node)object).getNextSibling();
                n4 = identityHashMap.containsKey(object) ? 1 : 0;
                if (n4 != 0 && n3 >= n && n3 <= n2) {
                    element.removeChild((Node)object);
                    bl3 = true;
                }
                ++n3;
                object = itemArray;
            }
            if (bl3) {
                EditUtil.normalizeText(element, elementType);
            }
        }
        object = element.getFirstChild();
        while (object != null) {
            if (object instanceof Element) {
                this.pruneNodes((Element)object, identityHashMap, identityHashMap2);
            }
            object = ((Node)object).getNextSibling();
        }
    }

    public String copy(TextLocation textLocation, TextLocation textLocation2) {
        return this.copy(textLocation.getTextNode(), textLocation.getOffset(), textLocation2.getTextNode(), textLocation2.getOffset());
    }

    public String copy(TextNode textNode, int n, TextNode textNode2, int n2) {
        Node[] nodeArray = this.doCopy(textNode, n, textNode2, n2);
        if (nodeArray == null) {
            return null;
        }
        if (nodeArray.length == 0) {
            return "";
        }
        PrefixEntry[] prefixEntryArray = null;
        Document document = textNode.getDocument();
        if (document != null) {
            prefixEntryArray = document.getPreferredPrefixes(false);
        }
        String string = this.clipboardSupport.formatNodes(nodeArray, nodeArray.length, prefixEntryArray);
        return string;
    }

    private Node[] doCopy(TextNode textNode, int n, TextNode textNode2, int n2) {
        Node node;
        Node node2;
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return null;
            }
            case 2: {
                node2 = textNode;
                textNode = textNode2;
                textNode2 = node2;
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        }
        node2 = TextEditor.findCommonAncestor(textNode, textNode2);
        Node node3 = null;
        Node node4 = textNode;
        while (node4 != null) {
            node = node4.getParent();
            if (node == node2) {
                node3 = node4;
                break;
            }
            node4 = node;
        }
        node = null;
        node4 = textNode2;
        while (node4 != null) {
            Tree tree = node4.getParent();
            if (tree == node2) {
                node = node4;
                break;
            }
            node4 = tree;
        }
        boolean bl = true;
        if (n == textNode.getTextLength() && TextEditor.isRightmostDescendant(textNode, node3)) {
            node3 = node3.getNextSibling();
            bl = false;
        }
        boolean bl2 = true;
        if (n2 == 0 && TextEditor.isLeftmostDescendant(textNode2, node)) {
            node = node.getPreviousSibling();
            bl2 = false;
        }
        if (node3 == null || node == null || !TextEditor.isFollowingSibling(node3, node)) {
            return new Node[0];
        }
        if (node3 == node) {
            if (node3 instanceof Element) {
                IdentityHashMap identityHashMap = new IdentityHashMap();
                TextOffset textOffset = bl ? new TextOffset(textNode, n) : null;
                TextOffset textOffset2 = bl2 ? new TextOffset(textNode2, n2) : null;
                Element element = this.elementCopier.run((Element)node3, this.documentType, identityHashMap, textOffset, textOffset2);
                if (bl) {
                    this.prune(element, null, -1, textOffset.text, textOffset.offset, identityHashMap);
                }
                if (bl2) {
                    this.prune(element, textOffset2.text, textOffset2.offset, null, -1, identityHashMap);
                }
                return new Node[]{element};
            }
            TextNode textNode3 = (TextNode)node3.copy();
            if (bl2) {
                textNode3.deleteText(n2, textNode3.getTextLength() - n2);
            }
            if (bl) {
                textNode3.deleteText(0, n);
            }
            return new Node[]{textNode3};
        }
        int n4 = 0;
        node4 = node3;
        while (node4 != null) {
            ++n4;
            if (node4 == node) break;
            node4 = node4.getNextSibling();
        }
        Node[] nodeArray = new Node[n4];
        n4 = 0;
        node4 = node3;
        while (node4 != null) {
            Object object;
            Element element;
            TextOffset textOffset;
            Object object2;
            if (node4 == node3) {
                if (node4 instanceof Element) {
                    object2 = new IdentityHashMap();
                    textOffset = bl ? new TextOffset(textNode, n) : null;
                    element = this.elementCopier.run((Element)node4, this.documentType, (IdentityHashMap)object2, textOffset, null);
                    if (bl) {
                        this.prune(element, null, -1, textOffset.text, textOffset.offset, (IdentityHashMap)object2);
                    }
                    object = element;
                } else {
                    object2 = (TextNode)node4.copy();
                    if (bl) {
                        ((TextNode)object2).deleteText(0, n);
                    }
                    object = object2;
                }
            } else if (node4 == node) {
                if (node4 instanceof Element) {
                    object2 = new IdentityHashMap();
                    textOffset = bl2 ? new TextOffset(textNode2, n2) : null;
                    element = this.elementCopier.run((Element)node4, this.documentType, (IdentityHashMap)object2, null, textOffset);
                    if (bl2) {
                        this.prune(element, textOffset.text, textOffset.offset, null, -1, (IdentityHashMap)object2);
                    }
                    object = element;
                } else {
                    object2 = (TextNode)node4.copy();
                    if (bl2) {
                        ((TextNode)object2).deleteText(n2, ((TextNode)object2).getTextLength() - n2);
                    }
                    object = object2;
                }
            } else {
                object = node4.copy();
            }
            nodeArray[n4++] = object;
            if (node4 == node) break;
            node4 = node4.getNextSibling();
        }
        return nodeArray;
    }

    private static final boolean isFollowingSibling(Node node, Node node2) {
        while (node != null) {
            if (node == node2) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    public String cut(TextNode textNode, int n, TextNode textNode2, int n2) {
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return null;
        }
        String string = this.copy(textNode, n, textNode2, n2);
        if (string == null) {
            return null;
        }
        this.delete(textNode, n, textNode2, n2);
        return string;
    }

    public String cut(TextLocation textLocation, TextLocation textLocation2) {
        String string;
        TextNode textNode = textLocation.getTextNode();
        int n = textLocation.getOffset();
        TextNode textNode2 = textLocation2.getTextNode();
        int n2 = textLocation2.getOffset();
        boolean bl = true;
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return null;
        }
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return null;
            }
            case 2: {
                TextNode textNode3 = textNode;
                textNode = textNode2;
                textNode2 = textNode3;
                int n3 = n;
                n = n2;
                n2 = n3;
                bl = false;
            }
        }
        int n4 = bl ? textLocation2.getPositionFromEnd() : textLocation2.getPositionFromBegin();
        MarkManager markManager = textLocation2.getManager();
        if (markManager != null) {
            markManager.beginBatchMarking();
        }
        if ((string = this.cut(textNode, n, textNode2, n2)) != null) {
            textLocation.remove();
            if (bl) {
                textLocation2.setPositionFromEnd(n4);
            } else {
                textLocation2.setPositionFromBegin(n4);
            }
        }
        if (markManager != null) {
            markManager.endBatchMarking();
        }
        return string;
    }

    public boolean canPaste(TextLocation textLocation, TextLocation textLocation2, String string) {
        Node[] nodeArray = this.clipboardSupport.getPastableNodes(string);
        return this.canPaste(textLocation.getTextNode(), textLocation.getOffset(), textLocation2.getTextNode(), textLocation2.getOffset(), string, nodeArray);
    }

    public boolean canPaste(TextLocation textLocation, TextLocation textLocation2, Node[] nodeArray) {
        return this.canPaste(textLocation.getTextNode(), textLocation.getOffset(), textLocation2.getTextNode(), textLocation2.getOffset(), null, nodeArray);
    }

    public boolean canPasteString(TextLocation textLocation, TextLocation textLocation2) {
        return this.canPaste(textLocation.getTextNode(), textLocation.getOffset(), textLocation2.getTextNode(), textLocation2.getOffset(), "any", ClipboardSupport.PLAIN_TEXT);
    }

    public boolean canPaste(TextNode textNode, int n, TextNode textNode2, int n2, String string) {
        Node[] nodeArray = this.clipboardSupport.getPastableNodes(string);
        return this.canPaste(textNode, n, textNode2, n2, string, nodeArray);
    }

    public boolean canPaste(TextNode textNode, int n, TextNode textNode2, int n2, Node[] nodeArray) {
        return this.canPaste(textNode, n, textNode2, n2, null, nodeArray);
    }

    public boolean canPasteString(TextNode textNode, int n, TextNode textNode2, int n2) {
        return this.canPaste(textNode, n, textNode2, n2, "any", ClipboardSupport.PLAIN_TEXT);
    }

    private boolean canPaste(TextNode textNode, int n, TextNode textNode2, int n2, String string, Node[] nodeArray) {
        Object object;
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return false;
        }
        if (textNode == textNode2 && string != null && nodeArray == ClipboardSupport.PLAIN_TEXT) {
            return true;
        }
        if (!this.compileReplace(textNode, n, textNode2, n2, this.replaceInfo)) {
            return false;
        }
        ElementType elementType = this.documentType.getElementType(this.replaceInfo.element);
        if (elementType == null) {
            elementType = UnconstrainedElementType.INSTANCE;
        }
        Node[] nodeArray2 = nodeArray;
        Node[] nodeArray3 = this.getNodeList(this.replaceInfo.element.getChildCount() + nodeArray2.length);
        int n3 = 0;
        if (this.replaceInfo.insertBefore != null || this.replaceInfo.replaceText != null) {
            int n4;
            if (this.replaceInfo.replaceText != null) {
                this.replaceInfo.insertBefore = this.replaceInfo.replaceOffset == this.replaceInfo.replaceText.getTextLength() ? this.replaceInfo.replaceText.getNextSibling() : this.replaceInfo.replaceText;
            }
            object = this.replaceInfo.element.getFirstChild();
            while (object != null) {
                if (object == this.replaceInfo.insertBefore) {
                    n4 = 0;
                    while (n4 < nodeArray2.length) {
                        nodeArray3[n3++] = nodeArray2[n4];
                        ++n4;
                    }
                }
                nodeArray3[n3++] = object;
                object = object.getNextSibling();
            }
            if (this.replaceInfo.insertBefore == null) {
                n4 = 0;
                while (n4 < nodeArray2.length) {
                    nodeArray3[n3++] = nodeArray2[n4];
                    ++n4;
                }
            }
        } else {
            object = this.replaceInfo.element.getFirstChild();
            while (object != null) {
                if (object == this.replaceInfo.replaceFrom) {
                    int n5 = 0;
                    while (n5 < nodeArray2.length) {
                        nodeArray3[n3++] = nodeArray2[n5];
                        ++n5;
                    }
                    object = this.replaceInfo.replaceTo;
                } else {
                    nodeArray3[n3++] = object;
                }
                object = object.getNextSibling();
            }
        }
        object = this.replaceInfo.element.getAllAttributes();
        return elementType.getElementStructure((Attribute[])object, ((Attribute[])object).length, nodeArray3, n3, false, this.structure);
    }

    public Node[] paste(TextNode textNode, int n, TextNode textNode2, int n2, String string) {
        Node[] nodeArray = this.clipboardSupport.copyPastableNodes(string);
        return this.paste(textNode, n, textNode2, n2, string, nodeArray);
    }

    public Node[] paste(TextNode textNode, int n, TextNode textNode2, int n2, Node[] nodeArray) {
        return this.paste(textNode, n, textNode2, n2, null, nodeArray);
    }

    public Node[] pasteString(TextNode textNode, int n, TextNode textNode2, int n2, String string) {
        return this.paste(textNode, n, textNode2, n2, string, ClipboardSupport.PLAIN_TEXT);
    }

    private Node[] paste(TextNode textNode, int n, TextNode textNode2, int n2, String string, Node[] nodeArray) {
        Document document;
        if (textNode == textNode2 && string != null && nodeArray == ClipboardSupport.PLAIN_TEXT) {
            if (!this.pasteChars(textNode, n, textNode2, n2, string)) {
                return null;
            }
            string = XMLUtil.filterText(string);
            switch (textNode.getNodeType()) {
                case 2: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)textNode;
                    return new Node[]{new ProcessingInstruction(processingInstruction.getTarget(), string)};
                }
                case 1: {
                    return new Node[]{new Comment(string)};
                }
            }
            return new Node[]{new Text(string)};
        }
        if (!this.compileReplace(textNode, n, textNode2, n2, this.replaceInfo)) {
            return null;
        }
        Node[] nodeArray2 = nodeArray;
        if (nodeArray2 == ClipboardSupport.PLAIN_TEXT) {
            nodeArray2 = new Node[]{new Text(XMLUtil.filterText(string))};
        }
        if ((document = this.replaceInfo.element.getDocument()) != null) {
            document.beginBatchEditing();
        }
        this.replace(this.replaceInfo, nodeArray2);
        if (document != null) {
            this.clipboardSupport.trimPastedNodes(nodeArray2);
            document.addPreferredPrefixes(this.replaceInfo.element, false, true);
            document.endBatchEditing();
        }
        return nodeArray2;
    }

    public Node[] paste(TextLocation textLocation, TextLocation textLocation2, String string) {
        Node[] nodeArray = this.clipboardSupport.copyPastableNodes(string);
        return this.paste(textLocation, textLocation2, string, nodeArray);
    }

    public Node[] paste(TextLocation textLocation, TextLocation textLocation2, Node[] nodeArray) {
        return this.paste(textLocation, textLocation2, null, nodeArray);
    }

    public Node[] pasteString(TextLocation textLocation, TextLocation textLocation2, String string) {
        return this.paste(textLocation, textLocation2, string, ClipboardSupport.PLAIN_TEXT);
    }

    private Node[] paste(TextLocation textLocation, TextLocation textLocation2, String string, Node[] nodeArray) {
        Node[] nodeArray2;
        MarkManager markManager;
        int n;
        int n2;
        TextNode textNode = textLocation.getTextNode();
        int n3 = textLocation.getOffset();
        TextNode textNode2 = textLocation2.getTextNode();
        int n4 = textLocation2.getOffset();
        boolean bl = true;
        switch (EditUtil.checkRange(textNode, n3, textNode2, n4)) {
            case 0: {
                return null;
            }
            case 2: {
                TextNode textNode3 = textNode;
                textNode = textNode2;
                textNode2 = textNode3;
                n2 = n3;
                n3 = n4;
                n4 = n2;
                bl = false;
            }
        }
        n2 = 0;
        if (bl) {
            n = textLocation2.getPositionFromEnd();
            if (nodeArray == ClipboardSupport.PLAIN_TEXT && n4 == textNode2.getTextLength()) {
                n2 = 1;
            }
        } else {
            n = textLocation2.getPositionFromBegin();
            if (nodeArray == ClipboardSupport.PLAIN_TEXT && n3 == 0) {
                n2 = 1;
            }
        }
        if ((markManager = textLocation2.getManager()) != null) {
            markManager.beginBatchMarking();
        }
        if ((nodeArray2 = this.paste(textNode, n3, textNode2, n4, string, nodeArray)) != null) {
            textLocation.remove();
            if (bl) {
                textLocation2.setPositionFromEnd(n);
                if (n2 != 0) {
                    textNode2 = textLocation2.getTextNode();
                    n4 = textLocation2.getOffset();
                    textLocation2.moveTo(textNode2, n4 + 1);
                }
            } else {
                textLocation2.setPositionFromBegin(n);
                if (n2 != 0) {
                    textNode = textLocation2.getTextNode();
                    n3 = textLocation2.getOffset();
                    textLocation2.moveTo(textNode, n3 - 1);
                }
            }
        }
        if (markManager != null) {
            markManager.endBatchMarking();
        }
        return nodeArray2;
    }

    private boolean compileReplace(TextNode textNode, int n, TextNode textNode2, int n2, ReplaceInfo replaceInfo) {
        Node node;
        Node node2;
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return false;
            }
            case 2: {
                node2 = textNode;
                textNode = textNode2;
                textNode2 = node2;
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        }
        replaceInfo.reset();
        replaceInfo.beginText = textNode;
        replaceInfo.beginOffset = n;
        replaceInfo.endText = textNode2;
        replaceInfo.endOffset = n2;
        node2 = TextEditor.findCommonAncestor(textNode, textNode2);
        replaceInfo.element = node2;
        TextNode textNode3 = null;
        boolean bl = true;
        Node node3 = textNode;
        while (node3 != null) {
            node = node3.getParent();
            if (node == node2) {
                textNode3 = node3;
                break;
            }
            if (node3 != ((Tree)node).getFirstChild()) {
                bl = false;
            }
            node3 = node;
        }
        if (n > 0) {
            bl = false;
        }
        node = null;
        boolean bl2 = true;
        node3 = textNode2;
        while (node3 != null) {
            Tree tree = node3.getParent();
            if (tree == node2) {
                node = node3;
                break;
            }
            if (node3 != tree.getLastChild()) {
                bl2 = false;
            }
            node3 = tree;
        }
        if (n2 < textNode2.getTextLength()) {
            bl2 = false;
        }
        if (textNode3 == node) {
            if (bl && bl2) {
                replaceInfo.replaceFrom = replaceInfo.replaceTo = textNode3;
            } else {
                replaceInfo.replaceText = textNode;
                replaceInfo.replaceOffset = n;
                replaceInfo.replaceCount = n2 - n;
            }
        } else {
            if (bl) {
                replaceInfo.replaceFrom = textNode3;
            } else {
                replaceInfo.replaceFrom = textNode3.getNextSibling();
                replaceInfo.pruneRight = textNode3;
                replaceInfo.pruneRightText = textNode;
                replaceInfo.pruneRightOffset = n;
            }
            if (bl2) {
                replaceInfo.replaceTo = node;
            } else {
                replaceInfo.replaceTo = node.getPreviousSibling();
                replaceInfo.pruneLeft = node;
                replaceInfo.pruneLeftText = textNode2;
                replaceInfo.pruneLeftOffset = n2;
            }
            if (replaceInfo.replaceFrom == node && replaceInfo.replaceTo == textNode3) {
                replaceInfo.replaceTo = null;
                replaceInfo.replaceFrom = null;
                replaceInfo.insertBefore = node;
            }
        }
        return true;
    }

    private void replace(ReplaceInfo replaceInfo, Node[] nodeArray) {
        if (replaceInfo.pruneRight != null) {
            if (replaceInfo.pruneRight instanceof Element) {
                this.prune((Element)replaceInfo.pruneRight, replaceInfo.pruneRightText, replaceInfo.pruneRightOffset, null, -1);
            } else {
                replaceInfo.pruneRightText.deleteText(replaceInfo.pruneRightOffset, replaceInfo.pruneRightText.getTextLength() - replaceInfo.pruneRightOffset);
            }
        }
        if (replaceInfo.pruneLeft != null) {
            if (replaceInfo.pruneLeft instanceof Element) {
                this.prune((Element)replaceInfo.pruneLeft, null, -1, replaceInfo.pruneLeftText, replaceInfo.pruneLeftOffset);
            } else {
                replaceInfo.pruneLeftText.deleteText(0, replaceInfo.pruneLeftOffset);
            }
        }
        if (replaceInfo.replaceText != null) {
            replaceInfo.replaceText.deleteText(replaceInfo.replaceOffset, replaceInfo.replaceCount);
            this.insertNodes(replaceInfo.replaceText, replaceInfo.replaceOffset, nodeArray);
        } else if (replaceInfo.insertBefore != null) {
            int n = 0;
            while (n < nodeArray.length) {
                replaceInfo.element.insertChild(replaceInfo.insertBefore, nodeArray[n]);
                ++n;
            }
        } else {
            Node node;
            Node node2 = replaceInfo.replaceFrom;
            while (node2 != replaceInfo.replaceTo) {
                node = node2.getNextSibling();
                replaceInfo.element.removeChild(node2);
                node2 = node;
            }
            node = replaceInfo.replaceTo.getNextSibling();
            replaceInfo.element.removeChild(replaceInfo.replaceTo);
            int n = 0;
            while (n < nodeArray.length) {
                replaceInfo.element.insertChild(node, nodeArray[n]);
                ++n;
            }
        }
        ElementType elementType = replaceInfo.getElementType(this.documentType);
        EditUtil.normalizeText(replaceInfo.element, elementType);
    }

    private void insertNodes(TextNode textNode, int n, Node[] nodeArray) {
        TextNode textNode2;
        int n2 = textNode.getTextLength();
        if (n < 0 || n > n2) {
            return;
        }
        Element element = textNode.getParentElement();
        int n3 = nodeArray.length;
        if (n == n2) {
            Node node = textNode.getNextSibling();
            int n4 = 0;
            while (n4 < n3) {
                element.insertChild(node, nodeArray[n4]);
                ++n4;
            }
            return;
        }
        if (n == 0) {
            int n5 = 0;
            while (n5 < n3) {
                element.insertChild(textNode, nodeArray[n5]);
                ++n5;
            }
            return;
        }
        char[] cArray = textNode.getTextChars();
        switch (textNode.getNodeType()) {
            case 1: {
                textNode2 = new Comment(cArray, n, n2 - n);
                break;
            }
            case 2: {
                textNode2 = new ProcessingInstruction(((ProcessingInstruction)textNode).getTarget(), cArray, n, n2 - n);
                break;
            }
            default: {
                textNode2 = new Text(cArray, n, n2 - n);
            }
        }
        element.insertChild(textNode.getNextSibling(), textNode2);
        Document document = element.getDocument();
        if (document != null) {
            this.textTransferEvent.initialize(this, textNode, n, textNode2, 0, n2);
            document.notifyDocumentListeners(this.textTransferEvent);
        }
        textNode.deleteText(n, n2 - n);
        int n6 = 0;
        while (n6 < n3) {
            element.insertChild(textNode2, nodeArray[n6]);
            ++n6;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean canSplit(Element var1_1, TextNode var2_2) {
        if (!var2_2.isEditable()) {
            return false;
        }
        if (!TextEditor.checkSplitPosition(var1_1, var2_2)) {
            return false;
        }
        var3_3 = var2_2.getParentElement();
        var4_4 = this.documentType.getElementType(var3_3);
        if (var4_4 == null) {
            var4_4 = UnconstrainedElementType.INSTANCE;
        }
        if (this.checkCanSplit(var4_4, var3_3, var2_2)) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5 = var3_3;
            var4_4 = this.documentType.getElementType(var3_3 = var3_3.getParentElement());
            if (var4_4 == null) {
                var4_4 = UnconstrainedElementType.INSTANCE;
            }
            if (this.checkCanSplit(var4_4, var3_3, var5_5)) continue;
            return false;
lbl17:
            // 2 sources

            ** while (var3_3 != var1_1)
        }
lbl18:
        // 1 sources

        var3_3 = var1_1.getParentElement();
        var4_4 = this.documentType.getElementType(var3_3);
        if (var4_4 == null) {
            var4_4 = UnconstrainedElementType.INSTANCE;
        }
        return this.checkCanDuplicate(var4_4, var3_3, var1_1);
    }

    private static final boolean checkSplitPosition(Element element, TextNode textNode) {
        return textNode != null && element != null && element.getParentElement() != null && element.isAncestorOf(textNode);
    }

    private boolean checkCanSplit(ElementType elementType, Element element, Node node) {
        switch (elementType.getElementContentType()) {
            case 0: 
            case 1: {
                return false;
            }
        }
        if (TextEditor.isParagraphLike(elementType)) {
            return true;
        }
        Node[] nodeArray = this.getNodeList(element.getChildCount());
        int n = 0;
        nodeArray[n++] = node;
        Node node2 = node.getNextSibling();
        while (node2 != null) {
            nodeArray[n++] = node2;
            node2 = node2.getNextSibling();
        }
        if (!elementType.getStructure(attributes0, 0, nodeArray, n, false, this.structure)) {
            return false;
        }
        Attribute[] attributeArray = element.getAllAttributes();
        n = 0;
        node2 = element.getFirstChild();
        while (node2 != node) {
            nodeArray[n++] = node2;
            node2 = node2.getNextSibling();
        }
        nodeArray[n++] = node;
        return elementType.getStructure(attributeArray, attributeArray.length, nodeArray, n, false, this.structure);
    }

    private static final boolean isParagraphLike(ElementType elementType) {
        if (elementType.getElementContentType() != 4) {
            return false;
        }
        Field[] fieldArray = elementType.getAttributeFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (elementType.isRequiredAttribute(fieldArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean checkCanDuplicate(ElementType elementType, Element element, Element element2) {
        int n = element.indexOfChild(element2);
        if (n < 0) {
            return false;
        }
        if (!elementType.getStructure(element, false, this.structure)) {
            return false;
        }
        Field[] fieldArray = this.structure.attributeFields;
        int n2 = this.structure.attributeFieldCount;
        Item[] itemArray = this.structure.childNodeItems;
        int n3 = this.structure.childNodeItemCount;
        int n4 = n3 + 1;
        Item[] itemArray2 = this.getItemList(n4);
        System.arraycopy(itemArray, 0, itemArray2, 0, n + 1);
        itemArray2[n + 1] = itemArray[n];
        int n5 = n3 - (n + 1);
        if (n5 > 0) {
            System.arraycopy(itemArray, n + 1, itemArray2, n + 2, n5);
        }
        return elementType.checkElementStructure(fieldArray, n2, itemArray2, n4);
    }

    public Element findSplit(TextNode textNode) {
        if (!textNode.isEditable()) {
            return null;
        }
        Element element = textNode.getParentElement();
        ElementType elementType = this.documentType.getElementType(element);
        if (elementType == null || elementType instanceof UnconstrainedElementType) {
            return null;
        }
        Element element2 = null;
        while (element != null) {
            Element element3;
            if (!TextEditor.isParagraphLike(elementType) || (element3 = element.getParentElement()) == null) break;
            ElementType elementType2 = this.documentType.getElementType(element3);
            if (elementType2 == null || elementType2 instanceof UnconstrainedElementType) {
                return null;
            }
            if (!this.checkCanDuplicate(elementType2, element3, element)) break;
            element2 = element;
            element = element3;
            elementType = elementType2;
        }
        return element2;
    }

    public Element split(Element element, TextNode textNode, int n) {
        Element element2;
        TextNode textNode2;
        if (!TextEditor.checkSplitPosition(element, textNode)) {
            return null;
        }
        Document document = element.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        Element element3 = textNode.getParentElement();
        Element element4 = new Element(element3.getName());
        int n2 = textNode.getTextLength();
        if (n < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        char[] cArray = textNode.getTextChars();
        switch (textNode.getNodeType()) {
            case 1: {
                textNode2 = new Comment(cArray, n, n2 - n);
                break;
            }
            case 2: {
                textNode2 = new ProcessingInstruction(((ProcessingInstruction)textNode).getTarget(), cArray, n, n2 - n);
                break;
            }
            default: {
                textNode2 = new Text(cArray, n, n2 - n);
            }
        }
        element4.appendChild(textNode2);
        TextEditor.transferChildren(element3, textNode, element4);
        while (element3 != element) {
            element2 = element3;
            element3 = element3.getParentElement();
            Element element5 = new Element(element3.getName());
            element5.appendChild(element4);
            TextEditor.transferChildren(element3, element2, element5);
            element4 = element5;
        }
        element.getParentElement().insertChild(element.getNextSibling(), element4);
        if (document != null) {
            this.textTransferEvent.initialize(this, textNode, n, textNode2, 0, n2);
            document.notifyDocumentListeners(this.textTransferEvent);
        }
        textNode.deleteText(n, n2 - n);
        if (textNode instanceof Text) {
            if (textNode.getTextLength() == 0 && TextEditor.hasContentOtherThan(element2 = textNode.getParentElement(), textNode)) {
                element2.removeChild(textNode);
            }
            if (textNode2.getTextLength() == 0 && TextEditor.hasContentOtherThan(element2 = textNode2.getParentElement(), textNode2)) {
                element2.removeChild(textNode2);
            }
        }
        if (document != null) {
            document.endBatchEditing();
        }
        return element4;
    }

    private static final void transferChildren(Element element, Node node, Element element2) {
        Node node2 = node.getNextSibling();
        while (node2 != null) {
            Node node3 = node2;
            node2 = node3.getNextSibling();
            element.removeChild(node3);
            element2.appendChild(node3.copy());
        }
    }

    private static final boolean hasContentOtherThan(Element element, Node node) {
        Node node2 = element.getFirstChild();
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (node2 == node) break;
                    return true;
                }
            }
            node2 = node2.getNextSibling();
        }
        return false;
    }

    public boolean canJoin(Element element) {
        if (element.hasNoChildren()) {
            return false;
        }
        Element element2 = this.getJoined(element);
        if (element2 == null) {
            return false;
        }
        Element element3 = element.getParentElement();
        if (!element2.isEditable() || !element3.isEditable()) {
            return false;
        }
        ElementType elementType = this.documentType.getElementType(element3);
        if (elementType == null) {
            elementType = UnconstrainedElementType.INSTANCE;
        }
        return this.checkCanRemove(elementType, element3, element);
    }

    private Element getJoined(Element element) {
        Node node = element.getPreviousSibling();
        if (node == null || !(node instanceof Element)) {
            return null;
        }
        Element element2 = (Element)node;
        if (this.checkCanJoin(element2, element)) {
            return element2;
        }
        return null;
    }

    private boolean checkCanJoin(Element element, Element element2) {
        Object object;
        if (element.getName() != element2.getName()) {
            return false;
        }
        Element element3 = element.getParentElement();
        ElementType elementType = this.documentType.getElementType(element3);
        if (elementType == null) {
            elementType = UnconstrainedElementType.INSTANCE;
        }
        if (!elementType.getElementStructure(element3, false, this.structure)) {
            return false;
        }
        int n = element3.indexOfChild(element);
        Field field = (Field)this.structure.childNodeItems[n];
        if (element.getNextSibling() == element2 && field != (object = (Field)this.structure.childNodeItems[n + 1])) {
            return false;
        }
        object = elementType.getChildElementType(field, element);
        if (object == null) {
            object = UnconstrainedElementType.INSTANCE;
        }
        switch (object.getElementContentType()) {
            case 0: 
            case 1: {
                return false;
            }
        }
        if (TextEditor.isParagraphLike((ElementType)object)) {
            return true;
        }
        Node[] nodeArray = new Node[element.getChildCount() + element2.getChildCount()];
        int n2 = 0;
        Node node = element.getFirstChild();
        Node node2 = null;
        while (node != null) {
            nodeArray[n2++] = node;
            node2 = node;
            node = node.getNextSibling();
        }
        node = element2.getFirstChild();
        if (node != null && node2 != null && node instanceof Element && node2 instanceof Element && this.checkCanJoin((Element)node2, (Element)node)) {
            node = node.getNextSibling();
        }
        while (node != null) {
            nodeArray[n2++] = node;
            node = node.getNextSibling();
        }
        Attribute[] attributeArray = element.getAllAttributes();
        return object.getElementStructure(attributeArray, attributeArray.length, nodeArray, n2, false, this.structure);
    }

    private boolean checkCanRemove(ElementType elementType, Element element, Element element2) {
        int n;
        int n2 = element.indexOfChild(element2);
        if (n2 < 0) {
            return false;
        }
        if (!elementType.getStructure(element, false, this.structure)) {
            return false;
        }
        Field[] fieldArray = this.structure.attributeFields;
        int n3 = this.structure.attributeFieldCount;
        Item[] itemArray = this.structure.childNodeItems;
        int n4 = this.structure.childNodeItemCount;
        int n5 = n4 - 1;
        Item[] itemArray2 = this.getItemList(n5);
        if (n2 > 0) {
            System.arraycopy(itemArray, 0, itemArray2, 0, n2);
        }
        if ((n = n4 - (n2 + 1)) > 0) {
            System.arraycopy(itemArray, n2 + 1, itemArray2, n2, n);
        }
        return elementType.checkElementStructure(fieldArray, n3, itemArray2, n5);
    }

    public Element findJoinBefore(Text text, int n) {
        Field field;
        if (n != 0 || text.getPreviousSibling() != null) {
            return null;
        }
        Node node = null;
        Element element = text.getParentElement();
        while (element != null && (node = element.getPreviousSibling()) == null) {
            element = element.getParentElement();
        }
        if (element == null || node == null || !(node instanceof Element) || ((Element)node).getName() != element.getName()) {
            return null;
        }
        Element element2 = element.getParentElement();
        if (!node.isEditable() || !element2.isEditable()) {
            return null;
        }
        ElementType elementType = this.documentType.getElementType(element2);
        if (elementType == null || elementType instanceof UnconstrainedElementType) {
            return null;
        }
        if (!elementType.getElementStructure(element2, false, this.structure)) {
            return null;
        }
        int n2 = element2.indexOfChild(node);
        Field field2 = (Field)this.structure.childNodeItems[n2];
        if (field2 != (field = (Field)this.structure.childNodeItems[n2 + 1])) {
            return null;
        }
        ElementType elementType2 = elementType.getChildElementType(field2, (Element)node);
        if (elementType2 == null || elementType2 instanceof UnconstrainedElementType || !TextEditor.isParagraphLike(elementType2)) {
            return null;
        }
        if (this.checkCanRemove(elementType, element2, element)) {
            return element;
        }
        return null;
    }

    public Element findJoinAfter(Text text, int n) {
        Field field;
        if (n != text.getTextLength() || text.getNextSibling() != null) {
            return null;
        }
        Node node = null;
        Element element = text.getParentElement();
        while (element != null && (node = element.getNextSibling()) == null) {
            element = element.getParentElement();
        }
        if (element == null || node == null || !(node instanceof Element) || ((Element)node).getName() != element.getName()) {
            return null;
        }
        Element element2 = element.getParentElement();
        if (!element.isEditable() || !element2.isEditable()) {
            return null;
        }
        ElementType elementType = this.documentType.getElementType(element2);
        if (elementType == null || elementType instanceof UnconstrainedElementType) {
            return null;
        }
        if (!elementType.getElementStructure(element2, false, this.structure)) {
            return null;
        }
        int n2 = element2.indexOfChild(element);
        Field field2 = (Field)this.structure.childNodeItems[n2];
        if (field2 != (field = (Field)this.structure.childNodeItems[n2 + 1])) {
            return null;
        }
        ElementType elementType2 = elementType.getChildElementType(field2, element);
        if (elementType2 == null || elementType2 instanceof UnconstrainedElementType || !TextEditor.isParagraphLike(elementType2)) {
            return null;
        }
        Element element3 = (Element)node;
        if (this.checkCanRemove(elementType, element2, element3)) {
            return element3;
        }
        return null;
    }

    public Node join(Element element) {
        Element element2 = this.getJoined(element);
        if (element2 == null) {
            return null;
        }
        Document document = element.getDocument();
        if (document != null) {
            document.beginBatchEditing();
        }
        Node node = element2.getLastChild();
        Node node2 = null;
        boolean bl = false;
        Node node3 = element.getFirstChild();
        while (node3 != null) {
            Node node4 = node3.copy();
            if (node2 == null) {
                node2 = node4;
            }
            if (node4 instanceof Text) {
                bl = true;
            }
            element2.appendChild(node4);
            node3 = node3.getNextSibling();
        }
        if (node2 != null && node2 instanceof Element) {
            this.join((Element)node2);
        }
        if (bl) {
            EditUtil.mergeContiguousText(element2);
        }
        element.getParentElement().removeChild(element);
        if (document != null) {
            document.endBatchEditing();
        }
        return node2.getDocument() == null ? node : node2;
    }

    public boolean canConvert(TextNode textNode, int n, TextNode textNode2, int n2) {
        return this.canConvert(textNode, n, textNode2, n2, null) != 0;
    }

    public int canConvert(TextNode textNode, int n, TextNode textNode2, int n2, ArrayList arrayList) {
        boolean bl;
        int n3;
        Structure structure;
        if (!this.canEdit(textNode, n, textNode2, n2)) {
            return 0;
        }
        if (!this.compileReplace(textNode, n, textNode2, n2, this.replaceInfo)) {
            return 0;
        }
        textNode = this.replaceInfo.beginText;
        n = this.replaceInfo.beginOffset;
        textNode2 = this.replaceInfo.endText;
        n2 = this.replaceInfo.endOffset;
        Node node = textNode;
        while (node.getParent() != this.replaceInfo.element) {
            node = node.getParent();
        }
        Node node2 = textNode2;
        while (node2.getParent() != this.replaceInfo.element) {
            node2 = node2.getParent();
        }
        if (n == textNode.getTextLength() && TextEditor.isRightmostDescendant(textNode, node)) {
            node = node.getNextSibling();
        }
        if (n2 == 0 && TextEditor.isLeftmostDescendant(textNode2, node2)) {
            node2 = node2.getPreviousSibling();
        }
        if (node == null || node2 == null || !TextEditor.isFollowingSibling(node, node2)) {
            return 0;
        }
        int n4 = 0;
        Node node3 = node;
        while (node3 != null) {
            ++n4;
            if (node3 == node2) break;
            node3 = node3.getNextSibling();
        }
        Node[] nodeArray = this.getNodeList(n4);
        n4 = 0;
        node3 = node;
        while (node3 != null) {
            nodeArray[n4++] = node3;
            if (node3 == node2) break;
            node3 = node3.getNextSibling();
        }
        ElementType elementType = this.documentType.getElementType(this.replaceInfo.element);
        if (elementType == null) {
            elementType = UnconstrainedElementType.INSTANCE;
        }
        if (!elementType.getStructure(this.replaceInfo.element, false, structure = new Structure())) {
            elementType = new UncheckedElementType(elementType);
            elementType.getStructure(this.replaceInfo.element, false, structure);
        }
        Item[] itemArray = this.getItemList(structure.childNodeItemCount + 1);
        int n5 = 0;
        int n6 = -1;
        if (this.replaceInfo.insertBefore != null || this.replaceInfo.replaceText != null) {
            if (this.replaceInfo.replaceText != null) {
                this.replaceInfo.insertBefore = this.replaceInfo.replaceOffset == this.replaceInfo.replaceText.getTextLength() ? this.replaceInfo.replaceText.getNextSibling() : this.replaceInfo.replaceText;
            }
            n3 = 0;
            node3 = this.replaceInfo.element.getFirstChild();
            while (node3 != null) {
                if (node3 == this.replaceInfo.insertBefore) {
                    n6 = n5;
                    itemArray[n5++] = null;
                }
                itemArray[n5++] = structure.childNodeItems[n3++];
                node3 = node3.getNextSibling();
            }
            if (this.replaceInfo.insertBefore == null) {
                n6 = n5;
                itemArray[n5++] = null;
            }
        } else {
            n3 = 0;
            bl = false;
            node3 = this.replaceInfo.element.getFirstChild();
            while (node3 != null) {
                if (node3 == this.replaceInfo.replaceFrom) {
                    n6 = n5;
                    itemArray[n5++] = null;
                    bl = true;
                }
                if (bl) {
                    ++n3;
                } else {
                    itemArray[n5++] = structure.childNodeItems[n3++];
                }
                if (node3 == this.replaceInfo.replaceTo) {
                    bl = false;
                }
                node3 = node3.getNextSibling();
            }
        }
        Field[] fieldArray = elementType.getChildElementFields();
        bl = false;
        if (arrayList != null) {
            arrayList.clear();
        }
        int n7 = 0;
        while (n7 < fieldArray.length) {
            if (this.checkPossibleField(elementType, fieldArray[n7], nodeArray, n4)) {
                itemArray[n6] = fieldArray[n7];
                if (elementType.checkElementStructure(structure.attributeFields, structure.attributeFieldCount, itemArray, n5)) {
                    bl = true;
                    if (arrayList == null) break;
                    arrayList.add(fieldArray[n7]);
                }
            }
            ++n7;
        }
        boolean bl2 = EditUtil.mayContainText(elementType);
        if (bl2) {
            bl2 = false;
            node3 = node;
            while (node3 != null) {
                if (!(node3 instanceof Text)) {
                    bl2 = true;
                    break;
                }
                if (node3 == node2) break;
                node3 = node3.getNextSibling();
            }
        }
        if (bl2) {
            this.emptyElementFinder.endText = textNode2;
            if (Traversal.traverseFrom(textNode, this.emptyElementFinder) != textNode2) {
                bl2 = false;
            }
        }
        if (bl2) {
            itemArray[n6] = TextItem.INSTANCE;
            if (!elementType.checkElementStructure(structure.attributeFields, structure.attributeFieldCount, itemArray, n5)) {
                bl2 = false;
            }
        }
        return bl || bl2 ? (bl2 ? 2 : 1) : 0;
    }

    private boolean checkPossibleField(ElementType elementType, Field field, Node[] nodeArray, int n) {
        int n2;
        Attribute[] attributeArray;
        Name name = field.getFieldName();
        if (name == null) {
            return false;
        }
        ElementType elementType2 = elementType.getChildElementType(field, name);
        if (elementType2 == null) {
            elementType2 = UnconstrainedElementType.INSTANCE;
        }
        if (elementType2.getElementContentType() == 1) {
            return false;
        }
        if (elementType2.canCheckAttributeStructure()) {
            attributeArray = attributes0;
            n2 = 0;
        } else {
            Field[] fieldArray = elementType2.getAttributeFields();
            attributeArray = this.getAttributeList(fieldArray.length);
            n2 = 0;
            int n3 = 0;
            while (n3 < fieldArray.length) {
                Name name2;
                Field field2 = fieldArray[n3];
                if (elementType2.isRequiredAttribute(field2) && (name2 = field2.getFieldName()) != null) {
                    Attribute attribute = attributeArray[n2++];
                    attribute.element = null;
                    attribute.name = name2;
                    attribute.value = "";
                }
                ++n3;
            }
        }
        return elementType2.getElementStructure(attributeArray, n2, nodeArray, n, false, this.structure);
    }

    public Element convert(TextNode textNode, int n, TextNode textNode2, int n2, Field field, Name name) {
        return (Element)this.doConvert(textNode, n, textNode2, n2, field, name);
    }

    public Text convertToText(TextNode textNode, int n, TextNode textNode2, int n2) {
        return (Text)this.doConvert(textNode, n, textNode2, n2, null, null);
    }

    private Node doConvert(TextNode textNode, int n, TextNode textNode2, int n2, Field field, Name name) {
        Node node;
        Object object;
        if (!this.compileReplace(textNode, n, textNode2, n2, this.replaceInfo)) {
            return null;
        }
        if (name == null) {
            object = this.copyChars(textNode, n, textNode2, n2);
            if (object == null) {
                return null;
            }
            node = new Text((String)object);
        } else {
            object = this.doCopy(textNode, n, textNode2, n2);
            if (object == null || ((Node[])object).length == 0) {
                return null;
            }
            ElementType elementType = this.replaceInfo.getElementType(this.documentType);
            ElementType elementType2 = elementType.getChildElementType(field, name);
            if (elementType2 == null) {
                elementType2 = UnconstrainedElementType.INSTANCE;
            }
            Element element = this.createInstance(this.replaceInfo.element, elementType2, name);
            element.removeAllChildren();
            int n3 = 0;
            while (n3 < ((Object)object).length) {
                element.appendChild(((Node)object[n3]).copy());
                ++n3;
            }
            EditUtil.normalizeText(element, elementType2);
            node = element;
        }
        object = this.replaceInfo.element.getDocument();
        if (object != null) {
            ((Document)object).beginBatchEditing();
        }
        this.replace(this.replaceInfo, new Node[]{node});
        if (object != null) {
            ((Document)object).endBatchEditing();
        }
        return node;
    }

    public Element convert(TextLocation textLocation, TextLocation textLocation2, Field field, Name name) {
        return (Element)this.doConvert(textLocation, textLocation2, field, name);
    }

    public Text convertToText(TextLocation textLocation, TextLocation textLocation2) {
        return (Text)this.doConvert(textLocation, textLocation2, null, null);
    }

    private Node doConvert(TextLocation textLocation, TextLocation textLocation2, Field field, Name name) {
        Node node;
        TextNode textNode = textLocation.getTextNode();
        int n = textLocation.getOffset();
        TextNode textNode2 = textLocation2.getTextNode();
        int n2 = textLocation2.getOffset();
        boolean bl = true;
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return null;
            }
            case 2: {
                TextNode textNode3 = textNode;
                textNode = textNode2;
                textNode2 = textNode3;
                int n3 = n;
                n = n2;
                n2 = n3;
                bl = false;
            }
        }
        int n4 = bl ? textLocation2.getPositionFromEnd() : textLocation2.getPositionFromBegin();
        MarkManager markManager = textLocation2.getManager();
        if (markManager != null) {
            markManager.beginBatchMarking();
        }
        if ((node = this.doConvert(textNode, n, textNode2, n2, field, name)) != null) {
            textLocation.remove();
            if (bl) {
                textLocation2.setPositionFromEnd(n4);
            } else {
                textLocation2.setPositionFromBegin(n4);
            }
        }
        if (markManager != null) {
            markManager.endBatchMarking();
        }
        return node;
    }

    private Node[] getNodeList(int n) {
        if (n > this.nodeList.length) {
            this.nodeList = new Node[Math.max(n, 2 * this.nodeList.length)];
        }
        return this.nodeList;
    }

    private Item[] getItemList(int n) {
        if (n > this.itemList.length) {
            this.itemList = new Item[Math.max(n, 2 * this.itemList.length)];
        }
        return this.itemList;
    }

    private Attribute[] getAttributeList(int n) {
        if (n > this.attributeList.length) {
            Attribute[] attributeArray = new Attribute[Math.max(n, 2 * this.attributeList.length)];
            System.arraycopy(this.attributeList, 0, attributeArray, 0, this.attributeList.length);
            int n2 = this.attributeList.length;
            while (n2 < attributeArray.length) {
                attributeArray[n2] = new Attribute();
                ++n2;
            }
            this.attributeList = attributeArray;
        }
        return this.attributeList;
    }

    private static final class EmptyElementFinder
    extends Traversal.HandlerBase {
        public TextNode endText;

        private EmptyElementFinder() {
        }

        public Object processComment(Comment comment) {
            return this.processTextNode(comment);
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            return this.processTextNode(processingInstruction);
        }

        public Object processText(Text text) {
            return this.processTextNode(text);
        }

        private Object processTextNode(TextNode textNode) {
            if (textNode == this.endText) {
                return this.endText;
            }
            return null;
        }

        public Object enterElement(Element element) {
            if (element.hasNoChildren()) {
                return element;
            }
            return null;
        }
    }

    private static final class ReplaceInfo {
        public TextNode beginText;
        public int beginOffset;
        public TextNode endText;
        public int endOffset;
        public Element element;
        public Node replaceFrom;
        public Node replaceTo;
        public Node insertBefore;
        public TextNode replaceText;
        public int replaceOffset;
        public int replaceCount;
        public Node pruneRight;
        public TextNode pruneRightText;
        public int pruneRightOffset;
        public Node pruneLeft;
        public TextNode pruneLeftText;
        public int pruneLeftOffset;
        private ElementType elementType;

        private ReplaceInfo() {
        }

        public void reset() {
            this.beginText = null;
            this.endText = null;
            this.element = null;
            this.replaceFrom = null;
            this.replaceTo = null;
            this.insertBefore = null;
            this.replaceText = null;
            this.replaceOffset = -1;
            this.replaceCount = -1;
            this.pruneRight = null;
            this.pruneRightText = null;
            this.pruneRightOffset = -1;
            this.pruneLeft = null;
            this.pruneLeftText = null;
            this.pruneLeftOffset = -1;
            this.elementType = null;
        }

        public ElementType getElementType(DocumentType documentType) {
            if (this.elementType == null) {
                this.elementType = documentType.getElementType(this.element);
                if (this.elementType == null) {
                    this.elementType = UnconstrainedElementType.INSTANCE;
                }
            }
            return this.elementType;
        }
    }

    private static final class ElementCopier
    implements Traversal.Handler {
        private DocumentType documentType;
        private IdentityHashMap elementTypes;
        private TextOffset offset1;
        private TextOffset offset2;
        private Stack stack = new Stack();

        private ElementCopier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Element run(Element var1_1, DocumentType var2_2, IdentityHashMap var3_3, TextOffset var4_4, TextOffset var5_5) {
            block4: {
                this.documentType = var2_2;
                this.elementTypes = var3_3;
                this.offset1 = var4_4;
                this.offset2 = var5_5;
                var6_6 = null;
                try {
                    var6_6 = (Element)Traversal.traverse(var1_1, this);
                    ** while (!this.stack.empty())
                }
                catch (Throwable var7_7) {
                    ** while (!this.stack.empty())
                }
lbl-1000:
                // 1 sources

                {
                    this.stack.pop();
                    continue;
                }
lbl12:
                // 1 sources

                break block4;
lbl-1000:
                // 1 sources

                {
                    this.stack.pop();
                    continue;
                }
lbl18:
                // 1 sources

                this.documentType = null;
                this.elementTypes = null;
                this.offset1 = null;
                this.offset2 = null;
                throw var7_7;
            }
            this.documentType = null;
            this.elementTypes = null;
            this.offset1 = null;
            this.offset2 = null;
            return var6_6;
        }

        public Object processComment(Comment comment) {
            return this.processTextNode(comment);
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            return this.processTextNode(processingInstruction);
        }

        public Object processText(Text text) {
            return this.processTextNode(text);
        }

        private Object processTextNode(TextNode textNode) {
            TextNode textNode2 = (TextNode)textNode.copy();
            if (this.offset1 != null && this.offset1.text == textNode) {
                this.offset1.text = textNode2;
            }
            if (this.offset2 != null && this.offset2.text == textNode) {
                this.offset2.text = textNode2;
            }
            ElementCopierInfo elementCopierInfo = (ElementCopierInfo)this.stack.peek();
            elementCopierInfo.elementCopy.appendChild(textNode2);
            return null;
        }

        public Object enterElement(Element element) {
            Object object;
            Object object2;
            Object object3;
            Element element2 = new Element(element.getName());
            if (element.getAttributeCount() > 0) {
                object3 = element.getAttributes();
                while (object3.hasMoreElements()) {
                    object2 = (Attribute)object3.nextElement();
                    element2.putAttribute(((Attribute)object2).name, ((Attribute)object2).value);
                }
            }
            if (this.stack.empty()) {
                object3 = this.documentType.getElementType(element);
            } else {
                object2 = (ElementCopierInfo)this.stack.peek();
                object = ((ElementCopierInfo)object2).elementCopy;
                ElementType elementType = ((ElementCopierInfo)object2).type;
                Structure structure = ((ElementCopierInfo)object2).structure;
                ((Tree)object).appendChild(element2);
                int n = ((Tree)object).indexOfChild(element2);
                object3 = elementType.getChildElementType((Field)structure.childNodeItems[n], element);
            }
            if (object3 == null) {
                object3 = UnconstrainedElementType.INSTANCE;
            }
            if (!object3.getStructure(element, false, (Structure)(object2 = new Structure()))) {
                object3 = new UncheckedElementType((ElementType)object3);
                object3.getStructure(element, false, (Structure)object2);
            }
            this.elementTypes.put(element2, object3);
            object = new ElementCopierInfo();
            ((ElementCopierInfo)object).elementCopy = element2;
            ((ElementCopierInfo)object).type = object3;
            ((ElementCopierInfo)object).structure = object2;
            this.stack.push(object);
            return null;
        }

        public Object leaveElement(Element element) {
            ElementCopierInfo elementCopierInfo = (ElementCopierInfo)this.stack.pop();
            if (this.stack.empty()) {
                return elementCopierInfo.elementCopy;
            }
            return null;
        }
    }

    private static final class ElementCopierInfo {
        public Element elementCopy;
        public ElementType type;
        public Structure structure;

        private ElementCopierInfo() {
        }
    }
}

