/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.Mark;
import com.xmlmind.xmledit.edit.PositionToTextOffset;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.edit.TextOffsetToPosition;
import java.text.BreakIterator;

public final class TextLocation
extends Mark {
    TextNode text;
    int offset;
    boolean cursor;
    private static BreakIterator breakIterator = null;
    private static char[] textNodeChars = null;

    TextLocation(Object object, TextNode textNode, int n, boolean bl) {
        super(object);
        this.text = textNode;
        this.offset = n;
        this.cursor = bl;
    }

    public boolean isCursor() {
        return this.cursor;
    }

    public int getType() {
        return 1;
    }

    public Node getNode() {
        return this.text;
    }

    public TextNode getTextNode() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append(this.id);
        stringBuffer.append(',');
        stringBuffer.append(this.text.toString());
        stringBuffer.append('[');
        stringBuffer.append(this.offset);
        stringBuffer.append(']');
        if (this.isRemoved()) {
            stringBuffer.append(",removed");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public boolean moveTo(TextNode textNode, int n) {
        int n2;
        int n3 = n2 = textNode == null ? 0 : textNode.getTextLength();
        if (n < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        if (textNode == this.text && n == this.offset) {
            return false;
        }
        TextNode textNode2 = this.text;
        int n4 = this.offset;
        this.text = textNode;
        this.offset = n;
        if (this.manager != null) {
            this.manager.markMoved(this, textNode2, n4);
        }
        return true;
    }

    public boolean moveToDocumentBegin() {
        Document document = this.getDocument();
        if (document == null) {
            return false;
        }
        TextNode textNode = (TextNode)Traversal.traverse(document.getRootElement(), Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        return this.moveTo(textNode, 0);
    }

    private Document getDocument() {
        return this.manager == null ? null : this.manager.getDocument();
    }

    public boolean moveToDocumentEnd() {
        Document document = this.getDocument();
        if (document == null) {
            return false;
        }
        TextNode textNode = (TextNode)Traversal.traverseBackwards(document.getRootElement(), Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        return this.moveTo(textNode, textNode.getTextLength());
    }

    public boolean moveToPreviousElement() {
        TextNode textNode = (TextNode)Traversal.traverseBefore(this.text.getParentElement(), Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        if ((textNode = (TextNode)Traversal.traverse(textNode.getParentElement(), Traversal.textNodeFinder)) == null) {
            return false;
        }
        return this.moveTo(textNode, 0);
    }

    public boolean moveToNextElement() {
        TextNode textNode = (TextNode)Traversal.traverseAfter(this.text.getParentElement(), Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        return this.moveTo(textNode, 0);
    }

    public boolean moveToElementBegin() {
        TextNode textNode = (TextNode)Traversal.traverse(this.text.getParentElement(), Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        return this.moveTo(textNode, 0);
    }

    public boolean moveToElementEnd() {
        TextNode textNode = (TextNode)Traversal.traverseBackwards(this.text.getParentElement(), Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        return this.moveTo(textNode, textNode.getTextLength());
    }

    public boolean moveToPreviousTextNode() {
        return this.moveToPreviousTextNode(false);
    }

    public boolean moveToPreviousTextNode(boolean bl) {
        TextNode textNode = (TextNode)Traversal.traverseBefore(this.text, Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        return this.moveTo(textNode, bl ? textNode.getTextLength() : 0);
    }

    public boolean moveToNextTextNode() {
        TextNode textNode = (TextNode)Traversal.traverseAfter(this.text, Traversal.textNodeFinder);
        if (textNode == null) {
            return false;
        }
        return this.moveTo(textNode, 0);
    }

    public boolean moveToTextNodeBegin() {
        if (this.offset == 0) {
            return false;
        }
        return this.moveTo(this.text, 0);
    }

    public boolean moveToTextNodeEnd() {
        int n = this.text.getTextLength();
        if (this.offset == n) {
            return false;
        }
        return this.moveTo(this.text, n);
    }

    public boolean moveToPreviousChar() {
        if (this.offset == 0) {
            return this.moveToPreviousTextNode(true);
        }
        return this.moveTo(this.text, this.offset - 1);
    }

    public boolean moveToNextChar() {
        if (this.offset == this.text.getTextLength()) {
            return this.moveToNextTextNode();
        }
        return this.moveTo(this.text, this.offset + 1);
    }

    public boolean moveToWordBegin() {
        char[] cArray = this.text.getTextChars();
        if (cArray.length == 0) {
            return false;
        }
        int n = this.offset;
        BreakIterator breakIterator = TextLocation.getBreakIterator(cArray);
        int n2 = breakIterator.last();
        if (n >= n2) {
            n = n2 - 1;
        }
        breakIterator.following(n);
        n = breakIterator.previous();
        return this.moveTo(this.text, n);
    }

    private static final BreakIterator getBreakIterator(char[] cArray) {
        if (textNodeChars != cArray) {
            textNodeChars = cArray;
            breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(new String(cArray));
        }
        return breakIterator;
    }

    public boolean moveToWordEnd() {
        char[] cArray = this.text.getTextChars();
        if (cArray.length == 0) {
            return false;
        }
        int n = this.offset;
        BreakIterator breakIterator = TextLocation.getBreakIterator(cArray);
        int n2 = breakIterator.last();
        if (n >= n2) {
            n = n2 - 1;
        }
        n = breakIterator.following(n);
        return this.moveTo(this.text, n);
    }

    public boolean moveToNextWord() {
        TextNode textNode = this.text;
        int n = TextLocation.nextWord(textNode.getTextChars(), this.offset, false);
        while (n < 0) {
            if ((textNode = (TextNode)Traversal.traverseAfter(textNode, Traversal.textNodeFinder)) == null) {
                return false;
            }
            n = TextLocation.nextWord(textNode.getTextChars(), 0, true);
        }
        if (n < 0) {
            return false;
        }
        return this.moveTo(textNode, n);
    }

    /*
     * Unable to fully structure code
     */
    private static final int nextWord(char[] var0, int var1_1, boolean var2_2) {
        var3_3 = var0.length;
        if (var1_1 >= var3_3) {
            return -1;
        }
        var4_4 = TextLocation.getBreakIterator(var0);
        if (var2_2 && var4_4.first() == var1_1 && !Character.isWhitespace(var0[var1_1])) {
            return var1_1;
        }
        if ((var1_1 = var4_4.following(var1_1)) != -1 && var1_1 < var3_3) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            var1_1 = var4_4.next();
            if (var1_1 != -1 && var1_1 < var3_3) continue;
            return -1;
lbl12:
            // 2 sources

            ** while (Character.isWhitespace((char)var0[var1_1]))
        }
lbl13:
        // 1 sources

        return var1_1;
    }

    public boolean moveToPreviousWord() {
        TextNode textNode = this.text;
        int n = TextLocation.previousWord(textNode.getTextChars(), this.offset);
        while (n < 0) {
            if ((textNode = (TextNode)Traversal.traverseBefore(textNode, Traversal.textNodeFinder)) == null) {
                return false;
            }
            n = TextLocation.previousWord(textNode.getTextChars(), textNode.getTextLength());
        }
        if (n < 0) {
            return false;
        }
        return this.moveTo(textNode, n);
    }

    /*
     * Unable to fully structure code
     */
    private static final int previousWord(char[] var0, int var1_1) {
        if (var0.length == 0) {
            return -1;
        }
        var2_2 = TextLocation.getBreakIterator(var0);
        var3_3 = var1_1;
        var4_4 = var2_2.last();
        if (var1_1 >= var4_4) {
            var1_1 = var4_4 - 1;
        }
        var2_2.following(var1_1);
        var1_1 = var2_2.previous();
        if (var1_1 == var3_3) {
            var1_1 = var2_2.previous();
        }
        if (var1_1 != -1) ** GOTO lbl18
        return -1;
lbl-1000:
        // 1 sources

        {
            var1_1 = var2_2.previous();
            if (var1_1 != -1) continue;
            return -1;
lbl18:
            // 2 sources

            ** while (Character.isWhitespace((char)var0[var1_1]))
        }
lbl19:
        // 1 sources

        return var1_1;
    }

    public boolean isAfter(TextLocation textLocation) {
        TextNode textNode = textLocation.text;
        int n = textLocation.offset;
        if (this.text == textNode) {
            if (this.offset > n) {
                return true;
            }
        } else {
            Traversal.TextNodeMatcher textNodeMatcher = new Traversal.TextNodeMatcher();
            textNodeMatcher.searchedNode = textNode;
            if (Traversal.traverseBefore(this.text, textNodeMatcher) != null) {
                return true;
            }
        }
        return false;
    }

    public void swapWith(TextLocation textLocation) {
        TextNode textNode = textLocation.text;
        int n = textLocation.offset;
        if (this.text != textNode || this.offset != n) {
            textLocation.moveTo(this.text, this.offset);
            this.moveTo(textNode, n);
        }
    }

    public int getPositionFromBegin() {
        return TextOffsetToPosition.INSTANCE.get(this.text, this.offset, false);
    }

    public int getPositionFromEnd() {
        return TextOffsetToPosition.INSTANCE.get(this.text, this.offset, true);
    }

    public boolean setPositionFromBegin(int n) {
        TextOffset textOffset = PositionToTextOffset.INSTANCE.get(this.getDocument(), n, false);
        if (textOffset == null) {
            return false;
        }
        return this.moveTo(textOffset.text, textOffset.offset);
    }

    public boolean setPositionFromEnd(int n) {
        TextOffset textOffset = PositionToTextOffset.INSTANCE.get(this.getDocument(), n, true);
        if (textOffset == null) {
            return false;
        }
        return this.moveTo(textOffset.text, textOffset.offset);
    }
}

