/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.TextOffset;

public final class TextOffsetToPosition
extends Traversal.HandlerBase {
    private TextNode searchedText;
    private int searchedOffset;
    private boolean fromEnd;
    private int position;
    public static final TextOffsetToPosition INSTANCE = new TextOffsetToPosition();

    public int getFromBegin(TextOffset textOffset) {
        return this.get(textOffset.text, textOffset.offset, false);
    }

    public int getFromEnd(TextOffset textOffset) {
        return this.get(textOffset.text, textOffset.offset, true);
    }

    public int get(TextNode textNode, int n, boolean bl) {
        Document document = textNode.getDocument();
        if (document == null) {
            return -1;
        }
        this.searchedText = textNode;
        this.searchedOffset = n;
        this.fromEnd = bl;
        this.position = 0;
        Object object = bl ? Traversal.traverseBackwards(document.getRootElement(), this) : Traversal.traverse(document.getRootElement(), this);
        if (object == this.searchedText) {
            return this.position;
        }
        return -1;
    }

    public Object processText(Text text) {
        return this.processTextNode(text);
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return this.processTextNode(processingInstruction);
    }

    public Object processComment(Comment comment) {
        return this.processTextNode(comment);
    }

    private Object processTextNode(TextNode textNode) {
        int n = textNode.getTextLength();
        ++n;
        if (textNode == this.searchedText) {
            if (this.searchedOffset >= 0 && this.searchedOffset < n) {
                this.position = this.fromEnd ? (this.position += n - 1 - this.searchedOffset) : (this.position += this.searchedOffset);
                return textNode;
            }
            return this;
        }
        this.position += n;
        return null;
    }
}

