/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.edit.UndoEvent;
import com.xmlmind.xmledit.edit.UndoListener;
import com.xmlmind.xmledit.edit.UndoManagerEvent;
import com.xmlmind.xmledit.edit.UndoManagerListener;
import java.util.ArrayList;

public class UndoManager
implements DocumentListener {
    public static final int DEFAULT_UNDO_MAX_COUNT = 10;
    private Document doc;
    private DocumentType docType;
    private int capacity;
    private UndoActionStack undoStack;
    private UndoActionStack redoStack;
    private int nextSerialNumber;
    private int mergeNesting;
    private int firstMerged;
    private UndoManagerListener[] listeners = new UndoManagerListener[0];
    private UndoManagerEvent undoManagerEvent = new UndoManagerEvent(this);
    private UndoListener[] actionListeners = new UndoListener[0];
    private UndoEvent undoEvent = new UndoEvent(this, null, false);
    private UndoAction targetAction = null;
    private UndoActionStack targetStack = null;

    public UndoManager() {
        this(null, 10);
    }

    public UndoManager(Document document) {
        this(document, 10);
    }

    public UndoManager(Document document, int n) {
        this.setUndoMaxCount(n);
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        if (this.doc != null) {
            this.reset();
            this.doc.removeDocumentListener(this);
            this.doc = null;
            this.docType = null;
        }
        if (document != null) {
            this.doc = document;
            document.addDocumentListener(this, false);
            this.docType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
            if (this.docType == null) {
                this.docType = UnconstrainedDocumentType.INSTANCE;
            }
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setUndoMaxCount(int n) {
        if (n < 1) {
            n = 1;
        }
        this.capacity = n;
        this.reset();
    }

    public int getUndoMaxCount() {
        return this.capacity;
    }

    public void reset() {
        this.undoStack = new UndoActionStack(this.capacity);
        this.redoStack = new UndoActionStack(this.capacity);
        this.nextSerialNumber = 0;
        this.mergeNesting = 0;
        this.firstMerged = -1;
        this.notifyUndoManagerListeners();
    }

    public Action getTopUndoAction() {
        return this.undoStack.top();
    }

    public Action getTopRedoAction() {
        return this.redoStack.top();
    }

    public boolean canUndo() {
        UndoAction undoAction = this.undoStack.top();
        return undoAction != null && undoAction.canPerform();
    }

    public boolean canRedo() {
        UndoAction undoAction = this.redoStack.top();
        return undoAction != null && undoAction.canPerform();
    }

    public boolean undo() {
        UndoAction undoAction = this.undoStack.pop();
        if (undoAction == null) {
            return false;
        }
        this.notifyUndoListeners(true, undoAction, false);
        this.targetStack = this.redoStack;
        int n = this.targetStack.size();
        undoAction.perform(this.doc, this.docType);
        this.notifyUndoListeners(false, undoAction, false);
        UndoAction undoAction2 = this.redoStack.get(n);
        if (undoAction2 != null) {
            undoAction2.description = undoAction.description;
            undoAction2.clientData = undoAction.clientData;
        }
        this.notifyUndoManagerListeners();
        return true;
    }

    public boolean redo() {
        UndoAction undoAction = this.redoStack.pop();
        if (undoAction == null) {
            return false;
        }
        this.notifyUndoListeners(true, undoAction, true);
        this.targetStack = this.undoStack;
        int n = this.targetStack.size();
        undoAction.perform(this.doc, this.docType);
        this.notifyUndoListeners(false, undoAction, true);
        UndoAction undoAction2 = this.undoStack.get(n);
        if (undoAction2 != null) {
            undoAction2.description = undoAction.description;
            undoAction2.clientData = undoAction.clientData;
        }
        this.notifyUndoManagerListeners();
        return true;
    }

    public void beginMerge() {
        if (this.mergeNesting == 0) {
            this.firstMerged = this.nextSerialNumber;
        }
        ++this.mergeNesting;
    }

    public void endMerge(String string) {
        if (this.mergeNesting <= 0) {
            throw new IllegalStateException();
        }
        --this.mergeNesting;
        if (this.mergeNesting == 0) {
            int n = this.undoStack.findFirstMerged(this.firstMerged);
            this.firstMerged = -1;
            if (n < 0) {
                return;
            }
            this.undoStack.mergeFrom(n, string);
        }
    }

    private UndoAction createUndoAction() {
        return this.createUndoAction(null);
    }

    private UndoAction createUndoAction(DocumentEvent documentEvent) {
        UndoAction undoAction = documentEvent == null ? new UndoAction() : new UndoAction(documentEvent);
        if (this.nextSerialNumber == Integer.MAX_VALUE) {
            this.nextSerialNumber = 0;
        }
        undoAction.setSerialNumber(this.nextSerialNumber++);
        return undoAction;
    }

    public void addUndoManagerListener(UndoManagerListener undoManagerListener) {
        if (this.indexOfUndoManagerListener(undoManagerListener) >= 0) {
            return;
        }
        UndoManagerListener[] undoManagerListenerArray = new UndoManagerListener[this.listeners.length + 1];
        if (this.listeners.length > 0) {
            System.arraycopy(this.listeners, 0, undoManagerListenerArray, 0, this.listeners.length);
        }
        undoManagerListenerArray[this.listeners.length] = undoManagerListener;
        this.listeners = undoManagerListenerArray;
    }

    public void removeUndoManagerListener(UndoManagerListener undoManagerListener) {
        int n;
        int n2;
        int n3 = this.indexOfUndoManagerListener(undoManagerListener);
        if (n3 < 0) {
            return;
        }
        UndoManagerListener[] undoManagerListenerArray = new UndoManagerListener[this.listeners.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.listeners, 0, undoManagerListenerArray, 0, n3);
        }
        if ((n2 = this.listeners.length - (n = n3 + 1)) > 0) {
            System.arraycopy(this.listeners, n, undoManagerListenerArray, n3, n2);
        }
        this.listeners = undoManagerListenerArray;
    }

    private int indexOfUndoManagerListener(UndoManagerListener undoManagerListener) {
        int n = 0;
        while (n < this.listeners.length) {
            if (this.listeners[n] == undoManagerListener) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void notifyUndoManagerListeners() {
        UndoManagerListener[] undoManagerListenerArray = this.listeners;
        int n = 0;
        while (n < undoManagerListenerArray.length) {
            undoManagerListenerArray[n].undoManagerChange(this.undoManagerEvent);
            ++n;
        }
    }

    public void addUndoListener(UndoListener undoListener) {
        if (this.indexOfUndoListener(undoListener) >= 0) {
            return;
        }
        UndoListener[] undoListenerArray = new UndoListener[this.actionListeners.length + 1];
        if (this.actionListeners.length > 0) {
            System.arraycopy(this.actionListeners, 0, undoListenerArray, 0, this.actionListeners.length);
        }
        undoListenerArray[this.actionListeners.length] = undoListener;
        this.actionListeners = undoListenerArray;
    }

    public void removeUndoListener(UndoListener undoListener) {
        int n;
        int n2;
        int n3 = this.indexOfUndoListener(undoListener);
        if (n3 < 0) {
            return;
        }
        UndoListener[] undoListenerArray = new UndoListener[this.actionListeners.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.actionListeners, 0, undoListenerArray, 0, n3);
        }
        if ((n2 = this.actionListeners.length - (n = n3 + 1)) > 0) {
            System.arraycopy(this.actionListeners, n, undoListenerArray, n3, n2);
        }
        this.actionListeners = undoListenerArray;
    }

    private int indexOfUndoListener(UndoListener undoListener) {
        int n = 0;
        while (n < this.actionListeners.length) {
            if (this.actionListeners[n] == undoListener) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void notifyUndoListeners(boolean bl, UndoAction undoAction, boolean bl2) {
        UndoListener[] undoListenerArray = this.actionListeners;
        this.undoEvent.initialize(this, undoAction, bl2);
        if (bl) {
            int n = 0;
            while (n < undoListenerArray.length) {
                undoListenerArray[n].performingUndoAction(this.undoEvent);
                ++n;
            }
        } else {
            int n = 0;
            while (n < undoListenerArray.length) {
                undoListenerArray[n].undoActionPerformed(this.undoEvent);
                ++n;
            }
        }
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        this.targetAction = this.createUndoAction();
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        if (this.targetStack == null) {
            if (!this.targetAction.isEmpty()) {
                this.undoStack.push(this.targetAction);
                this.redoStack.popAll();
                this.notifyUndoManagerListeners();
            }
        } else {
            this.targetStack.push(this.targetAction);
            this.targetStack = null;
        }
        this.targetAction = null;
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        this.pushEvent(elementAttributeEvent);
    }

    private void pushEvent(DocumentEvent documentEvent) {
        if (this.targetAction == null) {
            if (this.targetStack == null) {
                this.undoStack.push(this.createUndoAction(documentEvent));
                this.redoStack.popAll();
                this.notifyUndoManagerListeners();
            } else {
                this.targetStack.push(this.createUndoAction(documentEvent));
                this.targetStack = null;
            }
        } else {
            this.targetAction.add(documentEvent);
        }
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        this.pushEvent(elementStructureEvent);
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
        this.pushEvent(processingInstructionEvent);
    }

    public void textChanged(TextEvent textEvent, int n) {
        if (this.targetAction == null) {
            if (this.targetStack == null) {
                boolean bl = this.pushTextEvent(this.undoStack, textEvent);
                this.redoStack.popAll();
                if (bl) {
                    this.notifyUndoManagerListeners();
                }
            } else {
                this.pushTextEvent(this.targetStack, textEvent);
                this.targetStack = null;
            }
        } else {
            this.targetAction.add(textEvent);
        }
    }

    private boolean pushTextEvent(UndoActionStack undoActionStack, TextEvent textEvent) {
        UndoAction undoAction = undoActionStack.top();
        if (undoAction == null || !undoAction.mergeTextEvent(textEvent)) {
            undoActionStack.push(this.createUndoAction(textEvent));
            return true;
        }
        return false;
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
    }

    private static final class UndoActionStack {
        private UndoAction[] actions;
        private int count = 0;

        public UndoActionStack(int n) {
            this.actions = new UndoAction[n];
        }

        public UndoAction top() {
            return this.count > 0 ? this.actions[this.count - 1] : null;
        }

        public int size() {
            return this.count;
        }

        public UndoAction get(int n) {
            return n >= 0 && n < this.count ? this.actions[n] : null;
        }

        public UndoAction pop() {
            if (this.count > 0) {
                UndoAction undoAction = this.actions[this.count - 1];
                this.actions[--this.count] = null;
                return undoAction;
            }
            return null;
        }

        public void popAll() {
            if (this.count > 0) {
                int n = 0;
                while (n < this.count) {
                    this.actions[n] = null;
                    ++n;
                }
                this.count = 0;
            }
        }

        public void push(UndoAction undoAction) {
            if (this.count == this.actions.length) {
                System.arraycopy(this.actions, 1, this.actions, 0, --this.count);
            }
            this.actions[this.count++] = undoAction;
        }

        public int findFirstMerged(int n) {
            int n2 = -1;
            int n3 = this.count - 1;
            while (n3 >= 0) {
                int n4 = this.actions[n3].getSerialNumber();
                if (n4 >= 0) {
                    if (n4 < n) break;
                    n2 = n3;
                }
                --n3;
            }
            return n2;
        }

        public boolean mergeFrom(int n, String string) {
            DocumentEvent[] documentEventArray;
            int n2 = this.count - 1;
            while (n2 >= n) {
                if (this.actions[n2].getClientData() != null) {
                    return false;
                }
                --n2;
            }
            if (n == this.count - 1) {
                this.actions[n].setDescription(string);
                return true;
            }
            ArrayList<DocumentEvent> arrayList = new ArrayList<DocumentEvent>();
            int n3 = n;
            while (n3 < this.count) {
                documentEventArray = this.actions[n3].getDocumentEvents();
                this.actions[n3] = null;
                int n4 = 0;
                while (n4 < documentEventArray.length) {
                    arrayList.add(documentEventArray[n4]);
                    ++n4;
                }
                ++n3;
            }
            documentEventArray = new DocumentEvent[arrayList.size()];
            arrayList.toArray(documentEventArray);
            this.actions[n] = new UndoAction(documentEventArray);
            this.actions[n].setDescription(string);
            this.count = n + 1;
            return true;
        }
    }

    private static final class UndoAction
    extends Action {
        private DocumentEvent[] events;
        private int serialNumber;

        public UndoAction() {
            this(new DocumentEvent[0]);
        }

        public UndoAction(DocumentEvent documentEvent) {
            this(new DocumentEvent[]{documentEvent.copy()});
        }

        public UndoAction(DocumentEvent[] documentEventArray) {
            this.events = documentEventArray;
            this.serialNumber = -1;
        }

        public void setSerialNumber(int n) {
            this.serialNumber = n;
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        public boolean isEmpty() {
            return this.events.length == 0;
        }

        public DocumentEvent[] getDocumentEvents() {
            return this.events;
        }

        public void add(DocumentEvent documentEvent) {
            int n = this.events.length;
            DocumentEvent[] documentEventArray = new DocumentEvent[n + 1];
            System.arraycopy(this.events, 0, documentEventArray, 0, n);
            this.events = documentEventArray;
            this.events[n] = documentEvent.copy();
        }

        public boolean mergeTextEvent(TextEvent textEvent) {
            int n = textEvent.getId();
            TextNode textNode = textEvent.getTextSource();
            DocumentEvent documentEvent = null;
            if (this.events.length == 0 || (documentEvent = this.events[this.events.length - 1]).getId() != n || documentEvent.getSource() != textNode) {
                return false;
            }
            switch (n) {
                case 0: {
                    String string;
                    String string2 = textEvent.getNewString();
                    if (string2.length() > 1) {
                        return false;
                    }
                    TextEvent textEvent2 = (TextEvent)documentEvent;
                    int n2 = textEvent2.getOffset();
                    if (n2 + (string = textEvent2.getNewString()).length() != textEvent.getOffset()) break;
                    textEvent2.initialize(textNode, n, n2, null, string + string2);
                    return true;
                }
                case 2: {
                    String string = textEvent.getOldString();
                    int n3 = string.length();
                    if (n3 > 1) {
                        return false;
                    }
                    TextEvent textEvent3 = (TextEvent)documentEvent;
                    int n4 = textEvent3.getOffset();
                    String string3 = textEvent3.getOldString();
                    int n5 = textEvent.getOffset();
                    if (n5 + n3 == n4) {
                        textEvent3.initialize(textNode, n, n5, string + string3, null);
                        return true;
                    }
                    if (n4 != n5) break;
                    textEvent3.initialize(textNode, n, n4, string3 + string, null);
                    return true;
                }
            }
            return false;
        }

        public boolean canPerform() {
            int n = this.events.length - 1;
            while (n >= 0) {
                DocumentEvent documentEvent = this.events[n];
                switch (documentEvent.getId()) {
                    case 0: {
                        DocumentEvent documentEvent2 = (TextEvent)documentEvent;
                        if (((TextEvent)documentEvent2).getTextSource().isEditable()) break;
                        return false;
                    }
                    case 2: {
                        DocumentEvent documentEvent2 = (TextEvent)documentEvent;
                        if (((TextEvent)documentEvent2).getTextSource().isEditable()) break;
                        return false;
                    }
                    case 1: {
                        DocumentEvent documentEvent2 = (TextEvent)documentEvent;
                        if (((TextEvent)documentEvent2).getTextSource().isEditable()) break;
                        return false;
                    }
                    case 30: {
                        DocumentEvent documentEvent2 = (ProcessingInstructionEvent)documentEvent;
                        if (((ProcessingInstructionEvent)documentEvent2).getProcessingInstructionSource().isEditable()) break;
                        return false;
                    }
                    case 20: {
                        DocumentEvent documentEvent2 = (ElementAttributeEvent)documentEvent;
                        if (((ElementAttributeEvent)documentEvent2).getElementSource().isEditable()) break;
                        return false;
                    }
                    case 21: 
                    case 22: {
                        DocumentEvent documentEvent2 = (ElementAttributeEvent)documentEvent;
                        if (((ElementAttributeEvent)documentEvent2).getElementSource().isEditable()) break;
                        return false;
                    }
                    case 10: {
                        DocumentEvent documentEvent2 = (ElementStructureEvent)documentEvent;
                        if (((ElementStructureEvent)documentEvent2).getElementSource().isEditable()) break;
                        return false;
                    }
                    case 12: {
                        DocumentEvent documentEvent2 = (ElementStructureEvent)documentEvent;
                        if (((ElementStructureEvent)documentEvent2).getElementSource().isEditable()) break;
                        return false;
                    }
                    case 11: {
                        DocumentEvent documentEvent2 = (ElementStructureEvent)documentEvent;
                        if (((ElementStructureEvent)documentEvent2).getElementSource().isEditable()) break;
                        return false;
                    }
                }
                --n;
            }
            return true;
        }

        public void perform(Document document, DocumentType documentType) {
            Object object;
            Object object2;
            Object object3;
            document.beginBatchEditing();
            boolean bl = false;
            int n = this.events.length - 1;
            while (n >= 0) {
                object3 = this.events[n];
                switch (((DocumentEvent)object3).getId()) {
                    case 0: {
                        object2 = (TextEvent)object3;
                        ((TextEvent)object2).getTextSource().deleteText(((TextEvent)object2).getOffset(), ((TextEvent)object2).getNewString().length());
                        break;
                    }
                    case 2: {
                        object2 = (TextEvent)object3;
                        ((TextEvent)object2).getTextSource().insertText(((TextEvent)object2).getOffset(), ((TextEvent)object2).getOldString());
                        break;
                    }
                    case 1: {
                        object2 = (TextEvent)object3;
                        ((TextEvent)object2).getTextSource().replaceText(((TextEvent)object2).getOffset(), ((TextEvent)object2).getNewString().length(), ((TextEvent)object2).getOldString());
                        break;
                    }
                    case 30: {
                        object2 = (ProcessingInstructionEvent)object3;
                        ((ProcessingInstructionEvent)object2).getProcessingInstructionSource().setTarget(((ProcessingInstructionEvent)object2).getOldTarget());
                        break;
                    }
                    case 20: {
                        object2 = (ElementAttributeEvent)object3;
                        ((ElementAttributeEvent)object2).getElementSource().removeAttribute(((ElementAttributeEvent)object2).getName());
                        break;
                    }
                    case 21: 
                    case 22: {
                        object2 = (ElementAttributeEvent)object3;
                        ((ElementAttributeEvent)object2).getElementSource().putAttribute(((ElementAttributeEvent)object2).getName(), ((ElementAttributeEvent)object2).getOldValue());
                        break;
                    }
                    case 10: {
                        object2 = (ElementStructureEvent)object3;
                        ((ElementStructureEvent)object2).getElementSource().removeChild(((ElementStructureEvent)object2).getNewChild());
                        bl = true;
                        break;
                    }
                    case 12: {
                        object2 = (ElementStructureEvent)object3;
                        ((ElementStructureEvent)object2).getElementSource().insertChild(((ElementStructureEvent)object2).getBeforeChild(), ((ElementStructureEvent)object2).getOldChild());
                        bl = true;
                        break;
                    }
                    case 11: {
                        object2 = (ElementStructureEvent)object3;
                        ((ElementStructureEvent)object2).getElementSource().replaceChild(((ElementStructureEvent)object2).getNewChild(), ((ElementStructureEvent)object2).getOldChild());
                        bl = true;
                    }
                }
                --n;
            }
            if (bl) {
                int n2 = this.events.length - 1;
                while (n2 >= 0) {
                    object2 = this.events[n2];
                    switch (((DocumentEvent)object2).getId()) {
                        case 10: {
                            object = (ElementStructureEvent)object2;
                            Element element = ((ElementStructureEvent)object).getElementSource();
                            ElementType elementType = documentType.getElementType(element);
                            if (elementType == null) {
                                elementType = UnconstrainedElementType.INSTANCE;
                            }
                            EditUtil.normalizeText(element, elementType);
                            break;
                        }
                        case 11: 
                        case 12: {
                            object = (ElementStructureEvent)object2;
                            EditUtil.mergeContiguousText(((ElementStructureEvent)object).getElementSource());
                        }
                    }
                    --n2;
                }
            }
            if ((object3 = (MarkManager)document.getProperty("MARK_MANAGER")) != null) {
                Object object4;
                object2 = null;
                object = null;
                int n3 = -1;
                int n4 = this.events.length - 1;
                while (n4 >= 0) {
                    object4 = this.events[n4];
                    switch (((DocumentEvent)object4).getId()) {
                        case 0: {
                            DocumentEvent documentEvent = (TextEvent)object4;
                            Node node = ((TextEvent)documentEvent).getTextSource();
                            if (node.getDocument() == null) break;
                            object = node;
                            n3 = ((TextEvent)documentEvent).getOffset();
                            break;
                        }
                        case 1: 
                        case 2: {
                            DocumentEvent documentEvent = (TextEvent)object4;
                            Node node = ((TextEvent)documentEvent).getTextSource();
                            if (node.getDocument() == null) break;
                            object = node;
                            n3 = ((TextEvent)documentEvent).getOffset() + ((TextEvent)documentEvent).getOldString().length();
                            break;
                        }
                        case 30: {
                            DocumentEvent documentEvent = (ProcessingInstructionEvent)object4;
                            Node node = ((ProcessingInstructionEvent)documentEvent).getProcessingInstructionSource();
                            if (node.getDocument() == null) break;
                            object2 = node;
                            break;
                        }
                        case 20: 
                        case 21: 
                        case 22: {
                            DocumentEvent documentEvent = (ElementAttributeEvent)object4;
                            Node node = ((ElementAttributeEvent)documentEvent).getElementSource();
                            if (((Element)node).getDocument() == null) break;
                            object2 = node;
                            break;
                        }
                        case 10: {
                            DocumentEvent documentEvent = (ElementStructureEvent)object4;
                            Node node = ((ElementStructureEvent)documentEvent).getElementSource();
                            Node node2 = ((ElementStructureEvent)documentEvent).getBeforeChild();
                            Node node3 = null;
                            if (node2 == null) {
                                node3 = ((Tree)node).getLastChild();
                            } else {
                                node3 = node2.getPreviousSibling();
                                if (node3 == null) {
                                    node3 = node2;
                                }
                            }
                            if (node3 != null && node3.getDocument() != null) {
                                object2 = node3;
                                break;
                            }
                            if (((Element)node).getDocument() == null) break;
                            object2 = node;
                            break;
                        }
                        case 11: 
                        case 12: {
                            DocumentEvent documentEvent = (ElementStructureEvent)object4;
                            Node node = ((ElementStructureEvent)documentEvent).getElementSource();
                            Node node2 = ((ElementStructureEvent)documentEvent).getOldChild();
                            if (node2.getDocument() != null) {
                                object2 = node2;
                                break;
                            }
                            if (((Element)node).getDocument() == null) break;
                            object2 = node;
                        }
                    }
                    --n4;
                }
                ((MarkManager)object3).beginBatchMarking();
                ((MarkManager)object3).remove("MARK");
                ((MarkManager)object3).remove("SELECTED2");
                if (object2 != null && ((Node)object2).getDocument() != null) {
                    ((MarkManager)object3).set("SELECTED", (Node)object2);
                    object4 = (TextNode)Traversal.traverse((Node)object2, Traversal.textNodeFinder);
                    if (object4 != null) {
                        ((MarkManager)object3).set("DOT", (TextNode)object4, 0, true);
                    }
                } else if (object != null && ((Node)object).getDocument() != null) {
                    ((MarkManager)object3).set("DOT", (TextNode)object, n3, true);
                    ((MarkManager)object3).remove("SELECTED");
                }
                ((MarkManager)object3).endBatchMarking();
            }
            document.endBatchEditing();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('[');
            if (this.description == null) {
                stringBuffer.append(this.description);
            } else {
                stringBuffer.append("description=\"");
                stringBuffer.append(this.description);
                stringBuffer.append('\"');
            }
            int n = 0;
            while (n < this.events.length) {
                stringBuffer.append(",\nevents[");
                stringBuffer.append(n);
                stringBuffer.append("]=");
                stringBuffer.append(this.events[n]);
                ++n;
            }
            stringBuffer.append("\n]");
            return stringBuffer.toString();
        }
    }

    public static abstract class Action {
        protected String description;
        protected Object clientData;

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setClientData(Object object) {
            this.clientData = object;
        }

        public Object getClientData() {
            return this.clientData;
        }

        public String getDefaultDescription() {
            DocumentEvent[] documentEventArray = this.getDocumentEvents();
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            int n = documentEventArray.length - 1;
            while (n >= 0) {
                DocumentEvent documentEvent = documentEventArray[n];
                switch (documentEvent.getId()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    case 30: {
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    case 20: 
                    case 21: 
                    case 22: {
                        bl = false;
                        bl3 = false;
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        bl = false;
                        bl2 = false;
                        bl3 = false;
                    }
                }
                --n;
            }
            if (bl) {
                return Msg.msg("UM.textChanges");
            }
            if (bl2) {
                return Msg.msg("UM.attributeChanges");
            }
            if (bl3) {
                return Msg.msg("UM.piTargetChanges");
            }
            return null;
        }

        public abstract DocumentEvent[] getDocumentEvents();
    }
}

