/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.edit;

import com.jclark.xml.parse.NotWellFormedException;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentTrimmer;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.InclusionStatus;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.DocumentTypeCache;
import com.xmlmind.xmledit.edit.DocumentTypeDetector;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.LoaderBase;
import com.xmlmind.xmledit.edit.Msg;
import com.xmlmind.xmledit.edit.SimpleDocumentCache;
import com.xmlmind.xmledit.edit.XIncludeError;
import com.xmlmind.xmledit.edit.XIncluderUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.ElementXPointer;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;

public class XIncluder {
    private LoaderBase loader;
    private boolean addInclusionInfo = false;
    private int docCacheSize = 0;
    private DocumentTrimmer trimmer;
    private XIncludeError[] errors;
    private Stack documentStack = new Stack();
    private PreferredPrefix preferredPrefix;
    private InclusionStatus inclusionStatus;
    private SimpleDocumentCache documentCache;
    private static final Name XI_INCLUDE_NAME = Name.get("xi:include");
    private static final Name XI_FALLBACK_NAME = Name.get("xi:fallback");
    private static final Name HREF_NAME = Name.get("href");
    private static final Name XPOINTER_NAME = Name.get("xpointer");
    private static final Name PARSE_NAME = Name.get("parse");
    private static final Name ENCODING_NAME = Name.get("encoding");

    public XIncluder() {
        this.loader = new LoaderBase();
        this.trimmer = new DocumentTrimmer();
    }

    public void setDocumentTypeCache(DocumentTypeCache documentTypeCache) {
        this.loader.setDocumentTypeCache(documentTypeCache);
    }

    public DocumentTypeCache getDocumentTypeCache() {
        return this.loader.getDocumentTypeCache();
    }

    public void setDocumentTypeDetector(DocumentTypeDetector documentTypeDetector) {
        this.loader.setDocumentTypeDetector(documentTypeDetector);
    }

    public DocumentTypeDetector getDocumentTypeDetector() {
        return this.loader.getDocumentTypeDetector();
    }

    public void setAddingInclusionInfo(boolean bl) {
        this.addInclusionInfo = bl;
    }

    public boolean isAddingInclusionInfo() {
        return this.addInclusionInfo;
    }

    public void setDocumentCacheSize(int n) {
        if (n <= 0) {
            n = 0;
        }
        this.docCacheSize = n;
    }

    public int getDocumentCacheSize() {
        return this.docCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processDocument(Document var1_1) {
        block6: {
            var2_2 = new ArrayList<E>();
            this.errors = null;
            this.preferredPrefix = null;
            var3_3 = var1_1.getProperty("NAMESPACE_PREFIX_MAP");
            if (var3_3 != null && var3_3 instanceof PreferredPrefix) {
                this.preferredPrefix = (PreferredPrefix)var3_3;
            }
            this.inclusionStatus = (InclusionStatus)var1_1.getProperty("INCLUSION_STATUS");
            if (this.docCacheSize > 0) {
                this.documentCache = new SimpleDocumentCache(this.docCacheSize, this.loader);
            }
            try {
                this.doProcessDocument(var1_1, var2_2);
                ** while (!this.documentStack.empty())
            }
            catch (Throwable var4_4) {
                ** while (!this.documentStack.empty())
            }
lbl-1000:
            // 1 sources

            {
                this.documentStack.pop();
                continue;
            }
lbl16:
            // 1 sources

            break block6;
lbl-1000:
            // 1 sources

            {
                this.documentStack.pop();
                continue;
            }
lbl22:
            // 1 sources

            this.documentCache = null;
            throw var4_4;
        }
        this.documentCache = null;
        this.errors = new XIncludeError[var2_2.size()];
        var2_2.toArray(this.errors);
    }

    public XIncludeError[] getErrors() {
        return this.errors;
    }

    private void doProcessDocument(Document document, ArrayList arrayList) {
        URL uRL = document.getLocation();
        if (uRL == null) {
            XIncluder.addError(arrayList, document.getRootElement(), Msg.msg("XI.cannotProcessXIncludes"));
            return;
        }
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        this.documentStack.push(new StackItem(uRL, documentType));
        boolean bl = documentType == null || !documentType.isDTD();
        this.process(document, bl, arrayList);
        this.documentStack.pop();
    }

    private static final void addError(ArrayList arrayList, Element element, String string) {
        arrayList.add(new XIncludeError(element, string));
    }

    private void process(Tree tree, boolean bl, ArrayList arrayList) {
        boolean bl2 = false;
        Node node = tree.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getNodeType()) {
                case 4: {
                    Element element = (Element)node;
                    Name name = element.getName();
                    boolean bl3 = false;
                    if (bl) {
                        if (name == Name.XI_INCLUDE) {
                            bl3 = true;
                        } else if (name == Name.XI_FALLBACK) {
                            XIncluder.addError(arrayList, element, Msg.msg("XI.unexpectedXiFallback"));
                        }
                    } else if (name == XI_INCLUDE_NAME) {
                        bl3 = true;
                    } else if (name == XI_FALLBACK_NAME) {
                        XIncluder.addError(arrayList, element, Msg.msg("XI.unexpectedXiFallback"));
                    }
                    if (bl3) {
                        Comparable comparable;
                        PrefixEntry[] prefixEntryArray;
                        Replacement replacement = this.loadReplacement(element, arrayList);
                        if (replacement == null) break;
                        boolean bl4 = false;
                        int n = 0;
                        while (n < replacement.nodes.length) {
                            Node node3 = replacement.nodes[n];
                            if (node3 instanceof Text) {
                                bl4 = true;
                                break;
                            }
                            ++n;
                        }
                        if (bl4 && tree instanceof Document) {
                            XIncluder.addError(arrayList, element, Msg.msg("XI.cannotReplaceDocumentElementByText"));
                            break;
                        }
                        bl2 = bl2 || bl4;
                        boolean bl5 = XIncluder.insideDocumentEntity(element);
                        tree.removeChild(element);
                        int n2 = 0;
                        while (n2 < replacement.nodes.length) {
                            prefixEntryArray = replacement.nodes[n2];
                            tree.insertChild(node2, (Node)prefixEntryArray);
                            ++n2;
                        }
                        if (this.preferredPrefix != null && replacement.preferredPrefix != null) {
                            prefixEntryArray = replacement.preferredPrefix.getAll();
                            int n3 = 0;
                            while (n3 < prefixEntryArray.length) {
                                comparable = prefixEntryArray[n3];
                                this.preferredPrefix.add(((PrefixEntry)comparable).namespace, ((PrefixEntry)comparable).prefix);
                                ++n3;
                            }
                        }
                        if (!this.insideTopDocument() || !bl5) break;
                        boolean bl6 = false;
                        Element element2 = null;
                        if (this.addInclusionInfo) {
                            bl6 = true;
                            int n4 = 0;
                            while (n4 < replacement.nodes.length) {
                                Node node4 = replacement.nodes[n4];
                                if (!(node4 instanceof Element)) {
                                    bl6 = false;
                                    break;
                                }
                                element2 = (Element)node4;
                                ++n4;
                            }
                            boolean bl7 = bl6 = bl6 && element2 != null;
                        }
                        if (this.inclusionStatus != null) {
                            comparable = new StringBuffer();
                            ((StringBuffer)comparable).append("<xi:include href='");
                            ((StringBuffer)comparable).append(replacement.hrefAttr);
                            ((StringBuffer)comparable).append('\'');
                            if (replacement.xpointerAttr != null) {
                                ((StringBuffer)comparable).append(" xpointer='");
                                ((StringBuffer)comparable).append(replacement.xpointerAttr);
                                ((StringBuffer)comparable).append('\'');
                            }
                            if (replacement.isText) {
                                ((StringBuffer)comparable).append(" parse='text'");
                            }
                            ((StringBuffer)comparable).append("/>");
                            if (bl6 && this.inclusionStatus.managed == null) {
                                this.inclusionStatus.managed = ((StringBuffer)comparable).toString();
                            } else if (!bl6 && this.inclusionStatus.notManaged == null) {
                                this.inclusionStatus.notManaged = ((StringBuffer)comparable).toString();
                            }
                        }
                        if (!bl6) break;
                        element.putAttribute(HREF_NAME, replacement.hrefAttr);
                        if (replacement.xpointerAttr != null) {
                            element.putAttribute(XPOINTER_NAME, replacement.xpointerAttr);
                        }
                        this.trimmer.trim(element);
                        element2.putProperty("INCLUSION_INFO", new InclusionInfo(replacement.hrefAttr, replacement.xpointerAttr, element, replacement.xpointedElementLocation));
                        break;
                    }
                    this.process(element, bl, arrayList);
                    break;
                }
                case 0: {
                    bl2 = true;
                }
            }
            node = node2;
        }
        if (bl2 && tree instanceof Element) {
            EditUtil.mergeContiguousText((Element)tree);
        }
    }

    private boolean insideTopDocument() {
        return this.documentStack.size() == 1;
    }

    private static final boolean insideDocumentEntity(Element element) {
        URL uRL = element.getLocation();
        URL uRL2 = element.getDocument().getLocation();
        return uRL == null && uRL2 == null || uRL != null && uRL.equals(uRL2);
    }

    private Replacement loadReplacement(Element element, ArrayList arrayList) {
        URL uRL;
        boolean bl;
        String string;
        String string2;
        int n;
        String string3 = element.getAnyURIAttribute(HREF_NAME, null);
        String string4 = null;
        if (string3 != null && (n = string3.lastIndexOf(35)) >= 0) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        if ((string2 = element.getAttribute(XPOINTER_NAME)) == null && string4 != null) {
            string2 = string4;
            string4 = null;
        }
        if ((string = element.getAttribute(PARSE_NAME)) == null) {
            bl = false;
        } else if ("text".equals(string = string.trim())) {
            bl = true;
        } else if ("xml".equals(string)) {
            bl = false;
        } else {
            XIncluder.addError(arrayList, element, Msg.msg("XI.invalidParseAttribute", string));
            return null;
        }
        String string5 = null;
        if (bl && (string5 = element.getAttribute(ENCODING_NAME)) != null) {
            string5 = string5.trim();
        }
        if (bl) {
            if (string2 != null) {
                XIncluder.addError(arrayList, element, Msg.msg("XI.inconsistentXPointerAttribute"));
                return null;
            }
            if (string3 == null) {
                XIncluder.addError(arrayList, element, Msg.msg("XI.missingHrefAttribute"));
                return null;
            }
        } else if (string3 == null) {
            if (string2 == null) {
                XIncluder.addError(arrayList, element, Msg.msg("XI.missingHrefAttribute"));
                return null;
            }
            string3 = "";
        } else if (string4 != null) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.hrefAttributeHasAFragment"));
            return null;
        }
        URL uRL2 = element.getBase();
        try {
            uRL = new URL(uRL2, string3);
        }
        catch (MalformedURLException malformedURLException) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.unsupportedHrefAttribute", string3, uRL2 == null ? "???" : uRL2.toExternalForm()));
            return null;
        }
        if (bl) {
            return this.loadTextReplacement(string3, uRL2, uRL, string5, element, arrayList);
        }
        return this.loadXMLReplacement(string3, string2, uRL2, uRL, element, arrayList);
    }

    private Replacement loadTextReplacement(String string, URL uRL, URL uRL2, String string2, Element element, ArrayList arrayList) {
        String string3 = null;
        try {
            string3 = XIncluderUtil.loadText(uRL2, string2);
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            if (string4 == null) {
                string4 = iOException.getClass().getName();
            }
            XIncluder.addError(arrayList, element, Msg.msg("XI.cannotLoad", URLUtil.toLabel(uRL2), string4));
            return null;
        }
        boolean bl = false;
        int n = string3.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string3.charAt(n2);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') break;
                    bl = true;
                }
            }
            ++n2;
        }
        if (bl) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.containsNonXMLChars", URLUtil.toLabel(uRL2)));
            return null;
        }
        Replacement replacement = new Replacement(string, null, true, uRL);
        replacement.nodes = new Node[]{new Text(string3)};
        return replacement;
    }

    private Replacement loadXMLReplacement(String string, String string2, URL uRL, URL uRL2, Element element, ArrayList arrayList) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        int n = this.documentStack.size() - 1;
        while (n >= 0) {
            object3 = (StackItem)this.documentStack.elementAt(n);
            if (((StackItem)object3).documentURL.equals(uRL2)) {
                bl = true;
                break;
            }
            --n;
        }
        if (bl) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.alreadyProcessingXIncludes", URLUtil.toLabel(uRL2)));
            return null;
        }
        object3 = this.loadDocument(uRL2, element, arrayList);
        if (object3 == null) {
            return null;
        }
        if (this.documentCache != null) {
            object3 = (Document)((Document)object3).copy();
        }
        ArrayList arrayList2 = new ArrayList();
        this.doProcessDocument((Document)object3, arrayList2);
        if (arrayList2.size() > 0) {
            XIncludeError xIncludeError = (XIncludeError)arrayList2.get(0);
            XIncluder.addError(arrayList, element, Msg.msg("XI.hasXIncludeErrors", URLUtil.toLabel(uRL2), xIncludeError.getElement(), xIncludeError.getMessage()));
            return null;
        }
        String string3 = null;
        Node[] nodeArray = null;
        if (string2 != null) {
            object2 = this.dereferenceXPointer((Document)object3, string2, element, arrayList);
            if (object2 != null) {
                object = ((Tree)object2).getLocation();
                string3 = XIncluderUtil.relativeLocation((URL)object, uRL2);
                String string4 = XIncluderUtil.relativeLocation(string3, string, uRL);
                ((Tree)object2).putLocationInfo(string4, true);
                ((Node)object2).getParent().removeChild((Node)object2);
                nodeArray = new Node[]{object2};
            }
        } else {
            Node[] nodeArray2;
            nodeArray = new Node[((Tree)object3).getChildCount()];
            int n2 = 0;
            object = ((Tree)object3).getFirstChild();
            while (object != null) {
                nodeArray2 = object.getNextSibling();
                switch (object.getNodeType()) {
                    case 4: {
                        ((Element)object).putLocationInfo(string, true);
                    }
                    case 1: 
                    case 2: {
                        ((Tree)object3).removeChild((Node)object);
                        nodeArray[n2++] = object;
                    }
                }
                object = nodeArray2;
            }
            if (n2 != nodeArray.length) {
                nodeArray2 = new Node[n2];
                System.arraycopy(nodeArray, 0, nodeArray2, 0, n2);
                nodeArray = nodeArray2;
            }
        }
        if (nodeArray == null) {
            return null;
        }
        object2 = new Replacement(string, string2, false, uRL);
        ((Replacement)object2).xpointedElementLocation = string3;
        ((Replacement)object2).nodes = nodeArray;
        object = ((Document)object3).getProperty("NAMESPACE_PREFIX_MAP");
        if (object != null && object instanceof PreferredPrefix) {
            ((Replacement)object2).preferredPrefix = (PreferredPrefix)object;
        }
        return object2;
    }

    private Document loadDocument(URL uRL, Element element, ArrayList arrayList) {
        String string = null;
        Document document = null;
        try {
            document = this.documentCache == null ? this.loader.load(uRL) : this.documentCache.get(uRL);
        }
        catch (NotWellFormedException notWellFormedException) {
            string = Msg.msg("XI.xmlError", notWellFormedException.getEntityLocation(), new Integer(notWellFormedException.getLineNumber()), new Integer(notWellFormedException.getColumnNumber()), notWellFormedException.getMessageWithoutLocation());
        }
        catch (IOException iOException) {
            string = MiscUtil.reason(iOException);
        }
        catch (Exception exception) {
            string = MiscUtil.detailedReason(exception);
        }
        if (string != null) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.cannotLoad", URLUtil.toLabel(uRL), string));
            return null;
        }
        return document;
    }

    private Element dereferenceXPointer(Document document, String string, Element element, ArrayList arrayList) {
        String string2;
        Object object;
        ElementXPointer elementXPointer = ElementXPointer.parse(string);
        if (elementXPointer == null) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.invalidXPointer", string));
            return null;
        }
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        if (documentType == null) {
            int n = this.documentStack.size() - 1;
            while (n >= 0) {
                object = (StackItem)this.documentStack.elementAt(n);
                if (((StackItem)object).documentType != null) {
                    documentType = ((StackItem)object).documentType;
                    break;
                }
                --n;
            }
        }
        if (documentType == null) {
            documentType = UnconstrainedDocumentType.INSTANCE;
        }
        if ((string2 = elementXPointer.getId()) != null && documentType instanceof UnconstrainedDocumentType) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.incompatibleXPointer", string, string2));
            return null;
        }
        object = DocumentTypeUtil.findElement(document, elementXPointer, documentType);
        if (object == null) {
            XIncluder.addError(arrayList, element, Msg.msg("XI.badXPointer", string, URLUtil.toLabel(document.getLocation())));
            return null;
        }
        return object;
    }

    private static final class Replacement {
        public String hrefAttr;
        public String xpointerAttr;
        public boolean isText;
        public URL baseURL;
        public String xpointedElementLocation;
        public Node[] nodes;
        public PreferredPrefix preferredPrefix;

        public Replacement(String string, String string2, boolean bl, URL uRL) {
            this.hrefAttr = string;
            this.xpointerAttr = string2;
            this.isText = bl;
            this.baseURL = uRL;
        }
    }

    private static final class StackItem {
        public URL documentURL;
        public DocumentType documentType;

        public StackItem(URL uRL, DocumentType documentType) {
            this.documentURL = uRL;
            this.documentType = documentType;
        }
    }
}

