/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.styledgadget.ButtonBase;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledElementView;
import com.xmlmind.xmledit.styledview.StyledElementViewPart;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.NodeView;
import java.awt.Point;
import java.awt.event.MouseEvent;

public abstract class ButtonBaseVP
extends ButtonBase
implements StyledElementViewPart {
    protected StyledElementView view;
    protected byte flags;
    private static final int ROLE_MASK = 15;
    private static final int NO_SELECTION_MASK = 16;

    protected ButtonBaseVP(Style style, StyledElementView styledElementView, int n) {
        super(style);
        this.view = styledElementView;
        this.flags = 0;
        this.setRole(n);
    }

    public NodeView getView() {
        return this.view;
    }

    public ElementView getElementView() {
        return this.view;
    }

    public StyledElementView getStyledElementView() {
        return this.view;
    }

    private void setRole(int n) {
        if (n < 0 || n > 15) {
            throw new RuntimeException("role out of range " + n);
        }
        this.flags = (byte)(this.flags & 0xFFFFFFF0 | n);
    }

    public int getRole() {
        return this.flags & 0xF;
    }

    public void setElementSelected(boolean bl) {
        this.flags = bl ? (byte)(this.flags & 0xFFFFFFEF) : (byte)(this.flags | 0x10);
    }

    public boolean isElementSelected() {
        return (this.flags & 0x10) == 0;
    }

    public void detachingViewFromModel(Document document, int n) {
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return this.isEnabled() && ((this.hasCommand() || this.hasMenuSpec()) && n == 16 || this.hasMenuSpec() && n == 4);
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        block8: {
            int n;
            int n2;
            block9: {
                MenuSpec menuSpec;
                block10: {
                    n2 = mouseEvent.getModifiers();
                    n = mouseEvent.getID();
                    if (n != 501) break block9;
                    boolean bl = this.hasCommand();
                    if (n2 != 16 || !bl) break block10;
                    this.setPressed(true);
                    this.repaint();
                    break block8;
                }
                if (!this.hasMenuSpec()) break block8;
                Point point = new Point(mouseEvent.getPoint());
                DocumentView documentView = (DocumentView)this.gadgetToRoot(point);
                if (this.isElementSelected()) {
                    this.selectElement(documentView);
                }
                if ((menuSpec = this.getMenuSpec()) != null) {
                    documentView.showMenu(menuSpec, point.x, point.y);
                }
                break block8;
            }
            if (n != 502 || n2 != 16 || !this.hasCommand()) break block8;
            this.setPressed(false);
            this.repaint();
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            if (n3 >= 0 && n3 < this.width && n4 >= 0 && n4 < this.height) {
                Command command;
                Point point = new Point(n3, n4);
                DocumentView documentView = (DocumentView)this.gadgetToRoot(point);
                if (this.isElementSelected()) {
                    this.selectElement(documentView);
                }
                if ((command = this.getCommand()) != null) {
                    String string = this.getCommandParameter();
                    try {
                        if (command.prepareCommand(documentView, string, point.x, point.y)) {
                            command.executeCommand(documentView, string, point.x, point.y);
                        }
                    }
                    catch (Exception exception) {
                        ButtonBaseVP.reportCommandError(exception, command, string);
                    }
                }
            }
        }
    }

    protected void selectElement(DocumentView documentView) {
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return;
        }
        Element element = this.view.getElement();
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark == null || nodeMark.getNode() != element || markManager.getSelected2() != null) {
            markManager.beginBatchMarking();
            markManager.remove("SELECTED2");
            markManager.remove("MARK");
            markManager.set("SELECTED", element);
            documentView.ensureDotIsInside(element);
            markManager.endBatchMarking();
        }
    }

    protected static final void reportCommandError(Exception exception, Command command, String string) {
        String string2 = string == null ? "no parameter" : "parameter '" + string + "'";
        System.err.println("Execution of command " + command.getClass().getName() + "\n" + "with " + string2 + "\n" + "has thrown a " + exception.getClass().getName() + " exception.");
        System.err.println("----------------------------------------");
        exception.printStackTrace();
        System.err.println("----------------------------------------");
    }

    public abstract boolean hasCommand();

    public abstract void setCommand(Command var1);

    public abstract Command getCommand();

    public abstract void setCommandParameter(String var1);

    public abstract String getCommandParameter();

    public abstract boolean hasMenuSpec();

    public abstract void setMenuSpec(MenuSpec var1);

    public abstract MenuSpec getMenuSpec();
}

