/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.form.FormUtil;
import com.xmlmind.xmledit.form.ValueEditorRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public final class CheckBoxRenderer
extends ValueEditorRenderer {
    public String label = null;
    public String uncheckedValue = null;
    public String checkedValue = null;
    public boolean removeValue = false;
    private JCheckBox template = null;
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("label".equals(string)) {
                this.label = styleValue2.stringValue(element);
            } else if ("unchecked-value".equals(string)) {
                this.uncheckedValue = styleValue2.stringValue(element);
            } else if ("checked-value".equals(string)) {
                this.checkedValue = styleValue2.stringValue(element);
            } else if ("remove-value".equals(string)) {
                this.removeValue = styleValue2.booleanValue(element, false);
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.label != null) {
            n ^= this.label.hashCode();
        }
        if (this.uncheckedValue != null) {
            n ^= this.uncheckedValue.hashCode();
        }
        if (this.checkedValue != null) {
            n ^= this.checkedValue.hashCode();
        }
        return n ^= this.removeValue ? 1 : 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CheckBoxRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CheckBoxRenderer checkBoxRenderer = (CheckBoxRenderer)object;
        return MiscUtil.eq(this.label, checkBoxRenderer.label) && MiscUtil.eq(this.uncheckedValue, checkBoxRenderer.uncheckedValue) && MiscUtil.eq(this.checkedValue, checkBoxRenderer.checkedValue) && this.removeValue == checkBoxRenderer.removeValue;
    }

    public Component getTemplate() {
        if (this.template == null) {
            this.template = this.createCheckBox();
        }
        return this.template;
    }

    private JCheckBox createCheckBox() {
        JCheckBox jCheckBox;
        if (this.label == null) {
            jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            jCheckBox.setMargin(NO_MARGIN);
        } else {
            jCheckBox = new JCheckBox(this.label);
        }
        return jCheckBox;
    }

    protected Component doCreateComponent(final ValueEditorVP valueEditorVP) {
        final JCheckBox jCheckBox = this.createCheckBox();
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jCheckBox.isSelected();
                if (bl && CheckBoxRenderer.this.checkedValue != null || !bl && CheckBoxRenderer.this.uncheckedValue != null) {
                    CheckBoxRenderer.this.setCommitNeeded(valueEditorVP, jCheckBox, true);
                    CheckBoxRenderer.this.commit(valueEditorVP, jCheckBox, true);
                } else if (CheckBoxRenderer.this.removeValue && (bl && CheckBoxRenderer.this.checkedValue == null || !bl && CheckBoxRenderer.this.uncheckedValue == null)) {
                    CheckBoxRenderer.this.removeValue(valueEditorVP, jCheckBox);
                }
            }
        });
        return jCheckBox;
    }

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            if (string.equals(this.checkedValue)) {
                bl = true;
                bl2 = true;
            } else if (string.equals(this.uncheckedValue)) {
                bl = false;
                bl2 = true;
            }
        }
        ((JCheckBox)component).setSelected(bl);
        return bl2;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        return ((JCheckBox)component).isSelected() ? this.checkedValue : this.uncheckedValue;
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        super.showError(valueEditorVP, component);
        this.configure(valueEditorVP, component);
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox);
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return this.getFirstBaseLine(componentImageBox);
    }
}

