/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.form.FormUtil;
import com.xmlmind.xmledit.form.ListItem;
import com.xmlmind.xmledit.form.ValueEditorRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public final class ComboBoxRenderer
extends ValueEditorRenderer {
    public ListItem[] items = new ListItem[0];
    private JComboBox template = null;

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        this.items = FormUtil.parametersToItems(styleValueArray, style, styledViewFactory, element, name);
        if (this.items == null) {
            this.items = new ListItem[0];
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        int n2 = 0;
        while (n2 < this.items.length) {
            n ^= this.items[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ComboBoxRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ComboBoxRenderer comboBoxRenderer = (ComboBoxRenderer)object;
        if (this.items.length != comboBoxRenderer.items.length) {
            return false;
        }
        int n = 0;
        while (n < this.items.length) {
            if (!this.items[n].equals(comboBoxRenderer.items[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Component getTemplate() {
        if (this.template == null) {
            this.template = this.createComboBox();
        }
        return this.template;
    }

    private JComboBox createComboBox() {
        JComboBox<ListItem> jComboBox = new JComboBox<ListItem>(new DefaultComboBoxModel<ListItem>(this.items));
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected Component doCreateComponent(final ValueEditorVP valueEditorVP) {
        final JComboBox jComboBox = this.createComboBox();
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!Boolean.TRUE.equals(jComboBox.getClientProperty("settingValue")) && itemEvent.getStateChange() == 1) {
                    ComboBoxRenderer.this.setCommitNeeded(valueEditorVP, jComboBox, true);
                    ComboBoxRenderer.this.commit(valueEditorVP, jComboBox, true);
                }
            }
        });
        jComboBox.putClientProperty("settingValue", Boolean.FALSE);
        return jComboBox;
    }

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        JComboBox jComboBox = (JComboBox)component;
        boolean bl = false;
        if (this.items.length > 0) {
            jComboBox.putClientProperty("settingValue", Boolean.TRUE);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
            int n = defaultComboBoxModel.getSize() - 1;
            Object e = defaultComboBoxModel.getElementAt(n);
            if (e instanceof NotAListItem) {
                defaultComboBoxModel.removeElementAt(n);
            }
            ListItem listItem = this.items[0];
            if (string != null) {
                int n2 = 0;
                while (n2 < this.items.length) {
                    if (string.equals(this.items[n2].getValue())) {
                        listItem = this.items[n2];
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                listItem = string != null ? new NotAListItem(string, string) : new NotAListItem("-", null);
                defaultComboBoxModel.addElement(listItem);
                bl = true;
            }
            jComboBox.setSelectedItem(listItem);
            jComboBox.putClientProperty("settingValue", Boolean.FALSE);
        }
        return bl;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        JComboBox jComboBox = (JComboBox)component;
        ListItem listItem = (ListItem)jComboBox.getSelectedItem();
        return listItem == null ? null : listItem.getValue();
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        super.showError(valueEditorVP, component);
        this.configure(valueEditorVP, component);
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox);
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return this.getFirstBaseLine(componentImageBox);
    }

    private static class NotAListItem
    extends ListItem {
        public NotAListItem(String string, String string2) {
            super(string, string2);
        }
    }
}

